/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.security.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;

public class AsymmetricCryptoUtil {
    public static byte[] asymmetricCrypto(byte[] text, byte[] keyData, String algorithm, int mode) throws GeneralSecurityException {
        Cipher cipher = AsymmetricCryptoUtil.getCipher(keyData, algorithm, mode);
        return cipher.doFinal(text);
    }

    public static byte[] asymmetricCrypto(byte[] text, byte[] keyData, int textOffset, int textLen, String algorithm, int mode) throws GeneralSecurityException {
        Cipher cipher = AsymmetricCryptoUtil.getCipher(keyData, algorithm, mode);
        return cipher.doFinal(text, textOffset, textLen);
    }

    public static byte[] asymmetricCryptoReverse(byte[] text, byte[] keyData, String algorithm, int mode) throws GeneralSecurityException {
        Cipher cipher = AsymmetricCryptoUtil.getCipherReverse(keyData, algorithm, mode);
        return cipher.doFinal(text);
    }

    public static byte[] asymmetricCryptoReverse(byte[] text, byte[] keyData, int textOffset, int textLen, String algorithm, int mode) throws GeneralSecurityException {
        Cipher cipher = AsymmetricCryptoUtil.getCipherReverse(keyData, algorithm, mode);
        return cipher.doFinal(text, textOffset, textLen);
    }

    public static InputStream getInputStream(File file, byte[] keyData, String algorithm, int mode) throws FileNotFoundException, GeneralSecurityException {
        FileInputStream fileInputStream = new FileInputStream(file);
        Cipher cipher = AsymmetricCryptoUtil.getCipher(keyData, algorithm, mode);
        return new CipherInputStream(fileInputStream, cipher);
    }

    public static OutputStream getOutputStream(File file, byte[] keyData, String algorithm, int mode) throws GeneralSecurityException, FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        Cipher cipher = AsymmetricCryptoUtil.getCipher(keyData, algorithm, mode);
        return new CipherOutputStream(fileOutputStream, cipher);
    }

    private static PublicKey getPublicKey(byte[] keyData) throws GeneralSecurityException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyData);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(keySpec);
    }

    private static PrivateKey getPrivateKey(byte[] keyData) throws GeneralSecurityException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyData);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    private static Cipher getCipher(byte[] keyData, String algorithm, int mode) throws GeneralSecurityException {
        if (mode != 1 && mode != 2) {
            throw new GeneralSecurityException("\u9519\u8bef\u7684\u52a0\u89e3\u5bc6\u6807\u8bc6,\u76ee\u524dKMI\u53ea\u652f\u6301Cipher.ENCRYPT_MODE\u548cCipher.DECRYPT_MODE");
        }
        String fullAlg = algorithm + "/ECB/PKCS1Padding";
        Cipher cipher = Cipher.getInstance(fullAlg);
        Key rsaKey = null;
        if (mode == 1) {
            rsaKey = AsymmetricCryptoUtil.getPublicKey(keyData);
            cipher.init(mode, rsaKey);
        } else {
            rsaKey = AsymmetricCryptoUtil.getPrivateKey(keyData);
            cipher.init(mode, rsaKey);
        }
        return cipher;
    }

    private static Cipher getCipherReverse(byte[] keyData, String algorithm, int mode) throws GeneralSecurityException {
        if (mode != 1 && mode != 2) {
            throw new GeneralSecurityException("\u9519\u8bef\u7684\u52a0\u89e3\u5bc6\u6807\u8bc6,\u76ee\u524dKMI\u53ea\u652f\u6301Cipher.ENCRYPT_MODE\u548cCipher.DECRYPT_MODE");
        }
        String fullAlg = algorithm + "/ECB/PKCS1Padding";
        Cipher cipher = Cipher.getInstance(fullAlg);
        Key rsaKey = null;
        if (mode == 1) {
            rsaKey = AsymmetricCryptoUtil.getPrivateKey(keyData);
            cipher.init(mode, rsaKey);
        } else {
            rsaKey = AsymmetricCryptoUtil.getPublicKey(keyData);
            cipher.init(mode, rsaKey);
        }
        return cipher;
    }
}

