/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.security.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class SignatureUtil {
    public static byte[] sign(byte[] text, byte[] privateKeyData, String algorithm) throws GeneralSecurityException {
        PrivateKey privateKey = SignatureUtil.getPrivateKey(privateKeyData, algorithm);
        Signature signatureChecker = Signature.getInstance(algorithm);
        signatureChecker.initSign(privateKey);
        signatureChecker.update(text);
        return signatureChecker.sign();
    }

    public static boolean verify(byte[] text, byte[] signedText, byte[] publicKeyData, String algorithm) throws GeneralSecurityException {
        PublicKey publicKey = SignatureUtil.getPublicKey(publicKeyData, algorithm);
        Signature signatureChecker = Signature.getInstance(algorithm);
        signatureChecker.initVerify(publicKey);
        signatureChecker.update(text);
        return signatureChecker.verify(signedText);
    }

    public static boolean verify(byte[] text, byte[] signedText, File cert, String algorithm) throws GeneralSecurityException, IOException {
        PublicKey publicKey = SignatureUtil.getPublicKey(cert);
        Signature signatureChecker = Signature.getInstance(algorithm);
        signatureChecker.initVerify(publicKey);
        signatureChecker.update(text);
        return signatureChecker.verify(signedText);
    }

    private static PublicKey getPublicKey(byte[] keyData, String algorithm) throws GeneralSecurityException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyData);
        KeyFactory keyFactory = KeyFactory.getInstance(SignatureUtil.substringAfter(algorithm, "with"));
        return keyFactory.generatePublic(keySpec);
    }

    private static PublicKey getPublicKey(File cert) throws GeneralSecurityException, IOException {
        FileInputStream certIn = new FileInputStream(cert);
        CertificateFactory cf1 = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)cf1.generateCertificate(certIn);
        return certificate.getPublicKey();
    }

    private static PrivateKey getPrivateKey(byte[] keyData, String algorithm) throws GeneralSecurityException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyData);
        KeyFactory keyFactory = KeyFactory.getInstance(SignatureUtil.substringAfter(algorithm, "with"));
        return keyFactory.generatePrivate(keySpec);
    }

    private static String substringAfter(String str, String separator) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (separator == null) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos + separator.length());
    }
}

