/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.security.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SymmetricCryptoUtil {
    public static byte[] symmetricCrypto(byte[] text, byte[] keyData, String algorithm, int mode) throws GeneralSecurityException {
        String fullAlg = algorithm + "/CBC/PKCS5Padding";
        byte[] iv = SymmetricCryptoUtil.initIv(fullAlg);
        return SymmetricCryptoUtil.doCrypto(text, keyData, iv, fullAlg, "CBC", "PKCS5Padding", mode);
    }

    public static byte[] symmetricCrypto(byte[] text, byte[] keyData, int textOffset, int textLen, String algorithm, int mode) throws GeneralSecurityException {
        String fullAlg = algorithm + "/CBC/PKCS5Padding";
        byte[] iv = SymmetricCryptoUtil.initIv(fullAlg);
        return SymmetricCryptoUtil.doCrypto(text, keyData, iv, textOffset, textLen, fullAlg, "CBC", "PKCS5Padding", mode);
    }

    public static byte[] symmetricCrypto(byte[] text, byte[] keyData, String algorithm, String padding, int mode) throws GeneralSecurityException {
        String fullAlg = algorithm + "/CBC/" + padding;
        byte[] iv = SymmetricCryptoUtil.initIv(fullAlg);
        return SymmetricCryptoUtil.doCrypto(text, keyData, iv, fullAlg, "CBC", padding, mode);
    }

    public static byte[] symmetricCrypto(byte[] text, byte[] keyData, String algorithm, String workingMode, String padding, int mode) throws GeneralSecurityException {
        String fullAlg = algorithm + "/" + workingMode + "/" + padding;
        byte[] iv = null;
        if ("CBC".equals(workingMode)) {
            iv = SymmetricCryptoUtil.initIv(fullAlg);
        }
        return SymmetricCryptoUtil.doCrypto(text, keyData, iv, fullAlg, workingMode, padding, mode);
    }

    public static InputStream getInputStream(File file, byte[] keyData, String algorithm, int mode) throws IOException, GeneralSecurityException {
        return SymmetricCryptoUtil.getInputStream(file, keyData, algorithm, "CBC", "PKCS5Padding", mode);
    }

    public static InputStream getInputStream(File file, byte[] keyData, String algorithm, String workingMode, String padding, int mode) throws IOException, GeneralSecurityException {
        String fullAlg = algorithm + "/CBC/PKCS5Padding";
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] iv = SymmetricCryptoUtil.initIv(fullAlg);
        Cipher cipher = SymmetricCryptoUtil.getCipher(keyData, iv, fullAlg, workingMode, mode);
        return new CipherInputStream(fileInputStream, cipher);
    }

    public static OutputStream getOutputStream(File file, byte[] keyData, String algorithm, int mode) throws IOException, GeneralSecurityException {
        return SymmetricCryptoUtil.getOutputStream(file, keyData, algorithm, "CBC", "PKCS5Padding", mode);
    }

    public static OutputStream getOutputStream(File file, byte[] keyData, String algorithm, String workingMode, String padding, int mode) throws IOException, GeneralSecurityException {
        String fullAlg = algorithm + "/CBC/PKCS5Padding";
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] iv = SymmetricCryptoUtil.initIv(fullAlg);
        Cipher cipher = SymmetricCryptoUtil.getCipher(keyData, iv, fullAlg, workingMode, mode);
        return new CipherOutputStream(fileOutputStream, cipher);
    }

    public static byte[] doCrypto(byte[] text, byte[] keyData, byte[] iv, String fullAlg, String workingMode, String padding, int mode) throws GeneralSecurityException {
        if (!"CBC".equals(workingMode) && !"ECB".equals(workingMode)) {
            throw new GeneralSecurityException("\u9519\u8bef\u7684\u5de5\u4f5c\u6a21\u5f0f,\u76ee\u524dKMI\u53ea\u652f\u6301CBC\u548cECB\u4e24\u79cd\u5de5\u4f5c\u6a21\u5f0f");
        }
        if (!"PKCS5Padding".equals(padding) && !"NoPadding".equals(padding)) {
            throw new GeneralSecurityException("\u9519\u8bef\u7684\u586b\u5145\u6a21\u5f0f,\u76ee\u524dKMI\u53ea\u652f\u6301PKCS5Padding\u548cNoPadding\u4e24\u79cd\u5de5\u4f5c\u6a21\u5f0f");
        }
        if (mode != 1 && mode != 2) {
            throw new GeneralSecurityException("\u9519\u8bef\u7684\u52a0\u89e3\u5bc6\u6807\u8bc6,\u76ee\u524dKMI\u53ea\u652f\u6301Cipher.ENCRYPT_MODE\u548cCipher.DECRYPT_MODE");
        }
        Cipher cipher = SymmetricCryptoUtil.getCipher(keyData, iv, fullAlg, workingMode, mode);
        return cipher.doFinal(text);
    }

    public static byte[] doCrypto(byte[] text, byte[] keyData, byte[] iv, int textOffset, int textLen, String fullAlg, String workingMode, String padding, int mode) throws GeneralSecurityException {
        if (!"CBC".equals(workingMode) && !"ECB".equals(workingMode)) {
            throw new GeneralSecurityException("\u9519\u8bef\u7684\u5de5\u4f5c\u6a21\u5f0f,\u76ee\u524dKMI\u53ea\u652f\u6301CBC\u548cECB\u4e24\u79cd\u5de5\u4f5c\u6a21\u5f0f");
        }
        if (!"PKCS5Padding".equals(padding) && !"NoPadding".equals(padding)) {
            throw new GeneralSecurityException("\u9519\u8bef\u7684\u586b\u5145\u6a21\u5f0f,\u76ee\u524dKMI\u53ea\u652f\u6301PKCS5Padding\u548cNoPadding\u4e24\u79cd\u5de5\u4f5c\u6a21\u5f0f");
        }
        if (mode != 1 && mode != 2) {
            throw new GeneralSecurityException("\u9519\u8bef\u7684\u52a0\u89e3\u5bc6\u6807\u8bc6,\u76ee\u524dKMI\u53ea\u652f\u6301Cipher.ENCRYPT_MODE\u548cCipher.DECRYPT_MODE");
        }
        Cipher cipher = SymmetricCryptoUtil.getCipher(keyData, iv, fullAlg, workingMode, mode);
        return cipher.doFinal(text, textOffset, textLen);
    }

    private static Cipher getCipher(byte[] keyData, byte[] iv, String fullAlg, String workingMode, int mode) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(fullAlg);
        SecretKeySpec secretKey = new SecretKeySpec(keyData, SymmetricCryptoUtil.substringBefore(fullAlg, "/"));
        if ("CBC".equals(workingMode)) {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(mode, (Key)secretKey, ivSpec);
        } else {
            cipher.init(mode, secretKey);
        }
        return cipher;
    }

    private static byte[] initIv(String fullAlg) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(fullAlg);
        int blockSize = cipher.getBlockSize();
        byte[] iv = new byte[blockSize];
        for (int i = 0; i < blockSize; ++i) {
            iv[i] = 0;
        }
        return iv;
    }

    public static String substringBefore(String str, String separator) {
        if (str == null || str.isEmpty() || separator == null) {
            return str;
        }
        if (separator.length() == 0) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }
}

