/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.core.processor.impl;

import com.baidu.disconf.client.common.model.DisConfCommonModel;
import com.baidu.disconf.client.common.model.DisconfCenterFile;
import com.baidu.disconf.client.config.DisClientConfig;
import com.baidu.disconf.client.core.filetype.FileTypeProcessorUtils;
import com.baidu.disconf.client.core.processor.DisconfCoreProcessor;
import com.baidu.disconf.client.core.processor.impl.DisconfCoreProcessUtils;
import com.baidu.disconf.client.fetcher.FetcherMgr;
import com.baidu.disconf.client.store.DisconfStoreProcessor;
import com.baidu.disconf.client.store.DisconfStoreProcessorFactory;
import com.baidu.disconf.client.store.processor.model.DisconfValue;
import com.baidu.disconf.client.support.registry.Registry;
import com.baidu.disconf.client.watch.WatchMgr;
import com.baidu.disconf.core.common.constants.DisConfigTypeEnum;
import com.baidu.disconf.core.common.utils.GsonUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisconfFileCoreProcessorImpl
implements DisconfCoreProcessor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DisconfFileCoreProcessorImpl.class);
    private WatchMgr watchMgr = null;
    private FetcherMgr fetcherMgr = null;
    private DisconfStoreProcessor disconfStoreProcessor = DisconfStoreProcessorFactory.getDisconfStoreFileProcessor();
    private Registry registry = null;

    public DisconfFileCoreProcessorImpl(WatchMgr watchMgr, FetcherMgr fetcherMgr, Registry registry) {
        this.fetcherMgr = fetcherMgr;
        this.watchMgr = watchMgr;
        this.registry = registry;
    }

    @Override
    public void processAllItems() {
        for (String fileName : this.disconfStoreProcessor.getConfKeySet()) {
            this.processOneItem(fileName);
        }
    }

    @Override
    public void processOneItem(String key) {
        LOGGER.debug("==============\tstart to process disconf file: " + key + "\t=============================");
        DisconfCenterFile disconfCenterFile = (DisconfCenterFile)this.disconfStoreProcessor.getConfData(key);
        try {
            this.updateOneConfFile(key, disconfCenterFile);
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
    }

    private void updateOneConfFile(String fileName, DisconfCenterFile disconfCenterFile) throws Exception {
        if (disconfCenterFile == null) {
            throw new Exception("cannot find disconfCenterFile " + fileName);
        }
        String filePath = fileName;
        HashMap<String, Object> dataMap = new HashMap();
        if (DisClientConfig.getInstance().ENABLE_DISCONF) {
            try {
                String url = disconfCenterFile.getRemoteServerUrl();
                filePath = this.fetcherMgr.downloadFileFromServer(url, fileName, disconfCenterFile.getFileDir());
            }
            catch (Exception e) {
                LOGGER.error(e.toString(), (Throwable)e);
                LOGGER.warn("using local properties in class path: " + fileName);
                filePath = fileName;
            }
            LOGGER.debug("download ok.");
        }
        try {
            dataMap = FileTypeProcessorUtils.getKvMap(disconfCenterFile.getSupportFileTypeEnum(), disconfCenterFile.getFilePath());
        }
        catch (Exception e) {
            LOGGER.error("cannot get kv data for " + filePath, (Throwable)e);
        }
        this.disconfStoreProcessor.inject2Store(fileName, new DisconfValue(null, dataMap));
        LOGGER.debug("inject ok.");
        if (DisClientConfig.getInstance().ENABLE_DISCONF) {
            DisConfCommonModel disConfCommonModel = this.disconfStoreProcessor.getCommonModel(fileName);
            if (this.watchMgr != null) {
                this.watchMgr.watchPath(this, disConfCommonModel, fileName, DisConfigTypeEnum.FILE, GsonUtils.toJson(disconfCenterFile.getKV()));
                LOGGER.debug("watch ok.");
            } else {
                LOGGER.warn("cannot monitor {} because watch mgr is null", (Object)fileName);
            }
        }
    }

    @Override
    public void updateOneConfAndCallback(String key) throws Exception {
        this.updateOneConf(key);
        DisconfCoreProcessUtils.callOneConf(this.disconfStoreProcessor, key);
    }

    private void updateOneConf(String fileName) throws Exception {
        DisconfCenterFile disconfCenterFile = (DisconfCenterFile)this.disconfStoreProcessor.getConfData(fileName);
        if (disconfCenterFile != null) {
            this.updateOneConfFile(fileName, disconfCenterFile);
            this.inject2OneConf(fileName, disconfCenterFile);
        }
    }

    private void inject2OneConf(String fileName, DisconfCenterFile disconfCenterFile) {
        if (disconfCenterFile == null) {
            return;
        }
        try {
            Object object;
            try {
                object = disconfCenterFile.getObject();
                if (object == null) {
                    object = this.registry.getFirstByType(disconfCenterFile.getCls(), true);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.toString());
                object = null;
            }
            this.disconfStoreProcessor.inject2Instance(object, fileName);
        }
        catch (Exception e) {
            LOGGER.warn(e.toString(), (Throwable)e);
        }
    }

    @Override
    public void inject2Conf() {
        for (String key : this.disconfStoreProcessor.getConfKeySet()) {
            LOGGER.debug("==============\tstart to inject value to disconf file item instance: " + key + "\t=============================");
            DisconfCenterFile disconfCenterFile = (DisconfCenterFile)this.disconfStoreProcessor.getConfData(key);
            this.inject2OneConf(key, disconfCenterFile);
        }
    }
}

