/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.core.processor.impl;

import com.baidu.disconf.client.common.model.DisConfCommonModel;
import com.baidu.disconf.client.common.model.DisconfCenterItem;
import com.baidu.disconf.client.config.DisClientConfig;
import com.baidu.disconf.client.core.processor.DisconfCoreProcessor;
import com.baidu.disconf.client.core.processor.impl.DisconfCoreProcessUtils;
import com.baidu.disconf.client.fetcher.FetcherMgr;
import com.baidu.disconf.client.store.DisconfStoreProcessor;
import com.baidu.disconf.client.store.DisconfStoreProcessorFactory;
import com.baidu.disconf.client.store.processor.model.DisconfValue;
import com.baidu.disconf.client.support.registry.Registry;
import com.baidu.disconf.client.watch.WatchMgr;
import com.baidu.disconf.core.common.constants.DisConfigTypeEnum;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisconfItemCoreProcessorImpl
implements DisconfCoreProcessor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DisconfItemCoreProcessorImpl.class);
    private WatchMgr watchMgr = null;
    private FetcherMgr fetcherMgr = null;
    private Registry registry = null;
    private DisconfStoreProcessor disconfStoreProcessor = DisconfStoreProcessorFactory.getDisconfStoreItemProcessor();

    public DisconfItemCoreProcessorImpl(WatchMgr watchMgr, FetcherMgr fetcherMgr, Registry registry) {
        this.registry = registry;
        this.fetcherMgr = fetcherMgr;
        this.watchMgr = watchMgr;
    }

    @Override
    public void processAllItems() {
        for (String key : this.disconfStoreProcessor.getConfKeySet()) {
            this.processOneItem(key);
        }
    }

    @Override
    public void processOneItem(String key) {
        LOGGER.debug("==============\tstart to process disconf item: " + key + "\t=============================");
        DisconfCenterItem disconfCenterItem = (DisconfCenterItem)this.disconfStoreProcessor.getConfData(key);
        if (disconfCenterItem != null) {
            try {
                this.updateOneConfItem(key, disconfCenterItem);
            }
            catch (Exception e) {
                LOGGER.error(e.toString(), (Throwable)e);
            }
        }
    }

    private void updateOneConf(String keyName) throws Exception {
        DisconfCenterItem disconfCenterItem = (DisconfCenterItem)this.disconfStoreProcessor.getConfData(keyName);
        if (disconfCenterItem != null) {
            this.updateOneConfItem(keyName, disconfCenterItem);
            this.inject2OneConf(keyName, disconfCenterItem);
        }
    }

    private void updateOneConfItem(String keyName, DisconfCenterItem disconfCenterItem) throws Exception {
        if (disconfCenterItem == null) {
            throw new Exception("cannot find disconfCenterItem " + keyName);
        }
        String value = null;
        if (DisClientConfig.getInstance().ENABLE_DISCONF) {
            try {
                String url = disconfCenterItem.getRemoteServerUrl();
                value = this.fetcherMgr.getValueFromServer(url);
                if (value != null) {
                    LOGGER.debug("value: " + value);
                }
            }
            catch (Exception e) {
                LOGGER.error("cannot use remote configuration: " + keyName, (Throwable)e);
                LOGGER.info("using local variable: " + keyName);
            }
            LOGGER.debug("download ok.");
        }
        this.disconfStoreProcessor.inject2Store(keyName, new DisconfValue(value, null));
        LOGGER.debug("inject ok.");
        if (DisClientConfig.getInstance().ENABLE_DISCONF) {
            if (this.watchMgr != null) {
                DisConfCommonModel disConfCommonModel = this.disconfStoreProcessor.getCommonModel(keyName);
                this.watchMgr.watchPath(this, disConfCommonModel, keyName, DisConfigTypeEnum.ITEM, value);
                LOGGER.debug("watch ok.");
            } else {
                LOGGER.warn("cannot monitor {} because watch mgr is null", (Object)keyName);
            }
        }
    }

    @Override
    public void updateOneConfAndCallback(String key) throws Exception {
        this.updateOneConf(key);
        DisconfCoreProcessUtils.callOneConf(this.disconfStoreProcessor, key);
    }

    private void inject2OneConf(String key, DisconfCenterItem disconfCenterItem) {
        if (disconfCenterItem == null) {
            return;
        }
        try {
            Object object = null;
            Field field = disconfCenterItem.getField();
            if (!Modifier.isStatic(field.getModifiers())) {
                object = this.registry.getFirstByType(field.getDeclaringClass(), true);
            }
            this.disconfStoreProcessor.inject2Instance(object, key);
        }
        catch (Exception e) {
            LOGGER.warn(e.toString(), (Throwable)e);
        }
    }

    @Override
    public void inject2Conf() {
        for (String key : this.disconfStoreProcessor.getConfKeySet()) {
            LOGGER.debug("==============\tstart to inject value to disconf item instance: " + key + "\t=============================");
            DisconfCenterItem disconfCenterItem = (DisconfCenterItem)this.disconfStoreProcessor.getConfData(key);
            this.inject2OneConf(key, disconfCenterItem);
        }
    }
}

