/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.scan.inner.statically.strategy.impl;

import com.baidu.disconf.client.common.annotations.DisconfActiveBackupService;
import com.baidu.disconf.client.common.annotations.DisconfFile;
import com.baidu.disconf.client.common.annotations.DisconfFileItem;
import com.baidu.disconf.client.common.annotations.DisconfItem;
import com.baidu.disconf.client.common.annotations.DisconfUpdateService;
import com.baidu.disconf.client.scan.inner.common.ScanVerify;
import com.baidu.disconf.client.scan.inner.statically.model.ScanStaticModel;
import com.baidu.disconf.client.scan.inner.statically.strategy.ScanStaticStrategy;
import com.google.common.base.Predicate;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.MethodParameterScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionScanStatic
implements ScanStaticStrategy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ScanStaticStrategy.class);

    @Override
    public ScanStaticModel scan(List<String> packNameList) {
        ScanStaticModel scanModel = this.scanBasicInfo(packNameList);
        this.analysis(scanModel);
        return scanModel;
    }

    private Reflections getReflection(List<String> packNameList) {
        FilterBuilder filterBuilder = new FilterBuilder().includePackage("com.baidu.disconf");
        for (String packName : packNameList) {
            filterBuilder = filterBuilder.includePackage(packName);
        }
        FilterBuilder filter = filterBuilder;
        ArrayList urlTotals = new ArrayList();
        for (String packName : packNameList) {
            Set urls = ClasspathHelper.forPackage((String)packName, (ClassLoader[])new ClassLoader[0]);
            urlTotals.addAll(urls);
        }
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)filter).setScanners(new Scanner[]{new SubTypesScanner().filterResultsBy((Predicate)filter), new TypeAnnotationsScanner().filterResultsBy((Predicate)filter), new FieldAnnotationsScanner().filterResultsBy((Predicate)filter), new MethodAnnotationsScanner().filterResultsBy((Predicate)filter), new MethodParameterScanner()}).setUrls(urlTotals));
        return reflections;
    }

    private void analysis(ScanStaticModel scanModel) {
        this.analysis4DisconfFile(scanModel);
    }

    private void analysis4DisconfFile(ScanStaticModel scanModel) {
        HashMap disconfFileItemMap = new HashMap();
        Set<Class<?>> classdata = scanModel.getDisconfFileClassSet();
        for (Class<?> classFile : classdata) {
            disconfFileItemMap.put(classFile, new HashSet());
        }
        Set<Method> af1 = scanModel.getDisconfFileItemMethodSet();
        for (Method method : af1) {
            Class<?> thisClass = method.getDeclaringClass();
            if (disconfFileItemMap.containsKey(thisClass)) {
                Set fieldSet = (Set)disconfFileItemMap.get(thisClass);
                fieldSet.add(method);
                disconfFileItemMap.put(thisClass, fieldSet);
                continue;
            }
            LOGGER.error("cannot find CLASS ANNOTATION " + DisconfFile.class.getName() + " for disconf file item: " + method.toString());
        }
        for (Class classFile : disconfFileItemMap.keySet()) {
            if (((Set)disconfFileItemMap.get(classFile)).isEmpty()) {
                LOGGER.warn("disconf file hasn't any items: " + classFile.getName());
                continue;
            }
            DisconfFile disconfFile = classFile.getAnnotation(DisconfFile.class);
            boolean fileTypeRight = ScanVerify.isDisconfFileTypeRight(disconfFile);
            if (fileTypeRight) continue;
            LOGGER.warn("now do not support this file type" + disconfFile.toString());
        }
        scanModel.setDisconfFileItemMap(disconfFileItemMap);
    }

    private ScanStaticModel scanBasicInfo(List<String> packNameList) {
        ScanStaticModel scanModel = new ScanStaticModel();
        Reflections reflections = this.getReflection(packNameList);
        scanModel.setReflections(reflections);
        Set classdata = reflections.getTypesAnnotatedWith(DisconfFile.class);
        scanModel.setDisconfFileClassSet(classdata);
        Set af1 = reflections.getMethodsAnnotatedWith(DisconfFileItem.class);
        scanModel.setDisconfFileItemMethodSet(af1);
        af1 = reflections.getMethodsAnnotatedWith(DisconfItem.class);
        scanModel.setDisconfItemMethodSet(af1);
        classdata = reflections.getTypesAnnotatedWith(DisconfActiveBackupService.class);
        scanModel.setDisconfActiveBackupServiceClassSet(classdata);
        classdata = reflections.getTypesAnnotatedWith(DisconfUpdateService.class);
        scanModel.setDisconfUpdateService(classdata);
        return scanModel;
    }
}

