/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.store.inner;

import com.baidu.disconf.client.common.model.DisconfCenterBaseModel;
import com.baidu.disconf.client.common.model.DisconfCenterFile;
import com.baidu.disconf.client.common.model.DisconfCenterItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisconfCenterStore {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DisconfCenterStore.class);
    private Map<String, DisconfCenterFile> confFileMap = new HashMap<String, DisconfCenterFile>();
    private Map<String, DisconfCenterItem> confItemMap = new HashMap<String, DisconfCenterItem>();
    private List<String> activeBackupKeyList;
    private String machineName;

    private DisconfCenterStore() {
    }

    public static DisconfCenterStore getInstance() {
        return SingletonHolder.instance;
    }

    public void storeOneFile(DisconfCenterBaseModel disconfCenterBaseModel) {
        DisconfCenterFile disconfCenterFile = (DisconfCenterFile)disconfCenterBaseModel;
        String fileName = disconfCenterFile.getFileName();
        if (this.confFileMap.containsKey(fileName)) {
            LOGGER.error("There are two same fileName!!!! first: " + this.confFileMap.get(fileName).toString() + ", Second: " + disconfCenterFile.toString());
        } else {
            this.confFileMap.put(fileName, disconfCenterFile);
        }
    }

    public void storeOneItem(DisconfCenterBaseModel disconfCenterBaseModel) {
        DisconfCenterItem disconfCenterItem = (DisconfCenterItem)disconfCenterBaseModel;
        String key = disconfCenterItem.getKey();
        if (this.confItemMap.containsKey(key)) {
            LOGGER.error("There are two same fileName!!!! first: " + this.confItemMap.get(key).getClass().toString() + ", Second: " + disconfCenterItem.getClass().toString());
        } else {
            this.confItemMap.put(key, disconfCenterItem);
        }
    }

    public void excludeOneItem(String key) {
        if (this.confItemMap.containsKey(key)) {
            this.confItemMap.remove(key);
        }
    }

    public void excludeOneFile(String key) {
        if (this.confFileMap.containsKey(key)) {
            this.confFileMap.remove(key);
        }
    }

    public Map<String, DisconfCenterFile> getConfFileMap() {
        return this.confFileMap;
    }

    public Map<String, DisconfCenterItem> getConfItemMap() {
        return this.confItemMap;
    }

    public List<String> getActiveBackupKeyList() {
        return this.activeBackupKeyList;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }

    private static class SingletonHolder {
        private static DisconfCenterStore instance = new DisconfCenterStore();

        private SingletonHolder() {
        }
    }
}

