/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.store.processor.impl;

import com.baidu.disconf.client.common.model.DisConfCommonModel;
import com.baidu.disconf.client.common.model.DisconfCenterBaseModel;
import com.baidu.disconf.client.common.model.DisconfCenterItem;
import com.baidu.disconf.client.common.update.IDisconfUpdate;
import com.baidu.disconf.client.store.DisconfStoreProcessor;
import com.baidu.disconf.client.store.inner.DisconfCenterStore;
import com.baidu.disconf.client.store.processor.model.DisconfValue;
import com.baidu.disconf.client.utils.ClassUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisconfStoreItemProcessorImpl
implements DisconfStoreProcessor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DisconfStoreItemProcessorImpl.class);

    @Override
    public void addUpdateCallbackList(String keyName, List<IDisconfUpdate> iDisconfUpdateList) {
        if (DisconfCenterStore.getInstance().getConfItemMap().containsKey(keyName)) {
            DisconfCenterStore.getInstance().getConfItemMap().get(keyName).getDisconfCommonCallbackModel().getDisconfConfUpdates().addAll(iDisconfUpdateList);
        }
    }

    @Override
    public List<IDisconfUpdate> getUpdateCallbackList(String keyName) {
        if (DisconfCenterStore.getInstance().getConfItemMap().containsKey(keyName)) {
            return DisconfCenterStore.getInstance().getConfItemMap().get(keyName).getDisconfCommonCallbackModel().getDisconfConfUpdates();
        }
        return new ArrayList<IDisconfUpdate>();
    }

    @Override
    public DisConfCommonModel getCommonModel(String keyName) {
        DisconfCenterItem disconfCenterItem = DisconfCenterStore.getInstance().getConfItemMap().get(keyName);
        if (disconfCenterItem == null) {
            LOGGER.error("cannot find " + keyName + " in store....");
            return null;
        }
        return disconfCenterItem.getDisConfCommonModel();
    }

    @Override
    public boolean hasThisConf(String keyName) {
        return DisconfCenterStore.getInstance().getConfItemMap().containsKey(keyName);
    }

    @Override
    public void inject2Instance(Object object, String key) {
        DisconfCenterItem disconfCenterItem = DisconfCenterStore.getInstance().getConfItemMap().get(key);
        if (disconfCenterItem == null) {
            LOGGER.error("cannot find " + key + " in store....");
            return;
        }
        if (object != null) {
            disconfCenterItem.setObject(object);
        }
        try {
            if (object != null) {
                Object defaultValue = disconfCenterItem.getField().get(object);
                LOGGER.debug(disconfCenterItem.getKey() + " is a non-static field. ");
                if (disconfCenterItem.getValue() == null) {
                    disconfCenterItem.getField().set(object, defaultValue);
                    disconfCenterItem.setValue(defaultValue);
                } else {
                    disconfCenterItem.getField().set(object, disconfCenterItem.getValue());
                }
            } else if (Modifier.isStatic(disconfCenterItem.getField().getModifiers())) {
                LOGGER.debug(disconfCenterItem.getKey() + " is a static field. ");
                disconfCenterItem.getField().set(null, disconfCenterItem.getValue());
            }
        }
        catch (Exception e) {
            LOGGER.error("inject2Instance key: " + key + " " + e.toString(), (Throwable)e);
        }
    }

    @Override
    public Object getConfig(String fileName, String keyName) {
        DisconfCenterItem disconfCenterItem = DisconfCenterStore.getInstance().getConfItemMap().get(keyName);
        if (disconfCenterItem == null) {
            LOGGER.debug("cannot find " + keyName + " in store....");
            return null;
        }
        return disconfCenterItem.getValue();
    }

    @Override
    public void inject2Store(String key, DisconfValue disconfValue) {
        DisconfCenterItem disconfCenterItem = DisconfCenterStore.getInstance().getConfItemMap().get(key);
        if (disconfCenterItem == null) {
            LOGGER.error("cannot find " + key + " in store....");
            return;
        }
        if (disconfValue == null || disconfValue.getValue() == null) {
            return;
        }
        Class<?> typeClass = disconfCenterItem.getField().getType();
        try {
            Object newValue = ClassUtils.getValeByType(typeClass, disconfValue.getValue());
            disconfCenterItem.setValue(newValue);
            if (disconfCenterItem.getObject() != null) {
                disconfCenterItem.getField().set(disconfCenterItem.getObject(), disconfCenterItem.getValue());
            }
        }
        catch (Exception e) {
            LOGGER.error("key: " + key + " " + e.toString(), (Throwable)e);
        }
    }

    @Override
    public void transformScanData(List<DisconfCenterBaseModel> disconfCenterBaseModels) {
        for (DisconfCenterBaseModel disconfCenterItem : disconfCenterBaseModels) {
            this.transformScanData(disconfCenterItem);
        }
    }

    @Override
    public void transformScanData(DisconfCenterBaseModel disconfCenterBaseModel) {
        DisconfCenterStore.getInstance().storeOneItem(disconfCenterBaseModel);
    }

    @Override
    public DisconfCenterBaseModel getConfData(String key) {
        if (DisconfCenterStore.getInstance().getConfItemMap().containsKey(key)) {
            return DisconfCenterStore.getInstance().getConfItemMap().get(key);
        }
        return null;
    }

    @Override
    public Set<String> getConfKeySet() {
        return DisconfCenterStore.getInstance().getConfItemMap().keySet();
    }

    @Override
    public String confToString() {
        StringBuilder sBuffer = new StringBuilder();
        sBuffer.append("\n");
        Map<String, DisconfCenterItem> disMap = DisconfCenterStore.getInstance().getConfItemMap();
        for (String file : disMap.keySet()) {
            sBuffer.append("disItem:\t" + file + "\t");
            if (LOGGER.isDebugEnabled()) {
                sBuffer.append(disMap.get(file).toString());
            } else {
                sBuffer.append(disMap.get(file).infoString());
            }
            sBuffer.append("\n");
        }
        return sBuffer.toString();
    }

    @Override
    public void exclude(Set<String> keySet) {
        for (String key : keySet) {
            DisconfCenterStore.getInstance().excludeOneItem(key);
        }
    }
}

