/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.support.registry.impl;

import com.baidu.disconf.client.support.registry.Registry;
import com.baidu.disconf.client.support.registry.impl.SimpleRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringRegistry
implements Registry,
ApplicationContextAware {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SpringRegistry.class);
    private static ApplicationContext applicationContext;
    private SimpleRegistry simpleRegistry = new SimpleRegistry();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringRegistry.applicationContext = applicationContext;
    }

    @Override
    public <T> List<T> findByType(Class<T> type) {
        if (applicationContext == null) {
            LOGGER.error("Spring Context is null. Cannot autowire " + type.getCanonicalName());
            return new ArrayList(0);
        }
        if (type == null) {
            return new ArrayList(0);
        }
        Map<String, T> map = this.findByTypeWithName(type);
        if (map == null || map.isEmpty()) {
            LOGGER.debug("Not found from Spring IoC container for " + type.getSimpleName() + ", and try to init by " + "calling newInstance.");
            return this.simpleRegistry.findByType(type);
        }
        return new ArrayList<T>(map.values());
    }

    @Override
    public <T> T getFirstByType(Class<T> type) {
        List<T> list = this.findByType(type);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <T> T getFirstByType(Class<T> type, boolean withProxy) {
        T object = this.getFirstByType(type);
        if (!withProxy) {
            return object;
        }
        try {
            return this.getTargetObject(object, type);
        }
        catch (Exception e) {
            LOGGER.warn(e.toString());
            return object;
        }
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        return applicationContext.getBeansOfType(type);
    }

    protected <T> T getTargetObject(Object proxy, Class<T> targetClass) throws Exception {
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            return (T)((Advised)proxy).getTargetSource().getTarget();
        }
        if (AopUtils.isCglibProxy((Object)proxy)) {
            return (T)((Advised)proxy).getTargetSource().getTarget();
        }
        return (T)proxy;
    }
}

