/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class ClassUtils {
    public static String getFieldNameByGetMethodName(String methodName) {
        int prefixIndex = 0;
        if (methodName.startsWith("get")) {
            prefixIndex = 3;
        } else if (methodName.startsWith("is")) {
            prefixIndex = 2;
        } else {
            return null;
        }
        String fieldName = methodName.substring(prefixIndex);
        if (fieldName.length() >= 1) {
            String firstCharStr = String.valueOf(fieldName.charAt(0)).toLowerCase();
            fieldName = fieldName.length() > 1 ? firstCharStr + fieldName.substring(1) : firstCharStr.toLowerCase();
        }
        return fieldName;
    }

    public static void setFieldValeByType(Field field, Object obj, String value) throws Exception {
        Class<?> type = field.getType();
        String typeName = type.getName();
        if (typeName.equals("int")) {
            if (value.equals("")) {
                value = "0";
            }
            field.set(obj, Integer.valueOf(value));
        } else if (typeName.equals("long")) {
            if (value.equals("")) {
                value = "0";
            }
            field.set(obj, Long.valueOf(value));
        } else if (typeName.equals("boolean")) {
            if (value.equals("")) {
                value = "false";
            }
            field.set(obj, Boolean.valueOf(value));
        } else if (typeName.equals("double")) {
            if (value.equals("")) {
                value = "0.0";
            }
            field.set(obj, Double.valueOf(value));
        } else {
            field.set(obj, value);
        }
    }

    public static Object getValeByType(Class<?> type, Object value) throws Exception {
        if (!(value instanceof String)) {
            value = "";
        }
        String dataValue = (String)value;
        dataValue = dataValue.trim();
        String typeName = type.getName();
        if ((typeName = typeName.toLowerCase()).equals("int") || typeName.equals("java.lang.integer")) {
            if (value.equals("")) {
                value = "0";
            }
            return Integer.valueOf(dataValue);
        }
        if (typeName.equals("long") || typeName.equals("java.lang.long")) {
            if (value.equals("")) {
                value = "0";
            }
            return Long.valueOf(dataValue);
        }
        if (typeName.equals("boolean") || typeName.equals("java.lang.boolean")) {
            if (value.equals("")) {
                value = "false";
            }
            return Boolean.valueOf(dataValue);
        }
        if (typeName.equals("double") || typeName.equals("java.lang.double")) {
            if (value.equals("")) {
                value = "0.0";
            }
            return Double.valueOf(dataValue);
        }
        return value;
    }

    public static Set<Method> getAllMethod(Class<?> entityClass) {
        HashSet<Method> ms = new HashSet<Method>();
        for (Method m : entityClass.getMethods()) {
            ms.add(m);
        }
        for (Method m : entityClass.getDeclaredMethods()) {
            ms.add(m);
        }
        Class<?> superClass = entityClass.getSuperclass();
        if (!superClass.equals(Object.class)) {
            Set<Method> superFields = ClassUtils.getAllMethod(superClass);
            ms.addAll(superFields);
        }
        return ms;
    }
}

