/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public abstract class StringUtil {
    private static final char[] DIGITS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] DIGITS_NOCASE = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static List<Integer> parseStringToIntegerList(String source, String token) {
        String[] units;
        if (StringUtils.isBlank((String)source) || StringUtils.isEmpty((String)token)) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String unit : units = source.split(token)) {
            result.add(Integer.valueOf(unit));
        }
        return result;
    }

    public static List<Long> parseStringToLongList(String source, String token) {
        String[] units;
        if (StringUtils.isBlank((String)source) || StringUtils.isEmpty((String)token)) {
            return null;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (String unit : units = source.split(token)) {
            result.add(Long.valueOf(unit));
        }
        return result;
    }

    public static List<String> parseStringToStringList(String source, String token) {
        String[] units;
        if (StringUtils.isBlank((String)source) || StringUtils.isEmpty((String)token)) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String unit : units = source.split(token)) {
            result.add(unit);
        }
        return result;
    }

    public static String defaultIfEmpty(String str, String defaultStr) {
        return str == null || str.length() == 0 ? defaultStr : str;
    }

    public static String defaultIfBlank(String str, String defaultStr) {
        return StringUtils.isBlank((String)str) ? defaultStr : str;
    }

    public static String toCamelCase(String str) {
        return new WordTokenizer(){

            @Override
            protected void startSentence(StringBuilder buffer, char ch) {
                buffer.append(Character.toLowerCase(ch));
            }

            @Override
            protected void startWord(StringBuilder buffer, char ch) {
                if (!this.isDelimiter(buffer.charAt(buffer.length() - 1))) {
                    buffer.append(Character.toUpperCase(ch));
                } else {
                    buffer.append(Character.toLowerCase(ch));
                }
            }

            @Override
            protected void inWord(StringBuilder buffer, char ch) {
                buffer.append(Character.toLowerCase(ch));
            }

            @Override
            protected void startDigitSentence(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            @Override
            protected void startDigitWord(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            @Override
            protected void inDigitWord(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            @Override
            protected void inDelimiter(StringBuilder buffer, char ch) {
                if (ch != '_') {
                    buffer.append(ch);
                }
            }
        }.parse(str);
    }

    public static String toPascalCase(String str) {
        return new WordTokenizer(){

            @Override
            protected void startSentence(StringBuilder buffer, char ch) {
                buffer.append(Character.toUpperCase(ch));
            }

            @Override
            protected void startWord(StringBuilder buffer, char ch) {
                buffer.append(Character.toUpperCase(ch));
            }

            @Override
            protected void inWord(StringBuilder buffer, char ch) {
                buffer.append(Character.toLowerCase(ch));
            }

            @Override
            protected void startDigitSentence(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            @Override
            protected void startDigitWord(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            @Override
            protected void inDigitWord(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            @Override
            protected void inDelimiter(StringBuilder buffer, char ch) {
                if (ch != '_') {
                    buffer.append(ch);
                }
            }
        }.parse(str);
    }

    public static String toUpperCaseWithUnderscores(String str) {
        return new WordTokenizer(){

            @Override
            protected void startSentence(StringBuilder buffer, char ch) {
                buffer.append(Character.toUpperCase(ch));
            }

            @Override
            protected void startWord(StringBuilder buffer, char ch) {
                if (!this.isDelimiter(buffer.charAt(buffer.length() - 1))) {
                    buffer.append('_');
                }
                buffer.append(Character.toUpperCase(ch));
            }

            @Override
            protected void inWord(StringBuilder buffer, char ch) {
                buffer.append(Character.toUpperCase(ch));
            }

            @Override
            protected void startDigitSentence(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            @Override
            protected void startDigitWord(StringBuilder buffer, char ch) {
                if (!this.isDelimiter(buffer.charAt(buffer.length() - 1))) {
                    buffer.append('_');
                }
                buffer.append(ch);
            }

            @Override
            protected void inDigitWord(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            @Override
            protected void inDelimiter(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }
        }.parse(str);
    }

    public static String toLowerCaseWithUnderscores(String str) {
        return new WordTokenizer(){

            @Override
            protected void startSentence(StringBuilder buffer, char ch) {
                buffer.append(Character.toLowerCase(ch));
            }

            @Override
            protected void startWord(StringBuilder buffer, char ch) {
                if (!this.isDelimiter(buffer.charAt(buffer.length() - 1))) {
                    buffer.append('_');
                }
                buffer.append(Character.toLowerCase(ch));
            }

            @Override
            protected void inWord(StringBuilder buffer, char ch) {
                buffer.append(Character.toLowerCase(ch));
            }

            @Override
            protected void startDigitSentence(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            @Override
            protected void startDigitWord(StringBuilder buffer, char ch) {
                if (!this.isDelimiter(buffer.charAt(buffer.length() - 1))) {
                    buffer.append('_');
                }
                buffer.append(ch);
            }

            @Override
            protected void inDigitWord(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }

            @Override
            protected void inDelimiter(StringBuilder buffer, char ch) {
                buffer.append(ch);
            }
        }.parse(str);
    }

    public static String longToString(long longValue) {
        return StringUtil.longToString(longValue, false);
    }

    public static String longToString(long longValue, boolean noCase) {
        char[] digits = noCase ? DIGITS_NOCASE : DIGITS;
        int digitsLength = digits.length;
        if (longValue == 0L) {
            return String.valueOf(digits[0]);
        }
        if (longValue < 0L) {
            longValue = -longValue;
        }
        StringBuilder strValue = new StringBuilder();
        while (longValue != 0L) {
            int digit = (int)(longValue % (long)digitsLength);
            longValue /= (long)digitsLength;
            strValue.append(digits[digit]);
        }
        return strValue.toString();
    }

    public static String bytesToString(byte[] bytes) {
        return StringUtil.bytesToString(bytes, false);
    }

    public static String bytesToString(byte[] bytes, boolean noCase) {
        char[] digits = noCase ? DIGITS_NOCASE : DIGITS;
        int digitsLength = digits.length;
        if (ArrayUtils.isEmpty((byte[])bytes)) {
            return String.valueOf(digits[0]);
        }
        StringBuilder strValue = new StringBuilder();
        int value = 0;
        int limit = 0x7FFFFF;
        int i = 0;
        while (true) {
            if (i < bytes.length && value < limit) {
                value = (value << 8) + (0xFF & bytes[i++]);
                continue;
            }
            while (value >= digitsLength) {
                strValue.append(digits[value % digitsLength]);
                value /= digitsLength;
            }
            if (i >= bytes.length) break;
        }
        if (value != 0 || strValue.length() == 0) {
            strValue.append(digits[value]);
        }
        return strValue.toString();
    }

    public static boolean endsWithChar(String str, char ch) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        return str.charAt(str.length() - 1) == ch;
    }

    public static boolean startsWithChar(String str, char ch) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        return str.charAt(0) == ch;
    }

    public static int indexOfChars(String string, String chars) {
        return StringUtil.indexOfChars(string, chars, 0);
    }

    public static int indexOfChars(String string, String chars, int startindex) {
        if (string == null || chars == null) {
            return -1;
        }
        int stringLen = string.length();
        int charsLen = chars.length();
        if (startindex < 0) {
            startindex = 0;
        }
        for (int i = startindex; i < stringLen; ++i) {
            char c = string.charAt(i);
            for (int j = 0; j < charsLen; ++j) {
                if (c != chars.charAt(j)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOfChars(String string, char[] chars) {
        return StringUtil.indexOfChars(string, chars, 0);
    }

    public static int indexOfChars(String string, char[] chars, int startindex) {
        if (string == null || chars == null) {
            return -1;
        }
        int stringLen = string.length();
        int charsLen = chars.length;
        for (int i = startindex; i < stringLen; ++i) {
            char c = string.charAt(i);
            for (int j = 0; j < charsLen; ++j) {
                if (c != chars[j]) continue;
                return i;
            }
        }
        return -1;
    }

    private static abstract class WordTokenizer {
        protected static final char UNDERSCORE = '_';

        private WordTokenizer() {
        }

        public String parse(String str) {
            if (StringUtils.isEmpty((String)str)) {
                return str;
            }
            int length = str.length();
            StringBuilder buffer = new StringBuilder(length);
            for (int index = 0; index < length; ++index) {
                char ch = str.charAt(index);
                if (Character.isWhitespace(ch)) continue;
                if (Character.isUpperCase(ch)) {
                    int wordIndex;
                    for (wordIndex = index + 1; wordIndex < length; ++wordIndex) {
                        char wordChar = str.charAt(wordIndex);
                        if (Character.isUpperCase(wordChar)) {
                            continue;
                        }
                        if (!Character.isLowerCase(wordChar)) break;
                        --wordIndex;
                        break;
                    }
                    if (wordIndex == length || wordIndex > index) {
                        index = this.parseUpperCaseWord(buffer, str, index, wordIndex);
                        continue;
                    }
                    index = this.parseTitleCaseWord(buffer, str, index);
                    continue;
                }
                if (Character.isLowerCase(ch)) {
                    index = this.parseLowerCaseWord(buffer, str, index);
                    continue;
                }
                if (Character.isDigit(ch)) {
                    index = this.parseDigitWord(buffer, str, index);
                    continue;
                }
                this.inDelimiter(buffer, ch);
            }
            return buffer.toString();
        }

        private int parseUpperCaseWord(StringBuilder buffer, String str, int index, int length) {
            char ch = str.charAt(index++);
            if (buffer.length() == 0) {
                this.startSentence(buffer, ch);
            } else {
                this.startWord(buffer, ch);
            }
            while (index < length) {
                ch = str.charAt(index);
                this.inWord(buffer, ch);
                ++index;
            }
            return index - 1;
        }

        private int parseLowerCaseWord(StringBuilder buffer, String str, int index) {
            char ch = str.charAt(index++);
            if (buffer.length() == 0) {
                this.startSentence(buffer, ch);
            } else {
                this.startWord(buffer, ch);
            }
            int length = str.length();
            while (index < length && Character.isLowerCase(ch = str.charAt(index))) {
                this.inWord(buffer, ch);
                ++index;
            }
            return index - 1;
        }

        private int parseTitleCaseWord(StringBuilder buffer, String str, int index) {
            char ch = str.charAt(index++);
            if (buffer.length() == 0) {
                this.startSentence(buffer, ch);
            } else {
                this.startWord(buffer, ch);
            }
            int length = str.length();
            while (index < length && Character.isLowerCase(ch = str.charAt(index))) {
                this.inWord(buffer, ch);
                ++index;
            }
            return index - 1;
        }

        private int parseDigitWord(StringBuilder buffer, String str, int index) {
            char ch = str.charAt(index++);
            if (buffer.length() == 0) {
                this.startDigitSentence(buffer, ch);
            } else {
                this.startDigitWord(buffer, ch);
            }
            int length = str.length();
            while (index < length && Character.isDigit(ch = str.charAt(index))) {
                this.inDigitWord(buffer, ch);
                ++index;
            }
            return index - 1;
        }

        protected boolean isDelimiter(char ch) {
            return !Character.isUpperCase(ch) && !Character.isLowerCase(ch) && !Character.isDigit(ch);
        }

        protected abstract void startSentence(StringBuilder var1, char var2);

        protected abstract void startWord(StringBuilder var1, char var2);

        protected abstract void inWord(StringBuilder var1, char var2);

        protected abstract void startDigitSentence(StringBuilder var1, char var2);

        protected abstract void startDigitWord(StringBuilder var1, char var2);

        protected abstract void inDigitWord(StringBuilder var1, char var2);

        protected abstract void inDelimiter(StringBuilder var1, char var2);
    }
}

