/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.fasterxml.jackson.databind.node;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import wiremock.com.fasterxml.jackson.databind.node.ArrayNode;
import wiremock.com.fasterxml.jackson.databind.node.BigIntegerNode;
import wiremock.com.fasterxml.jackson.databind.node.BinaryNode;
import wiremock.com.fasterxml.jackson.databind.node.BooleanNode;
import wiremock.com.fasterxml.jackson.databind.node.DecimalNode;
import wiremock.com.fasterxml.jackson.databind.node.DoubleNode;
import wiremock.com.fasterxml.jackson.databind.node.IntNode;
import wiremock.com.fasterxml.jackson.databind.node.LongNode;
import wiremock.com.fasterxml.jackson.databind.node.NullNode;
import wiremock.com.fasterxml.jackson.databind.node.NumericNode;
import wiremock.com.fasterxml.jackson.databind.node.ObjectNode;
import wiremock.com.fasterxml.jackson.databind.node.POJONode;
import wiremock.com.fasterxml.jackson.databind.node.TextNode;
import wiremock.com.fasterxml.jackson.databind.node.ValueNode;

public class JsonNodeFactory
implements Serializable {
    private static final long serialVersionUID = 2323165117839546871L;
    private final boolean _cfgBigDecimalExact;
    private static final JsonNodeFactory decimalsNormalized = new JsonNodeFactory(false);
    private static final JsonNodeFactory decimalsAsIs = new JsonNodeFactory(true);
    public static final JsonNodeFactory instance = decimalsNormalized;

    protected JsonNodeFactory(boolean bigDecimalExact) {
        this._cfgBigDecimalExact = bigDecimalExact;
    }

    protected JsonNodeFactory() {
        this(false);
    }

    public static JsonNodeFactory withExactBigDecimals(boolean bigDecimalExact) {
        return bigDecimalExact ? decimalsAsIs : decimalsNormalized;
    }

    public BooleanNode booleanNode(boolean v) {
        return v ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    public NumericNode numberNode(byte v) {
        return IntNode.valueOf(v);
    }

    public ValueNode numberNode(Byte value) {
        return value == null ? this.nullNode() : IntNode.valueOf(value.intValue());
    }

    public NumericNode numberNode(short v) {
        return IntNode.valueOf(v);
    }

    public ValueNode numberNode(Short value) {
        return value == null ? this.nullNode() : IntNode.valueOf(value.shortValue());
    }

    public NumericNode numberNode(int v) {
        return IntNode.valueOf(v);
    }

    public ValueNode numberNode(Integer value) {
        return value == null ? this.nullNode() : IntNode.valueOf(value);
    }

    public NumericNode numberNode(long v) {
        return LongNode.valueOf(v);
    }

    public ValueNode numberNode(Long value) {
        return value == null ? this.nullNode() : LongNode.valueOf(value);
    }

    public NumericNode numberNode(BigInteger v) {
        return BigIntegerNode.valueOf(v);
    }

    public NumericNode numberNode(float v) {
        return DoubleNode.valueOf(v);
    }

    public ValueNode numberNode(Float value) {
        return value == null ? this.nullNode() : DoubleNode.valueOf(value.doubleValue());
    }

    public NumericNode numberNode(double v) {
        return DoubleNode.valueOf(v);
    }

    public ValueNode numberNode(Double value) {
        return value == null ? this.nullNode() : DoubleNode.valueOf(value);
    }

    public NumericNode numberNode(BigDecimal v) {
        return DecimalNode.valueOf(this._cfgBigDecimalExact ? v : v.stripTrailingZeros());
    }

    public TextNode textNode(String text) {
        return TextNode.valueOf(text);
    }

    public BinaryNode binaryNode(byte[] data) {
        return BinaryNode.valueOf(data);
    }

    public BinaryNode binaryNode(byte[] data, int offset, int length) {
        return BinaryNode.valueOf(data, offset, length);
    }

    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    public POJONode POJONode(Object pojo) {
        return new POJONode(pojo);
    }
}

