/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.http.impl.cookie;

import wiremock.org.apache.http.annotation.Immutable;
import wiremock.org.apache.http.cookie.Cookie;
import wiremock.org.apache.http.cookie.CookieOrigin;
import wiremock.org.apache.http.cookie.MalformedCookieException;
import wiremock.org.apache.http.cookie.SetCookie;
import wiremock.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;

@Immutable
public class BasicSecureHandler
extends AbstractCookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        cookie.setSecure(true);
    }

    public boolean match(Cookie cookie, CookieOrigin origin) {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        return !cookie.isSecure() || origin.isSecure();
    }
}

