/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.soap.transport.jms;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.soap.transport.jms.AsyncCallback;
import com.ibm.mq.soap.transport.jms.TLS;
import com.ibm.mq.soap.util.MQTrace;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;

public final class AsyncUtil
implements Serializable {
    public static final String SCCSID = "@(#) java/soap/com/ibm/mq/soap/transport/jms/AsyncUtil.java, soap, p701, p701-112-140304 1.5.2.1 09/08/16 06:57:42";
    public static final String REQUESTSLOT = "WMQ_async_request";
    public static final String RESPONSESLOT = "WMQ_async_response";
    public static String CLIENTIDSTRINGSLOT = "WMQ_async_request_clientid_string";
    public static String DOINSYNCPOINTSLOT = "WMQ_async_request_doInSyncPoint";
    public static String RESPONSEDOINSYNCPOINTSLOT = "WMQ_async_response_doInSyncPoint";

    public static Object getAsyncContext() {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 103);
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 103, 0);
        }
        return TLS.get(REQUESTSLOT);
    }

    public static String getClientId() {
        return (String)TLS.get(CLIENTIDSTRINGSLOT);
    }

    public static boolean getDoInSyncPoint() {
        boolean bl = false;
        String string = (String)TLS.get(DOINSYNCPOINTSLOT);
        if (string.equalsIgnoreCase("true")) {
            bl = true;
        }
        return bl;
    }

    public static boolean getResponseDoInSyncPoint() {
        boolean bl = false;
        String string = (String)TLS.get(RESPONSEDOINSYNCPOINTSLOT);
        if (string.equalsIgnoreCase("true")) {
            bl = true;
        }
        return bl;
    }

    public static boolean asyncIsPending() {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 104);
        }
        if (null == TLS.get(REQUESTSLOT)) {
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 104, -1, Integer.MIN_VALUE, "No request pending");
            }
            return false;
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 104, 0);
        }
        return true;
    }

    public static boolean asyncResponseIsPending() {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 105);
        }
        if (null == TLS.get(RESPONSESLOT)) {
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 105, -1, Integer.MIN_VALUE, "No Response pending");
            }
            return false;
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 105, 0);
        }
        return true;
    }

    public static Object getAsyncResponseContext() {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 106);
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 106, 0);
        }
        return TLS.get(RESPONSESLOT);
    }

    public static void clearAsyncContext() {
        TLS.free(REQUESTSLOT);
        TLS.free(CLIENTIDSTRINGSLOT);
        TLS.free(DOINSYNCPOINTSLOT);
    }

    public static byte[] serialiseContext(AsyncCallback asyncCallback) {
        byte[] byArray;
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 107);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(asyncCallback);
            objectOutputStream.flush();
            objectOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            MQTrace.writeSoapLog("9", null, 0x20009920, 0, 0, "com.ibm.mq.soap.AsyncUtil.serialiseContext", exception.toString(), null, "com.ibm.mq.soap.AsyncUtil.java", 0, 0, Level.ALL);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 107, -1, Integer.MIN_VALUE, "Exception raised in serialiseContext: " + exception.toString());
            }
            return null;
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 107, 0);
        }
        return byArray;
    }

    public static void clearAsyncResponseContext() {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 108);
        }
        TLS.free(RESPONSESLOT);
        TLS.free(RESPONSEDOINSYNCPOINTSLOT);
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 108, 0);
        }
    }

    public static byte[] getBytes(int n) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(n);
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            MQTrace.writeSoapLog("9", null, 0x20009920, 0, 0, "com.ibm.mq.soap.AsyncUtil.getBytes", exception.toString(), null, "com.ibm.mq.soap.AsyncUtil.java", 0, 0, Level.ALL);
            return null;
        }
    }
}

