/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.soap.transport.jms;

import com.ibm.mq.MQMessage;
import com.ibm.mq.soap.transport.jms.WMQSOAPException;
import com.ibm.mq.soap.util.HexString;
import com.ibm.mq.soap.util.MQTrace;
import java.io.IOException;
import java.util.Date;

public final class RFH2Message
extends MQMessage {
    public static final String SCCSID = "@(#) java/soap/com/ibm/mq/soap/transport/jms/RFH2Message.java, soap, p701, p701-112-140304 1.30.1.1 09/08/16 05:47:58";
    private final int MQRFH_VERSION_2 = 2;
    private final int MQLONG_LENGTH = 4;
    private final int MQTRANSPORTVERSION = 1;
    private final String MQCONTENTTYPE = "text/xml; charset=utf-8";
    private int _NameValueCCSID = 0;
    private final int JMSC_MQJMS_PER_QDEF = -1;
    private final int JMSC_MQJMS_PER_NON = 1;
    private final int JMSC_MQJMS_PER_PER = 2;
    public final int SIDE_QUEUE_REQUEST_CONTEXT = 1;
    public final int SIDE_QUEUE_QUEUE_MAPPING = 2;
    private int _strucLength = 0;
    private int _strucLengthOffset = 0;
    private String _contentType = null;
    private int _transportVersion = 0;
    private int lenMCD = 0;
    private int lenJMS = 0;
    private int lenUSR = 0;
    private int lenFixed = 36;
    private String mcdBuff = "";
    private String jmsBuff = "";
    private String usrBuff = "";
    private String _buff = "";
    private String _folderName = "";
    private String _soapAction = null;
    private String _targetUri = "";
    private String _clientId = "";
    private int _sideQueueReason = 0;
    private String _sideQueueBaseQueueName = "";
    private String _sideQueueExpandedQueueName = "";
    private String _varName = "";
    private String _varValue = "";
    private int _offSet = 0;
    private int _folderEnd = 0;
    private String _dstQueue = null;

    public String get() throws IOException, WMQSOAPException {
        this.getFixed();
        this.getMCD();
        this.getJMS();
        this.getUSR();
        return this.getRest();
    }

    public byte[] getAsBytes() throws IOException, WMQSOAPException {
        this.getFixed();
        this.getMCD();
        this.getJMS();
        this.getUSR();
        return this.getRestAsBytes();
    }

    public void set(String string) throws IOException {
        this.setRFH2();
        this.writeActualString(string);
    }

    public void set(byte[] byArray) throws IOException {
        this.setRFH2();
        this.write(byArray);
    }

    private void setRFH2() throws IOException {
        this.setFixed();
        this.StartFolder("mcd");
        this.FolderEntry("Msd", "jms_bytes");
        this.EndFolder();
        this.StartFolder("jms");
        if (this._dstQueue != null) {
            this.FolderEntry("Dst", this._dstQueue);
        } else {
            this.FolderEntry("Dst", "queue://dummy");
        }
        String string = null;
        if (this.replyToQueueManagerName != null && this.replyToQueueManagerName.length() != 0) {
            string = "queue://" + this.replyToQueueManagerName;
        }
        if (this.replyToQueueName != null && this.replyToQueueName.length() != 0) {
            string = string != null ? string + "/" + this.replyToQueueName : "queue:///" + this.replyToQueueName;
        }
        if (string != null) {
            this.FolderEntry("Rto", string);
        }
        Date date = new Date();
        Long l = new Long(date.getTime());
        this.FolderEntry("Tms", l.toString());
        this.FolderEntry("Cid", "ID:" + HexString.BytesToString(this.correlationId).toLowerCase());
        int n = -1;
        if (this.persistence == 1) {
            n = 2;
        }
        if (this.persistence == 0) {
            n = 1;
        }
        this.FolderEntry("Dlv", Integer.toString(n));
        this.EndFolder();
        this.StartFolder("usr");
        this.FolderEntry("contentType", "text/xml; charset=utf-8");
        this.FolderEntry("transportVersion", Integer.toString(1));
        if (this._soapAction != null) {
            this.FolderEntry("soapAction", this._soapAction);
        }
        if (!this._targetUri.equals("")) {
            this.FolderEntry("endpointURL", this._targetUri);
            int n2 = this._targetUri.indexOf("targetService=");
            if (n2 != -1) {
                String string2 = null;
                int n3 = this._targetUri.indexOf(38, n2 += "targetService=".length());
                string2 = n3 != -1 ? this._targetUri.substring(n2, n3) : this._targetUri.substring(n2);
                this.FolderEntry("targetService", string2);
            }
        }
        if (this._clientId != null && !this._clientId.equals("")) {
            this.FolderEntry("ClientId", this._clientId);
        }
        if (this._sideQueueReason != 0) {
            this.FolderEntry("SideQueueReason", Integer.toString(this._sideQueueReason));
        }
        if (!this._sideQueueBaseQueueName.equals("")) {
            this.FolderEntry("SideQueueBaseQueueName", this._sideQueueBaseQueueName);
        }
        if (!this._sideQueueExpandedQueueName.equals("")) {
            this.FolderEntry("SideQueueExpandedQueueName", this._sideQueueExpandedQueueName);
        }
        this.EndFolder();
        this.EndRFH2();
    }

    private String readActualString(int n) throws IOException {
        int n2 = this.characterSet;
        this.characterSet = 1208;
        String string = this.readStringOfByteLength(n);
        this.characterSet = n2;
        return string;
    }

    private void writeActualString(String string) throws IOException {
        int n = this.characterSet;
        this.characterSet = 1208;
        this.writeString(string);
        this.characterSet = n;
    }

    private void getFixed() throws IOException, WMQSOAPException {
        if (this.getMessageLength() - this.lenFixed < 4) {
            String string = MQTrace.writeSoapExceptionLog("60", 536910145, 0, 0, null, null, null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string, 2, 2421, null);
            throw wMQSOAPException;
        }
        String string = this.readStringOfCharLength(4);
        if (!string.equals("RFH ")) {
            String string2 = MQTrace.writeSoapExceptionLog("60", 536910145, 0, 0, null, null, null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string2, 2, 2421, null);
            throw wMQSOAPException;
        }
        int n = this.readInt();
        if (n != 2) {
            String string3 = MQTrace.writeSoapExceptionLog("61", 536910147, 0, 0, null, null, null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string3, 2, 2421, null);
            throw wMQSOAPException;
        }
        this._strucLength = this.readInt();
        if (this._strucLength < 0 || this._strucLength > this.getMessageLength()) {
            String string4 = MQTrace.writeSoapExceptionLog("62", 536910148, 0, 0, null, null, null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string4, 2, 2421, null);
            throw wMQSOAPException;
        }
        int n2 = this.readInt();
        int n3 = this.readInt();
        String string5 = this.readStringOfCharLength(8);
        if (!string5.equals("        ")) {
            String string6 = MQTrace.writeSoapExceptionLog("76", 536910146, 0, 0, null, null, null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string6, 2, 2421, null);
            throw wMQSOAPException;
        }
        int n4 = this.readInt();
        this._NameValueCCSID = this.readInt();
    }

    private void setFixed() throws IOException {
        String string = "RFH ";
        int n = 2;
        int n2 = 1;
        int n3 = 1208;
        int n4 = 0;
        int n5 = 1208;
        this.writeString(string);
        this.writeInt(n);
        this._strucLengthOffset = this.getDataOffset();
        this._strucLength = this.lenFixed;
        this.writeInt(this._strucLength);
        this.writeInt(n2);
        this.writeInt(n3);
        this.writeBytes("        ");
        this.writeInt(n4);
        this.writeInt(n5);
    }

    public RFH2Message() {
        this.encoding = 1;
    }

    public RFH2Message(String string) {
        this.encoding = 1;
        this._dstQueue = "queue://" + string;
    }

    private boolean StartFolder(String string) {
        this._folderName = string;
        this._buff = "<" + this._folderName + ">";
        return true;
    }

    private boolean FolderEntry(String string, String string2) {
        if (!string.equals("Dst") && !string.equals("Rto")) {
            StringBuffer stringBuffer = new StringBuffer();
            this.StringToXML(stringBuffer, string2);
            string2 = stringBuffer.toString();
        }
        this._buff = this._buff + "<" + string + ">" + string2 + "</" + string + ">";
        return true;
    }

    private String padBuffer(String string) {
        int n = string.length() % 4;
        if (n != 0) {
            for (int i = 0; i < 4 - n; ++i) {
                string = string + " ";
            }
        }
        return string;
    }

    private void EndFolder() throws IOException {
        this._buff = this.padBuffer(this._buff + "</" + this._folderName + ">");
        this.writeInt(this._buff.length());
        this._strucLength += this._buff.length() + 4;
        this.writeBytes(this._buff);
    }

    private void EndRFH2() throws IOException {
        int n = this.getDataOffset();
        this.setDataOffset(this._strucLengthOffset);
        this.writeInt(this._strucLength);
        this.setDataOffset(n);
    }

    private void getMCD() throws IOException, WMQSOAPException {
        this.lenMCD = this.readInt();
        if (this.lenMCD > this.getMessageLength() - this.lenFixed - 4) {
            String string = MQTrace.writeSoapExceptionLog("63", 536910149, 0, 0, "MCD", null, null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string, 2, 2421, null);
            throw wMQSOAPException;
        }
        int n = this.characterSet;
        this.characterSet = this._NameValueCCSID;
        this.mcdBuff = this.readStringOfByteLength(this.lenMCD);
        this.characterSet = n;
        this.parseFolder(this.mcdBuff);
    }

    private void getJMS() throws IOException, WMQSOAPException {
        this.lenJMS = this.readInt();
        if (this.lenJMS > this.getMessageLength() - this.lenFixed - 4 - this.lenMCD - 4) {
            String string = MQTrace.writeSoapExceptionLog("63", 536910149, 0, 0, "JMS", null, null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string, 2, 2421, null);
            throw wMQSOAPException;
        }
        int n = this.characterSet;
        this.characterSet = this._NameValueCCSID;
        this.jmsBuff = this.readStringOfByteLength(this.lenJMS);
        this.characterSet = n;
        this.parseFolder(this.jmsBuff);
    }

    private void getUSR() throws IOException, WMQSOAPException {
        this.lenUSR = this.readInt();
        if (this.lenUSR > this.getMessageLength() - this.lenFixed - 4 - this.lenMCD - 4 - this.lenJMS - 4) {
            String string = MQTrace.writeSoapExceptionLog("63", 536910149, 0, 0, "USR", null, null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string, 2, 2421, null);
            throw wMQSOAPException;
        }
        int n = this.characterSet;
        this.characterSet = this._NameValueCCSID;
        this.usrBuff = this.readStringOfByteLength(this.lenUSR);
        this.characterSet = n;
        this.usrBuff = this.safeUTF8ToString(this.usrBuff.getBytes(), 0, this.usrBuff.length());
        this.parseFolder(this.usrBuff);
        if (this._contentType == null || !this._contentType.equalsIgnoreCase("text/xml; charset=utf-8") || this._transportVersion != 1) {
            String string = MQTrace.writeSoapExceptionLog("77", 536910163, 0, 0, null, null, null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string, 2, 2228, null);
            throw wMQSOAPException;
        }
    }

    private String getRest() throws IOException, WMQSOAPException {
        int n = this.getMessageLength() - this.lenMCD - this.lenJMS - this.lenUSR - 12 - this.lenFixed;
        if (n < 0) {
            String string = MQTrace.writeSoapExceptionLog("64", 536910150, 0, 0, null, null, null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string, 2, 2421, null);
            throw wMQSOAPException;
        }
        return this.readActualString(n);
    }

    private byte[] getRestAsBytes() throws IOException, WMQSOAPException {
        int n = this.getMessageLength() - this.lenMCD - this.lenJMS - this.lenUSR - 12 - this.lenFixed;
        if (n < 0) {
            String string = MQTrace.writeSoapExceptionLog("64", 536910150, 0, 0, null, null, null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string, 2, 2421, null);
            throw wMQSOAPException;
        }
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    private int myIndexOfAny(String string, char[] cArray, int n) {
        int n2 = -1;
        for (int i = 0; i < cArray.length; ++i) {
            int n3 = string.indexOf(cArray[i], n);
            if (-1 == n3) continue;
            if (n2 == -1) {
                n2 = n3;
                continue;
            }
            if (n3 >= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private String getFolderName(String string) throws WMQSOAPException {
        this._offSet = string.indexOf(60);
        if (this._offSet == -1) {
            String string2 = MQTrace.writeSoapExceptionLog("65", 536910151, 0, 0, "syntax", "1", null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string2, 2, 2421, null);
            throw wMQSOAPException;
        }
        char[] cArray = new char[]{' ', '>'};
        int n = this.myIndexOfAny(string, cArray, 0);
        if (n == -1) {
            String string3 = MQTrace.writeSoapExceptionLog("65", 536910151, 0, 0, "syntax", "2", null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string3, 2, 2421, null);
            throw wMQSOAPException;
        }
        String string4 = string.substring(this._offSet + 1, n);
        this._offSet = string.indexOf(62);
        if (this._offSet == -1) {
            String string5 = MQTrace.writeSoapExceptionLog("65", 536910151, 0, 0, "syntax", "3", null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string5, 2, 2421, null);
            throw wMQSOAPException;
        }
        String string6 = "</" + string4 + ">";
        this._folderEnd = string.indexOf(string6);
        if (this._folderEnd == -1) {
            String string7 = MQTrace.writeSoapExceptionLog("65", 536910151, 0, 0, "syntax", "4", null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string7, 2, 2421, null);
            throw wMQSOAPException;
        }
        return string4;
    }

    private boolean getTriplet(String string) throws WMQSOAPException {
        int n = string.indexOf(60, this._offSet);
        if (n >= this._folderEnd) {
            return false;
        }
        this._offSet = n;
        char[] cArray = new char[]{' ', '>'};
        int n2 = this.myIndexOfAny(string, cArray, this._offSet);
        if (n2 < 0) {
            String string2 = MQTrace.writeSoapExceptionLog("65", 536910151, 0, 0, "format", "1", null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string2, 2, 2421, null);
            throw wMQSOAPException;
        }
        this._varName = string.substring(n + 1, n2);
        this._offSet = string.indexOf(62, this._offSet);
        if (this._offSet < 0) {
            String string3 = MQTrace.writeSoapExceptionLog("65", 536910151, 0, 0, "format", "2", null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string3, 2, 2421, null);
            throw wMQSOAPException;
        }
        ++this._offSet;
        int n3 = this._offSet;
        int n4 = string.indexOf("</", this._offSet);
        if (n4 < 0) {
            String string4 = MQTrace.writeSoapExceptionLog("65", 536910151, 0, 0, "format", "3", null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string4, 2, 2421, null);
            throw wMQSOAPException;
        }
        this._varValue = string.substring(n3, n4);
        this._offSet = string.indexOf(">", n4);
        if (this._offSet < 0) {
            String string5 = MQTrace.writeSoapExceptionLog("65", 536910151, 0, 0, "format", "4", null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string5, 2, 2421, null);
            throw wMQSOAPException;
        }
        return true;
    }

    private boolean parseFolder(String string) throws WMQSOAPException {
        this.getFolderName(string);
        while (this.getTriplet(string)) {
            if (this._varName.equals("soapAction")) {
                this._soapAction = this._varValue;
            }
            if (this._varName.equals("endpointURL")) {
                this._targetUri = this._varValue;
            }
            if (this._varName.equals("ClientId")) {
                this._clientId = this._varValue;
            }
            if (this._varName.equals("contentType")) {
                this._contentType = this._varValue;
            }
            if (this._varName.equals("transportVersion")) {
                this._transportVersion = Integer.parseInt(this._varValue);
            }
            if (this._varName.equals("SideQueueReason")) {
                this._sideQueueReason = Integer.parseInt(this._varValue);
            }
            if (this._varName.equals("SideQueueBaseQueueName")) {
                this._sideQueueBaseQueueName = this._varValue;
            }
            if (!this._varName.equals("SideQueueExpandedQueueName")) continue;
            this._sideQueueExpandedQueueName = this._varValue;
        }
        return true;
    }

    private String safeUTF8ToString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = n;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        while (n3 - n < n2) {
            byte by = byArray[n3];
            if (bl) {
                if (by == 59) {
                    bl = false;
                    switch (n5) {
                        case 6385008: {
                            cArray[n4] = 38;
                            break;
                        }
                        case 26484: {
                            cArray[n4] = 62;
                            break;
                        }
                        case 27764: {
                            cArray[n4] = 60;
                            break;
                        }
                        case 1634758515: {
                            cArray[n4] = 39;
                            break;
                        }
                        case 1903521652: {
                            cArray[n4] = 34;
                            break;
                        }
                    }
                    ++n4;
                } else {
                    if (by < 0) {
                        by = (byte)(by + 256);
                    }
                    n5 <<= 8;
                    n5 += by;
                }
            } else if (by == 38) {
                bl = true;
                n5 = 0;
            } else {
                cArray[n4] = (char)byArray[n3];
                ++n4;
            }
            ++n3;
        }
        return new String(cArray, 0, n4);
    }

    void StringToXML(StringBuffer stringBuffer, String string) {
        char c;
        int n;
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (!(c == '&' | c == '\"' | c == '\'' | c == '<' | c == '>')) continue;
            ++n2;
        }
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if ('<' == c) {
                stringBuffer.append("&lt;");
                continue;
            }
            if ('>' == c) {
                stringBuffer.append("&gt;");
                continue;
            }
            if ('&' == c) {
                stringBuffer.append("&amp;");
                continue;
            }
            if ('\"' == c) {
                stringBuffer.append("&quot;");
                continue;
            }
            if ('\'' == c) {
                stringBuffer.append("&apos;");
                continue;
            }
            stringBuffer.append(c);
        }
    }

    public String getSoapAction() {
        return this._soapAction;
    }

    public void setSoapAction(String string) {
        this._soapAction = string;
    }

    public String getTargetUri() {
        return this._targetUri;
    }

    public void setTargetUri(String string) {
        this._targetUri = string;
    }

    public void setSideQueueReason(int n) {
        this._sideQueueReason = n;
    }

    public int getSideQueueReason() {
        return this._sideQueueReason;
    }

    public void setClientId(String string) {
        this._clientId = string;
    }

    public String getClientId() {
        return this._clientId;
    }

    public void setSideQueueBaseQueueName(String string) {
        this._sideQueueBaseQueueName = string;
    }

    public String getSideQueueBaseQueueName() {
        return this._sideQueueBaseQueueName;
    }

    public void setSideQueueExpandedQueueName(String string) {
        this._sideQueueExpandedQueueName = string;
    }

    public String getSideQueueExpandedQueueName() {
        return this._sideQueueExpandedQueueName;
    }

    public String getContenType() {
        return this._contentType;
    }

    public void setContentType(String string) {
        this._contentType = string;
    }

    public int getTransportVersion() {
        return this._transportVersion;
    }

    public void setTransportVersion(int n) {
        this._transportVersion = n;
    }
}

