/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.soap.transport.jms;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.soap.transport.jms.WMQSOAPException;
import com.ibm.mq.soap.util.MQTrace;
import com.ibm.mq.soap.util.ParseOptions;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class WMQAddress {
    public static final String MQ_URL_PREFIX = "jms:/queue?";
    public static final String MQ_DEFAULT_REPLY_QUEUE = "SYSTEM.SOAP.RESPONSE.QUEUE";
    private static final String MQ_ADDRESS_ATTR_SEP = "&";
    private static final String MQ_ADDRESS_ATTR_VAL = "=";
    private static final String MQ_ADDRESS_QMGR_SEP = "@";
    private static final String MQ_ADDRESS_LOWLEVEL_START = "(";
    private static final String MQ_ADDRESS_LOWLEVEL_END = ")";
    private static final String MQ_ADDRESS_ATTR_DESTINATION = "destination";
    private static final String MQ_ADDRESS_ATTR_CONNECTIONFACTORY = "connectionFactory";
    private static final String MQ_ADDRESS_ATTR_INITIALCONTEXTFACTORY = "initialContextFactory";
    private static final String MQ_ADDRESS_ATTR_TARGETSERVICE = "targetService";
    private static final String MQ_ADDRESS_ATTR_TIMEOUT = "timeout";
    private static final String MQ_ADDRESS_ATTR_TIMETOLIVE = "timeToLive";
    private static final String MQ_ADDRESS_ATTR_PERSISTENCE = "persistence";
    private static final String MQ_ADDRESS_ATTR_PRIORITY = "priority";
    private static final String MQ_ADDRESS_ATTR_REPLYDESTINATION = "replyDestination";
    private static final String MQ_ADDRESS_ATTR_CONNECT_QUEUE_MANAGER = "connectQueueManager";
    private static final String MQ_ADDRESS_ATTR_BINDING = "binding";
    private static final String MQ_ADDRESS_ATTR_CLIENT_CHANNEL = "clientChannel";
    private static final String MQ_ADDRESS_ATTR_CLIENT_CONNECTION = "clientConnection";
    private static final String MQ_ADDRESS_ATTR_SSLKEYREPOSITORY = "sslKeyRepository";
    private static final String MQ_ADDRESS_ATTR_SSLCIPHERSPEC = "sslCipherSpec";
    private static final String MQ_ADDRESS_ATTR_SSLCIPHERSUITE = "sslCipherSuite";
    private static final String MQ_ADDRESS_ATTR_SSLPEERNAME = "sslPeerName";
    private static final String MQ_ADDRESS_ATTR_SSLKEYRESETCOUNT = "sslKeyResetCount";
    private static final String MQ_ADDRESS_ATTR_SSLLDAPCRLSERVERS = "sslLDAPCRLServers";
    private static final String MQ_ADDRESS_ATTR_SSLKEYSTORE = "sslKeyStore";
    private static final String MQ_ADDRESS_ATTR_SSLKEYSTOREPASSWORD = "sslKeyStorePassword";
    private static final String MQ_ADDRESS_ATTR_SSLTRUSTSTORE = "sslTrustStore";
    private static final String MQ_ADDRESS_ATTR_SSLTRUSTSTOREPASSWORD = "sslTrustStorePassword";
    private static final String MQ_ADDRESS_ATTR_SSLFIPSREQUIRED = "sslFipsRequired";
    private static final String MQ_ADDRESS_VAL_VALID_INITIALCONTEXTFATORY = "com.ibm.mq.jms.Nojndi";
    private static final String MQ_ADDRESS_VAL_EMPTY_CONNECTIONFACTORY = "()";
    private static final String MQ_ADDRESS_VAL_NONPERSISTENT = "1";
    private static final String MQ_ADDRESS_VAL_PERSISTENT = "2";
    private static final String MQ_ADDRESS_VAL_ASQDEF = "3";
    private static final String MQ_ADDRESS_VAL_CLIENT_TRANSPORT_TCP = "tcp";
    private static final int MQ_ADDRESS_VAL_BINDING_CLIENT = 1;
    private static final int MQ_ADDRESS_VAL_BINDING_SERVER = 2;
    private static final int MQ_ADDRESS_VAL_BINDING_XACLIENT = 3;
    private static final int MQ_ADDRESS_VAL_BINDING_AUTO = 4;
    private static final int MQ_DEFAULT_PERSISTENCE = 0;
    private static final int MQ_DEFAULT_PRIORITY = -1;
    private static final int MQ_DEFAULT_EXPIRY = -1;
    private static final String MQ_ENCODING_CODEPAGE = "UTF-8";
    private static final String SCCSID = "@(#) java/soap/com/ibm/mq/soap/transport/jms/WMQAddress.java, soap, p701, p701-112-140304 1.26.1.1 09/08/16 05:47:30";
    private String requestQueueName = null;
    private String serviceQmgr = null;
    private String responseQueueName = null;
    private String connectQueueManager = null;
    private int timeout = 0;
    private int persistence = 0;
    private String persString = null;
    private int expiry = -1;
    private int priority = -1;
    private String clientChannel = null;
    private String clientTransport = "tcp";
    private String clientConnection = null;
    private String hostName = null;
    private int portNo = 1414;
    private String sslCipherSpec = null;
    private String sslCipherSuite = null;
    private String sslPeerName = null;
    private String sslKeyRepository = null;
    private String sslLdapCRLServers = null;
    private int sslKeyResetCount = 0;
    private Collection sslLdapCRLColl = null;
    private String sslKeyStore = null;
    private String sslKeyStorePassword = null;
    private String sslTrustStore = null;
    private String sslTrustStorePassword = null;
    private String sslFipsRequired = null;
    private boolean sslSpecified = false;
    private boolean connectionFactoryProvided = false;
    private boolean initialContextFactoryProvided = false;
    private String bindingStr = null;
    private int binding = 4;
    private String targetService = null;
    public static final int MQ_TRANSACTION_NONE = 0;
    public static final int MQ_TRANSACTION_PARTICIPANT = 1;
    public static final int MQ_TRANSACTION_OWNER = 2;

    public void setWmqURI(String string) throws WMQSOAPException {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 122, 0, string);
        }
        if (string == null) {
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 122);
            }
            return;
        }
        if (!string.startsWith(MQ_URL_PREFIX)) {
            String string2 = MQTrace.writeSoapExceptionLog("66", 536910132, 0, 0, string, null, null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string2, 2, 2212, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 122);
            }
            throw wMQSOAPException;
        }
        String string3 = string.substring(MQ_URL_PREFIX.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string3, MQ_ADDRESS_ATTR_SEP, false);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            Object object2;
            int n;
            Object object3;
            String string4;
            String string5 = stringTokenizer.nextToken();
            int n2 = string5.indexOf(MQ_ADDRESS_ATTR_VAL);
            if (n2 < 1 || n2 == string5.length() - 1) {
                string4 = MQTrace.writeSoapExceptionLog("66", 536910132, 0, 0, string, null, null);
                object3 = WMQSOAPException.getSOAPException(string4, 2, 2212, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 122);
                }
                throw object3;
            }
            string4 = string5.substring(0, n2);
            object3 = string5.substring(n2 + 1);
            string4 = this.outerDecode(string4);
            object3 = this.outerDecode((String)object3);
            if (string4.equals(MQ_ADDRESS_ATTR_DESTINATION)) {
                n = ((String)object3).indexOf(MQ_ADDRESS_QMGR_SEP);
                if (n == -1) {
                    this.requestQueueName = object3;
                    continue;
                }
                if (n < ((String)object3).length() - 1) {
                    this.requestQueueName = ((String)object3).substring(0, n);
                    this.serviceQmgr = ((String)object3).substring(n + 1);
                    continue;
                }
                object2 = MQTrace.writeSoapExceptionLog("67", 536910128, 0, 0, "QueueMgr", null, null);
                object = WMQSOAPException.getSOAPException((String)object2, 2, 2212, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 124);
                }
                throw object;
            }
            if (string4.equals(MQ_ADDRESS_ATTR_CONNECTIONFACTORY)) {
                Object object4;
                this.connectionFactoryProvided = true;
                if (((String)object3).equals(MQ_ADDRESS_VAL_EMPTY_CONNECTIONFACTORY)) continue;
                n = 0;
                if (((String)object3).substring(0, 1).equals(MQ_ADDRESS_LOWLEVEL_START)) {
                    n = 1;
                    object3 = ((String)object3).substring(1);
                }
                object2 = new StringTokenizer((String)object3, MQ_ADDRESS_LOWLEVEL_END, true);
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    String string6;
                    Object object5;
                    String string7;
                    object = ((StringTokenizer)object2).nextToken();
                    if (!((StringTokenizer)object2).hasMoreTokens()) {
                        if (n == 0) {
                            object4 = MQTrace.writeSoapExceptionLog("66", 536910132, 0, 0, string, null, null);
                            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException((String)object4, 2, 2212, null);
                            if (Trace.isTracing) {
                                MQTrace.mqTrace.exit(49, 122);
                            }
                            throw wMQSOAPException;
                        }
                        if (!((String)object).equals(MQ_ADDRESS_LOWLEVEL_END)) {
                            object4 = MQTrace.writeSoapExceptionLog("66", 536910132, 0, 0, string, null, null);
                            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException((String)object4, 2, 2212, null);
                            if (Trace.isTracing) {
                                MQTrace.mqTrace.exit(49, 122);
                            }
                            throw wMQSOAPException;
                        }
                        n = 0;
                        continue;
                    }
                    object4 = ((StringTokenizer)object2).nextToken();
                    int n3 = ((String)object).indexOf(MQ_ADDRESS_LOWLEVEL_START);
                    if (n3 < 1 || n3 == ((String)object).length() - 1) {
                        string7 = MQTrace.writeSoapExceptionLog("66", 536910132, 0, 0, string, null, null);
                        object5 = WMQSOAPException.getSOAPException(string7, 2, 2212, null);
                        if (Trace.isTracing) {
                            MQTrace.mqTrace.exit(49, 122);
                        }
                        throw object5;
                    }
                    if (!((String)object4).equals(MQ_ADDRESS_LOWLEVEL_END)) {
                        string7 = MQTrace.writeSoapExceptionLog("66", 536910132, 0, 0, string, null, null);
                        object5 = WMQSOAPException.getSOAPException(string7, 2, 2212, null);
                        if (Trace.isTracing) {
                            MQTrace.mqTrace.exit(49, 122);
                        }
                        throw object5;
                    }
                    string7 = ((String)object).substring(0, n3);
                    object5 = ((String)object).substring(n3 + 1);
                    if (((String)object5).indexOf(MQ_ADDRESS_LOWLEVEL_START) > 0) {
                        if (string7.equals(MQ_ADDRESS_ATTR_CLIENT_CONNECTION)) {
                            string6 = ((StringTokenizer)object2).nextToken();
                            if (!string6.equals(MQ_ADDRESS_LOWLEVEL_END)) {
                                String string8 = MQTrace.writeSoapExceptionLog("66", 536910132, 0, 0, string, null, null);
                                WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string8, 2, 2212, null);
                                if (Trace.isTracing) {
                                    MQTrace.mqTrace.exit(49, 122);
                                }
                                throw wMQSOAPException;
                            }
                        } else {
                            string6 = MQTrace.writeSoapExceptionLog("66", 536910132, 0, 0, string, null, null);
                            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string6, 2, 2212, null);
                            if (Trace.isTracing) {
                                MQTrace.mqTrace.exit(49, 122);
                            }
                            throw wMQSOAPException;
                        }
                    }
                    string7 = this.innerDecode(string7);
                    object5 = this.innerDecode((String)object5);
                    if (string7.equals(MQ_ADDRESS_ATTR_CONNECT_QUEUE_MANAGER)) {
                        this.connectQueueManager = object5;
                        continue;
                    }
                    if (string7.equals(MQ_ADDRESS_ATTR_BINDING)) {
                        if (((String)object5).equalsIgnoreCase("client")) {
                            this.binding = 1;
                        } else if (((String)object5).equalsIgnoreCase("xaclient")) {
                            this.binding = 3;
                        } else if (((String)object5).equalsIgnoreCase("server")) {
                            this.binding = 2;
                        } else if (((String)object5).equalsIgnoreCase("auto")) {
                            this.binding = 4;
                        } else {
                            string6 = MQTrace.writeSoapExceptionLog("70", 536910129, 0, 0, (String)object5, MQ_ADDRESS_ATTR_BINDING, null);
                            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string6, 2, 2212, null);
                            if (Trace.isTracing) {
                                MQTrace.mqTrace.exit(49, 122);
                            }
                            throw wMQSOAPException;
                        }
                        this.bindingStr = object5;
                        continue;
                    }
                    if (string7.equals(MQ_ADDRESS_ATTR_CLIENT_CHANNEL)) {
                        this.clientChannel = object5;
                        continue;
                    }
                    if (string7.equals(MQ_ADDRESS_ATTR_CLIENT_CONNECTION)) {
                        this.clientConnection = object5;
                        this.parseConnName(this.clientConnection);
                        continue;
                    }
                    if (string7.equals(MQ_ADDRESS_ATTR_SSLKEYREPOSITORY)) {
                        this.sslKeyRepository = object5;
                        this.sslSpecified = true;
                        continue;
                    }
                    if (string7.equals(MQ_ADDRESS_ATTR_SSLCIPHERSPEC)) {
                        this.sslCipherSpec = object5;
                        this.sslSpecified = true;
                        continue;
                    }
                    if (string7.equals(MQ_ADDRESS_ATTR_SSLCIPHERSUITE)) {
                        this.sslCipherSuite = object5;
                        this.sslSpecified = true;
                        continue;
                    }
                    if (string7.equals(MQ_ADDRESS_ATTR_SSLPEERNAME)) {
                        this.sslPeerName = object5;
                        this.sslSpecified = true;
                        continue;
                    }
                    if (string7.equals(MQ_ADDRESS_ATTR_SSLKEYRESETCOUNT)) {
                        try {
                            this.sslKeyResetCount = Integer.parseInt((String)object5);
                            this.sslSpecified = true;
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            String string9 = MQTrace.writeSoapExceptionLog("70", 536910129, 0, 0, (String)object5, MQ_ADDRESS_ATTR_SSLKEYRESETCOUNT, null);
                            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string9, 2, 2212, null);
                            if (Trace.isTracing) {
                                MQTrace.mqTrace.exit(49, 122);
                            }
                            throw wMQSOAPException;
                        }
                    }
                    if (string7.equals(MQ_ADDRESS_ATTR_SSLLDAPCRLSERVERS)) {
                        this.sslLdapCRLServers = object5;
                        this.sslLdapCRLColl = new Vector();
                        if (!ParseOptions.ParseLDAPCRL(this.sslLdapCRLServers, this.sslLdapCRLColl)) {
                            string6 = MQTrace.writeSoapExceptionLog("70", 536910129, 0, 0, this.sslLdapCRLServers, MQ_ADDRESS_ATTR_SSLLDAPCRLSERVERS, null);
                            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string6, 2, 2212, null);
                            if (Trace.isTracing) {
                                MQTrace.mqTrace.exit(49, 122);
                            }
                            throw wMQSOAPException;
                        }
                        this.sslSpecified = true;
                        continue;
                    }
                    if (string7.equals(MQ_ADDRESS_ATTR_SSLKEYSTORE)) {
                        this.sslKeyStore = object5;
                        this.sslSpecified = true;
                        continue;
                    }
                    if (string7.equals(MQ_ADDRESS_ATTR_SSLKEYSTOREPASSWORD)) {
                        this.sslKeyStorePassword = object5;
                        this.sslSpecified = true;
                        continue;
                    }
                    if (string7.equals(MQ_ADDRESS_ATTR_SSLTRUSTSTORE)) {
                        this.sslTrustStore = object5;
                        this.sslSpecified = true;
                        continue;
                    }
                    if (string7.equals(MQ_ADDRESS_ATTR_SSLTRUSTSTOREPASSWORD)) {
                        this.sslTrustStorePassword = object5;
                        this.sslSpecified = true;
                        continue;
                    }
                    if (string7.equals(MQ_ADDRESS_ATTR_SSLFIPSREQUIRED)) {
                        if (!((String)object5).equalsIgnoreCase("yes") && !((String)object5).equalsIgnoreCase("no")) {
                            string6 = MQTrace.writeSoapExceptionLog("70", 536910129, 0, 0, (String)object5, MQ_ADDRESS_ATTR_SSLFIPSREQUIRED, null);
                            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string6, 2, 2212, null);
                            if (Trace.isTracing) {
                                MQTrace.mqTrace.exit(49, 122);
                            }
                            throw wMQSOAPException;
                        }
                        this.sslFipsRequired = object5;
                        this.sslSpecified = true;
                        continue;
                    }
                    string6 = MQTrace.writeSoapExceptionLog("70", 536910129, 0, 0, string, "ConnectionFactory", null);
                    WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string6, 2, 2212, null);
                    if (Trace.isTracing) {
                        MQTrace.mqTrace.exit(49, 122);
                    }
                    throw wMQSOAPException;
                }
                if (n == 0) continue;
                object = MQTrace.writeSoapExceptionLog("70", 536910129, 0, 0, string, "ConnectionFactory", null);
                object4 = WMQSOAPException.getSOAPException((String)object, 2, 2212, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 122);
                }
                throw object4;
            }
            if (string4.equals(MQ_ADDRESS_ATTR_INITIALCONTEXTFACTORY)) {
                this.initialContextFactoryProvided = true;
                if (((String)object3).equals(MQ_ADDRESS_VAL_VALID_INITIALCONTEXTFATORY)) continue;
                String string10 = MQTrace.writeSoapExceptionLog("70", 536910129, 0, 0, string, "InitialContextFactory", null);
                object2 = WMQSOAPException.getSOAPException(string10, 2, 2212, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 122);
                }
                throw object2;
            }
            if (string4.equals(MQ_ADDRESS_ATTR_TARGETSERVICE)) {
                this.targetService = object3;
                continue;
            }
            if (string4.equals(MQ_ADDRESS_ATTR_TIMEOUT)) {
                try {
                    this.timeout = Integer.parseInt((String)object3);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    object2 = MQTrace.writeSoapExceptionLog("70", 536910129, 0, 0, (String)object3, MQ_ADDRESS_ATTR_TIMEOUT, null);
                    object = WMQSOAPException.getSOAPException((String)object2, 2, 2212, null);
                    if (Trace.isTracing) {
                        MQTrace.mqTrace.exit(49, 122);
                    }
                    throw object;
                }
            }
            if (string4.equals(MQ_ADDRESS_ATTR_TIMETOLIVE)) {
                try {
                    this.expiry = Integer.parseInt((String)object3) / 100;
                    if (this.expiry != 0) continue;
                    this.expiry = -1;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    object2 = MQTrace.writeSoapExceptionLog("70", 536910129, 0, 0, (String)object3, MQ_ADDRESS_ATTR_TIMETOLIVE, null);
                    object = WMQSOAPException.getSOAPException((String)object2, 2, 2212, null);
                    if (Trace.isTracing) {
                        MQTrace.mqTrace.exit(49, 122);
                    }
                    throw object;
                }
            }
            if (string4.equals(MQ_ADDRESS_ATTR_PERSISTENCE)) {
                if (((String)object3).equals(MQ_ADDRESS_VAL_NONPERSISTENT)) {
                    this.persistence = 0;
                } else if (((String)object3).equals(MQ_ADDRESS_VAL_PERSISTENT)) {
                    this.persistence = 1;
                } else if (((String)object3).equals(MQ_ADDRESS_VAL_ASQDEF)) {
                    this.persistence = 2;
                } else {
                    String string11 = MQTrace.writeSoapExceptionLog("70", 536910129, 0, 0, (String)object3, MQ_ADDRESS_ATTR_PERSISTENCE, null);
                    object2 = WMQSOAPException.getSOAPException(string11, 2, 2212, null);
                    if (Trace.isTracing) {
                        MQTrace.mqTrace.exit(49, 122);
                    }
                    throw object2;
                }
                this.persString = object3;
                continue;
            }
            if (string4.equals(MQ_ADDRESS_ATTR_PRIORITY)) {
                try {
                    this.priority = Integer.parseInt((String)object3);
                    if (this.priority >= 0 && this.priority <= 9) continue;
                    String string12 = MQTrace.writeSoapExceptionLog("70", 536910129, 0, 0, (String)object3, MQ_ADDRESS_ATTR_PRIORITY, null);
                    object2 = WMQSOAPException.getSOAPException(string12, 2, 2212, null);
                    if (Trace.isTracing) {
                        MQTrace.mqTrace.exit(49, 122);
                    }
                    throw object2;
                }
                catch (NumberFormatException numberFormatException) {
                    object2 = MQTrace.writeSoapExceptionLog("70", 536910129, 0, 0, (String)object3, MQ_ADDRESS_ATTR_PRIORITY, null);
                    object = WMQSOAPException.getSOAPException((String)object2, 2, 2212, null);
                    if (Trace.isTracing) {
                        MQTrace.mqTrace.exit(49, 122);
                    }
                    throw object;
                }
            }
            if (!string4.equals(MQ_ADDRESS_ATTR_REPLYDESTINATION)) continue;
            this.responseQueueName = object3;
        }
        this.validate();
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 122, 0);
        }
    }

    public String getWmqURI() throws WMQSOAPException {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 123);
        }
        this.validate();
        StringBuffer stringBuffer = new StringBuffer(MQ_URL_PREFIX);
        stringBuffer.append(MQ_ADDRESS_ATTR_DESTINATION);
        stringBuffer.append(MQ_ADDRESS_ATTR_VAL);
        stringBuffer.append(this.outerEncode(this.getRequestQueueName()));
        if (this.getServiceQmgr().length() > 0) {
            stringBuffer.append(MQ_ADDRESS_QMGR_SEP).append(this.outerEncode(this.getServiceQmgr()));
        }
        stringBuffer.append(MQ_ADDRESS_ATTR_SEP);
        stringBuffer.append(MQ_ADDRESS_ATTR_CONNECTIONFACTORY);
        stringBuffer.append(MQ_ADDRESS_ATTR_VAL);
        stringBuffer.append(MQ_ADDRESS_LOWLEVEL_START);
        if (this.getConnectQueueManager() != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_CONNECT_QUEUE_MANAGER);
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_START);
            stringBuffer.append(this.innerEncode(this.getConnectQueueManager()));
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_END);
        }
        if (this.bindingStr != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_BINDING);
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_START);
            stringBuffer.append(this.innerEncode(this.bindingStr));
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_END);
        }
        if (this.clientChannel != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_CLIENT_CHANNEL);
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_START);
            stringBuffer.append(this.innerEncode(this.clientChannel));
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_END);
        }
        if (this.clientConnection != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_CLIENT_CONNECTION);
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_START);
            stringBuffer.append(this.innerEncode(this.clientConnection));
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_END);
        }
        if (this.sslKeyRepository != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SSLKEYREPOSITORY);
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_START);
            stringBuffer.append(this.innerEncode(this.sslKeyRepository));
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_END);
        }
        if (this.sslCipherSpec != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SSLCIPHERSPEC);
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_START);
            stringBuffer.append(this.innerEncode(this.sslCipherSpec));
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_END);
        }
        if (this.sslCipherSuite != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SSLCIPHERSUITE);
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_START);
            stringBuffer.append(this.innerEncode(this.sslCipherSuite));
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_END);
        }
        if (this.sslPeerName != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SSLPEERNAME);
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_START);
            stringBuffer.append(this.innerEncode(this.sslPeerName));
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_END);
        }
        if (this.getSslKeyResetCount() != 0) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SSLKEYRESETCOUNT);
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_START);
            stringBuffer.append(String.valueOf(this.sslKeyResetCount));
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_END);
        }
        if (this.sslLdapCRLServers != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SSLLDAPCRLSERVERS);
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_START);
            stringBuffer.append(this.innerEncode(this.sslLdapCRLServers));
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_END);
        }
        if (this.getSslKeyStore() != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SSLKEYSTORE);
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_START);
            stringBuffer.append(this.innerEncode(this.sslKeyStore));
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_END);
        }
        if (this.getSslKeyStorePassword() != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SSLKEYSTOREPASSWORD);
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_START);
            stringBuffer.append(this.innerEncode(this.sslKeyStorePassword));
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_END);
        }
        if (this.getSslTrustStore() != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SSLTRUSTSTORE);
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_START);
            stringBuffer.append(this.innerEncode(this.sslTrustStore));
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_END);
        }
        if (this.getSslTrustStorePassword() != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SSLTRUSTSTOREPASSWORD);
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_START);
            stringBuffer.append(this.innerEncode(this.sslTrustStorePassword));
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_END);
        }
        if (this.getSslFipsRequired() != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SSLFIPSREQUIRED);
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_START);
            stringBuffer.append(this.innerEncode(this.sslFipsRequired));
            stringBuffer.append(MQ_ADDRESS_LOWLEVEL_END);
        }
        stringBuffer.append(MQ_ADDRESS_LOWLEVEL_END);
        stringBuffer.append(MQ_ADDRESS_ATTR_SEP);
        stringBuffer.append(MQ_ADDRESS_ATTR_INITIALCONTEXTFACTORY);
        stringBuffer.append(MQ_ADDRESS_ATTR_VAL);
        stringBuffer.append(MQ_ADDRESS_VAL_VALID_INITIALCONTEXTFATORY);
        if (this.getTargetService() != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SEP).append(MQ_ADDRESS_ATTR_TARGETSERVICE);
            stringBuffer.append(MQ_ADDRESS_ATTR_VAL).append(this.outerEncode(this.getTargetService()));
        }
        if (this.getResponseQueueName() != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SEP).append(MQ_ADDRESS_ATTR_REPLYDESTINATION);
            stringBuffer.append(MQ_ADDRESS_ATTR_VAL).append(this.outerEncode(this.getResponseQueueName()));
        }
        if (this.getTimeout() > 0) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SEP).append(MQ_ADDRESS_ATTR_TIMEOUT).append(MQ_ADDRESS_ATTR_VAL).append(String.valueOf(this.timeout));
        }
        if (this.persString != null) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SEP).append(MQ_ADDRESS_ATTR_PERSISTENCE).append(MQ_ADDRESS_ATTR_VAL).append(this.outerEncode(this.persString));
        }
        if (this.getPriority() != -1) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SEP).append(MQ_ADDRESS_ATTR_PRIORITY).append(MQ_ADDRESS_ATTR_VAL).append(String.valueOf(this.priority));
        }
        if (this.getExpiry() != -1) {
            stringBuffer.append(MQ_ADDRESS_ATTR_SEP).append(MQ_ADDRESS_ATTR_TIMETOLIVE).append(MQ_ADDRESS_ATTR_VAL).append(String.valueOf(this.expiry == -1 ? 0 : this.expiry * 100));
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 123, 0, 0, stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private void validate() throws WMQSOAPException {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 124);
        }
        if (this.requestQueueName == null) {
            String string = MQTrace.writeSoapExceptionLog("67", 536910128, 0, 0, "RequestQueueName", null, null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string, 2, 2212, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 124);
            }
            throw wMQSOAPException;
        }
        if (!this.connectionFactoryProvided) {
            String string = MQTrace.writeSoapExceptionLog("67", 536910128, 0, 0, MQ_ADDRESS_ATTR_CONNECTIONFACTORY, null, null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string, 2, 2212, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 124);
            }
            throw wMQSOAPException;
        }
        if (!this.initialContextFactoryProvided) {
            String string = MQTrace.writeSoapExceptionLog("67", 536910128, 0, 0, MQ_ADDRESS_ATTR_INITIALCONTEXTFACTORY, null, null);
            WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string, 2, 2212, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 124);
            }
            throw wMQSOAPException;
        }
        if (this.responseQueueName == null) {
            this.responseQueueName = MQ_DEFAULT_REPLY_QUEUE;
        }
        if (this.binding == 2) {
            if (this.sslSpecified) {
                String string = MQTrace.writeSoapExceptionLog("68", 536910131, 0, 0, "SSL", "Binding", null);
                WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string, 2, 2212, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 124);
                }
                throw wMQSOAPException;
            }
            if (this.clientChannel != null || this.clientConnection != null) {
                String string = MQTrace.writeSoapExceptionLog("68", 536910131, 0, 0, "client", "server binding", null);
                WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string, 2, 2212, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 124);
                }
                throw wMQSOAPException;
            }
        }
        if (this.bindingStr == null && this.clientConnection != null) {
            this.binding = 1;
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 124, 0);
        }
    }

    public String getClientChannel() {
        return this.clientChannel;
    }

    public String getClientConnection() {
        return this.clientConnection;
    }

    public String getSSLCipherSuite() {
        return this.sslCipherSuite;
    }

    public String getClientTransport() {
        return this.clientTransport;
    }

    public String getRequestQueueName() {
        return this.requestQueueName;
    }

    public String getServiceQmgr() {
        if (this.serviceQmgr == null) {
            return "";
        }
        return this.serviceQmgr;
    }

    public String getResponseQueueName() {
        return this.responseQueueName;
    }

    public String getConnectQueueManager() {
        return this.connectQueueManager;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getPersistence() {
        return this.persistence;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getTargetService() {
        return this.targetService;
    }

    public int getSslKeyResetCount() {
        return this.sslKeyResetCount;
    }

    public String getSSLPeerName() {
        return this.sslPeerName;
    }

    public Collection getSslLDAPCRLColl() {
        return this.sslLdapCRLColl;
    }

    public String getSslKeyStore() {
        return this.sslKeyStore;
    }

    public String getSslKeyStorePassword() {
        return this.sslKeyStorePassword;
    }

    public String getSslTrustStore() {
        return this.sslTrustStore;
    }

    public String getSslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    public String getSslFipsRequired() {
        return this.sslFipsRequired;
    }

    public int getBinding() {
        return this.binding;
    }

    public void setClientChannel(String string) {
        this.clientChannel = string;
    }

    public void setClientTransport(String string) {
        this.clientTransport = string;
    }

    public void setConnectQueueManager(String string) {
        this.connectQueueManager = string;
    }

    public void setRequestQueueName(String string) {
        this.requestQueueName = string;
    }

    public void setServiceQmgr(String string) {
        this.serviceQmgr = string;
    }

    public void setResponseQueueName(String string) {
        this.responseQueueName = string;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public void setTargetService(String string) {
        this.targetService = string;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPortNo() {
        return this.portNo;
    }

    boolean parseConnName(String string) {
        if (string.startsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n != -1 && n2 != -1) {
            this.hostName = string.substring(0, n);
            this.portNo = Integer.parseInt(string.substring(n + 1, n2));
        } else {
            this.hostName = string;
        }
        return true;
    }

    public MQQueueManager connectToQmgr(WMQAddress wMQAddress) throws WMQSOAPException {
        return this.connectToQmgr(wMQAddress, 0);
    }

    public MQQueueManager connectToQmgr(WMQAddress wMQAddress, int n) throws WMQSOAPException {
        Object object;
        String string;
        MQQueueManager mQQueueManager;
        block53: {
            if (Trace.isTracing) {
                MQTrace.mqTrace.entry(49, 125);
            }
            mQQueueManager = null;
            int n2 = wMQAddress.getBinding();
            string = null;
            string = System.getProperty("com.ibm.mq.soap.transport.jms.mqchlurl");
            if (n2 == 2 && string != null) {
                String string2 = MQTrace.writeSoapExceptionLog("68", 536910131, 0, 0, "Channel url", "server binding", null);
                WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string2, 2, 2212, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 125);
                }
                throw wMQSOAPException;
            }
            if (n2 == 4 && string != null) {
                n2 = 1;
            }
            if (n2 == 4 || n2 == 2) {
                try {
                    if (n == 0) {
                        mQQueueManager = new MQQueueManager(wMQAddress.getConnectQueueManager(), 0);
                    } else if (n == 1) {
                        mQQueueManager = MQEnvironment.getQueueManagerReference((int)8, (Object)wMQAddress.getConnectQueueManager());
                    } else if (n == 2) {
                        object = new Hashtable<String, Integer>();
                        ((Hashtable)object).put("QMgr_Association", new Integer(8));
                        mQQueueManager = new MQQueueManager(wMQAddress.getConnectQueueManager(), (Hashtable)object);
                    }
                }
                catch (MQException mQException) {
                    if (n2 != 2) break block53;
                    String string3 = MQTrace.writeSoapExceptionLog("75", 536910134, 0, 0, "Server", null, null);
                    WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string3, mQException.completionCode, mQException.reasonCode, (Exception)((Object)mQException));
                    if (Trace.isTracing) {
                        MQTrace.mqTrace.exit(49, 125);
                    }
                    throw wMQSOAPException;
                }
            }
        }
        if (mQQueueManager == null) {
            if (wMQAddress.getClientConnection() == null && string == null) {
                object = MQTrace.writeSoapExceptionLog("75", 536910134, 0, 0, "Client/Server", null, null);
                WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException((String)object, 2, 2273, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 125);
                }
                throw wMQSOAPException;
            }
            try {
                if (wMQAddress.getClientConnection() != null) {
                    object = null;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                    if (wMQAddress.getClientChannel() != null) {
                        hashtable.put("channel", wMQAddress.getClientChannel());
                    }
                    hashtable.put("hostname", wMQAddress.getHostName());
                    hashtable.put("port", new Integer(wMQAddress.getPortNo()));
                    if (null != wMQAddress.getSSLCipherSuite()) {
                        hashtable.put("SSL Cipher Suite", wMQAddress.getSSLCipherSuite());
                        if (null != wMQAddress.getSSLPeerName()) {
                            hashtable.put("SSL Peer Name", wMQAddress.getSSLPeerName());
                        }
                        hashtable.put("KeyResetCount", new Integer(wMQAddress.getSslKeyResetCount()));
                        if (this.sslLdapCRLServers != null) {
                            if (wMQAddress.getSslLDAPCRLColl() != null) {
                                hashtable.put("SSL CertStores", wMQAddress.getSslLDAPCRLColl());
                            } else {
                                return null;
                            }
                        }
                        if ((object = System.getProperty("javax.net.ssl.keyStore")) != null && wMQAddress.getSslKeyStore() != null && !((String)object).equalsIgnoreCase(wMQAddress.getSslKeyStore())) {
                            MQTrace.writeSoapMessage("45", null, null, MQ_ADDRESS_ATTR_SSLKEYSTORE, null, null);
                            object = wMQAddress.getSslKeyStore();
                        }
                        if (object == null) {
                            object = wMQAddress.getSslKeyStore();
                        }
                        if ((string4 = System.getProperty("javax.net.ssl.keyStorePassword")) != null && wMQAddress.getSslKeyStorePassword() != null && !string4.equalsIgnoreCase(wMQAddress.getSslKeyStorePassword())) {
                            MQTrace.writeSoapMessage("45", null, null, MQ_ADDRESS_ATTR_SSLKEYSTOREPASSWORD, null, null);
                            string4 = wMQAddress.getSslKeyStorePassword();
                        }
                        if (string4 == null) {
                            string4 = wMQAddress.getSslKeyStorePassword();
                        }
                        if ((string5 = System.getProperty("javax.net.ssl.trustStore")) != null && wMQAddress.getSslTrustStore() != null && !string5.equalsIgnoreCase(wMQAddress.getSslTrustStore())) {
                            MQTrace.writeSoapMessage("45", null, null, MQ_ADDRESS_ATTR_SSLTRUSTSTORE, null, null);
                            string5 = wMQAddress.getSslTrustStore();
                        }
                        if (string5 == null) {
                            string5 = wMQAddress.getSslTrustStore();
                        }
                        if ((string6 = System.getProperty("javax.net.ssl.trustStorePassword")) != null && wMQAddress.getSslTrustStorePassword() != null && !string6.equalsIgnoreCase(wMQAddress.getSslTrustStorePassword())) {
                            MQTrace.writeSoapMessage("45", null, null, MQ_ADDRESS_ATTR_SSLTRUSTSTOREPASSWORD, null, null);
                            string6 = wMQAddress.getSslTrustStorePassword();
                        }
                        if (string6 == null) {
                            string6 = wMQAddress.getSslTrustStorePassword();
                        }
                        if (object != null) {
                            System.setProperty("javax.net.ssl.keyStore", (String)object);
                        }
                        if (string4 != null) {
                            System.setProperty("javax.net.ssl.keyStorePassword", string4);
                        }
                        if (string5 != null) {
                            System.setProperty("javax.net.ssl.trustStore", string5);
                        }
                        if (string6 != null) {
                            System.setProperty("javax.net.ssl.trustStorePassword", string6);
                        }
                        if (wMQAddress.getSslFipsRequired() != null) {
                            hashtable.put("SSL Fips Required", wMQAddress.getSslFipsRequired());
                        }
                    }
                    if (n == 0) {
                        mQQueueManager = new MQQueueManager(wMQAddress.getConnectQueueManager(), hashtable);
                    } else if (n == 1) {
                        mQQueueManager = MQEnvironment.getQueueManagerReference((int)8, (Object)wMQAddress.getConnectQueueManager());
                    } else if (n == 2) {
                        hashtable.put("QMgr_Association", new Integer(8));
                        mQQueueManager = new MQQueueManager(wMQAddress.getConnectQueueManager(), hashtable);
                    }
                } else {
                    object = new URL(string);
                    if (n == 0) {
                        mQQueueManager = new MQQueueManager(wMQAddress.getConnectQueueManager(), (URL)object);
                    } else if (n == 1) {
                        mQQueueManager = MQEnvironment.getQueueManagerReference((int)8, (Object)wMQAddress.getConnectQueueManager());
                    } else if (n == 2) {
                        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
                        hashtable.put("QMgr_Association", new Integer(8));
                        mQQueueManager = new MQQueueManager(wMQAddress.getConnectQueueManager(), hashtable, (URL)object);
                    }
                }
            }
            catch (MQException mQException) {
                String string7 = MQTrace.writeSoapExceptionLog("75", 536910134, 0, 0, "Client", null, null);
                WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string7, mQException.completionCode, mQException.reasonCode, (Exception)((Object)mQException));
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 125);
                }
                throw wMQSOAPException;
            }
            catch (MalformedURLException malformedURLException) {
                String string8 = MQTrace.writeSoapExceptionLog("70", 536910129, 0, 0, string, "Channel table URL", null);
                WMQSOAPException wMQSOAPException = WMQSOAPException.getSOAPException(string8, 2, 2212, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 125);
                }
                throw wMQSOAPException;
            }
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 125, 0);
        }
        return mQQueueManager;
    }

    private String outerDecode(String string) throws WMQSOAPException {
        try {
            return URLDecoder.decode(string, MQ_ENCODING_CODEPAGE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WMQSOAPException("Unsupported encoding exception");
        }
    }

    private String innerDecode(String string) throws WMQSOAPException {
        try {
            return URLDecoder.decode(string, MQ_ENCODING_CODEPAGE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WMQSOAPException("Unsupported encoding exception");
        }
    }

    private String outerEncode(String string) throws WMQSOAPException {
        try {
            return URLEncoder.encode(string, MQ_ENCODING_CODEPAGE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WMQSOAPException("Unsupported encoding exception");
        }
    }

    private String innerEncode(String string) throws WMQSOAPException {
        try {
            return URLEncoder.encode(URLEncoder.encode(string, MQ_ENCODING_CODEPAGE), MQ_ENCODING_CODEPAGE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WMQSOAPException("Unsupported encoding exception");
        }
    }
}

