/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.soap.util;

import com.ibm.mq.MQException;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.soap.transport.jms.WMQAddress;
import com.ibm.mq.soap.transport.jms.WMQSOAPException;
import com.ibm.mq.soap.util.MQTrace;
import com.ibm.mq.soap.util.ParseOptions;
import com.ibm.mq.soap.util.RunCommand;
import com.ibm.mq.soap.util.RunMQCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;

public class DeployWMQService {
    private static final String SCCSID = "@(#) java/soap/com/ibm/mq/soap/util/DeployWMQService.java, soap, p701, p701-112-140304 1.48.1.1 09/08/15 17:28:18";
    private String className;
    private String classSourceDir;
    private String packageName;
    private String proxyDir;
    private String wmq_wsdl;
    private String servicePort;
    private String uriOption = null;
    private WMQAddress wmqAddress = null;
    private String queueManager = "";
    private String queue = null;
    private String todo = "";
    private int serverThreads = 10;
    private int boThresh = 3;
    private boolean verbose = false;
    private boolean replaceQs = false;
    private String qCmdStr = "DEFINE";
    private String trqCmdStr = "DEFINE";
    private boolean windows = false;
    private boolean generatingAxis = true;
    private final String generatedServerDir = "generated" + File.separatorChar + "server";
    private final String generatedClientDir = "generated" + File.separatorChar + "client";
    private boolean triggeringEnabled = false;
    private String triggerQueueName = null;
    private String triggerProgName = "runmqtrm";
    private String processName = "";
    private String applicIDStr = null;
    private boolean listenerAsWMQService = false;
    private String idContext = null;
    private String transactionOptions = null;
    private String msgIntegrity = null;

    private void usage() {
        MQTrace.writeSoapMessage("17", null, null, null, null, null);
    }

    private boolean asmxOnWindows() {
        if (!this.windows) {
            MQTrace.writeSoapMessage("18", null, null, null, null, null);
            return false;
        }
        return true;
    }

    private boolean onLinux() {
        return System.getProperty("os.name").toLowerCase().startsWith("linux");
    }

    private String getDateTime() {
        Date date = new Date();
        return DateFormat.getDateTimeInstance().format(date);
    }

    private static boolean mkdir(String string) {
        File file = new File(string);
        if (file.exists()) {
            return true;
        }
        return file.mkdirs();
    }

    private static boolean erase(String string) {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 80);
        }
        File file = new File(string);
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 80, 0);
        }
        return DeployWMQService.deletePath(file);
    }

    private static boolean deletePath(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = DeployWMQService.deletePath(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    private boolean fileExists(String string) {
        File file = new File(string);
        return file.exists();
    }

    private String getAbsParent(String string) {
        File file = new File(string);
        File file2 = new File(file.getParent());
        return file2.getAbsolutePath() + File.separator;
    }

    private String getCurrentDir() {
        File file = new File(".");
        String string = "";
        try {
            string = file.getCanonicalPath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private boolean processArgs(String[] stringArray) {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 82);
        }
        try {
            String string;
            ParseOptions parseOptions = new ParseOptions(stringArray);
            if (parseOptions.isFlagSet('?')) {
                this.usage();
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 82, 0);
                }
                System.exit(0);
            }
            if (null == (string = parseOptions.isValueSet('f'))) {
                MQTrace.writeSoapMessage("11", "'-f'", null, null, null, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 82, -1, Integer.MIN_VALUE, "ERROR - 'classname  file' not specified");
                }
                this.usage();
                return false;
            }
            this.className = string;
            this.wmqAddress = new WMQAddress();
            string = parseOptions.isValueSet('u');
            if (null != string) {
                block37: {
                    this.uriOption = string;
                    try {
                        this.wmqAddress.setWmqURI(string);
                    }
                    catch (WMQSOAPException wMQSOAPException) {
                        if (wMQSOAPException.getMessage().indexOf("RequestQueueName") != -1) break block37;
                        this.usage();
                        throw wMQSOAPException;
                    }
                }
                this.queueManager = this.wmqAddress.getServiceQmgr();
                this.queue = this.wmqAddress.getRequestQueueName();
            }
            if (null != (string = parseOptions.isValueSet('c'))) {
                this.todo = string;
            }
            if (null != (string = parseOptions.isValueSet('n'))) {
                this.serverThreads = Integer.parseInt(string);
                if (this.serverThreads < 0) {
                    MQTrace.writeSoapMessage("19", Integer.toString(this.serverThreads), "'-n'", null, null, null);
                    if (Trace.isTracing) {
                        MQTrace.mqTrace.exit(49, 82, -1, Integer.MIN_VALUE, "ERROR - '-n' must be a positive value");
                    }
                    return false;
                }
            }
            if (null != (string = parseOptions.isValueSet('b'))) {
                this.boThresh = Integer.parseInt(string);
            }
            if (null != (string = parseOptions.isValueSet("tmq"))) {
                this.triggeringEnabled = true;
                this.triggerQueueName = string;
            }
            if (null != (string = parseOptions.isValueSet("tmp"))) {
                if (!this.triggeringEnabled) {
                    MQTrace.writeSoapMessage("11", "'-tmq'", null, null, null, null);
                    if (Trace.isTracing) {
                        MQTrace.mqTrace.exit(49, 82, -1, Integer.MIN_VALUE, "ERROR - trigger queue not specified");
                    }
                    return false;
                }
                this.triggerProgName = string;
            }
            if (parseOptions.isFlagSet('s')) {
                if (this.triggeringEnabled) {
                    MQTrace.writeSoapMessage("20", "'-tmq'", "'-s'", null, null, null);
                    if (Trace.isTracing) {
                        MQTrace.mqTrace.exit(49, 82, -1, Integer.MIN_VALUE, "ERROR - 'both -tmq and -s specified");
                    }
                    return false;
                }
                this.listenerAsWMQService = true;
            }
            if (null != (string = parseOptions.isValueSet('i'))) {
                if (!string.equalsIgnoreCase("passcontext")) {
                    MQTrace.writeSoapMessage("19", string, "'-i'", null, null, null);
                    if (Trace.isTracing) {
                        MQTrace.mqTrace.exit(49, 82, -1, Integer.MIN_VALUE, "ERROR - invalid value for '-i' option");
                    }
                    return false;
                }
                this.idContext = string;
            }
            if (null != (string = parseOptions.isValueSet('x'))) {
                if (!(string.equalsIgnoreCase("none") || string.equalsIgnoreCase("onePhase") || string.equalsIgnoreCase("twoPhase"))) {
                    if (Trace.isTracing) {
                        MQTrace.mqTrace.exit(49, 82, -1, Integer.MIN_VALUE, "ERROR - invalid value for '-x' option");
                    }
                    return false;
                }
                this.transactionOptions = string;
            }
            if (null != (string = parseOptions.isValueSet('a'))) {
                if (!(string.equalsIgnoreCase("DefaultMsgIntegrity") || string.equalsIgnoreCase("LowMsgIntegrity") || string.equalsIgnoreCase("HighMsgIntegrity"))) {
                    MQTrace.writeSoapMessage("19", string, "'-a'", null, null, null);
                    if (Trace.isTracing) {
                        MQTrace.mqTrace.exit(49, 82, -1, Integer.MIN_VALUE, "ERROR - invalid value for '-a' option");
                    }
                    return false;
                }
                if (this.transactionOptions != null && this.transactionOptions.equalsIgnoreCase("none") && !string.equalsIgnoreCase("LowMsgIntegrity")) {
                    MQTrace.writeSoapMessage("52", null, null, "'-a'", "'-x'", null);
                    if (Trace.isTracing) {
                        MQTrace.mqTrace.exit(49, 82, -1, Integer.MIN_VALUE, "ERROR - incompatile values for options '-a', '-x'");
                    }
                    return false;
                }
                this.msgIntegrity = string;
            }
            if (parseOptions.isFlagSet('r')) {
                this.replaceQs = true;
            }
            if (parseOptions.isFlagSet('v')) {
                this.verbose = true;
            }
        }
        catch (Exception exception) {
            MQTrace.writeSoapMessage("9", null, null, "processArgs", exception.toString(), null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 82, -1, Integer.MIN_VALUE, "Exception" + exception.toString());
            }
            System.exit(2);
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 82, 0);
        }
        return true;
    }

    private boolean doBatCommand(String string) {
        String string2 = "cmd /V:ON /C \"" + string + " && exit /b !errorlevel!\"";
        return new RunCommand(string2).Execute();
    }

    private boolean doCommand(String string) {
        return new RunCommand(string).Execute();
    }

    private boolean doMQCommand(String string) {
        return new RunMQCommand(this.queueManager).Execute(string);
    }

    private boolean setup() throws Exception {
        String string;
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 83);
        }
        if (this.className.endsWith(".java")) {
            this.generatingAxis = true;
            this.className = this.className.substring(0, this.className.length() - 5);
            if (this.todo.equals("")) {
                this.todo = "allAxis";
            }
        } else if (this.className.endsWith(".asmx")) {
            this.generatingAxis = false;
            this.className = this.className.substring(0, this.className.length() - 5);
            if (this.todo.equals("")) {
                this.todo = "allAsmx";
            }
        } else {
            MQTrace.writeSoapMessage("19", this.className, "'-f'", null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 82, -1, Integer.MIN_VALUE, "ERROR - 'Unrecognised file extension on the '-f' switch");
            }
            return false;
        }
        this.className = this.className.replace(File.separatorChar, '.');
        this.className = this.className.replace('/', '.');
        this.classSourceDir = this.className.replace('.', File.separatorChar);
        String string2 = this.generatingAxis ? this.className + ".java" : this.className + ".asmx";
        if (this.wmqAddress.getTargetService() != null) {
            if (!this.wmqAddress.getTargetService().equalsIgnoreCase(string2)) {
                MQTrace.writeSoapMessage("21", string2, this.wmqAddress.getTargetService(), null, null, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 82, -1, Integer.MIN_VALUE, "ERROR - 'targetService' and 'classname(-f)' must match");
                }
                return false;
            }
        } else {
            this.wmqAddress.setTargetService(string2);
        }
        this.packageName = (string = new File(this.classSourceDir).getParent()) == null ? "DefaultNamespace" : string.replace(File.separatorChar, '.');
        this.proxyDir = this.classSourceDir;
        if (this.classSourceDir.equals(this.className)) {
            this.proxyDir = "DefaultNamespace" + File.separator + this.className;
        }
        this.wmq_wsdl = this.className + "_Wmq.wsdl";
        if (this.queue == null || this.queue.equals("")) {
            boolean bl = false;
            this.queue = this.className;
            this.queue = this.queue.replace(File.separatorChar, '.');
            this.queue = this.queue.replace(' ', '_');
            if (this.windows && this.queue.indexOf(58) != -1) {
                this.queue = this.queue.replace(':', '.');
                bl = true;
            }
            this.queue = this.generatingAxis ? "SOAPJ." + this.queue : "SOAPN." + this.queue;
            if (48 < this.queue.length()) {
                this.queue = bl ? this.queue.substring(0, 7) + this.queue.substring(this.queue.length() - 40) : this.queue.substring(0, 5) + this.queue.substring(this.queue.length() - 42);
            }
            this.wmqAddress.setRequestQueueName(this.queue);
        }
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        MQQueueManager mQQueueManager = null;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        String string4 = this.generatingAxis ? this.generatedServerDir + File.separator + "startWMQJListener" + this.scriptExtn() : this.generatedServerDir + File.separator + "startWMQNListener" + this.scriptExtn();
        try {
            fileReader = new FileReader(string4);
            bufferedReader = new BufferedReader(fileReader);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            try {
                boolean bl4 = false;
                while (!bl4) {
                    int n;
                    String string5 = bufferedReader.readLine();
                    if (string5 == null) {
                        bl4 = true;
                        continue;
                    }
                    if (string5.startsWith("#") || string5.startsWith("@") || string5.startsWith("rem") || (!this.generatingAxis ? string5.indexOf("amqwSOAPNETListener") == -1 : string5.indexOf("SimpleJavaListener") == -1)) continue;
                    int n2 = string5.indexOf("-u");
                    if (n2 == -1) {
                        MQTrace.writeSoapMessage("22", null, null, null, null, null);
                        if (Trace.isTracing) {
                            MQTrace.mqTrace.exit(49, 82, -1, Integer.MIN_VALUE, "ERROR - Invalid script found");
                        }
                        return false;
                    }
                    int n3 = 0;
                    int n4 = string5.indexOf("destination");
                    if (n4 != -1) {
                        n4 = string5.indexOf(61);
                    }
                    if (n4 == -1) continue;
                    if ((n = string5.indexOf(64, ++n4)) == -1) {
                        n3 = string5.indexOf(38, n4);
                        if (n3 == -1) {
                            n3 = string5.length() - 1;
                        }
                    } else {
                        n3 = n;
                    }
                    string3 = string5.substring(n4, n3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MQException.logExclude((Integer)new Integer(2085));
        try {
            mQQueueManager = new MQQueueManager(this.queueManager);
            bl2 = true;
        }
        catch (MQException mQException) {
            // empty catch block
        }
        if (bl2) {
            MQQueue mQQueue;
            try {
                mQQueue = mQQueueManager.accessQueue(this.queue, 1, null, null, null);
                bl3 = true;
                if (!this.replaceQs) {
                    this.qCmdStr = "ALTER";
                }
                mQQueue.close();
            }
            catch (MQException mQException) {
                // empty catch block
            }
            if (this.triggerQueueName != null) {
                try {
                    mQQueue = mQQueueManager.accessQueue(this.triggerQueueName, 1, null, null, null);
                    if (!this.replaceQs) {
                        this.trqCmdStr = "ALTER";
                    }
                    mQQueue.close();
                }
                catch (MQException mQException) {
                    // empty catch block
                }
            }
        }
        if (bl3) {
            if (!bl) {
                MQTrace.writeSoapMessage("23", this.queue, null, null, null, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 82, -1, Integer.MIN_VALUE, "ERROR - Queue already in use");
                }
                return false;
            }
            if (!this.queue.equalsIgnoreCase(string3)) {
                MQTrace.writeSoapMessage("24", string3, this.queue, null, null, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 82, -1, Integer.MIN_VALUE, "ERROR - Request Queue does not match script");
                }
                return false;
            }
        } else if (bl) {
            if (!this.queue.equalsIgnoreCase(string3)) {
                MQTrace.writeSoapMessage("24", string3, this.queue, null, null, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 82, -1, Integer.MIN_VALUE, "ERROR - Request Queue does not match script");
                }
                return false;
            }
            MQTrace.writeSoapMessage("25", null, null, null, null, null);
        }
        if (this.triggeringEnabled) {
            this.applicIDStr = this.generatingAxis ? (this.windows ? "start \"Java WMQSoapListener - " + this.queue + "\" /min " + this.getCurrentDir() + File.separator + this.generatedServerDir + File.separator + "startWMQJListener" + this.scriptExtn() : this.getCurrentDir() + File.separator + this.generatedServerDir + File.separator + "startWMQJListener" + this.scriptExtn()) : "start \"WMQAsmxListener - " + this.className + "\" /min " + this.getCurrentDir() + File.separator + this.generatedServerDir + File.separator + "startWMQNListener" + this.scriptExtn();
            if (this.applicIDStr.length() > 256) {
                MQTrace.writeSoapMessage("26", null, null, null, null, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 82, -1, Integer.MIN_VALUE, "ERROR - APPLICID exceeds 256 characters");
                }
                return false;
            }
        }
        this.processName = this.queue;
        this.uriOption = this.uriOption != null ? this.wmqAddress.getWmqURI() : "jms:/queue?initialContextFactory=com.ibm.mq.jms.Nojndi&connectionFactory=()&destination=" + this.queue + "&targetService=" + this.wmqAddress.getTargetService();
        this.servicePort = this.className + "_Wmq";
        if (!(DeployWMQService.mkdir("generated") && DeployWMQService.mkdir(this.generatedServerDir) && DeployWMQService.mkdir(this.generatedClientDir) && DeployWMQService.mkdir(this.generatedClientDir + File.separator + "remote"))) {
            MQTrace.writeSoapMessage("27", "generated", null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 83, -1, Integer.MIN_VALUE, "ERROR - creating generated directories");
            }
            return false;
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 83, 0);
        }
        return true;
    }

    private boolean compileJava() {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 84);
        }
        if (!this.doCommand("javac -d " + this.generatedServerDir + " " + this.classSourceDir + ".java")) {
            MQTrace.writeSoapMessage("28", this.proxyDir + ".java", null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 84, -1, Integer.MIN_VALUE, "Error in compilation of " + this.proxyDir + ".java");
            }
            return false;
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 84, 0);
        }
        return true;
    }

    private boolean genAxisWsdl() {
        boolean bl;
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 85);
        }
        String string = "generated" + File.separator + this.wmq_wsdl;
        String string2 = "";
        if (this.fileExists(string)) {
            string2 = "--input " + string;
        }
        if (!(bl = this.doCommand("java org.apache.axis.wsdl.Java2WSDL " + string2 + " --output " + string + " --namespace " + this.servicePort + " --location " + this.uriOption + " --bindingName " + this.className + "BindingSoap" + " --servicePortName " + this.servicePort + " " + this.className)) || !this.fileExists(string)) {
            MQTrace.writeSoapMessage("29", null, null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 85, -1, Integer.MIN_VALUE, "ERROR - Failure in building WSDL");
            }
            return false;
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 85, 0);
        }
        return true;
    }

    private boolean axisDeploy() {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 86);
        }
        if (!this.doCommand("java com.ibm.mq.soap.util.RunWSDL2Java --server-side  --timeout -1 -p " + this.packageName + " " + "--output generated" + File.separator + "temp.server" + " " + "generated" + File.separator + this.wmq_wsdl)) {
            MQTrace.writeSoapMessage("30", null, null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 86, -1, Integer.MIN_VALUE, "ERROR - running RunWSDL2Java");
            }
            return false;
        }
        String string = this.generatedServerDir + File.separator + this.classSourceDir;
        if (!DeployWMQService.mkdir(this.getAbsParent(string))) {
            MQTrace.writeSoapMessage("27", string, null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 86, -1, Integer.MIN_VALUE, "ERROR - creating directory: " + string);
            }
            return false;
        }
        String string2 = this.getAbsParent("generated" + File.separator + "temp.server" + File.separator + this.proxyDir);
        String string3 = null;
        string3 = this.windows ? "java com.ibm.mq.soap.util.PatchWsdd " + this.className + " \"" + string2 + "deploy.wsdd\" " + this.generatedServerDir + File.separator + this.classSourceDir + "_deploy.wsdd" : "java com.ibm.mq.soap.util.PatchWsdd " + this.className + " " + string2 + "deploy.wsdd " + this.generatedServerDir + File.separator + this.classSourceDir + "_deploy.wsdd";
        if (this.windows) {
            string3 = "cmd /c " + string3;
        }
        if (!this.doCommand(string3)) {
            MQTrace.writeSoapMessage("31", string2 + "deploy.wsdd", null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 86, -1, Integer.MIN_VALUE, "ERROR - patching " + string2 + "deploy.wsdd");
            }
            return false;
        }
        string3 = this.windows ? "java com.ibm.mq.soap.util.PatchWsdd " + this.className + " \"" + string2 + "undeploy.wsdd\" " + this.generatedServerDir + File.separator + this.classSourceDir + "_undeploy.wsdd" : "java com.ibm.mq.soap.util.PatchWsdd " + this.className + " " + string2 + "undeploy.wsdd " + " " + this.generatedServerDir + File.separator + this.classSourceDir + "_undeploy.wsdd";
        if (this.windows) {
            string3 = "cmd /c " + string3;
        }
        if (!this.doCommand(string3)) {
            MQTrace.writeSoapMessage("31", string2 + "undeploy.wsdd", null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 86, -1, Integer.MIN_VALUE, "ERROR - patching " + string2 + "undeploy.wsdd");
            }
            return false;
        }
        if (!DeployWMQService.erase("generated" + File.separator + "temp.server")) {
            MQTrace.writeSoapMessage("32", string2 + "temp.server", null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 86, -1, Integer.MIN_VALUE, "ERROR - deleting temp.server directory");
            }
            return false;
        }
        if (!this.doCommand("java org.apache.axis.utils.Admin server " + this.generatedServerDir + File.separator + this.classSourceDir + "_deploy.wsdd")) {
            MQTrace.writeSoapMessage("33", null, null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 86, -1, Integer.MIN_VALUE, "ERROR - in deployment with generated wsdd");
            }
            return false;
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 86, 0);
        }
        return true;
    }

    private String scriptExtn() {
        if (this.windows) {
            return ".cmd";
        }
        return ".sh";
    }

    private boolean genAxisWMQBits() {
        Object object;
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 87);
        }
        String string = "java";
        String string2 = System.getProperty("com.ibm.mq.soap.transport.jms.mqchlurl");
        if (string2 != null) {
            string = string + " -Dcom.ibm.mq.soap.transport.jms.mqchlurl=" + string2;
        }
        String string3 = System.getProperty("javax.net.ssl.keyStore");
        if (this.wmqAddress.getSslKeyStore() == null) {
            if (string3 != null) {
                string = string + " -Djavax.net.ssl.keyStore=" + string3;
            }
        } else if (string3 != null && !string3.equals(this.wmqAddress.getSslKeyStore())) {
            MQTrace.writeSoapMessage("34", "Keystore", null, null, null, null);
        }
        String string4 = System.getProperty("javax.net.ssl.keyStorePassword");
        if (this.wmqAddress.getSslKeyStorePassword() == null) {
            if (string4 != null) {
                string = string + " -Djavax.net.ssl.keyStorePassword=" + string4;
            }
        } else if (string4 != null && !string4.equals(this.wmqAddress.getSslKeyStorePassword())) {
            MQTrace.writeSoapMessage("34", "KeystorePassword", null, null, null, null);
        }
        String string5 = System.getProperty("javax.net.ssl.trustStore");
        if (this.wmqAddress.getSslTrustStore() == null) {
            if (string5 != null) {
                string = string + " -Djavax.net.ssl.trustStore=" + string5;
            }
        } else if (string5 != null && !string5.equals(this.wmqAddress.getSslTrustStore())) {
            MQTrace.writeSoapMessage("34", "Truststore", null, null, null, null);
        }
        String string6 = System.getProperty("javax.net.ssl.trustStorePassword");
        if (this.wmqAddress.getSslTrustStorePassword() == null) {
            if (string6 != null) {
                string = string + " -Djavax.net.ssl.trustStorePassword=" + string6;
            }
        } else if (string6 != null && !string6.equals(this.wmqAddress.getSslTrustStorePassword())) {
            MQTrace.writeSoapMessage("34", "TruststorePassword", null, null, null, null);
        }
        string = string + " com.ibm.mq.soap.transport.jms.SimpleJavaListener" + " -u \"" + this.uriOption + "\" -n " + this.serverThreads;
        if (this.idContext != null) {
            string = string + " -i " + this.idContext;
        }
        if (this.transactionOptions != null) {
            string = string + " -x " + this.transactionOptions;
        }
        if (this.msgIntegrity != null) {
            string = string + " -a " + this.msgIntegrity;
        }
        String string7 = this.generatedServerDir + File.separator + "startWMQJListener" + this.scriptExtn();
        try {
            object = new FileWriter(string7);
            if (this.windows) {
                ((Writer)object).write("rem - generated by DeployWMQService.java at " + this.getDateTime() + "\n");
                ((Writer)object).write("call amqwsetcp" + this.scriptExtn() + "\n");
                ((Writer)object).write("set CLASSPATH=" + this.generatedServerDir + ";%CLASSPATH%\n");
                ((Writer)object).write("cd /d " + this.getCurrentDir() + "\n");
                ((Writer)object).write(string + "\n");
                ((OutputStreamWriter)object).close();
            } else {
                if (this.onLinux()) {
                    ((Writer)object).write("#!/bin/bash\n");
                } else {
                    ((Writer)object).write("#!/bin/sh\n");
                }
                ((Writer)object).write("# - generated by DeployWMQService.java at " + this.getDateTime() + "\n");
                ((Writer)object).write(". amqwsetcp" + this.scriptExtn() + "\n");
                ((Writer)object).write("CLASSPATH=" + this.generatedServerDir + ":${CLASSPATH}\n");
                ((Writer)object).write("export CLASSPATH\n");
                ((Writer)object).write("cd " + this.getCurrentDir() + "\n");
                ((Writer)object).write("exec " + string + "\n");
                ((OutputStreamWriter)object).close();
                if (!this.doCommand("chmod ugo+x " + string7)) {
                    MQTrace.writeSoapMessage("35", string7, null, null, null, null);
                    if (Trace.isTracing) {
                        MQTrace.mqTrace.exit(49, 87, -1, Integer.MIN_VALUE, "ERROR - setting permission on: " + string7);
                    }
                    return false;
                }
            }
        }
        catch (Exception exception) {
            MQTrace.writeSoapMessage("36", string7, null, null, null, null);
            exception.printStackTrace();
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 87, -1, Integer.MIN_VALUE, "ERROR - generating listener script" + exception.toString());
            }
            return false;
        }
        if (this.listenerAsWMQService && !this.writeListenerSvcScript(string7)) {
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 87, -1, Integer.MIN_VALUE, "ERROR - error writing listener service script");
            }
            return false;
        }
        object = this.generatedServerDir + File.separator + "endWMQJListener" + this.scriptExtn();
        if (!this.writeListenerStopScript((String)object)) {
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 87, -1, Integer.MIN_VALUE, "ERROR - error writing listener stop script");
            }
            return false;
        }
        if (!this.triggeringEnabled) {
            String string8 = "REPLACE";
            if (this.qCmdStr.equals("ALTER")) {
                string8 = "";
            }
            if (!this.doMQCommand(this.qCmdStr + " QL('" + this.queue + "') BOTHRESH(" + this.boThresh + ") " + string8)) {
                MQTrace.writeSoapMessage("37", "request", this.queue, null, null, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 87, -1, Integer.MIN_VALUE, "ERROR - creating request queue");
                }
                return false;
            }
            this.doMQCommand("CLEAR QLOCAL('" + this.queue + "')");
        } else {
            String string9 = "REPLACE";
            if (this.trqCmdStr.equals("ALTER")) {
                string9 = "";
            }
            if (!this.doMQCommand(this.trqCmdStr + " QL('" + this.triggerQueueName + "') defsopt(excl) " + string9)) {
                MQTrace.writeSoapMessage("37", "trigger", this.triggerQueueName, null, null, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 87, -1, Integer.MIN_VALUE, "ERROR - defining queue " + this.triggerQueueName);
                }
                return false;
            }
            this.doMQCommand("CLEAR QLOCAL('" + this.triggerQueueName + "')");
            String string10 = this.windows ? "DEFINE PROCESS('" + this.processName + "') APPLICID('" + this.applicIDStr + " ') ENVRDATA('&') REPLACE" : "DEFINE PROCESS('" + this.processName + "') APPLICID('" + this.applicIDStr + "') ENVRDATA('&') REPLACE";
            String string11 = "REPLACE";
            if (this.qCmdStr.equals("ALTER")) {
                string11 = "";
            }
            if (!this.doMQCommand(this.qCmdStr + " QL('" + this.queue + "') BOTHRESH(" + this.boThresh + ") TRIGTYPE(FIRST) TRIGGER PROCESS('" + this.processName + "') INITQ('" + this.triggerQueueName + "') TRIGMPRI(0) " + string11) || !this.doMQCommand(string10)) {
                MQTrace.writeSoapMessage("37", "triggered request", "definitions", null, null, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 87, -1, Integer.MIN_VALUE, "ERROR - creating triggered request queue definitions");
                }
                return false;
            }
            this.doMQCommand("CLEAR QLOCAL('" + this.queue + "')");
        }
        return true;
    }

    private boolean genAsmxWsdl() {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 88);
        }
        if (!this.asmxOnWindows()) {
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 88, -1, Integer.MIN_VALUE, "ERROR - generating ASMX WSDL on non Windows system");
            }
            return false;
        }
        String string = "";
        int n = 0;
        int n2 = 0;
        do {
            if ((n2 = this.uriOption.indexOf(38, n)) == -1) {
                if (string.equals("")) break;
                string = string + this.uriOption.substring(n, this.uriOption.length());
                break;
            }
            string = string + this.uriOption.substring(n, n2 + 1) + "amp;";
        } while ((n = n2 + 1) < this.uriOption.length());
        if (string.equals("")) {
            string = this.uriOption;
        }
        boolean bl = this.doCommand("amqswsdl " + string + " " + this.className + ".asmx" + " generated" + File.separator + this.wmq_wsdl);
        if (!this.fileExists("generated" + File.separator + this.wmq_wsdl)) {
            MQTrace.writeSoapMessage("29", null, null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 88, -1, Integer.MIN_VALUE, "ERROR - Failure in building WSDL");
            }
            return false;
        }
        if (!bl) {
            MQTrace.writeSoapMessage("38", "'generated\\'" + this.wmq_wsdl, null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 88, -1, Integer.MIN_VALUE, "ERROR - building WSDL, see 'generated\\'" + this.wmq_wsdl + "' for details");
            }
            return false;
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 88, 0);
        }
        return true;
    }

    private boolean genAsmxWMQBits() {
        Object object;
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 89);
        }
        if (!this.asmxOnWindows()) {
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 89, -1, Integer.MIN_VALUE, "ERROR - generating ASMX WMQ on non Windows system");
            }
            return false;
        }
        String string = "amqwSOAPNETListener -u \"" + this.uriOption + "\" -w " + this.getCurrentDir() + " " + "-n " + this.serverThreads;
        if (this.idContext != null) {
            string = string + " -i " + this.idContext;
        }
        if (this.transactionOptions != null) {
            string = string + " -x " + this.transactionOptions;
        }
        if (this.msgIntegrity != null) {
            string = string + " -a " + this.msgIntegrity;
        }
        String string2 = this.generatedServerDir + File.separator + "startWMQNListener" + this.scriptExtn();
        try {
            object = new FileWriter(string2);
            ((Writer)object).write("rem - generated by DeployWMQService.java at " + this.getDateTime() + "\n");
            ((Writer)object).write("call amqwsetcp" + this.scriptExtn() + "\n");
            ((Writer)object).write(string + "\n");
            ((OutputStreamWriter)object).close();
        }
        catch (Exception exception) {
            MQTrace.writeSoapMessage("36", string2, null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 89, -1, Integer.MIN_VALUE, "ERROR - generating listener script" + exception.toString());
            }
            return false;
        }
        if (this.listenerAsWMQService && !this.writeListenerSvcScript(string2)) {
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 89, -1, Integer.MIN_VALUE, "ERROR - error writing listener service script");
            }
            return false;
        }
        object = this.generatedServerDir + File.separator + "endWMQNListener" + this.scriptExtn();
        if (!this.writeListenerStopScript((String)object)) {
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 89, -1, Integer.MIN_VALUE, "ERROR - error writing listener stop script");
            }
            return false;
        }
        if (!this.triggeringEnabled) {
            String string3 = "REPLACE";
            if (this.qCmdStr.equals("ALTER")) {
                string3 = "";
            }
            if (!this.doMQCommand(this.qCmdStr + " QL('" + this.queue + "') BOTHRESH(" + this.boThresh + ") " + string3)) {
                MQTrace.writeSoapMessage("37", "request", this.queue, null, null, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 89, -1, Integer.MIN_VALUE, "ERROR - creating request queue");
                }
                return false;
            }
            this.doMQCommand("CLEAR QLOCAL('" + this.queue + "')");
        } else {
            String string4 = "REPLACE";
            if (this.trqCmdStr.equals("ALTER")) {
                string4 = "";
            }
            if (!this.doMQCommand(this.trqCmdStr + " QL('" + this.triggerQueueName + "') defsopt(excl) " + string4)) {
                MQTrace.writeSoapMessage("37", "trigger", this.triggerQueueName, null, null, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 89, -1, Integer.MIN_VALUE, "ERROR - defining queue " + this.triggerQueueName);
                }
                return false;
            }
            this.doMQCommand("CLEAR QLOCAL('" + this.triggerQueueName + "')");
            String string5 = "REPLACE";
            if (this.qCmdStr.equals("ALTER")) {
                string5 = "";
            }
            if (!this.doMQCommand(this.qCmdStr + " QL('" + this.queue + "') BOTHRESH(" + this.boThresh + ") TRIGTYPE(FIRST) TRIGGER PROCESS('" + this.processName + "') INITQ('" + this.triggerQueueName + "') TRIGMPRI(0) " + string5) || !this.doMQCommand("DEFINE PROCESS('" + this.processName + "') APPLICID('" + this.applicIDStr + "') REPLACE")) {
                MQTrace.writeSoapMessage("37", "triggered request", "definitions", null, null, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 89, -1, Integer.MIN_VALUE, "ERROR - creating triggered request queue definitions");
                }
                return false;
            }
            this.doMQCommand("CLEAR QLOCAL('" + this.queue + "')");
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 89, 0);
        }
        return true;
    }

    private boolean writeListenerSvcScript(String string) {
        String string2 = this.generatingAxis ? this.generatedServerDir + File.separator + "defineWMQJListener" + this.scriptExtn() : this.generatedServerDir + File.separator + "defineWMQNListener" + this.scriptExtn();
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 90);
        }
        try {
            FileWriter fileWriter = new FileWriter(string2);
            if (this.windows) {
                fileWriter.write("rem - generated by DeployWMQService.java at " + this.getDateTime() + "\n");
                fileWriter.write("echo DEFINE SERVICE('" + this.className + "') STARTCMD('" + this.getCurrentDir() + File.separator + string + "') ");
                fileWriter.write("CONTROL(QMGR) SERVTYPE(SERVER) REPLACE | runmqsc " + this.queueManager + "\n");
                fileWriter.write("echo START SERVICE('" + this.className + "') | runmqsc " + this.queueManager + "\n");
            } else {
                if (this.onLinux()) {
                    fileWriter.write("#!/bin/bash\n");
                } else {
                    fileWriter.write("#!/bin/sh\n");
                }
                fileWriter.write("# - generated by DeployWMQService.java at " + this.getDateTime() + "\n");
                fileWriter.write("runmqsc " + this.queueManager + " << eof\n");
                fileWriter.write("DEFINE SERVICE('" + this.className + "') STARTCMD('" + this.getCurrentDir() + File.separator + string + "') ");
                fileWriter.write("CONTROL(QMGR) SERVTYPE(SERVER) REPLACE\n");
                fileWriter.write("START SERVICE('" + this.className + "')\n");
                fileWriter.write("eof\n");
            }
            fileWriter.close();
            if (!this.windows && !this.doCommand("chmod ugo+x " + string2)) {
                MQTrace.writeSoapMessage("35", string2, null, null, null, null);
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 90, -1, Integer.MIN_VALUE, "ERROR - setting permission on: " + string);
                }
                return false;
            }
        }
        catch (Exception exception) {
            MQTrace.writeSoapMessage("36", string2, null, null, null, null);
            exception.printStackTrace();
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 90, -1, Integer.MIN_VALUE, "ERROR - generating listener service script" + exception.toString());
            }
            return false;
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 90, 0);
        }
        return true;
    }

    private boolean writeListenerStopScript(String string) {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 132);
        }
        try {
            FileWriter fileWriter = new FileWriter(string);
            if (this.windows) {
                fileWriter.write("rem - generated by DeployWMQService.java at " + this.getDateTime() + "\n");
                fileWriter.write("call amqwsetcp" + this.scriptExtn() + "\n");
                fileWriter.write("set CLASSPATH=" + this.generatedServerDir + ";%CLASSPATH%\n");
            } else {
                if (this.onLinux()) {
                    fileWriter.write("#!/bin/bash\n");
                } else {
                    fileWriter.write("#!/bin/sh\n");
                }
                fileWriter.write("# - generated by DeployWMQService.java at " + this.getDateTime() + "\n");
                fileWriter.write(". amqwsetcp" + this.scriptExtn() + "\n");
                fileWriter.write("CLASSPATH=" + this.generatedServerDir + ":${CLASSPATH}\n");
                fileWriter.write("export CLASSPATH\n");
                fileWriter.write("cd " + this.getCurrentDir() + "\n");
            }
            if (this.queueManager.equals("")) {
                fileWriter.write("java com.ibm.mq.soap.util.EndWMQListener -q " + this.queue + "\n");
            } else {
                fileWriter.write("java com.ibm.mq.soap.util.EndWMQListener -m " + this.queueManager + " -q " + this.queue + "\n");
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            MQTrace.writeSoapMessage("36", string, null, null, null, null);
            exception.printStackTrace();
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 132, -1, Integer.MIN_VALUE, "ERROR - generating stop listener script" + exception.toString());
            }
            return false;
        }
        if (!this.windows && !this.doCommand("chmod ugo+x " + string)) {
            MQTrace.writeSoapMessage("35", string, null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 132, -1, Integer.MIN_VALUE, "ERROR - setting permission on: " + string);
            }
            return false;
        }
        return true;
    }

    private boolean genProxiesToDotNet() {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 91);
        }
        if (!this.asmxOnWindows()) {
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 91, -1, Integer.MIN_VALUE, "ERROR - generating DotNet Proxies on non Windows system");
            }
            return false;
        }
        if (!this.doBatCommand("amqwcallWSDL" + this.scriptExtn() + " .." + File.separator + this.wmq_wsdl) || !this.doBatCommand("amqwcallWSDL" + this.scriptExtn() + " .." + File.separator + this.wmq_wsdl + " /language:VB")) {
            MQTrace.writeSoapMessage("39", null, null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 91, -1, Integer.MIN_VALUE, "ERROR - generating proxy code");
            }
            return false;
        }
        String string = "java com.ibm.mq.soap.util.RunWSDL2Java --output " + this.generatedClientDir + File.separator + "remote -p dotNetService generated" + File.separator + this.wmq_wsdl;
        if (!this.doCommand(string)) {
            MQTrace.writeSoapMessage("30", null, null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 91, -1, Integer.MIN_VALUE, "ERROR - running WSDL2Java");
            }
            return false;
        }
        String string2 = this.getJavaFiles(this.getAbsParent(this.generatedClientDir + File.separator + "remote" + File.separator + "dotNetService" + File.separator + this.className));
        if (string2.equals("")) {
            MQTrace.writeSoapMessage("40", null, null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 91, -1, Integer.MIN_VALUE, "ERROR - cannot obtain list of Java proxies");
            }
            return false;
        }
        String string3 = this.generatedClientDir + File.separator + "remote";
        String string4 = "javac -d " + string3 + " " + string2;
        if (!this.doCommand(string4)) {
            MQTrace.writeSoapMessage("41", null, null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 91, -1, Integer.MIN_VALUE, "ERROR - compiling proxy code");
            }
            return false;
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 91, 0);
        }
        return true;
    }

    private String getJavaFiles(String string) {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 92);
        }
        String string2 = "";
        File file = new File(string);
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 92, 0);
                }
                return string.endsWith(".java");
            }
        };
        String[] stringArray = file.list(filenameFilter);
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = this.windows ? string2 + "\"" + string + stringArray[i] + "\" " : string2 + string + stringArray[i] + " ";
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 92, 0);
        }
        return string2;
    }

    private boolean genProxiesToAxis() {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 93);
        }
        if (!(!this.windows || this.doBatCommand("amqwcallWSDL" + this.scriptExtn() + " .." + File.separator + this.wmq_wsdl) && this.doBatCommand("amqwcallWSDL" + this.scriptExtn() + " .." + File.separator + this.wmq_wsdl + " /language:VB"))) {
            MQTrace.writeSoapMessage("39", null, null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 93, -1, Integer.MIN_VALUE, "ERROR - generating proxy code");
            }
            return false;
        }
        if (!this.doCommand("java com.ibm.mq.soap.util.RunWSDL2Java --timeout -1 --output " + this.generatedClientDir + File.separator + "remote" + " -p " + this.packageName + " " + "generated" + File.separator + this.wmq_wsdl)) {
            MQTrace.writeSoapMessage("30", null, null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 93, -1, Integer.MIN_VALUE, "ERROR - running WSDL2Java");
            }
            return false;
        }
        String string = this.getJavaFiles(this.getAbsParent(this.generatedClientDir + File.separator + "remote" + File.separator + this.proxyDir));
        if (string.equals("")) {
            MQTrace.writeSoapMessage("40", null, null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 93, -1, Integer.MIN_VALUE, "ERROR - cannot obtain list of Java proxies");
            }
            return false;
        }
        String string2 = this.generatedClientDir + File.separator + "remote";
        String string3 = "javac -d " + string2 + " " + string;
        if (!this.doCommand(string3)) {
            MQTrace.writeSoapMessage("41", null, null, null, null, null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 93, -1, Integer.MIN_VALUE, "ERROR - compiling proxy code");
            }
            return false;
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 93, 0);
        }
        return true;
    }

    private boolean allAxis() {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 94);
        }
        if (!this.compileJava()) {
            return false;
        }
        if (!this.genAxisWsdl()) {
            return false;
        }
        if (!this.axisDeploy()) {
            return false;
        }
        if (!this.genAxisWMQBits()) {
            return false;
        }
        if (!this.genProxiesToAxis()) {
            return false;
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 94, 0);
        }
        return true;
    }

    private boolean allAsmx() {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 95);
        }
        if (!this.genAsmxWsdl()) {
            return false;
        }
        if (!this.genAsmxWMQBits()) {
            return false;
        }
        if (!this.genProxiesToDotNet()) {
            return false;
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 95);
        }
        return true;
    }

    DeployWMQService(String[] stringArray) {
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 98);
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            this.windows = true;
        }
        if (!this.processArgs(stringArray)) {
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 98, 0);
            }
            System.exit(2);
        }
        if (this.todo.equals("usage")) {
            this.usage();
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 98, 0);
            }
            return;
        }
        RunCommand.setQuiet(!this.verbose);
        RunMQCommand.setQuiet(!this.verbose);
        try {
            if (!this.setup()) {
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 98, 0);
                }
                System.exit(2);
            }
        }
        catch (Exception exception) {
            MQTrace.writeSoapMessage("9", null, null, "setup()", exception.toString(), null);
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 98, -1, Integer.MIN_VALUE, "Exception thrown by setup " + exception.toString());
            }
            System.exit(2);
        }
        if (this.todo.equalsIgnoreCase("allAxis")) {
            if (!this.allAxis()) {
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 98, 0);
                }
                System.exit(2);
            }
        } else if (this.todo.equalsIgnoreCase("allAsmx")) {
            if (!this.allAsmx()) {
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 98, 0);
                }
                System.exit(2);
            }
        } else if (this.todo.equalsIgnoreCase("compileJava")) {
            if (!this.compileJava()) {
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 98, 0);
                }
                System.exit(2);
            }
        } else if (this.todo.equalsIgnoreCase("genAxisWsdl")) {
            if (!this.genAxisWsdl()) {
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 98, 0);
                }
                System.exit(2);
            }
        } else if (this.todo.equalsIgnoreCase("axisDeploy")) {
            if (!this.axisDeploy()) {
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 98, 0);
                }
                System.exit(2);
            }
        } else if (this.todo.equalsIgnoreCase("genAxisWMQBits")) {
            if (!this.genAxisWMQBits()) {
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 98, 0);
                }
                System.exit(2);
            }
        } else if (this.todo.equalsIgnoreCase("genProxiesToAxis")) {
            if (!this.genProxiesToAxis()) {
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 98, 0);
                }
                System.exit(2);
            }
        } else if (this.todo.equalsIgnoreCase("genAsmxWsdl")) {
            if (!this.genAsmxWsdl()) {
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 98, 0);
                }
                System.exit(2);
            }
        } else if (this.todo.equalsIgnoreCase("genProxiesToDotNet")) {
            if (!this.genProxiesToDotNet()) {
                if (Trace.isTracing) {
                    MQTrace.mqTrace.exit(49, 98, 0);
                }
                System.exit(2);
            }
        } else if (this.todo.equalsIgnoreCase("genAsmxWMQBits") && !this.genAsmxWMQBits()) {
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 98, 0);
            }
            System.exit(2);
        }
        if (Trace.isTracing) {
            MQTrace.mqTrace.exit(49, 98, 0);
        }
    }

    public static void main(String[] stringArray) {
        MQTrace.mqTrace = MQTrace.Setup();
        new DeployWMQService(stringArray);
        if (Trace.isTracing) {
            CommonServices.processTerminate((Trace)MQTrace.mqTrace);
        }
    }
}

