/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.soap.util;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.soap.util.MQTrace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class RunMQCommand {
    private static final String SCCSID = "@(#) java/soap/com/ibm/mq/soap/util/RunMQCommand.java, soap, p701, p701-112-140304 1.10.3.1 09/08/15 17:28:35";
    private String mqOutput = "";
    private String mqError = "";
    private String queueManager;
    private static boolean quietMode = true;

    RunMQCommand(String string) {
        this.queueManager = string;
    }

    private boolean onWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("win");
    }

    public static boolean setQuiet(boolean bl) {
        quietMode = bl;
        return true;
    }

    public boolean Execute(String string) {
        if (this.onWindows()) {
            return this.ExecuteWindows(string);
        }
        return this.ExecuteUnix(string);
    }

    private boolean ExecuteWindows(String string) {
        boolean bl = true;
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 102);
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("runmqsc " + this.queueManager);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            bufferedWriter.write("end");
            bufferedWriter.newLine();
            bufferedWriter.flush();
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                this.mqOutput = this.mqOutput + string2 + "\n";
            }
            string2 = null;
            if (bufferedReader2.ready()) {
                while ((string2 = bufferedReader2.readLine()) != null) {
                    this.mqError = this.mqError + string2 + "\n";
                }
            }
            bufferedWriter.close();
            bufferedReader.close();
            bufferedReader2.close();
            if (process.exitValue() != 0) {
                bl = false;
            }
        }
        catch (Exception exception) {
            MQTrace.writeSoapMessage("15", string, null, null, null, null);
            bl = false;
            exception.printStackTrace();
        }
        if (!bl || !quietMode) {
            MQTrace.writeSoapMessage("16", string, null, null, null, null);
        }
        if (Trace.isTracing) {
            int n = bl ? 0 : -1;
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 102, n);
            }
        }
        return bl;
    }

    private boolean ExecuteUnix(String string) {
        boolean bl = true;
        if (Trace.isTracing) {
            MQTrace.mqTrace.entry(49, 101);
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(new String[]{"/bin/sh", "-c", "echo \"" + string + "\" | runmqsc " + this.queueManager});
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                this.mqOutput = this.mqOutput + string2 + "\n";
            }
            string2 = null;
            if (bufferedReader2.ready()) {
                while ((string2 = bufferedReader2.readLine()) != null) {
                    this.mqError = this.mqError + string2 + "\n";
                }
            }
            bufferedReader.close();
            bufferedReader2.close();
            Thread.sleep(100L);
            if (process.exitValue() != 0) {
                bl = false;
            }
        }
        catch (Exception exception) {
            MQTrace.writeSoapMessage("15", string, null, null, null, null);
            bl = false;
            exception.printStackTrace();
        }
        if (!bl || !quietMode) {
            MQTrace.writeSoapMessage("16", string, null, null, null, null);
        }
        if (Trace.isTracing) {
            int n = bl ? 0 : -1;
            if (Trace.isTracing) {
                MQTrace.mqTrace.exit(49, 101, n);
            }
        }
        return bl;
    }

    public String getOutput() {
        return this.mqOutput;
    }

    public String getError() {
        return this.mqError;
    }
}

