/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.deliver.console.application.service.impl;

import com.irdstudio.allinapaas.deliver.console.acl.repository.FlowConfMasterRepository;
import com.irdstudio.allinapaas.deliver.console.acl.repository.FlowConfNodeRepository;
import com.irdstudio.allinapaas.deliver.console.acl.repository.FlowConfValidateRepository;
import com.irdstudio.allinapaas.deliver.console.domain.entity.FlowConfMasterDO;
import com.irdstudio.allinapaas.deliver.console.domain.entity.FlowConfNodeDO;
import com.irdstudio.allinapaas.deliver.console.domain.entity.FlowConfValidateDO;
import com.irdstudio.allinapaas.deliver.console.facade.FlowConfValidateService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.FlowConfValidateDTO;
import com.irdstudio.allinapaas.deliver.console.types.BatchState;
import com.irdstudio.allinapaas.deliver.console.types.CheckResult;
import com.irdstudio.allinapaas.executor.facade.PluginExecutorService;
import com.irdstudio.allinapaas.executor.facade.dto.PluginExecutorDTO;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="flowConfValidateServiceImpl")
public class FlowConfValidateServiceImpl
extends BaseServiceImpl<FlowConfValidateDTO, FlowConfValidateDO, FlowConfValidateRepository>
implements FlowConfValidateService {
    public static final ConcurrentMap<String, Boolean> taskDebounce = new ConcurrentHashMap<String, Boolean>();
    @Autowired
    private FlowConfMasterRepository flowConfMasterRepository;
    @Autowired
    private FlowConfNodeRepository flowConfNodeRepository;
    @Autowired
    private PluginExecutorService pluginExecutorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(String batchId, String userId) {
        FlowConfValidateService selfService = (FlowConfValidateService)SpringContextUtils.getBean(FlowConfValidateService.class);
        FlowConfValidateDTO delParam = new FlowConfValidateDTO();
        delParam.setBatchId(batchId);
        selfService.deleteByPk((Object)delParam);
        FlowConfNodeDO taskParam = new FlowConfNodeDO();
        taskParam.setBatchId(batchId);
        List taskList = this.flowConfNodeRepository.queryList((Object)taskParam);
        if (CollectionUtils.isNotEmpty((Collection)taskList)) {
            taskDebounce.put(batchId, true);
            try {
                FlowConfValidateDTO valid;
                boolean validFlag = true;
                String now = CurrentDateUtil.getTodayDateEx2();
                ArrayList<FlowConfValidateDTO> validate = new ArrayList<FlowConfValidateDTO>(taskList.size());
                for (FlowConfNodeDO task : taskList) {
                    valid = new FlowConfValidateDTO();
                    valid.setBatchId(batchId);
                    valid.setTaskId(task.getTaskId());
                    valid.setValidTime(now);
                    valid.setCreateTime(now);
                    valid.setCreateUser(userId);
                    validate.add(valid);
                }
                selfService.batchInsert(validate);
                for (int i = 0; i < taskList.size(); ++i) {
                    FlowConfNodeDO task;
                    task = (FlowConfNodeDO)taskList.get(i);
                    valid = (FlowConfValidateDTO)validate.get(i);
                    PluginExecutorDTO validateParam = new PluginExecutorDTO();
                    validateParam.setBatchId(batchId);
                    validateParam.setTaskId(task.getTaskId());
                    validateParam.setPluginClass(task.getPluginClass());
                    ResponseData resp = this.pluginExecutorService.validate(validateParam);
                    if (resp.isSuccess()) {
                        valid.setValidRe(CheckResult.Pass.getCode());
                        valid.setValidMsg("\u6821\u9a8c\u6210\u529f");
                    } else {
                        validFlag = false;
                        valid.setValidRe(CheckResult.Fail.getCode());
                        if (resp.getRows() != null) {
                            valid.setValidMsg(String.format("%s%s", StringUtils.join((Iterable)((ValidateRtnDTO)resp.getRows()).getMessage(), (String)","), ((ValidateRtnDTO)resp.getRows()).getErrorMsgSuffix()));
                        } else {
                            valid.setValidMsg(resp.getMessage());
                        }
                    }
                    valid.setValidTime(CurrentDateUtil.getTodayDateEx2());
                    this.insert((BaseInfo)valid);
                }
                if (validFlag) {
                    FlowConfMasterDO batchUpdate = new FlowConfMasterDO();
                    batchUpdate.setBatchId(batchId);
                    batchUpdate.setBatchState(BatchState.Validated.getCode());
                    this.flowConfMasterRepository.updateByPk((Object)batchUpdate);
                }
                boolean bl = validFlag;
                return bl;
            }
            finally {
                taskDebounce.put(batchId, false);
            }
        }
        return false;
    }

    public boolean validateStat(String batchId) {
        return (Boolean)taskDebounce.get(batchId);
    }
}

