/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.deliver.console.application.service.impl;

import com.irdstudio.allinapaas.deliver.console.acl.repository.PaasEnvInfoRepository;
import com.irdstudio.allinapaas.deliver.console.acl.repository.PaasEnvParamRepository;
import com.irdstudio.allinapaas.deliver.console.domain.entity.PaasEnvInfoDO;
import com.irdstudio.allinapaas.deliver.console.domain.entity.PaasEnvInfoSummaryDO;
import com.irdstudio.allinapaas.deliver.console.domain.entity.PaasEnvParamDO;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvInfoSummaryDTO;
import com.irdstudio.allinapaas.deliver.console.types.YesOrNO;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import com.irdstudio.sdk.ssm.web.audit.AuditOperate;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paasEnvInfoServiceImpl")
public class PaasEnvInfoServiceImpl
extends BaseServiceImpl<PaasEnvInfoDTO, PaasEnvInfoDO, PaasEnvInfoRepository>
implements PaasEnvInfoService {
    @Autowired
    private PaasEnvParamRepository paasEnvParamRepository;

    @AuditOperate(action=AuditOperate.Action.Add, auditType="E", bizKey="${args[0].envId}", bizName="${args[0].envName}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].envId} ${args[0].envName}")
    public int insert(PaasEnvInfoDTO paramDTO) {
        Integer envOrder = paramDTO.getEnvOrder();
        if (envOrder == null) {
            envOrder = ((PaasEnvInfoRepository)this.getRepository()).queryMaxEnvOrder();
            paramDTO.setEnvOrder(envOrder);
        }
        PaasEnvParamDO envParam = new PaasEnvParamDO();
        envParam.setEnvId("dev");
        List envParamList = this.paasEnvParamRepository.queryList((Object)envParam);
        if (CollectionUtils.isNotEmpty((Collection)envParamList)) {
            for (PaasEnvParamDO ep : envParamList) {
                ep.setEnvId(paramDTO.getEnvId());
            }
            this.paasEnvParamRepository.batchInsert(envParamList);
        }
        return super.insert((BaseInfo)paramDTO);
    }

    @AuditOperate(action=AuditOperate.Action.Update, auditType="E", bizKey="${args[0].envId}", bizName="${args[0].envName}")
    public int updateByPk(PaasEnvInfoDTO paramDTO) {
        PaasEnvInfoDTO oldData = (PaasEnvInfoDTO)this.queryByPk((BaseInfo)paramDTO);
        paramDTO.setOldData((Object)oldData);
        return super.updateByPk((BaseInfo)paramDTO);
    }

    @AuditOperate(action=AuditOperate.Action.Delete, auditType="E", bizKey="${args[0].envId}", bizName="${args[0].envName}", text="${dynamicLog.action().getName()}\u4e86 #${args[0].envId} ${args[0].envName}")
    public int deleteByPk(PaasEnvInfoDTO paramDTO) {
        PaasEnvInfoDTO oldData = (PaasEnvInfoDTO)this.queryByPk((BaseInfo)paramDTO);
        if (!StringUtils.equals((CharSequence)oldData.getEnvCustom(), (CharSequence)YesOrNO.YES.getCode())) {
            throw new RuntimeException("\u975e\u81ea\u5b9a\u4e49\u73af\u5883\u4e0d\u53ef\u4ee5\u5220\u9664\uff01");
        }
        PaasEnvParamDO envParam = new PaasEnvParamDO();
        envParam.setEnvId(paramDTO.getEnvId());
        this.paasEnvParamRepository.deleteByEnvId(envParam);
        return super.deleteByPk((BaseInfo)paramDTO);
    }

    public List<PaasEnvInfoSummaryDTO> queryAllOwnerSummary(PaasEnvInfoDTO paasEnvInfoVo) {
        PaasEnvInfoDO param = (PaasEnvInfoDO)this.beanCopy(paasEnvInfoVo, PaasEnvInfoDO.class);
        List list = ((PaasEnvInfoRepository)this.getRepository()).queryAllOwnerSummary(param);
        return this.beansCopy(list, PaasEnvInfoSummaryDTO.class);
    }

    public List<PaasEnvInfoSummaryDTO> querySubsSummaryByPage(PaasEnvInfoSummaryDTO paasEnvInfoVo) {
        PaasEnvInfoSummaryDO param = (PaasEnvInfoSummaryDO)this.beanCopy(paasEnvInfoVo, PaasEnvInfoSummaryDO.class);
        List list = ((PaasEnvInfoRepository)this.getRepository()).querySubsSummaryByPage(param);
        return this.beansCopy(list, PaasEnvInfoSummaryDTO.class);
    }
}

