/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.deliver.console.application.service.impl;

import com.irdstudio.allinapaas.deliver.console.acl.repository.PaasEcsInfoRepository;
import com.irdstudio.allinapaas.deliver.console.acl.repository.PluginConfNginxRepository;
import com.irdstudio.allinapaas.deliver.console.domain.entity.PaasEcsInfoDO;
import com.irdstudio.allinapaas.deliver.console.domain.entity.PluginConfNginxDO;
import com.irdstudio.allinapaas.deliver.console.facade.PluginConfNginxService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PluginConfNginxDTO;
import com.irdstudio.allinapaas.deliver.console.types.NginxSrc;
import com.irdstudio.sdk.beans.core.base.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pluginConfNginxServiceImpl")
public class PluginConfNginxServiceImpl
extends BaseServiceImpl<PluginConfNginxDTO, PluginConfNginxDO, PluginConfNginxRepository>
implements PluginConfNginxService {
    @Autowired
    private PaasEcsInfoRepository paasEcsInfoRepository;

    public String generateNginxConf(String appId, String envId, String pluginConfId) {
        PluginConfNginxDO nginxConf = new PluginConfNginxDO();
        nginxConf.setPluginConfId(pluginConfId);
        nginxConf = (PluginConfNginxDO)((PluginConfNginxRepository)this.getRepository()).queryByPk((Object)nginxConf);
        if (nginxConf == null) {
            nginxConf = new PluginConfNginxDO();
            nginxConf.setPluginConfId(pluginConfId);
            nginxConf.setNginxSrc(NginxSrc.Automatic.getCode());
            ((PluginConfNginxRepository)this.getRepository()).insert((Object)nginxConf);
        }
        if (StringUtils.equals((CharSequence)nginxConf.getNginxSrc(), (CharSequence)NginxSrc.Automatic.getCode())) {
            PaasEcsInfoDO ecs;
            PaasEcsInfoDO ecsParam = new PaasEcsInfoDO();
            ecsParam.setAppId(appId);
            ecsParam.setEnvId(envId);
            List ecsList = this.paasEcsInfoRepository.queryListByPage((Object)ecsParam);
            PaasEcsInfoDO paasEcsInfoDO = ecs = CollectionUtils.isNotEmpty((Collection)ecsList) ? (PaasEcsInfoDO)ecsList.get(0) : null;
            if (ecs == null) {
                throw new RuntimeException("\u672a\u914d\u7f6e\u5e94\u7528\u670d\u52a1\u5668");
            }
            String conf = this.getNginxConf(ecs.getAppCode(), (PaasEcsInfoDTO)this.beanCopy(ecs, PaasEcsInfoDTO.class));
            nginxConf.setNginxConf(conf);
            ((PluginConfNginxRepository)this.getRepository()).updateByPk((Object)nginxConf);
            return conf;
        }
        return "";
    }

    public String getNginxConf(String appCode, PaasEcsInfoDTO ecs) {
        String ip;
        String conf = "";
        String server_port = "";
        if (StringUtils.isNotBlank((CharSequence)ecs.getEcsPort())) {
            server_port = ecs.getEcsPort();
        }
        if (StringUtils.isBlank((CharSequence)(ip = ecs.getEcsOutIp()))) {
            ip = ecs.getEcsIp();
        }
        conf = String.format("location ~ /%s/ {\n     rewrite /%s/(.*) /$1 break;\n     proxy_pass http://%s:%s;\n     proxy_set_header X-Real-IP $remote_addr;\n     proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;\n }\n", appCode, appCode, ip, server_port);
        return conf;
    }
}

