/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.manager.console.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.SSubsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.WikiRepoCommitQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.WikiRepoPushTask;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.WikiRepoPushTaskImpl;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.impl.ConnPoolForDruid;
import com.irdstudio.allinapaas.manager.console.facade.PaasDocDirectoryService;
import com.irdstudio.allinapaas.manager.console.facade.PaasDocExecutorService;
import com.irdstudio.allinapaas.manager.console.facade.PaasDocLibraryService;
import com.irdstudio.allinapaas.manager.console.facade.PaasDocTemplateService;
import com.irdstudio.allinapaas.manager.console.facade.dto.PaasDocDirectoryDTO;
import com.irdstudio.allinapaas.manager.console.facade.dto.PaasDocLibraryDTO;
import com.irdstudio.allinapaas.manager.console.facade.dto.PaasDocTemplateDTO;
import com.irdstudio.allinapaas.portal.console.application.service.task.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.portal.console.application.service.utils.DataBaseSQLScriptUtil;
import com.irdstudio.allinapaas.portal.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableIndexService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.PubDbmsDatatypeService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableIndexDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableStructDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.PubDbmsDatatypeDTO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paasDocExecutorServiceImpl")
public class PaasDocExecutorServiceImpl
implements FrameworkService,
PaasDocExecutorService {
    public static Logger logger = LoggerFactory.getLogger(PaasDocExecutorServiceImpl.class);
    @Autowired
    private PaasAppsInfoService paasAppsInfoService;
    @Autowired
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    private ModelTableIndexService modelTableIndexService;
    @Autowired
    private ModelTableFieldService modelTableFieldService;
    @Autowired
    private PubDbmsDatatypeService pubDbmsDatatypeService;
    @Autowired
    private SSubsInfoService sSubsInfoService;
    @Autowired
    private PaasDocLibraryService paasDocLibraryService;
    @Autowired
    private PaasDocDirectoryService paasDocDirectoryService;
    @Autowired
    private PaasDocTemplateService paasDocTemplateService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> docTemplateGenerate(String docTid, String subsId, String appId, boolean useSubs, String groupName, String extParms, String userId) {
        List<File> files = null;
        try {
            List<String> list;
            block16: {
                if (StringUtils.isBlank((String)docTid)) {
                    return null;
                }
                DocTemplateRepoPullQueueExecutor.syncRun();
                String docsRootPath = SdEnvUtil.DOCS_PATH;
                File sysDir = new File(docsRootPath + File.separator + subsId);
                ConnPoolForDruid connPool = new ConnPoolForDruid();
                Connection conn = null;
                try {
                    conn = connPool.getConnection();
                    PaasDocTemplateDTO templateParam = new PaasDocTemplateDTO();
                    templateParam.setDirId(docTid);
                    PaasDocTemplateDTO template = (PaasDocTemplateDTO)this.paasDocTemplateService.queryByPk((Object)templateParam);
                    template.setLoginUserId(userId);
                    if (!StringUtils.equals((String)"java", (String)template.getDocGenType())) {
                        List<String> list2 = null;
                        return list2;
                    }
                    Class<?> genClass = Class.forName(template.getDocGenContent());
                    DocGenerate genInstance = (DocGenerate)genClass.newInstance();
                    Map<String, Object> extParamsMap = null;
                    if (StringUtils.isNotBlank((String)extParms)) {
                        try {
                            extParamsMap = PaasDocExecutorServiceImpl.processExtParam(new String(Base64.getDecoder().decode(extParms.getBytes())));
                        }
                        catch (Exception e) {
                            logger.info("\u6269\u5c55\u53c2\u6570\u89e3\u6790\u5f02\u5e38 \u5ffd\u7565\u3002 " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (useSubs) {
                        files = genInstance.generateDoc((PaasDocTemplate)this.beanCopy(template, PaasDocTemplate.class), subsId, sysDir, (IConnPool)connPool, extParamsMap);
                        break block16;
                    }
                    if (StringUtils.isNotBlank((String)groupName)) {
                        File file = genInstance.generateGroupDoc((PaasDocTemplate)this.beanCopy(template, PaasDocTemplate.class), subsId, groupName, sysDir, (IConnPool)connPool, extParamsMap);
                        files = Arrays.asList(file);
                    } else {
                        File file = genInstance.generateAppDoc((PaasDocTemplate)this.beanCopy(template, PaasDocTemplate.class), appId, sysDir, (IConnPool)connPool, extParamsMap);
                        files = Arrays.asList(file);
                    }
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528\u6a21\u677f\u751f\u6210\u7c7b\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                }
                finally {
                    connPool.releaseConnection(conn);
                }
            }
            if (files == null) {
                list = Collections.emptyList();
                return list;
            }
            list = files.stream().map(f -> f.getAbsolutePath()).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    public String generateDDL(String objectId) {
        ModelTableInfoDTO inVo = new ModelTableInfoDTO();
        inVo.setObjectId(objectId);
        ModelTableInfoDTO outputVo = (ModelTableInfoDTO)this.modelTableInfoService.queryByPk((Object)inVo);
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(outputVo.getAppId());
        appInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfo);
        ModelTableFieldDTO modelTableFieldVO = new ModelTableFieldDTO();
        modelTableFieldVO.setObjectId(objectId);
        List modelTableFieldVOs = this.modelTableFieldService.queryList((Object)modelTableFieldVO);
        PubDbmsDatatypeDTO pubParam = new PubDbmsDatatypeDTO();
        pubParam.setDbmsId(Integer.valueOf(NumberUtils.toInt((String)appInfo.getBizDbDbms(), (int)425)));
        List dbmsTypes = this.pubDbmsDatatypeService.queryList((Object)pubParam);
        HashMap<String, PubDbmsDatatypeDTO> dbmsTypeMap = new HashMap<String, PubDbmsDatatypeDTO>();
        if (CollectionUtils.isNotEmpty((Collection)dbmsTypes)) {
            for (PubDbmsDatatypeDTO tt : dbmsTypes) {
                dbmsTypeMap.put(tt.getDbmsDatatypeCode(), tt);
            }
            if (CollectionUtils.isNotEmpty((Collection)modelTableFieldVOs)) {
                for (ModelTableFieldDTO ff : modelTableFieldVOs) {
                    PubDbmsDatatypeDTO dt = (PubDbmsDatatypeDTO)dbmsTypeMap.get(ff.getFieldType());
                    if (dt == null || !StringUtils.equals((String)dt.getIsNeedLength(), (String)"N")) continue;
                    ff.setFieldLength(Integer.valueOf(0));
                }
            }
        }
        ModelTableStructDTO genSQLScript = new ModelTableStructDTO();
        genSQLScript.setDbms(String.valueOf(appInfo.getBizDbDbms()));
        genSQLScript.setTable(outputVo);
        genSQLScript.setFields(modelTableFieldVOs);
        DataBaseSQLScriptUtil plugin = new DataBaseSQLScriptUtil();
        ModelTableIndexDTO indexParam = new ModelTableIndexDTO();
        indexParam.setObjectId(objectId);
        indexParam.setIndexTypePrimary(YesOrNO.NO.getCode());
        List indexList = this.modelTableIndexService.queryList((Object)indexParam);
        genSQLScript.setIndexs(indexList);
        ModelTableStructDTO genParam = (ModelTableStructDTO)JSON.parseObject((String)JSON.toJSONString((Object)genSQLScript), ModelTableStructDTO.class);
        return plugin.generateDDLScript(genParam);
    }

    public boolean subsDocsInitLocalDir(String subsId, String userId) {
        String docsRootPath = SdEnvUtil.DOCS_PATH;
        DocTemplateRepoPullQueueExecutor.run();
        File sysDir = new File(docsRootPath + File.separator + subsId);
        if (sysDir.exists()) {
            FileUtils.deleteQuietly((File)sysDir);
        }
        sysDir.mkdirs();
        SSubsInfoDTO subsInfo = new SSubsInfoDTO();
        subsInfo.setSubsId(subsId);
        subsInfo = (SSubsInfoDTO)this.sSubsInfoService.queryByPk((Object)subsInfo);
        if (StringUtils.isBlank((String)subsInfo.getDocLibraryId())) {
            subsInfo.setDocLibraryId("DEFAULT");
        }
        PaasDocLibraryDTO lib = new PaasDocLibraryDTO();
        lib.setLibId(subsInfo.getDocLibraryId());
        lib = (PaasDocLibraryDTO)this.paasDocLibraryService.queryByPk((Object)lib);
        PaasDocDirectoryDTO dirParam = new PaasDocDirectoryDTO();
        dirParam.setLibId(lib.getLibId());
        List dirList = this.paasDocDirectoryService.queryList((Object)dirParam);
        HashMap<String, PaasDocDirectoryDTO> dirMap = new HashMap<String, PaasDocDirectoryDTO>();
        for (PaasDocDirectoryDTO dir : dirList) {
            dirMap.put(dir.getDirId(), dir);
        }
        ArrayList<PaasDocDirectoryDTO> roots = new ArrayList<PaasDocDirectoryDTO>();
        for (PaasDocDirectoryDTO dir : dirList) {
            PaasDocDirectoryDTO parent = (PaasDocDirectoryDTO)dirMap.get(dir.getDirAbvId());
            if (parent != null) {
                if (parent.getChildren() == null) {
                    parent.setChildren(new ArrayList());
                }
                parent.getChildren().add(dir);
                continue;
            }
            roots.add(dir);
        }
        if (CollectionUtils.isNotEmpty(roots)) {
            roots.stream().forEach(p -> this.recursionMkdir((PaasDocDirectoryDTO)p, sysDir));
        }
        return true;
    }

    private void recursionMkdir(PaasDocDirectoryDTO dir, File parentDir) {
        File dirFile = new File(parentDir, dir.getDirName());
        dirFile.mkdirs();
        if (CollectionUtils.isNotEmpty((Collection)dir.getChildren())) {
            dir.getChildren().stream().forEach(p -> this.recursionMkdir((PaasDocDirectoryDTO)p, dirFile));
        }
    }

    public boolean subsDocsGenerate(String subsId, String userId) {
        String loginUserId = userId;
        String docsRootPath = SdEnvUtil.DOCS_PATH;
        File sysDir = new File(docsRootPath + File.separator + subsId);
        SSubsInfoDTO subsInfo = new SSubsInfoDTO();
        subsInfo.setSubsId(subsId);
        subsInfo = (SSubsInfoDTO)this.sSubsInfoService.queryByPk((Object)subsInfo);
        if (StringUtils.isBlank((String)subsInfo.getDocLibraryId())) {
            subsInfo.setDocLibraryId("DEFAULT");
        }
        PaasDocTemplateDTO templateParam = new PaasDocTemplateDTO();
        templateParam.setLibId(subsInfo.getDocLibraryId());
        List templateList = this.paasDocTemplateService.queryList((Object)templateParam);
        if (CollectionUtils.isNotEmpty((Collection)templateList)) {
            ConnPoolForDruid connPool = new ConnPoolForDruid();
            for (PaasDocTemplateDTO template : templateList) {
                if (!StringUtils.equals((String)template.getState(), (String)YesOrNO.YES.getCode())) continue;
                template.setLoginUserId(loginUserId);
                PaasDocTemplate copyTemplate = (PaasDocTemplate)this.beanCopy(template, PaasDocTemplate.class);
                if (!StringUtils.equals((String)"java", (String)template.getDocGenType())) continue;
                try {
                    Class<?> genClass = Class.forName(template.getDocGenContent());
                    DocGenerate genInstance = (DocGenerate)genClass.newInstance();
                    List files = genInstance.generateDoc(copyTemplate, subsId, sysDir, (IConnPool)connPool, null);
                    if (!CollectionUtils.isNotEmpty((Collection)files)) continue;
                    String dirPath = genInstance.getDocDirPath(copyTemplate);
                    for (File file : files) {
                        WikiRepoPushTaskImpl task = new WikiRepoPushTaskImpl(subsId, loginUserId, file, dirPath, String.format("\u63d0\u4ea4wiki\u6587\u6863\u751f\u6210 %s", file.getName()));
                        WikiRepoCommitQueueExecutor.addTask((WikiRepoPushTask)task);
                    }
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528\u6a21\u677f\u751f\u6210\u7c7b\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                }
            }
        }
        return true;
    }

    public boolean subsDocsPush(String subsId, String userId) {
        WikiRepoCommitQueueExecutor.start();
        return true;
    }

    private static Map<String, Object> processExtParam(String extParms) {
        JSONObject extParamsMap = Collections.emptyMap();
        if (StringUtils.isNotEmpty((String)extParms)) {
            extParamsMap = JSON.parseObject((String)extParms);
        }
        return extParamsMap;
    }
}

