/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsParamPortalService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.portal.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinapaas.portal.console.application.service.task.CodeTemplateRepoPullTask;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskCardgenService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskCardgenDTO;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionEnumService;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionEnumDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.CardDevInfoService;
import com.irdstudio.allinrdm.dev.console.facade.CodeProduceInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.CardDevInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.ModelStat;
import com.irdstudio.allinrdm.sam.console.facade.ComBaseInfoService;
import com.irdstudio.allintcp.sdk.bi.facade.operation.RdmModuleInfoService;
import com.irdstudio.allintcp.sdk.bi.facade.operation.dto.RdmModuleInfoDTO;
import com.irdstudio.allintcp.sdk.card.facade.operation.CardBaseInfoService;
import com.irdstudio.allintcp.sdk.card.facade.operation.CardPageInfoService;
import com.irdstudio.allintcp.sdk.card.facade.operation.CardPageLayoutService;
import com.irdstudio.allintcp.sdk.card.facade.operation.dto.CardBaseInfoDTO;
import com.irdstudio.allintcp.sdk.card.facade.operation.dto.CardPageInfoDTO;
import com.irdstudio.allintcp.sdk.card.facade.operation.dto.CardPageLayoutDTO;
import com.irdstudio.sdk.beans.core.spring.ExpressionUtil;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.FileUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardGenTask
extends AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(CardGenTask.class);
    private static final Pattern NumberCheckPattern = Pattern.compile("^\\d+\\S*");
    private PaasTaskInfoDTO taskInfo;
    private PaasTaskCardgenService paasCardgenService;
    private PaasAppsInfoService paasAppsInfoService;
    private CardDevInfoService cardDevInfoService;
    private ComBaseInfoService comBaseInfoService;
    private RdmModuleInfoService rdmModuleInfoService;
    private CodeProduceInfoService codeProduceInfoService;
    private DictOptionEnumService dictOptionEnumService;
    private DictOptionInfoService dictOptionInfoService;
    private CardBaseInfoService cardBaseInfoService;
    private CardPageInfoService cardPageInfoService;
    private CardPageLayoutService cardPageLayoutService;

    public CardGenTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        try {
            List cardList;
            this.paasCardgenService = (PaasTaskCardgenService)SpringContextUtils.getBean(PaasTaskCardgenService.class);
            this.paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            this.cardDevInfoService = (CardDevInfoService)SpringContextUtils.getBean(CardDevInfoService.class);
            this.comBaseInfoService = (ComBaseInfoService)SpringContextUtils.getBean(ComBaseInfoService.class);
            this.rdmModuleInfoService = (RdmModuleInfoService)SpringContextUtils.getBean(RdmModuleInfoService.class);
            this.codeProduceInfoService = (CodeProduceInfoService)SpringContextUtils.getBean(CodeProduceInfoService.class);
            this.dictOptionEnumService = (DictOptionEnumService)SpringContextUtils.getBean(DictOptionEnumService.class);
            this.dictOptionInfoService = (DictOptionInfoService)SpringContextUtils.getBean(DictOptionInfoService.class);
            this.cardBaseInfoService = (CardBaseInfoService)SpringContextUtils.getBean(CardBaseInfoService.class);
            this.cardPageInfoService = (CardPageInfoService)SpringContextUtils.getBean(CardPageInfoService.class);
            this.cardPageLayoutService = (CardPageLayoutService)SpringContextUtils.getBean(CardPageLayoutService.class);
            PaasTaskCardgenDTO fngenDTO = new PaasTaskCardgenDTO();
            fngenDTO.setTaskId(this.taskInfo.getTaskId());
            fngenDTO = (PaasTaskCardgenDTO)this.paasCardgenService.queryByPk((Object)fngenDTO);
            String userId = this.taskInfo.getLoginUserId();
            String subsId = this.taskInfo.getSubsId();
            String appId = this.taskInfo.getAppId();
            String taskId = this.taskInfo.getTaskId();
            String moduleId = this.taskInfo.getModuleId();
            String cardId = fngenDTO.getCardId();
            String pageId = fngenDTO.getPageId();
            String comId = null;
            CardDevInfoDTO cardParam = new CardDevInfoDTO();
            cardParam.setSubsId(subsId);
            cardParam.setAppId(appId);
            if (StringUtils.isNotBlank((CharSequence)cardId)) {
                cardParam.setCardId(cardId);
            }
            if (StringUtils.isNotBlank(comId)) {
                cardParam.setComId(comId);
            }
            if (StringUtils.isNotBlank((CharSequence)pageId)) {
                cardParam.setPageId(pageId);
            }
            if (StringUtils.isNotBlank((CharSequence)moduleId)) {
                cardParam.setModuleId(moduleId);
            }
            if (CollectionUtils.isNotEmpty((Collection)(cardList = this.cardDevInfoService.queryList((Object)cardParam)))) {
                PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
                appInfo.setAppId(appId);
                appInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfo);
                if (appInfo == null) {
                    throw new RuntimeException(appId + "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                appInfo.setLoginUserId(this.taskInfo.getLoginUserId());
                this.checkAndImportCom(appInfo, "COM01019", "S03013");
                CodeTemplateRepoPullTask templatePullTask = new CodeTemplateRepoPullTask();
                templatePullTask.syncRun();
                String nowTime = CurrentDateUtil.getTodayDate();
                String rootPath = SdEnvUtil.PROJECT_PATH + File.separator + appId;
                File rootDir = new File(rootPath);
                FileUtils.deleteQuietly((File)rootDir);
                if (!rootDir.exists()) {
                    rootDir.mkdirs();
                }
                PaasAppsParamPortalService paasAppsParamService = (PaasAppsParamPortalService)SpringContextUtils.getBean(PaasAppsParamPortalService.class);
                Map appsParam = paasAppsParamService.queryAppParamMap(appInfo.getAppId(), "dev");
                String packagePrefixVal = "com.irdstudio";
                if (StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)appsParam, (Object)"package_prefix"))) {
                    packagePrefixVal = MapUtils.getString((Map)appsParam, (Object)"package_prefix");
                }
                String appCode = SdEnvUtil.wrapperAppCode((String)appInfo.getAppCode());
                for (CardDevInfoDTO card : cardList) {
                    card.setLoginUserId(this.taskInfo.getLoginUserId());
                    List cardDataItem = null;
                    try {
                        cardDataItem = JSON.parseArray((String)card.getCardDataItem(), Map.class);
                    }
                    catch (Exception e) {
                        logger.error("{}\u5361\u7247\u4ee3\u7801\u6570\u636e\u9879\u89e3\u6790\u5f02\u5e38{}", new Object[]{card.getCardId(), e.getMessage(), e});
                        continue;
                    }
                    List<Map<String, Object>> optionsList = this.getOptionList(cardDataItem);
                    String comFeatureCodePackage = "";
                    RdmModuleInfoDTO moduleInfo = new RdmModuleInfoDTO();
                    moduleInfo.setModuleId(card.getModuleId());
                    moduleInfo = this.rdmModuleInfoService.queryByPk(moduleInfo);
                    if (moduleInfo != null) {
                        comFeatureCodePackage = moduleInfo.getFeatureCode();
                        packagePrefixVal = moduleInfo.getOrgCode();
                    } else {
                        comFeatureCodePackage = SdEnvUtil.wrapperAppCode((String)appInfo.getAppCode());
                    }
                    String appCodePackage = (packagePrefixVal + "." + comFeatureCodePackage).replaceAll("_|\\.|-", "/");
                    CodeTemplateDataBo ctdb = new CodeTemplateDataBo();
                    ctdb.getMapData().put("appCode", appCode);
                    ctdb.getMapData().put("appCodePackage", appCodePackage.replaceAll("_|\\.|-|/", "."));
                    ctdb.getMapData().put("comFeatureCodePackage", comFeatureCodePackage.replaceAll("_|\\.|-", "."));
                    ctdb.getMapData().put("appsParam", appsParam);
                    List<String> mainCodeTemplateFiles = Arrays.asList("${appCode}-web/src/main/java/${appCodePackage}/web/operation/", "XXXCardController.java", "${appCode}-infrastructure/src/main/resources/mybatis/mapper/${appCodePackage}/", "XXXMapperImpl.xml", "${appCode}-start/src/main/resources/front/page/${comFeatureCodePackage}/components/", "XXXCard.js");
                    HashMap<String, String> expMap = new HashMap<String, String>();
                    expMap.put("appCode", SdEnvUtil.wrapperAppCode((String)appInfo.getAppCode()));
                    expMap.put("appCodePackage", appCodePackage);
                    expMap.put("comFeatureCodePackage", comFeatureCodePackage.replaceAll("_|\\.|-", "/"));
                    for (int i = 0; i < mainCodeTemplateFiles.size(); i += 2) {
                        String path = mainCodeTemplateFiles.get(i);
                        String templateFile = mainCodeTemplateFiles.get(i + 1);
                        String targetPath = ExpressionUtil.parse((String)path, expMap);
                        ctdb.getMapData().put("appCodePackage", appCodePackage.replaceAll("/", "."));
                        ctdb.getMapData().put("nowTime", nowTime);
                        ctdb.getMapData().put("cardInfo", card);
                        ctdb.getMapData().put("cardDataItem", cardDataItem);
                        ctdb.getMapData().put("optionList", optionsList);
                        ctdb.getMapData().put("BASE_PATH", this.getBasePath(comFeatureCodePackage.replaceAll("_|\\.|-", "/")));
                        ctdb.getMapData().put("CARD_BASE_PATH", this.getBasePath("allintcp.sdk.card".replaceAll("_|\\.|-", "/")));
                        this.codeProduceInfoService.produceCodeFile("card", templateFile, card.getCardId(), "XXX", card.getCardId(), null, targetPath, appInfo.getAppId(), ctdb);
                    }
                    String id = card.getCardId();
                    File idDir = new File(SdEnvUtil.PROJECT_PATH + File.separator + id);
                    if (idDir.exists()) {
                        FileUtils.copyDirectory((File)idDir, (File)rootDir);
                    }
                    card.setModelStat(ModelStat.Generated.getCode());
                    this.cardDevInfoService.updateByPk((Object)card);
                }
                if (StringUtils.isBlank((CharSequence)cardId)) {
                    CardPageInfoDTO pageParam = new CardPageInfoDTO();
                    pageParam.setSubsId(subsId);
                    pageParam.setAppId(appId);
                    pageParam.setComId(comId);
                    pageParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
                    List pageList = this.cardPageInfoService.queryListByPage((Object)pageParam);
                    for (CardPageInfoDTO page : pageList) {
                        this.genCardDataJsonFile(page, rootPath, appCode);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)pageId)) {
                    File pageDir = new File(SdEnvUtil.PROJECT_PATH, pageId);
                    FileUtils.deleteQuietly((File)pageDir);
                    pageDir.mkdirs();
                    FileUtil.copyDirToDir((File)new File(rootPath), (File)pageDir);
                } else if (StringUtils.isNotBlank((CharSequence)cardId)) {
                    File cardDir = new File(SdEnvUtil.PROJECT_PATH, cardId);
                    FileUtil.copyDirToDir((File)new File(rootPath), (File)cardDir);
                }
            }
            this.taskInfo.setTaskErrorMsg(null);
            rtn.setSuccessFlag(true);
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("\u5361\u7247\u4ee3\u7801\u751f\u6210\u5f02\u5e38 " + e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u5361\u7247\u4ee3\u7801\u751f\u6210\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
            taskDebounce.put(this.taskInfo.getTaskId(), false);
        }
        return rtn;
    }

    private String getBasePath(String codePackagePath) {
        String[] strs = StringUtils.split((String)codePackagePath, (String)"/");
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("..");
        for (String s : strs) {
            paths.add("..");
        }
        return StringUtils.join(paths, (String)"/");
    }

    private void genCardDataJsonFile(CardPageInfoDTO pageInfo, String rootPath, String appCode) {
        String pageId = pageInfo.getPageId();
        CardPageLayoutDTO layoutParam = new CardPageLayoutDTO();
        layoutParam.setPageId(pageId);
        layoutParam.setLayoutId("default");
        layoutParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List layoutList = this.cardPageLayoutService.queryListByPage((Object)layoutParam);
        CardDevInfoDTO cardParam = new CardDevInfoDTO();
        cardParam.setPageId(pageId);
        List cardDevList = this.cardDevInfoService.queryList((Object)cardParam);
        HashMap layoutMap = new HashMap();
        layoutList.forEach(layout -> layoutMap.put(layout.getCardId(), layout));
        ArrayList<CardBaseInfoDTO> cardBaseList = new ArrayList<CardBaseInfoDTO>(cardDevList.size());
        for (CardDevInfoDTO cardDev : cardDevList) {
            CardBaseInfoDTO card = new CardBaseInfoDTO();
            CardPageLayoutDTO layout2 = (CardPageLayoutDTO)layoutMap.get(cardDev.getCardId());
            BeanUtility.beanCopy((Object)cardDev, (Object)card);
            BeanUtility.beanCopy((Object)layout2, (Object)card, (boolean)true);
            String comFeatureCodePackage = "";
            RdmModuleInfoDTO moduleInfo = new RdmModuleInfoDTO();
            moduleInfo.setModuleId(cardDev.getModuleId());
            moduleInfo = this.rdmModuleInfoService.queryByPk(moduleInfo);
            comFeatureCodePackage = moduleInfo != null ? moduleInfo.getFeatureCode() : appCode;
            HashMap<String, String> expMap = new HashMap<String, String>();
            expMap.put("cardId", card.getCardId());
            expMap.put("appCode", appCode);
            expMap.put("comFeatureCodePackage", comFeatureCodePackage.replaceAll("_|\\.|-", "/"));
            card.setCardCmp(ExpressionUtil.parse((String)"page/${comFeatureCodePackage}/components/${cardId}Card", expMap));
            cardBaseList.add(card);
        }
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("pageInfo", pageInfo);
        jsonMap.put("pageLayout", layoutList);
        jsonMap.put("card", cardBaseList);
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("appCode", appCode);
        String targetPath = ExpressionUtil.parse((String)"${appCode}-application/src/main/resources/META-INF/card/", expMap);
        File dir = new File(rootPath, targetPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File jsonFile = new File(dir, pageId + ".json");
        String jsonString = JSON.toJSONString(jsonMap);
        try (FileOutputStream output = new FileOutputStream(jsonFile);){
            IOUtils.write((String)jsonString, (OutputStream)output, (String)"UTF-8");
        }
        catch (Exception e) {
            logger.error("{}\u9875\u9762\u6570\u636e\u751f\u6210\u5f02\u5e38{}", new Object[]{pageId, e.getMessage(), e});
        }
    }

    private List<Map<String, Object>> getOptionList(List<Map> cardDataItem) {
        ArrayList<Map<String, Object>> optionList = new ArrayList<Map<String, Object>>();
        if (CollectionUtils.isNotEmpty(cardDataItem)) {
            for (Map field : cardDataItem) {
                String fieldId = MapUtils.getString((Map)field, (Object)"fieldId");
                String fieldOption = MapUtils.getString((Map)field, (Object)"fieldOption");
                String dictId = MapUtils.getString((Map)field, (Object)"dictId");
                String dictDslId = MapUtils.getString((Map)field, (Object)"dictDslId");
                if (!StringUtils.isNotBlank((CharSequence)fieldOption)) continue;
                DictOptionEnumDTO enumParam = new DictOptionEnumDTO();
                enumParam.setDictId(dictId);
                enumParam.setSubsId(dictDslId);
                List dictList = this.dictOptionEnumService.queryList((Object)enumParam);
                DictOptionInfoDTO optionInfo = new DictOptionInfoDTO();
                optionInfo.setDictId(dictId);
                optionInfo.setSubsId(dictDslId);
                if ((optionInfo = (DictOptionInfoDTO)this.dictOptionInfoService.queryByPk((Object)optionInfo)) == null) continue;
                if (CollectionUtils.isNotEmpty((Collection)dictList)) {
                    for (DictOptionEnumDTO dict : dictList) {
                        Matcher m;
                        if (StringUtils.isBlank((CharSequence)dict.getOptionEnum())) {
                            String optionEnum = String.format("%s_%s", optionInfo.getDictCode(), dict.getOptionCode());
                            dict.setOptionEnum(optionEnum);
                        }
                        if (!(m = NumberCheckPattern.matcher(dict.getOptionEnum())).matches()) continue;
                        String optionEnum = String.format("%s_%s", optionInfo.getDictCode(), dict.getOptionEnum());
                        dict.setOptionEnum(optionEnum);
                    }
                }
                String oriDictCode = optionInfo.getDictCode();
                optionInfo.setDictCode(TmModelUtil.tableCodeToClassName((String)optionInfo.getDictCode()));
                HashMap<String, Object> optionMap = new HashMap<String, Object>();
                optionMap.put("dictCode", optionInfo.getDictCode());
                optionMap.put("dictId", oriDictCode);
                optionMap.put("option", optionInfo);
                optionMap.put("dictList", dictList);
                optionList.add(optionMap);
            }
        }
        return optionList;
    }
}

