/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.portal.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinapaas.portal.console.application.service.task.AppRepoPullTask;
import com.irdstudio.allinapaas.portal.console.application.service.task.AppRepoPushTaskImpl;
import com.irdstudio.allinapaas.portal.console.application.service.task.ComBaseInfoRepoPullTask;
import com.irdstudio.allinapaas.portal.console.application.service.task.GitRepoPushQueueExecutor;
import com.irdstudio.allinapaas.portal.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskComimportService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskComimportDTO;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.ModelFolderInfoService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelFolderInfoDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.PageImportType;
import com.irdstudio.allinrdm.sam.console.facade.ComBaseInfoService;
import com.irdstudio.allinrdm.sam.console.facade.ComDependInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.ComBaseInfoDTO;
import com.irdstudio.allinrdm.sam.console.facade.dto.ComDependInfoDTO;
import com.irdstudio.allinrdm.sam.console.types.ComDependType;
import com.irdstudio.allinrdm.sam.console.types.ComSrcType;
import com.irdstudio.allintcp.sdk.bi.facade.operation.RdmModuleInfoService;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.FilterItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComBaseInfoImportTask
extends AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(ComBaseInfoImportTask.class);
    private PaasTaskInfoDTO taskInfo;
    private final String[] pageSuffixes = new String[]{".vue", ".js", ".html", ".css"};

    public ComBaseInfoImportTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        try {
            block61: {
                PaasTaskComimportService paasTaskComimportService = (PaasTaskComimportService)SpringContextUtils.getBean(PaasTaskComimportService.class);
                PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
                ComBaseInfoService comBaseInfoService = (ComBaseInfoService)SpringContextUtils.getBean(ComBaseInfoService.class);
                RdmModuleInfoService rdmModuleInfoService = (RdmModuleInfoService)SpringContextUtils.getBean(RdmModuleInfoService.class);
                PaasTaskComimportDTO comImport = new PaasTaskComimportDTO();
                comImport.setTaskId(this.taskInfo.getTaskId());
                comImport = (PaasTaskComimportDTO)paasTaskComimportService.queryByPk((Object)comImport);
                String userId = this.taskInfo.getLoginUserId();
                String subsId = this.taskInfo.getSubsId();
                String appId = this.taskInfo.getAppId();
                String taskId = this.taskInfo.getTaskId();
                String comId = comImport.getComId();
                String comSubsId = comImport.getComSubsId();
                String pageImportType = comImport.getPageImportType();
                String frontAppId = comImport.getFrontAppId();
                PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
                appInfo.setAppId(appId);
                appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appInfo);
                if (appInfo == null) {
                    throw new RuntimeException(appId + "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                String gitUrl = appInfo.getAppGitUrl();
                ComBaseInfoDTO comBaseInfo = new ComBaseInfoDTO();
                comBaseInfo.setComId(comId);
                comBaseInfo.setSubsId(comSubsId);
                comBaseInfo = (ComBaseInfoDTO)comBaseInfoService.queryByPk((Object)comBaseInfo);
                if (comBaseInfo == null) {
                    throw new RuntimeException(comId + "\u7ec4\u4ef6\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                this.saveComData(appInfo, comBaseInfo, comImport, userId);
                String comFeatureCode = comBaseInfo.getComFeatureCode();
                String featureCodePath = StringUtils.replace((String)comFeatureCode, (String)".", (String)File.separator);
                String comGitUrl = comBaseInfo.getComGitUrl();
                if (StringUtils.isBlank((CharSequence)comGitUrl)) {
                    throw new RuntimeException(comId + "\u7ec4\u4ef6\u672a\u914d\u7f6e\u7ec4\u4ef6\u4ee3\u7801\u4ed3\u5e93");
                }
                if (StringUtils.equals((CharSequence)comImport.getComDependType(), (CharSequence)ComDependType.Dynamic.getCode())) {
                    ComBaseInfoRepoPullTask pullTask = new ComBaseInfoRepoPullTask(comGitUrl);
                    pullTask.syncRun();
                    String comGitRepoPath = pullTask.getLocalRepoPath();
                    List<File> allComBaseInfoFileList = this.comBaseInfoRepoAllFile(new File(comGitRepoPath));
                    List<File> allNeedFileList = allComBaseInfoFileList.stream().filter(file -> StringUtils.contains((CharSequence)file.getAbsolutePath(), (CharSequence)featureCodePath)).collect(Collectors.toList());
                    File appRootDir = new File(SdEnvUtil.PROJECT_PATH + File.separator + this.taskInfo.getTaskId() + "-com");
                    String appRootPath = appRootDir.getAbsolutePath();
                    this.copyAndReplaceNeedFileList(comGitRepoPath, appRootPath, allNeedFileList, comBaseInfo, comImport, appInfo);
                    AppRepoPushTaskImpl pushTask = new AppRepoPushTaskImpl(userId, appRootDir, gitUrl, String.format("%s #%s", this.taskInfo.getTaskName(), this.taskInfo.getTaskId()));
                    GitRepoPushQueueExecutor.run(pushTask);
                    if (StringUtils.equals((CharSequence)pageImportType, (CharSequence)PageImportType.IMPORT_TO_FRONT_APP.getCode())) {
                        PaasAppsInfoDTO frontApp = new PaasAppsInfoDTO();
                        frontApp.setAppId(frontAppId);
                        frontApp = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)frontApp);
                        if (frontApp != null) {
                            File appFrontRootDir = new File(SdEnvUtil.PROJECT_PATH + File.separator + frontAppId + "-com");
                            AppRepoPushTaskImpl frontPushTask = new AppRepoPushTaskImpl(userId, appFrontRootDir, frontApp.getAppGitUrl(), String.format("%s #%s", this.taskInfo.getTaskName(), this.taskInfo.getTaskId()), frontApp);
                            GitRepoPushQueueExecutor.run(frontPushTask);
                        }
                    }
                } else if (StringUtils.equals((CharSequence)comImport.getComDependType(), (CharSequence)ComDependType.Static.getCode())) {
                    File[] appRootDirs;
                    ComBaseInfoRepoPullTask pullTask = new ComBaseInfoRepoPullTask(comGitUrl);
                    pullTask.syncRun();
                    String comGitRepoPath = pullTask.getLocalRepoPath();
                    String rootPomPath = comGitRepoPath + File.separator + "pom.xml";
                    String groupId = "";
                    String artifactId = "";
                    String version = "";
                    try (FileInputStream input = new FileInputStream(new File(rootPomPath));){
                        String xmlString = IOUtils.toString((InputStream)input);
                        Document document = DocumentHelper.parseText((String)xmlString);
                        Element groupDom = document.getRootElement().element("groupId");
                        groupId = groupDom.getText();
                        File[] artifactDom = document.getRootElement().element("artifactId");
                        String rootId = artifactDom.getText();
                        artifactId = String.format("%s-autoconfigure", rootId);
                        Element versionDom = document.getRootElement().element("version");
                        version = versionDom.getText();
                    }
                    catch (Exception e) {
                        logger.error("\u8bfb\u53d6\u9759\u6001\u5f15\u5165\u7ec4\u4ef6\u5de5\u7a0b\u4fe1\u606f\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                        rtn.setSuccessFlag(false);
                        this.taskInfo.setTaskErrorMsg("\u8bfb\u53d6\u9759\u6001\u5f15\u5165\u7ec4\u4ef6\u5de5\u7a0b\u4fe1\u606f\u5f02\u5e38 " + e.getMessage());
                    }
                    if (StringUtils.isBlank((CharSequence)groupId) || StringUtils.isBlank((CharSequence)artifactId)) {
                        rtn.setSuccessFlag(true);
                        ExecuteRtnInfo e = rtn;
                        return e;
                    }
                    AppRepoPullTask appPullTask = new AppRepoPullTask(appInfo.getAppId(), gitUrl);
                    appPullTask.syncRun();
                    String appRootPath = appPullTask.getAppPath();
                    String startPomPath = "";
                    File appRootFile = new File(appRootPath);
                    for (File dir : appRootDirs = appRootFile.listFiles()) {
                        if (!StringUtils.endsWith((CharSequence)dir.getName(), (CharSequence)"-application") || !dir.isDirectory()) continue;
                        startPomPath = new File(dir, "pom.xml").getAbsolutePath();
                        break;
                    }
                    if (StringUtils.isBlank((CharSequence)startPomPath)) {
                        rtn.setSuccessFlag(false);
                        this.taskInfo.setTaskErrorMsg("\u672a\u627e\u5230\u5e94\u7528 application \u5de5\u7a0bpom.xml\u6587\u4ef6\uff0c\u65e0\u6cd5\u9759\u6001\u5f15\u5165");
                    }
                    try (FileInputStream input = new FileInputStream(new File(startPomPath));){
                        String xmlString = IOUtils.toString((InputStream)input);
                        Document document = DocumentHelper.parseText((String)xmlString);
                        boolean findFlag = false;
                        for (Element dependency : document.getRootElement().element("dependencies").elements()) {
                            Element groupIdDom = dependency.element("groupId");
                            Element artifactIdDom = dependency.element("artifactId");
                            Element versionDom = dependency.element("version");
                            if (!StringUtils.equals((CharSequence)groupIdDom.getText(), (CharSequence)groupId) && !StringUtils.equals((CharSequence)artifactIdDom.getText(), (CharSequence)artifactId)) continue;
                            findFlag = true;
                            break;
                        }
                        if (!findFlag) {
                            document.getRootElement().element("dependencies").add(this.addDependency(groupId, artifactId, version));
                            OutputFormat format = OutputFormat.createPrettyPrint();
                            format.setIndentSize(4);
                            format.setSuppressDeclaration(true);
                            format.setEncoding("UTF-8");
                            try (PrintWriter pw = new PrintWriter(new File(startPomPath));){
                                XMLWriter writer = new XMLWriter((Writer)pw, format);
                                writer.write(document);
                                pw.flush();
                            }
                            AppRepoPushTaskImpl pushTask = new AppRepoPushTaskImpl(userId, new File(appRootPath), gitUrl, String.format("%s #%s", this.taskInfo.getTaskName(), this.taskInfo.getTaskId()));
                            GitRepoPushQueueExecutor.run(pushTask);
                            break block61;
                        }
                        logger.error(appInfo.getAppId() + "\u5df2\u5b58\u5728\u7ec4\u4ef6\u4f9d\u8d56\u4fe1\u606f" + comFeatureCode);
                    }
                    catch (Exception e) {
                        logger.error("\u5199\u5165\u9759\u6001\u5f15\u5165\u7ec4\u4ef6\u4f9d\u8d56\u4fe1\u606f\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                        rtn.setSuccessFlag(false);
                        this.taskInfo.setTaskErrorMsg("\u5199\u5165\u9759\u6001\u5f15\u5165\u7ec4\u4ef6\u4f9d\u8d56\u4fe1\u606f\u5f02\u5e38 " + e.getMessage());
                    }
                }
            }
            rtn.setSuccessFlag(true);
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("\u5e94\u7528\u7ec4\u4ef6\u5bfc\u5165\u5f02\u5e38 " + e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u5e94\u7528\u7ec4\u4ef6\u5bfc\u5165\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
            taskDebounce.put(this.taskInfo.getTaskId(), false);
        }
        return rtn;
    }

    private Element addDependency(String groupId, String artifactId, String version) {
        Element groupIdDom = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"groupId", (Namespace)DocumentHelper.createNamespace((String)"", (String)"http://maven.apache.org/POM/4.0.0")));
        groupIdDom.setText(groupId);
        Element artifactIdDom = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"artifactId", (Namespace)DocumentHelper.createNamespace((String)"", (String)"http://maven.apache.org/POM/4.0.0")));
        artifactIdDom.setText(artifactId);
        Element versionDom = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"version", (Namespace)DocumentHelper.createNamespace((String)"", (String)"http://maven.apache.org/POM/4.0.0")));
        versionDom.setText(version);
        Element dependency = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"dependency", (Namespace)DocumentHelper.createNamespace((String)"", (String)"http://maven.apache.org/POM/4.0.0")));
        dependency.add(groupIdDom);
        dependency.add(artifactIdDom);
        dependency.add(versionDom);
        return dependency;
    }

    private boolean saveComData(PaasAppsInfoDTO appInfo, ComBaseInfoDTO comBaseInfo, PaasTaskComimportDTO comImport, String userId) {
        boolean flag = true;
        ComBaseInfoService comBaseInfoService = (ComBaseInfoService)SpringContextUtils.getBean(ComBaseInfoService.class);
        ComDependInfoService comDependInfoService = (ComDependInfoService)SpringContextUtils.getBean(ComDependInfoService.class);
        ModelTableInfoService modelTableInfoService = (ModelTableInfoService)SpringContextUtils.getBean(ModelTableInfoService.class);
        ModelFolderInfoService modelFolderInfoService = (ModelFolderInfoService)SpringContextUtils.getBean(ModelFolderInfoService.class);
        String now = CurrentDateUtil.getTodayDateEx2();
        ComDependInfoDTO appCom = new ComDependInfoDTO();
        BeanUtility.beanCopy((Object)comBaseInfo, (Object)appCom, (boolean)true);
        appCom.setSubsId(appInfo.getSubsId());
        appCom.setAppId(appInfo.getAppId());
        appCom.setComSrcType(ComSrcType.Import.getCode());
        appCom.setComDependType(comImport.getComDependType());
        appCom.setCreateUser(userId);
        appCom.setCreateTime(now);
        appCom.setLastModifyUser(userId);
        appCom.setLastModifyTime(now);
        appCom.setComSrcId(comBaseInfo.getComId());
        appCom.setComSrcSubsId(comBaseInfo.getSubsId());
        ComDependInfoDTO checkObj = (ComDependInfoDTO)comDependInfoService.queryByPk((Object)appCom);
        if (checkObj == null) {
            comDependInfoService.insert((Object)appCom);
        } else {
            comDependInfoService.updateByPk((Object)appCom);
        }
        String refDbAppid = StringUtils.isNotBlank((CharSequence)appInfo.getRefDbAppid()) ? appInfo.getRefDbAppid() : appInfo.getAppId();
        ModelTableInfoDTO modelParam = new ModelTableInfoDTO();
        modelParam.setSubsId(comBaseInfo.getSubsId());
        modelParam.setComId(comBaseInfo.getComId());
        List refModelTableList = modelTableInfoService.queryList((Object)modelParam);
        if (CollectionUtils.isNotEmpty((Collection)refModelTableList)) {
            ModelTableInfoDTO comTableParam = new ModelTableInfoDTO();
            comTableParam.setComId(appCom.getComId());
            comTableParam.setAppId(refDbAppid);
            List oldTbList = modelTableInfoService.queryList((Object)comTableParam);
            if (CollectionUtils.isNotEmpty((Collection)oldTbList)) {
                oldTbList.stream().forEach(tb -> modelTableInfoService.deleteByPk(tb));
            }
            FilterItem folderParamItem = new FilterItem();
            folderParamItem.setOp(FilterItem.FilterOpEnum.In.getCode());
            folderParamItem.setKey("folderId");
            folderParamItem.setValues(refModelTableList.stream().map(ModelTableInfoDTO::getFolderId).collect(Collectors.toList()));
            ModelFolderInfoDTO folderParam = new ModelFolderInfoDTO();
            folderParam.setFilterCond(JSON.toJSONString(Arrays.asList(folderParamItem)));
            List folderList = modelFolderInfoService.queryList((Object)folderParam);
            HashMap<String, String> folderMap = new HashMap<String, String>();
            if (CollectionUtils.isNotEmpty((Collection)folderList)) {
                ArrayList<ModelFolderInfoDTO> needInsertFolderList = new ArrayList<ModelFolderInfoDTO>();
                for (ModelFolderInfoDTO folderInfo : folderList) {
                    ModelFolderInfoDTO checkFolderObj = new ModelFolderInfoDTO();
                    checkFolderObj.setFolderName(folderInfo.getFolderName());
                    checkFolderObj.setAppId(refDbAppid);
                    List alreadyHas = modelFolderInfoService.queryListByPage((Object)checkFolderObj);
                    if (CollectionUtils.isNotEmpty((Collection)alreadyHas)) {
                        folderMap.put(folderInfo.getFolderId(), ((ModelFolderInfoDTO)alreadyHas.get(0)).getFolderId());
                        continue;
                    }
                    ModelFolderInfoDTO newFolder = new ModelFolderInfoDTO();
                    BeanUtility.beanCopy((Object)folderInfo, (Object)newFolder);
                    newFolder.setAppId(refDbAppid);
                    newFolder.setFolderId(UUIDUtil.getUUID());
                    newFolder.setCreateUser(userId);
                    newFolder.setCreateTime(now);
                    newFolder.setLastModifyUser(userId);
                    newFolder.setLastModifyTime(now);
                    needInsertFolderList.add(newFolder);
                    folderMap.put(folderInfo.getFolderId(), newFolder.getFolderId());
                }
                if (CollectionUtils.isNotEmpty(needInsertFolderList)) {
                    modelFolderInfoService.batchInsert(needInsertFolderList);
                }
            }
            for (ModelTableInfoDTO table : refModelTableList) {
                table.setAppId(refDbAppid);
                table.setReferenceId(table.getObjectId());
                table.setCreateUser(userId);
                table.setCreateTime(now);
                table.setLastModifyUser(userId);
                table.setLastModifyTime(now);
                table.setComId(appCom.getComId());
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)folderMap.get(table.getFolderId())))) {
                    table.setFolderId((String)folderMap.get(table.getFolderId()));
                }
                modelTableInfoService.copyModelTableInfo(table);
            }
        }
        return flag;
    }

    private List<File> comBaseInfoRepoAllFile(File parentFile) {
        if (!parentFile.exists()) {
            return Collections.emptyList();
        }
        if (StringUtils.equalsAny((CharSequence)parentFile.getName(), (CharSequence[])new CharSequence[]{".git"})) {
            return Collections.emptyList();
        }
        ArrayList<File> list = new ArrayList<File>();
        list.add(parentFile);
        if (parentFile.isDirectory()) {
            File[] files;
            for (File subFile : files = parentFile.listFiles()) {
                list.addAll(this.comBaseInfoRepoAllFile(subFile));
            }
        }
        return list;
    }

    private void copyAndReplaceNeedFileList(String comGitRepoPath, String appRootPath, List<File> needFileList, ComBaseInfoDTO comBaseInfo, PaasTaskComimportDTO comImport, PaasAppsInfoDTO appInfo) {
        if (CollectionUtils.isEmpty(needFileList)) {
            return;
        }
        String pageImportType = comImport.getPageImportType();
        String frontAppId = comImport.getFrontAppId();
        String frontAppCode = comImport.getFrontAppCode();
        frontAppCode = SdEnvUtil.wrapperAppCode(frontAppCode);
        String oldPackagePrefix = comBaseInfo.getComOrgCode();
        oldPackagePrefix = StringUtils.replace((String)oldPackagePrefix, (String)".", (String)File.separator);
        String newPackagePrefix = comImport.getPackagePrefix();
        newPackagePrefix = StringUtils.replace((String)newPackagePrefix, (String)".", (String)File.separator);
        String appReplaceString = SdEnvUtil.wrapperAppCode(appInfo.getAppCode());
        for (File sourceFile : needFileList) {
            String sourcePath = sourceFile.getAbsolutePath();
            if (!sourceFile.exists() || !sourceFile.isFile()) continue;
            if (StringUtils.containsAnyIgnoreCase((CharSequence)sourceFile.getName(), (CharSequence[])this.pageSuffixes)) {
                if (StringUtils.equals((CharSequence)pageImportType, (CharSequence)PageImportType.DOT_NOT_IMPORT.getCode())) continue;
                if (StringUtils.equals((CharSequence)pageImportType, (CharSequence)PageImportType.IMPORT_TO_FRONT_APP.getCode())) {
                    File appFrontRootDir = new File(SdEnvUtil.PROJECT_PATH + File.separator + frontAppId + "-com");
                    String relationPath = this.handleFilePrefix(frontAppCode, comGitRepoPath, sourcePath);
                    relationPath = StringUtils.replace((String)relationPath, (String)oldPackagePrefix, (String)newPackagePrefix);
                    String targetPath = appFrontRootDir.getAbsolutePath() + File.separator + relationPath;
                    this.replaceFileContentAndWrite(sourceFile, targetPath, new String[]{comBaseInfo.getComOrgCode()}, new String[]{comImport.getPackagePrefix()});
                    continue;
                }
            }
            String relationPath = this.handleFilePrefix(appReplaceString, comGitRepoPath, sourcePath);
            relationPath = StringUtils.replace((String)relationPath, (String)oldPackagePrefix, (String)newPackagePrefix);
            String targetPath = appRootPath + File.separator + relationPath;
            this.replaceFileContentAndWrite(sourceFile, targetPath, new String[]{comBaseInfo.getComOrgCode(), comImport.getPackagePrefix() + ".framework.beans"}, new String[]{comImport.getPackagePrefix(), "com.irdstudio.framework.beans"});
        }
    }

    private String handleFilePrefix(String appCodePrefix, String rootPath, String filePath) {
        String rootDirName;
        DirPrefix dirPrefix;
        String remainder;
        String rootFileName = StringUtils.replace((String)filePath, (String)rootPath, (String)"");
        if (StringUtils.startsWith((CharSequence)rootFileName, (CharSequence)File.separator)) {
            rootFileName = StringUtils.substring((String)rootFileName, (int)1);
        }
        if (StringUtils.startsWith((CharSequence)(remainder = StringUtils.substring((String)rootFileName, (int)StringUtils.indexOf((CharSequence)rootFileName, (CharSequence)File.separator))), (CharSequence)File.separator)) {
            remainder = StringUtils.substring((String)remainder, (int)1);
        }
        if ((dirPrefix = DirPrefix.get(rootDirName = StringUtils.substring((String)rootFileName, (int)0, (int)StringUtils.indexOf((CharSequence)rootFileName, (CharSequence)File.separator)))) != null) {
            String newPrefix = appCodePrefix + dirPrefix.getSuffix();
            String newFilePath = newPrefix + File.separator + remainder;
            return newFilePath;
        }
        return rootFileName;
    }

    private void replaceFileContentAndWrite(File sourceFile, String targetFilePath, String[] sourceReplaces, String[] targetReplaces) {
        if (!this.isBinary(sourceFile)) {
            StringBuffer strBuffer = new StringBuffer();
            try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(new FileInputStream(sourceFile)));){
                String temp = null;
                while ((temp = bufReader.readLine()) != null) {
                    for (int i = 0; i < sourceReplaces.length; ++i) {
                        temp = StringUtils.replace((String)temp, (String)sourceReplaces[i], (String)targetReplaces[i]);
                    }
                    strBuffer.append(temp);
                    strBuffer.append(System.getProperty("line.separator"));
                    temp = null;
                }
            }
            catch (FileNotFoundException e) {
                String msg = "\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + e;
                logger.error(msg, (Object)e.getMessage(), (Object)e);
            }
            catch (IOException e) {
                String msg = "IO\u51fa\u73b0\u5f02\u5e38\uff1a" + e;
                logger.error(msg, (Object)e.getMessage(), (Object)e);
            }
            this.writeToNewFile(targetFilePath, strBuffer);
        } else {
            logger.info("\u4e8c\u8fdb\u5236\u6587\u4ef6:{}", (Object)sourceFile.getAbsolutePath());
            try {
                File targetFile = new File(targetFilePath);
                File parentDir = targetFile.getParentFile();
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                FileUtils.copyFile((File)sourceFile, (File)targetFile);
            }
            catch (IOException e) {
                logger.error("{} \u590d\u5236 {}", new Object[]{sourceFile.getAbsolutePath(), e.getMessage(), e});
            }
        }
    }

    public boolean isBinary(File file) {
        boolean isBinary = false;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            long len = file.length();
            for (int j = 0; j < (int)len; ++j) {
                int t = fin.read();
                if (t >= 32 || t == 9 || t == 10 || t == 13) continue;
                isBinary = true;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isBinary;
    }

    private void writeToNewFile(String newFilePath, StringBuffer strBuffer) {
        try {
            File file = new File(newFilePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.write(strBuffer.toString().toCharArray());
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException e) {
            logger.error("{} \u5199\u5165\u5931\u8d25 {}", new Object[]{newFilePath, e.getMessage(), e});
        }
    }

    private static enum DirPrefix {
        application("-application"),
        common("-common"),
        domain("-domain"),
        facade("-facade"),
        front("-front"),
        infracl("-infracl"),
        infrastructure("-infrastructure"),
        start("-start"),
        types("-types"),
        web("-web");

        private String suffix;

        private DirPrefix(String suffix) {
            this.suffix = suffix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public static DirPrefix get(String name) {
            if (name == null) {
                return null;
            }
            for (DirPrefix r : DirPrefix.values()) {
                if (!StringUtils.endsWith((CharSequence)name, (CharSequence)r.getSuffix())) continue;
                return r;
            }
            return null;
        }
    }
}

