/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.TemplateGenAppCodeService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.portal.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinapaas.portal.console.application.service.task.CodeTemplateRepoPullTask;
import com.irdstudio.allinapaas.portal.console.application.service.task.GenFrontPageTask;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskFngenService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskFngenDTO;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dev.console.facade.PageModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.allinrdm.sam.console.facade.FnModelInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.FnModelInfoDTO;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FnTableModelGenTask
extends AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(FnTableModelGenTask.class);
    private PaasTaskInfoDTO taskInfo;

    public FnTableModelGenTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        try {
            List fnList;
            PaasTaskFngenService paasTaskFngenService = (PaasTaskFngenService)SpringContextUtils.getBean(PaasTaskFngenService.class);
            PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            FnModelInfoService fnModelInfoService = (FnModelInfoService)SpringContextUtils.getBean(FnModelInfoService.class);
            PageModelInfoService pageModelInfoService = (PageModelInfoService)SpringContextUtils.getBean(PageModelInfoService.class);
            SrvModelInfoService srvModelInfoService = (SrvModelInfoService)SpringContextUtils.getBean(SrvModelInfoService.class);
            PaasTaskFngenDTO fngenDTO = new PaasTaskFngenDTO();
            fngenDTO.setTaskId(this.taskInfo.getTaskId());
            fngenDTO = (PaasTaskFngenDTO)paasTaskFngenService.queryByPk((Object)fngenDTO);
            String userId = this.taskInfo.getLoginUserId();
            String subsId = this.taskInfo.getSubsId();
            String appId = this.taskInfo.getAppId();
            String taskId = this.taskInfo.getTaskId();
            String tableModelId = fngenDTO.getTableModelId();
            String comId = fngenDTO.getComId();
            String genPath = fngenDTO.getGenPath();
            FnModelInfoDTO fnParam = new FnModelInfoDTO();
            fnParam.setSubsId(subsId);
            fnParam.setAppId(appId);
            fnParam.setTableModelId(tableModelId);
            if (StringUtils.equals((CharSequence)this.taskInfo.getTaskType(), (CharSequence)"E01003")) {
                fnParam.setComId(comId);
            }
            if (CollectionUtils.isNotEmpty((Collection)(fnList = fnModelInfoService.queryList((Object)fnParam)))) {
                PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
                appInfo.setAppId(appId);
                appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appInfo);
                if (appInfo == null) {
                    throw new RuntimeException(appId + "\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                appInfo.setGenPath(genPath);
                appInfo.setLoginUserId(this.taskInfo.getLoginUserId());
                CodeTemplateRepoPullTask templatePullTask = new CodeTemplateRepoPullTask();
                templatePullTask.syncRun();
                TemplateGenAppCodeService genService = (TemplateGenAppCodeService)SpringContextUtils.getBean((String)"backendAppGenCodeServiceImpl", TemplateGenAppCodeService.class);
                if (StringUtils.equals((CharSequence)fngenDTO.getRegenRepo(), (CharSequence)YesOrNO.YES.getCode())) {
                    appInfo.setNoCopyTemplate(false);
                    genService.copyTemplateProjectGen(appInfo);
                }
                for (FnModelInfoDTO fn : fnList) {
                    SrvModelInfoDTO srvModelParam = new SrvModelInfoDTO();
                    srvModelParam.setFnId(fn.getFnId());
                    List srvModelList = srvModelInfoService.queryList((Object)srvModelParam);
                    if (CollectionUtils.isNotEmpty((Collection)srvModelList)) {
                        appInfo.setNoCopyTemplate(true);
                        for (SrvModelInfoDTO srvModelInfo : srvModelList) {
                            appInfo.setSrvModelId(srvModelInfo.getSrvModelId());
                            genService.execute(appInfo);
                        }
                    }
                    PageModelInfoDTO pageModelParam = new PageModelInfoDTO();
                    pageModelParam.setFnId(fn.getFnId());
                    List pageList = pageModelInfoService.queryList((Object)pageModelParam);
                    if (!CollectionUtils.isNotEmpty((Collection)pageList)) continue;
                    GenFrontPageTask task = (GenFrontPageTask)SpringContextUtils.getBean(GenFrontPageTask.class);
                    for (PageModelInfoDTO page : pageList) {
                        try {
                            appInfo.setPageModelId(page.getPageModelId());
                            task.execute(appInfo);
                        }
                        catch (Exception e) {
                            logger.error("\u751f\u6210\u9875\u9762\u6a21\u578b{}\u5931\u8d25", new Object[]{page.getPageModelCode(), e.getMessage(), e});
                        }
                    }
                }
            }
            if (StringUtils.equals((CharSequence)fngenDTO.getRegenRepo(), (CharSequence)YesOrNO.YES.getCode())) {
                fngenDTO.setRegenRepo(YesOrNO.NO.getCode());
                paasTaskFngenService.updateByPk((Object)fngenDTO);
            }
            rtn.setSuccessFlag(true);
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("\u529f\u80fd\u4ee3\u7801\u751f\u6210\u5f02\u5e38 " + e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u529f\u80fd\u4ee3\u7801\u751f\u6210\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
            taskDebounce.put(this.taskInfo.getTaskId(), false);
        }
        return rtn;
    }
}

