/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.fadpaas.FadpaasPageRenderFactory;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.fadpaas.IFadpaasPageRender;
import com.irdstudio.allinapaas.portal.console.application.service.task.BaseGenTask;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.AppResourceService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelFieldService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelLogService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelPackageService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelParamService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateFileService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.AppResourceDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelLogDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelPackageDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelParamDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelSubpageDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateFileDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.PageTemplateType;
import com.irdstudio.allinrdm.dev.console.types.ParamType;
import com.irdstudio.allinrdm.sam.console.facade.ComBaseInfoService;
import com.irdstudio.allintcp.sdk.bi.facade.operation.RdmModuleInfoService;
import com.irdstudio.allintcp.sdk.bi.facade.operation.dto.RdmModuleInfoDTO;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.freemarker.util.FreemarkerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GenFrontPageTask
extends BaseGenTask {
    @Autowired
    protected PaasEnvInfoService paasEnvInfoService;

    @Override
    public boolean execute(PaasAppsInfoDTO appInfo) {
        String loginUserId = appInfo.getLoginUserId();
        String subsId = appInfo.getSubsId();
        String appCode = appInfo.getAppCode();
        boolean flag = this.genPageCode(appInfo);
        if (!flag) {
            return flag;
        }
        flag = this.genPageConfigCode(appInfo);
        return flag;
    }

    private boolean genPageCode(PaasAppsInfoDTO appInfo) {
        String userId = appInfo.getLoginUserId();
        PageModelPackageService pageModelPackageService = (PageModelPackageService)SpringContextUtils.getBean(PageModelPackageService.class);
        PageModelInfoService pageModelInfoService = (PageModelInfoService)SpringContextUtils.getBean(PageModelInfoService.class);
        PageModelLogService pageModelLogService = (PageModelLogService)SpringContextUtils.getBean(PageModelLogService.class);
        PageModelParamService pageModelParamService = (PageModelParamService)SpringContextUtils.getBean(PageModelParamService.class);
        PageTemplateInfoService pageTemplateInfoService = (PageTemplateInfoService)SpringContextUtils.getBean(PageTemplateInfoService.class);
        PageTemplateFileService pageTemplateFileService = (PageTemplateFileService)SpringContextUtils.getBean(PageTemplateFileService.class);
        PageModelFieldService pageModelFieldService = (PageModelFieldService)SpringContextUtils.getBean(PageModelFieldService.class);
        ModelTableInfoService modelTableInfoService = (ModelTableInfoService)SpringContextUtils.getBean(ModelTableInfoService.class);
        ComBaseInfoService comBaseInfoService = (ComBaseInfoService)SpringContextUtils.getBean(ComBaseInfoService.class);
        RdmModuleInfoService rdmModuleInfoService = (RdmModuleInfoService)SpringContextUtils.getBean(RdmModuleInfoService.class);
        String gitLocalPath = SdEnvUtil.TEMPLATE_PATH;
        Map appsParam = this.paasAppsParamPortalService.queryAppParamMap(appInfo.getAppId(), "dev");
        String genTargetPath = "page";
        if (StringUtils.isNotBlank((CharSequence)appInfo.getGenPath())) {
            genTargetPath = appInfo.getGenPath();
        } else if (appsParam != null) {
            genTargetPath = MapUtils.getString((Map)appsParam, (Object)"gen_path");
        }
        String appTemplatePath = GenFrontPageTask.getPageTemplatePath(appInfo);
        String appCode = SdEnvUtil.wrapperAppCode((String)appInfo.getAppCode());
        String targetPath = SdEnvUtil.PROJECT_PATH + appCode + File.separator + genTargetPath + File.separator;
        PageModelInfoDTO modelParam = new PageModelInfoDTO();
        modelParam.setPageModelCatalog(PageTemplateType.Page.getCode());
        modelParam.setAppId(appInfo.getAppId());
        modelParam.setPageModelId(appInfo.getPageModelId());
        List modelList = pageModelInfoService.queryList((Object)modelParam);
        PageModelPackageDTO packageParam = new PageModelPackageDTO();
        packageParam.setAppId(appInfo.getAppId());
        List packageList = pageModelPackageService.queryList((Object)packageParam);
        Map<String, String> modelPathMap = this.createPackageMap(packageList);
        ArrayList<Map<String, String>> routes = new ArrayList<Map<String, String>>();
        if (CollectionUtils.isNotEmpty((Collection)modelList)) {
            File routeTemplateFile;
            for (PageModelInfoDTO modelInfoDTO : modelList) {
                PageModelInfoDTO modelInfo = modelInfoDTO;
                IFadpaasPageRender render = FadpaasPageRenderFactory.get((String)modelInfo.getPageModelType());
                if (render != null) {
                    render.render(modelInfo, appTemplatePath, targetPath, modelPathMap, routes);
                } else {
                    PageModelParamDTO param = new PageModelParamDTO();
                    param.setPageModelId(modelInfo.getPageModelId());
                    param.setQueryRef("query");
                    List paramList = pageModelParamService.queryList((Object)param);
                    if (StringUtils.isBlank((CharSequence)modelInfo.getPageTemplateId())) {
                        logger.error(String.format("\u9875\u9762\u6a21\u677f\u672a\u914d\u7f6e\u6a21\u677f %s", modelInfo.getPageModelCode()));
                        continue;
                    }
                    PageTemplateInfoDTO templateParam = new PageTemplateInfoDTO();
                    templateParam.setPageTemplateId(modelInfo.getPageTemplateId());
                    PageTemplateInfoDTO template = (PageTemplateInfoDTO)pageTemplateInfoService.queryByPk((Object)templateParam);
                    PageTemplateFileDTO fileParam = new PageTemplateFileDTO();
                    fileParam.setPageTemplateId(template.getPageTemplateId());
                    List fileList = pageTemplateFileService.queryList((Object)fileParam);
                    String localAppTemplatePath = appTemplatePath + File.separator + template.getPageTemplateCode();
                    if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                        String packagePath = "";
                        ModelTableInfoDTO table = new ModelTableInfoDTO();
                        if (StringUtils.isNotBlank((CharSequence)modelInfoDTO.getTableModelId())) {
                            table.setObjectId(modelInfoDTO.getTableModelId());
                            table = (ModelTableInfoDTO)modelTableInfoService.queryByPk((Object)table);
                            RdmModuleInfoDTO moduleInfo = new RdmModuleInfoDTO();
                            moduleInfo.setModuleId(modelInfo.getModuleId());
                            moduleInfo = rdmModuleInfoService.queryByPk(moduleInfo);
                            if (StringUtils.isNotBlank((CharSequence)moduleInfo.getFeatureCode())) {
                                packagePath = moduleInfo.getFeatureCode().replaceAll("_|\\.|-", File.separator);
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)modelPathMap.get(modelInfo.getPackageId()))) {
                            packagePath = packagePath + File.separator + modelPathMap.get(modelInfo.getPackageId());
                        }
                        String basePath = this.getBasePath(packagePath);
                        Map<String, Object> root = this.prepareParam(modelInfo, paramList, appTemplatePath, basePath);
                        ArrayList dataCodes = new ArrayList();
                        paramList.forEach(pageModelParamVO -> {
                            List fields = pageModelParamVO.getFields();
                            if (CollectionUtils.isNotEmpty((Collection)fields)) {
                                fields.forEach(f -> {
                                    if (StringUtils.isNotEmpty((CharSequence)f.getFieldOption()) && !dataCodes.contains(f)) {
                                        dataCodes.add(f.getFieldOption());
                                    }
                                });
                            }
                        });
                        String dataCodeJoin = String.join((CharSequence)",", dataCodes);
                        root.put("BASE_PATH", basePath);
                        root.put("pageModelInfo", modelInfo);
                        root.put("dataCodeJoin", dataCodeJoin);
                        root.put("localAppTemplatePath", localAppTemplatePath);
                        String pageSuffix = template.getPageTemplateSuffix();
                        if (StringUtils.isBlank((CharSequence)pageSuffix)) {
                            pageSuffix = ".html";
                        }
                        for (PageTemplateFileDTO file : fileList) {
                            String templateName = file.getFileName() + ".vm";
                            String tempPath = localAppTemplatePath + File.separator + templateName;
                            File tempFile = new File(tempPath);
                            if (!tempFile.exists()) continue;
                            try {
                                String oriFileName;
                                String html = FreemarkerUtil.produceStringByTemplate((String)localAppTemplatePath, (String)templateName, root);
                                File targetDir = new File(targetPath + File.separator + packagePath);
                                if (!targetDir.exists()) {
                                    targetDir.mkdirs();
                                }
                                if (!StringUtils.endsWith((CharSequence)(oriFileName = modelInfo.getPageModelCode()), (CharSequence)pageSuffix)) {
                                    oriFileName = oriFileName + pageSuffix;
                                }
                                File targetFile = new File(targetDir, oriFileName);
                                try (FileOutputStream output = new FileOutputStream(targetFile);){
                                    IOUtils.write((String)html, (OutputStream)output, (String)"utf-8");
                                }
                                boolean jsFlag = this.renderOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".js", localAppTemplatePath, root, targetPath, packagePath, targetDir);
                                boolean cssFlag = this.renderOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".ccs", localAppTemplatePath, root, targetPath, packagePath, targetDir);
                                Map<String, String> route = this.createRoute(packagePath, targetFile);
                                route.put("jsFlag", String.valueOf(jsFlag));
                                route.put("cssFlag", String.valueOf(cssFlag));
                                route.put("cnname", modelInfo.getPageModelName());
                                routes.add(route);
                            }
                            catch (Exception e) {
                                logger.error("\u83b7\u53d6\u9875\u9762\u6a21\u578b\u9884\u89c8html\u5931\u8d25 " + file.getFileId(), (Throwable)e);
                            }
                        }
                    }
                }
                PageModelLogDTO genLog = new PageModelLogDTO();
                genLog.setLogId(UUIDUtil.getUUID());
                BeanUtility.beanCopy((Object)modelInfo, (Object)genLog);
                if (StringUtils.isBlank((CharSequence)genLog.getSubsId())) {
                    genLog.setSubsId(appInfo.getSubsId());
                }
                genLog.setCreateUser(userId);
                genLog.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                genLog.setGenState("S");
                pageModelLogService.insert((Object)genLog);
            }
            if (CollectionUtils.isNotEmpty(routes) && (routeTemplateFile = new File(appTemplatePath + File.separator + "views-routes.js.vm")).exists()) {
                HashMap<String, ArrayList<Map<String, String>>> root = new HashMap<String, ArrayList<Map<String, String>>>();
                root.put("routes", routes);
                String localAppTemplatePath = appTemplatePath;
                String routesJs = FreemarkerUtil.produceStringByTemplate((String)localAppTemplatePath, (String)routeTemplateFile.getName(), root);
                String routeTargetPath = "router";
                if (appsParam != null) {
                    routeTargetPath = MapUtils.getString((Map)appsParam, (Object)"route_path");
                }
                File targetFile = new File(new File(targetPath).getParent() + File.separator + routeTargetPath + File.separator + "views-routes.js");
                try (FileOutputStream output = new FileOutputStream(targetFile);){
                    IOUtils.write((String)routesJs, (OutputStream)output, (String)"utf-8");
                }
                catch (IOException e) {
                    throw new RuntimeException("\u6e32\u67d3\u9875\u9762\u8def\u7531\u4fe1\u606f\u5f02\u5e38 " + e.getMessage(), e);
                }
            }
        }
        return true;
    }

    private boolean genPageConfigCode(PaasAppsInfoDTO appInfo) {
        String gitLocalPath = SdEnvUtil.TEMPLATE_PATH;
        AppResourceService appResourceService = (AppResourceService)SpringContextUtils.getBean(AppResourceService.class);
        String appTemplatePath = GenFrontPageTask.getPageTemplatePath(appInfo);
        String appCode = SdEnvUtil.wrapperAppCode((String)appInfo.getAppCode());
        String targetPath = SdEnvUtil.PROJECT_PATH + appCode + File.separator;
        Map appsParam = this.paasAppsParamPortalService.queryAppParamMap(appInfo.getAppId(), "dev");
        File menusTemplate = new File(appTemplatePath + File.separator + "menu-app-preview.js.vm");
        if (menusTemplate.exists()) {
            AppResourceDTO param = new AppResourceDTO();
            param.setAppId(appInfo.getAppId());
            List rows = appResourceService.queryList((Object)param);
            for (AppResourceDTO row : rows) {
                if (!StringUtils.isNotEmpty((CharSequence)row.getUrl())) continue;
                row.setUrl(row.getUrl().replace(".html", ""));
            }
            HashMap<String, List> root = new HashMap<String, List>();
            root.put("menus", rows);
            String localAppTemplatePath = appTemplatePath;
            String mockJs = FreemarkerUtil.produceStringByTemplate((String)localAppTemplatePath, (String)menusTemplate.getName(), root);
            String menuJsFilePath = "mocks/data";
            if (appsParam != null) {
                menuJsFilePath = MapUtils.getString((Map)appsParam, (Object)"menujs_path");
            }
            File targetFile = new File(new File(targetPath) + File.separator + menuJsFilePath + File.separator + "menu-app-preview.js");
            try (FileOutputStream output = new FileOutputStream(targetFile);){
                IOUtils.write((String)mockJs, (OutputStream)output, (String)"utf-8");
            }
            catch (IOException e) {
                throw new RuntimeException("\u6e32\u67d3\u8def\u7531\u4fe1\u606f\u5f02\u5e38" + e.getMessage(), e);
            }
        }
        if (StringUtils.equals((CharSequence)appInfo.getAppTemplateId(), (CharSequence)"A99YFP")) {
            Throwable throwable;
            FileOutputStream output;
            File targetFile;
            File targetDir;
            String localAppTemplatePath = appTemplatePath + File.separator + "config.js.vm";
            HashMap root = new HashMap();
            appsParam.put("debugModel", "false");
            root.put("appsParam", appsParam);
            root.put("appInfo", appInfo);
            if (new File(localAppTemplatePath).exists()) {
                String configJsContent = FreemarkerUtil.produceStringByTemplate((String)appTemplatePath, (String)"config.js.vm", root);
                targetDir = new File(targetPath + File.separator + "custom");
                if (!targetDir.exists()) {
                    targetDir.mkdirs();
                }
                targetFile = new File(targetDir, "config.js");
                try {
                    output = new FileOutputStream(targetFile);
                    throwable = null;
                    try {
                        IOUtils.write((String)configJsContent, (OutputStream)output, (String)"utf-8");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (output != null) {
                            if (throwable != null) {
                                try {
                                    ((OutputStream)output).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((OutputStream)output).close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("\u6e32\u67d3\u8def\u7531\u4fe1\u606f\u5f02\u5e38" + e.getMessage(), e);
                }
            }
            if (new File(localAppTemplatePath = appTemplatePath + File.separator + "app.data.service.js.vm").exists()) {
                String serviceJsContent = FreemarkerUtil.produceStringByTemplate((String)appTemplatePath, (String)"app.data.service.js.vm", root);
                targetDir = new File(targetPath + File.separator + "custom" + File.separator + "common");
                if (!targetDir.exists()) {
                    targetDir.mkdirs();
                }
                targetFile = new File(targetDir, "app.data.service.js");
                try {
                    output = new FileOutputStream(targetFile);
                    throwable = null;
                    try {
                        IOUtils.write((String)serviceJsContent, (OutputStream)output, (String)"utf-8");
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (output != null) {
                            if (throwable != null) {
                                try {
                                    ((OutputStream)output).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                ((OutputStream)output).close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("\u6e32\u67d3\u8def\u7531\u4fe1\u606f\u5f02\u5e38" + e.getMessage(), e);
                }
            }
        }
        return true;
    }

    public String wrapperPath(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public String replaceSuffix(String fileName) {
        if (fileName.lastIndexOf(".") >= 0) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    public boolean renderOtherTemplate(String pageModelCode, String templateName, String suffix, String appTemplatePath, Map<String, Object> root, String targetPath, String packagePath, File targetDir) throws Exception {
        String templateFile = templateName + suffix + ".vm";
        String tempPath = appTemplatePath + File.separator + templateFile;
        File tempFile = new File(tempPath);
        boolean flag = false;
        if (tempFile.exists()) {
            String content = FreemarkerUtil.produceStringByTemplate((String)appTemplatePath, (String)templateFile, root);
            File contentTargetDir = new File(targetPath + File.separator + packagePath);
            if (!contentTargetDir.exists()) {
                contentTargetDir.mkdirs();
            }
            String fileName = this.replaceSuffix(pageModelCode) + suffix;
            File file = new File(targetDir, fileName);
            try (FileOutputStream output = new FileOutputStream(file);){
                IOUtils.write((String)content, (OutputStream)output, (String)"utf-8");
            }
            flag = true;
        }
        return flag;
    }

    public boolean checkOtherTemplate(String pageModelCode, String templateName, String suffix, String appTemplatePath) {
        String templateFile = templateName + suffix + ".vm";
        String tempPath = appTemplatePath + File.separator + templateFile;
        File tempFile = new File(tempPath);
        boolean flag = tempFile.exists();
        return flag;
    }

    public Map<String, Object> prepareParam(PageModelInfoDTO modelInfo, List<PageModelParamDTO> paramList, String appTemplatePath, String basePath) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("BASE_PATH", "../../../");
        Pattern listReg = Pattern.compile("(\\S+)\\[(\\d+)\\]");
        if (CollectionUtils.isNotEmpty(paramList)) {
            HashMap quickMap = new HashMap();
            for (PageModelParamDTO param : paramList) {
                String paramCode = param.getParamCode();
                if (!ParamType.kv.getCode().equals(param.getParamType())) {
                    if (CollectionUtils.isNotEmpty((Collection)param.getFields()) && (ParamType.fields.getCode().equals(param.getParamType()) || ParamType.formFields.getCode().equals(param.getParamType()))) {
                        root.put(paramCode, param.getFields());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getQueryFields()) && ParamType.conds.getCode().equals(param.getParamType())) {
                        root.put(paramCode, param.getQueryFields());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getButtons()) && ParamType.buttons.getCode().equals(param.getParamType())) {
                        root.put(paramCode, param.getButtons());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getLinkeds()) && ParamType.linkeds.getCode().equals(param.getParamType())) {
                        root.put(paramCode, param.getLinkeds());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getSubspages()) && ParamType.subpages.getCode().equals(param.getParamType())) {
                        List subpages = param.getSubspages();
                        ArrayList<Map<String, Object>> subPageMapList = new ArrayList<Map<String, Object>>();
                        if (CollectionUtils.isNotEmpty((Collection)subpages)) {
                            for (PageModelSubpageDTO sub : subpages) {
                                Map<String, Object> subPageParam = this.fetchSubPageParam(modelInfo, sub, sub.getModelInfo(), appTemplatePath, basePath);
                                subPageMapList.add(subPageParam);
                            }
                        }
                        root.put(paramCode, subPageMapList);
                        continue;
                    }
                    try {
                        List list = JSON.parseArray((String)param.getParamValue(), Map.class);
                        root.put(paramCode, list);
                    }
                    catch (Exception e) {
                        logger.error("\u89e3\u6790\u53c2\u6570json\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                String[] paths = StringUtils.split((String)paramCode, (String)".");
                if (paths == null) {
                    root.put(paramCode, this.parseParamValue(param));
                    continue;
                }
                Map<String, Object> var = root;
                for (int i = 0; i < paths.length; ++i) {
                    String key;
                    String path = paths[i];
                    Matcher m = listReg.matcher(path);
                    boolean isList = m.matches();
                    if (isList) {
                        int k;
                        List<Object> list;
                        key = m.group(1);
                        int index = Integer.valueOf(m.group(2));
                        if (paths.length - 1 == i) {
                            list = (ArrayList<Object>)var.get(key);
                            if (list == null) {
                                list = new ArrayList<Object>(index);
                                var.put(key, list);
                            }
                            if (list.size() <= index) {
                                for (k = list.size(); k <= index; ++k) {
                                    list.add(null);
                                }
                            }
                            list.set(index, this.parseParamValue(param));
                            continue;
                        }
                        list = (List)var.get(key);
                        if (list == null) {
                            list = new ArrayList(index);
                            var.put(key, list);
                        }
                        if (list.size() <= index) {
                            for (k = list.size(); k <= index; ++k) {
                                list.add(new HashMap());
                            }
                        }
                        if ((var = (Map)list.get(index)) != null) continue;
                        var = new HashMap();
                        list.set(index, var);
                        continue;
                    }
                    key = path;
                    if (paths.length - 1 == i) {
                        var.put(key, this.parseParamValue(param));
                        continue;
                    }
                    HashMap temp = (HashMap)var.get(key);
                    if (temp == null) {
                        temp = new HashMap();
                        var.put(key, temp);
                    }
                    var = temp;
                }
            }
        }
        return root;
    }

    public String parseParamValue(PageModelParamDTO param) {
        if (param == null) {
            return "";
        }
        return param.getParamValue();
    }

    public Map<String, String> createPackageMap(List<PageModelPackageDTO> packageList) {
        HashMap<String, String> pathMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(packageList)) {
            HashMap<String, PageModelPackageDTO> map = new HashMap<String, PageModelPackageDTO>();
            for (PageModelPackageDTO p : packageList) {
                map.put(p.getPackageId(), p);
            }
            for (PageModelPackageDTO p : packageList) {
                ArrayList<String> paths = new ArrayList<String>();
                paths.add(p.getPackageCode());
                PageModelPackageDTO parent = (PageModelPackageDTO)map.get(p.getPackageAbvId());
                while (parent != null) {
                    paths.add(parent.getPackageCode());
                    parent = (PageModelPackageDTO)map.get(parent.getPackageAbvId());
                }
                Collections.reverse(paths);
                pathMap.put(p.getPackageId(), StringUtils.join(paths, (String)File.separator));
            }
        }
        return pathMap;
    }

    public String getBasePath(String packagePath) {
        String[] pathNum = StringUtils.split((String)packagePath, (String)File.separator);
        int deep = pathNum.length;
        ++deep;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= deep; ++i) {
            list.add("../");
        }
        return StringUtils.join(list, (String)"");
    }

    public Map<String, String> createRoute(String packagePath, File page) {
        Object[] paths = StringUtils.split((String)(packagePath + File.separator + this.replaceSuffix(page.getName())), (String)File.separator);
        String path = StringUtils.join((Object[])paths, (String)"/");
        HashMap<String, String> route = new HashMap<String, String>();
        route.put("path", path);
        route.put("name", StringUtils.join((Object[])paths, (String)"-"));
        route.put("pageName", page.getName());
        return route;
    }

    public Map<String, Object> fetchSubPageParam(PageModelInfoDTO rootModelInfo, PageModelSubpageDTO subPage, PageModelInfoDTO modelInfo, String appTemplatePath, String basePath) {
        if (modelInfo != null) {
            PageModelPackageService pageModelPackageService = (PageModelPackageService)SpringContextUtils.getBean(PageModelPackageService.class);
            PageModelInfoService pageModelInfoService = (PageModelInfoService)SpringContextUtils.getBean(PageModelInfoService.class);
            PageModelLogService pageModelLogService = (PageModelLogService)SpringContextUtils.getBean(PageModelLogService.class);
            PageModelParamService pageModelParamService = (PageModelParamService)SpringContextUtils.getBean(PageModelParamService.class);
            PageTemplateInfoService pageTemplateInfoService = (PageTemplateInfoService)SpringContextUtils.getBean(PageTemplateInfoService.class);
            PageTemplateFileService pageTemplateFileService = (PageTemplateFileService)SpringContextUtils.getBean(PageTemplateFileService.class);
            PageModelFieldService pageModelFieldService = (PageModelFieldService)SpringContextUtils.getBean(PageModelFieldService.class);
            ModelTableInfoService modelTableInfoService = (ModelTableInfoService)SpringContextUtils.getBean(ModelTableInfoService.class);
            PageModelParamDTO param = new PageModelParamDTO();
            param.setPageModelId(modelInfo.getPageModelId());
            param.setQueryRef("query");
            List paramList = pageModelParamService.queryList((Object)param);
            if (StringUtils.isBlank((CharSequence)modelInfo.getPageTemplateId())) {
                logger.error(String.format("\u9875\u9762\u6a21\u677f\u672a\u914d\u7f6e\u6a21\u677f %s", modelInfo.getPageModelCode()));
                return Collections.emptyMap();
            }
            PageTemplateInfoDTO template = new PageTemplateInfoDTO();
            template.setPageTemplateId(modelInfo.getPageTemplateId());
            template = (PageTemplateInfoDTO)pageTemplateInfoService.queryByPk((Object)template);
            PageTemplateFileDTO fileParam = new PageTemplateFileDTO();
            fileParam.setPageTemplateId(template.getPageTemplateId());
            List fileList = pageTemplateFileService.queryList((Object)fileParam);
            String localAppTemplatePath = appTemplatePath + File.separator + template.getPageTemplateId();
            if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                PageTemplateFileDTO file = (PageTemplateFileDTO)fileList.get(0);
                String templateName = file.getFileName() + ".vm";
                String tempPath = localAppTemplatePath + File.separator + templateName;
                File tempFile = new File(tempPath);
                if (tempFile.exists()) {
                    Map<String, Object> root = this.prepareParam(modelInfo, paramList, appTemplatePath, basePath);
                    ArrayList dataCodes = new ArrayList();
                    paramList.forEach(pageModelParamVO -> {
                        List fields = pageModelParamVO.getFields();
                        if (CollectionUtils.isNotEmpty((Collection)fields)) {
                            fields.forEach(f -> {
                                if (StringUtils.isNotEmpty((CharSequence)f.getFieldOption()) && !dataCodes.contains(f)) {
                                    dataCodes.add(f.getFieldOption());
                                }
                            });
                        }
                    });
                    String dataCodeJoin = String.join((CharSequence)",", dataCodes);
                    root.put("templateName", templateName);
                    root.put("templateFilePrefix", this.replaceSuffix(file.getFileName()));
                    root.put("rootModelInfo", rootModelInfo);
                    root.put("subPage", subPage);
                    root.put("BASE_PATH", basePath);
                    root.put("pageModelInfo", modelInfo);
                    root.put("dataCodeJoin", dataCodeJoin);
                    root.put("localAppTemplatePath", localAppTemplatePath);
                    ArrayList<String> jsList = new ArrayList<String>();
                    File localTemplateFile = new File(localAppTemplatePath);
                    if (localTemplateFile.exists()) {
                        File[] files;
                        for (File f : files = localTemplateFile.listFiles()) {
                            if (!StringUtils.endsWithAny((CharSequence)f.getName(), (CharSequence[])new CharSequence[]{".js.vm"})) continue;
                            jsList.add(f.getName());
                        }
                    }
                    root.put("jsList", jsList);
                    boolean jsFlag = this.checkOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".js", localAppTemplatePath);
                    boolean cssFlag = this.checkOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".ccs", localAppTemplatePath);
                    root.put("jsFlag", jsFlag);
                    root.put("cssFlag", cssFlag);
                    return root;
                }
            }
        }
        return Collections.emptyMap();
    }
}

