/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvParamDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.LoggerFactory;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.TLogger;
import com.irdstudio.allinapaas.executor.types.ExecutorInstInfo;
import com.irdstudio.allinapaas.portal.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinapaas.portal.console.application.service.task.AppRepoPushTaskImpl;
import com.irdstudio.allinapaas.portal.console.application.service.task.AppTemplateRepoPullTask;
import com.irdstudio.allinapaas.portal.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class NginxDeployTask
extends AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private ILogger logger = null;
    private PaasTaskInfoDTO taskInfo;
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (NginxDeployTask.this.logger != null) {
                NginxDeployTask.this.logger.info((Object)line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (NginxDeployTask.this.logger != null) {
                NginxDeployTask.this.logger.error((Object)line);
            } else {
                System.err.println(line);
            }
        }
    };

    public NginxDeployTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
        String fullLogFileName = ExecutorInstInfo.BATCH_LOG_PATH + File.separator + taskInfo.getTaskId() + ".log";
        FileUtils.deleteQuietly((File)new File(fullLogFileName));
        ILogger fileLogger = LoggerFactory.makeTxtFileLogger((String)fullLogFileName, (boolean)true);
        fileLogger.setName(taskInfo.getTaskId());
        TLogger.registerCategoryLogger((String)taskInfo.getTaskId(), (ILogger)fileLogger);
        this.logger = TLogger.getLogger((String)taskInfo.getTaskId());
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        try {
            File[] files;
            String uploadPath;
            PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            PaasEcsInfoService paasEcsInfoService = (PaasEcsInfoService)SpringContextUtils.getBean(PaasEcsInfoService.class);
            PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
            String userId = this.taskInfo.getLoginUserId();
            String subsId = this.taskInfo.getSubsId();
            String appId = this.taskInfo.getAppId();
            String taskId = this.taskInfo.getTaskId();
            String envId = this.taskInfo.getEnvId();
            PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
            appInfo.setAppId(appId);
            appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appInfo);
            Object ecsInfo = new PaasEcsInfoDTO();
            ecsInfo.setAppId(appId);
            ecsInfo.setEnvId(envId);
            List ecsInfoList = paasEcsInfoService.queryListByPage(ecsInfo);
            ecsInfo = CollectionUtils.isNotEmpty((Collection)ecsInfoList) ? (PaasEcsInfoDTO)ecsInfoList.get(0) : null;
            if (ecsInfo == null) {
                throw new RuntimeException("\u670d\u52a1\u5668\u4e0d\u5b58\u5728");
            }
            PaasEnvParamDTO deployRoot = paasEnvParamService.queryEnvParamByCodeReturnValue("deploy_root", ecsInfo.getEnvId());
            String deployRootDir = this.getDeployRootDir(deployRoot.getParamValue());
            AppTemplateRepoPullTask templatePullTask = new AppTemplateRepoPullTask(appInfo.getAppTemplateId());
            templatePullTask.syncRun();
            String localRepoPath = templatePullTask.getAppTemplatePath();
            File localRepoDir = new File(localRepoPath, String.format("%s-project", appInfo.getAppTemplateId()));
            if (!localRepoDir.exists()) {
                throw new RuntimeException("\u8f6f\u4ef6\u4e0b\u8f7d\u5931\u8d25");
            }
            this.logger.info((Object)("\u8fdc\u7a0b\u64cd\u4f5cLinux\u670d\u52a1\u5668 " + ecsInfo.getEcsIp()));
            RemoteSSHClient client = new RemoteSSHClient(ecsInfo.getEcsIp(), ecsInfo.getEcsLoginUser(), ecsInfo.getEcsLoginPwd());
            boolean loginFlag = client.connect();
            if (!loginFlag) {
                this.logger.error((Object)"\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
                throw new RuntimeException("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            }
            if (!client.fileExists("/" + deployRootDir)) {
                client.executeCommand("mkdir /" + deployRootDir, this.sshPrinter);
            }
            if (!client.fileExists(uploadPath = deployRootDir + "/" + appInfo.getAppCode())) {
                client.executeCommand("mkdir -p " + uploadPath, this.sshPrinter);
            }
            for (File file : files = localRepoDir.listFiles()) {
                if (!file.isFile()) continue;
                client.upload(file.getAbsolutePath(), uploadPath);
            }
            File configDir = new File(this.getAppConfigFilePath(appInfo));
            File configFile = null;
            File[] configList = configDir.listFiles();
            if (configList != null) {
                for (File config : configList) {
                    if (!StringUtils.endsWithAny((CharSequence)config.getName(), (CharSequence[])new CharSequence[]{String.format("-%s.conf", envId)})) continue;
                    configFile = config;
                    break;
                }
            }
            if (configFile != null && configFile.exists()) {
                client.upload(configFile.getAbsolutePath(), uploadPath + "/" + StringUtils.replace((String)configFile.getName(), (String)String.format("-%s", envId), (String)""));
            }
            client.executeCommand(String.format("chmod 777 %s/install.sh", uploadPath), this.sshPrinter);
            this.logger.info((Object)String.format("\u6267\u884c\u811a\u672c %s/install.sh %s/", uploadPath, uploadPath));
            client.executeCommand(String.format("bash %s/install.sh %s/", uploadPath, uploadPath), this.sshPrinter);
            AppRepoPushTaskImpl appRepoPushTaskImpl = new AppRepoPushTaskImpl(userId, configDir.getParentFile(), appInfo.getAppGitUrl(), String.format("%s #%s %s", this.taskInfo.getTaskName(), this.taskInfo.getTaskId(), CurrentDateUtil.getTodayDate()), appInfo);
            appRepoPushTaskImpl.execute();
            rtn.setSuccessFlag(true);
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("nginx\u90e8\u7f72\u5f02\u5e38 " + e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("nginx\u90e8\u7f72\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
            taskDebounce.put(this.taskInfo.getTaskId(), false);
        }
        return rtn;
    }

    private String getDeployRootDir(String deployRootDir) {
        if (deployRootDir == null) {
            deployRootDir = "/agent";
        }
        return deployRootDir;
    }

    private String getAppConfigFilePath(PaasAppsInfoDTO appInfo) {
        String targetPath = SdEnvUtil.PROJECT_PATH + appInfo.getAppId() + File.separator + "config";
        targetPath = this.pathMatchSystem(targetPath);
        return targetPath;
    }

    private String pathMatchSystem(String path) {
        String targetSeparetor = File.separator;
        if (targetSeparetor.equals("\\")) {
            if (path.contains("/")) {
                // empty if block
            }
        } else if (targetSeparetor.equals("/") && path.contains("\\")) {
            path = path.replaceAll("\\\\", "/");
        }
        return path;
    }
}

