/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.task;

import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasSoftInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasSoftInstalledService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvParamDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasSoftInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasSoftInstalledDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.LoggerFactory;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.TLogger;
import com.irdstudio.allinapaas.executor.types.ExecutorInstInfo;
import com.irdstudio.allinapaas.portal.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinapaas.portal.console.application.service.task.GitPullTask;
import com.irdstudio.allinapaas.portal.console.facade.PaasTaskSoftopsService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskSoftopsDTO;
import com.irdstudio.allinapaas.portal.console.types.SoftOpsType;
import com.irdstudio.sdk.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class SoftInstallTask
extends AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private ILogger logger = null;
    private PaasTaskInfoDTO taskInfo;
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (SoftInstallTask.this.logger != null) {
                SoftInstallTask.this.logger.info((Object)line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (SoftInstallTask.this.logger != null) {
                SoftInstallTask.this.logger.error((Object)line);
            } else {
                System.err.println(line);
            }
        }
    };

    public SoftInstallTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
        String fullLogFileName = ExecutorInstInfo.BATCH_LOG_PATH + File.separator + taskInfo.getTaskId() + ".log";
        FileUtils.deleteQuietly((File)new File(fullLogFileName));
        ILogger fileLogger = LoggerFactory.makeTxtFileLogger((String)fullLogFileName, (boolean)true);
        fileLogger.setName(taskInfo.getTaskId());
        TLogger.registerCategoryLogger((String)taskInfo.getTaskId(), (ILogger)fileLogger);
        this.logger = TLogger.getLogger((String)taskInfo.getTaskId());
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        try {
            PaasSoftInstalledDTO installedDTO;
            File[] files;
            String uploadPath;
            PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            PaasEcsInfoService paasEcsInfoService = (PaasEcsInfoService)SpringContextUtils.getBean(PaasEcsInfoService.class);
            PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
            PaasTaskSoftopsService paasTaskSoftopsService = (PaasTaskSoftopsService)SpringContextUtils.getBean(PaasTaskSoftopsService.class);
            PaasSoftInfoService paasSoftInfoService = (PaasSoftInfoService)SpringContextUtils.getBean(PaasSoftInfoService.class);
            PaasSoftInstalledService paasSoftInstalledService = (PaasSoftInstalledService)SpringContextUtils.getBean(PaasSoftInstalledService.class);
            PaasTaskSoftopsDTO taskSoft = new PaasTaskSoftopsDTO();
            taskSoft.setTaskId(this.taskInfo.getTaskId());
            taskSoft = (PaasTaskSoftopsDTO)paasTaskSoftopsService.queryByPk((Object)taskSoft);
            String userId = this.taskInfo.getLoginUserId();
            String subsId = this.taskInfo.getSubsId();
            String appId = this.taskInfo.getAppId();
            String taskId = this.taskInfo.getTaskId();
            String softId = taskSoft.getSoftId();
            String ecsId = taskSoft.getEcsId();
            PaasSoftInfoDTO softInfo = new PaasSoftInfoDTO();
            softInfo.setSoftId(softId);
            softInfo = (PaasSoftInfoDTO)paasSoftInfoService.queryByPk((Object)softInfo);
            if (softInfo == null) {
                throw new RuntimeException(taskSoft.getSoftName() + "\u8f6f\u4ef6\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            PaasEcsInfoDTO ecsInfo = new PaasEcsInfoDTO();
            ecsInfo.setEcsId(ecsId);
            ecsInfo = (PaasEcsInfoDTO)paasEcsInfoService.queryByPk((Object)ecsInfo);
            if (ecsInfo == null) {
                throw new RuntimeException(ecsId + "\u670d\u52a1\u5668\u4e0d\u5b58\u5728");
            }
            String envId = ecsInfo.getEnvId();
            PaasEnvParamDTO deployRoot = paasEnvParamService.queryEnvParamByCodeReturnValue("deploy_root", ecsInfo.getEnvId());
            String deployRootDir = this.getDeployRootDir(deployRoot.getParamValue());
            String softGitUrl = softInfo.getSoftGitUrl();
            GitPullTask gitPullTask = new GitPullTask(softGitUrl, this.logger);
            gitPullTask.execute();
            String localRepoPath = gitPullTask.gitPath();
            File localRepoDir = new File(localRepoPath);
            if (!localRepoDir.exists()) {
                throw new RuntimeException("\u8f6f\u4ef6\u4e0b\u8f7d\u5931\u8d25");
            }
            this.logger.info((Object)("\u8fdc\u7a0b\u64cd\u4f5cLinux\u670d\u52a1\u5668 " + ecsInfo.getEcsIp()));
            RemoteSSHClient client = new RemoteSSHClient(ecsInfo.getEcsIp(), ecsInfo.getEcsLoginUser(), ecsInfo.getEcsLoginPwd());
            boolean loginFlag = client.connect();
            if (!loginFlag) {
                this.logger.error((Object)"\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
                throw new RuntimeException("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            }
            if (!client.fileExists("/" + deployRootDir)) {
                client.executeCommand("mkdir /" + deployRootDir, this.sshPrinter);
            }
            if (!client.fileExists(uploadPath = deployRootDir + "/" + softInfo.getSoftCode())) {
                client.executeCommand("mkdir -p " + uploadPath, this.sshPrinter);
            }
            for (File file : files = localRepoDir.listFiles()) {
                if (!file.isFile()) continue;
                client.upload(file.getAbsolutePath(), uploadPath);
            }
            if (StringUtils.equals((CharSequence)taskSoft.getOpsType(), (CharSequence)SoftOpsType.Install.getCode())) {
                client.executeCommand(String.format("chmod 777 %s/install.sh", uploadPath), this.sshPrinter);
                this.logger.info((Object)String.format("\u6267\u884c\u811a\u672c %s/install.sh %s/", uploadPath, uploadPath));
                client.executeCommand(String.format("bash %s/install.sh %s/", uploadPath, uploadPath), this.sshPrinter);
                installedDTO = new PaasSoftInstalledDTO();
                installedDTO.setSoftInstalledId(UUIDUtil.getShortUUID());
                installedDTO.setSoftId(softInfo.getSoftId());
                installedDTO.setSoftCode(softInfo.getSoftCode());
                installedDTO.setSoftName(softInfo.getSoftName());
                installedDTO.setEcsId(ecsInfo.getEcsId());
                installedDTO.setEcsName(ecsInfo.getEcsName());
                installedDTO.setCloudEcsId(ecsInfo.getCloudEcsId());
                installedDTO.setSoftInstalledTime(CurrentDateUtil.getTodayDateEx2());
                installedDTO.setCreateUser(userId);
                installedDTO.setLastUpdateUser(userId);
                installedDTO.setCreateTime(installedDTO.getSoftInstalledTime());
                installedDTO.setLastUpdateTime(installedDTO.getSoftInstalledTime());
                installedDTO.setSubsId(subsId);
                installedDTO.setEnvId(envId);
                installedDTO.setSoftState(SoftOpsType.Install.getCode());
                paasSoftInstalledService.insert((Object)installedDTO);
            } else {
                client.executeCommand(String.format("chmod 777 %s/uninstall.sh", uploadPath), this.sshPrinter);
                this.logger.info((Object)String.format("\u6267\u884c\u811a\u672c %s/uninstall.sh %s/", uploadPath, uploadPath));
                client.executeCommand(String.format("bash %s/uninstall.sh %s/", uploadPath, uploadPath), this.sshPrinter);
                installedDTO = new PaasSoftInstalledDTO();
                installedDTO.setSoftId(softInfo.getSoftId());
                installedDTO.setCloudEcsId(ecsInfo.getCloudEcsId());
                installedDTO.setSubsId(subsId);
                installedDTO.setEnvId(envId);
                List installedList = paasSoftInstalledService.queryList((Object)installedDTO);
                if (CollectionUtils.isNotEmpty((Collection)installedList)) {
                    for (PaasSoftInstalledDTO install : installedList) {
                        paasSoftInstalledService.deleteByPk((Object)install);
                    }
                }
            }
            rtn.setSuccessFlag(true);
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("\u8f6f\u4ef6\u5b89\u88c5\u4e0e\u5378\u8f7d\u5f02\u5e38 " + e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u8f6f\u4ef6\u5b89\u88c5\u4e0e\u5378\u8f7d\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
            taskDebounce.put(this.taskInfo.getTaskId(), false);
        }
        return rtn;
    }

    private String getDeployRootDir(String deployRootDir) {
        if (deployRootDir == null) {
            deployRootDir = "/agent";
        }
        return deployRootDir;
    }
}

