/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.utils;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvArrangeTableDTO;
import com.irdstudio.allinrdm.dev.console.types.RowRspType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;

public class DrawOsrvArrangeTable {
    private static final Color nodeBackgroundColor = new Color(246, 247, 255);
    private static final Color nodeBorderColor = new Color(3, 104, 154);
    private static final Color lineColor = new Color(128, 128, 128);
    private static final Color fontColor = new Color(0, 0, 0);

    public File generateImage(String srvModelId, List<OsrvArrangeTableDTO> tables, File dir) {
        if (tables == null || tables.size() == 0) {
            return null;
        }
        int tableSize = tables.size();
        File imageFile = new File(dir.getAbsolutePath() + File.separator + srvModelId + ".png");
        int imageWidth = 986;
        int startNodeWidth = 96;
        BufferedImage image = new BufferedImage(imageWidth, tableSize * 83 + 83 + 30, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.setBackground(Color.white);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        int[] start = new int[]{15, 15};
        this.drawNode(15, 15, startNodeWidth, 34, "\u5f00\u59cb", "center", graphics);
        int startNodeLineX = startNodeWidth / 2 + 15;
        int startNodeLineEndY = 49 + (tableSize - 1) * 83 + 34 + 34 - 2;
        this.drawLine(startNodeLineX, 49, startNodeLineX, startNodeLineEndY, graphics);
        int tableRowsLen = tables.size();
        int rowCondEffect = 0;
        int effectCount = 0;
        int startCondNo = 0;
        for (int i = 0; i < tableRowsLen; ++i) {
            int currentX = startNodeLineX + startNodeWidth / 2;
            int currentY = start[1] + (i + 1) * 83 + 17;
            OsrvArrangeTableDTO tb = tables.get(i);
            if (tb.getRowCondEffect() != null && tb.getRowCondEffect().compareTo(1) > 0) {
                effectCount = rowCondEffect = tb.getRowCondEffect().intValue();
                startCondNo = i;
            }
            if (i >= startCondNo && i < startCondNo + effectCount) {
                if (i == startCondNo) {
                    this.drawLine(startNodeLineX, currentY, startNodeLineX + (imageWidth - startNodeLineX - 30 - 20), currentY, graphics);
                    String rowCondName = StringUtils.isNotBlank((CharSequence)tb.getRowCondName()) ? tb.getRowCondName() : String.format("\u884c%s\u6267\u884c\u6761\u4ef6", startCondNo);
                    this.drawArrow(currentX + 15, currentY - 7, graphics);
                    this.drawNode(currentX + 22, currentY - 17, 148, 34, rowCondName, "center", graphics);
                } else {
                    this.drawLine(currentX + 22 + 74, currentY, startNodeLineX + (imageWidth - startNodeLineX - 30 - 20), currentY, graphics);
                    int fixedY = i == startCondNo + 1 ? 17 : 0;
                    this.drawLine(currentX + 22 + 74, currentY - 83 + fixedY, currentX + 22 + 74, currentY, graphics);
                }
            } else {
                this.drawLine(startNodeLineX, currentY, startNodeLineX + (imageWidth - startNodeLineX - 30 - 20), currentY, graphics);
                if (StringUtils.isNotBlank((CharSequence)tb.getRowCondName())) {
                    this.drawArrow(currentX + 15, currentY - 7, graphics);
                    this.drawNode(currentX + 22, currentY - 17, 148, 34, tb.getRowCondName(), "center", graphics);
                }
            }
            String rowTargetName = tb.getRowOpTargetName();
            if (StringUtils.isBlank((CharSequence)rowTargetName)) {
                rowTargetName = "";
            }
            this.drawArrow(currentX + 192 + 15, currentY - 7, graphics);
            this.drawNode(currentX + 192 + 22, currentY - 17, 380, 34, rowTargetName, "left", graphics);
            String rowSuccess = RowRspType.trans2Name((String)(StringUtils.isNotBlank((CharSequence)tb.getRowSuccess()) ? tb.getRowSuccess() : RowRspType.GoOn.getCode()));
            String rowFailed = RowRspType.trans2Name((String)(StringUtils.isNotBlank((CharSequence)tb.getRowFailed()) ? tb.getRowFailed() : RowRspType.Finish.getCode()));
            this.drawArrow(currentX + 192 + 380 + 100 + 15, currentY - 7, graphics);
            this.drawNode(currentX + 192 + 380 + 100 + 22, currentY - 17, 70, 34, "\u6210\u529f", "center", graphics);
            this.drawArrow(currentX + 192 + 380 + 100 + 70 + 26 + 15, currentY - 7, graphics);
            this.drawNode(currentX + 192 + 380 + 100 + 70 + 26 + 22, currentY - 17, 70, 34, rowSuccess, "center", graphics);
            this.drawLine(currentX + 192 + 380 + 50 + 22, currentY, currentX + 192 + 380 + 50 + 22, currentY + 34 + 5, graphics);
            this.drawLine(currentX + 192 + 380 + 50 + 22, currentY + 34 + 5, startNodeLineX + (imageWidth - startNodeLineX - 30 - 20), currentY + 34 + 5, graphics);
            this.drawArrow(currentX + 192 + 380 + 100 + 15, currentY - 7 + 34 + 5, graphics);
            this.drawNode(currentX + 192 + 380 + 100 + 22, currentY - 17 + 34 + 5, 70, 34, "\u5931\u8d25", "center", graphics);
            this.drawArrow(currentX + 192 + 380 + 100 + 70 + 26 + 15, currentY - 7 + 34 + 5, graphics);
            this.drawNode(currentX + 192 + 380 + 100 + 70 + 26 + 22, currentY - 17 + 34 + 5, 70, 34, rowFailed, "center", graphics);
        }
        try {
            ImageIO.write((RenderedImage)image, "png", imageFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            imageFile = null;
        }
        return imageFile;
    }

    private void drawNode(int x, int y, int width, int height, String text, String align, Graphics2D graphics) {
        Rectangle rect = new Rectangle(x, y, width, height);
        graphics.draw(rect);
        graphics.setColor(nodeBackgroundColor);
        graphics.fill(rect);
        float thickness = 2.0f;
        graphics.setStroke(new BasicStroke(thickness));
        graphics.setColor(nodeBorderColor);
        graphics.drawRect(x, y, width, height);
        graphics.setFont(new Font("Default", 0, 14));
        graphics.setColor(fontColor);
        if (align.equals("center")) {
            int len = text.length() * 14;
            float _x = (width - 5 - len) / 2;
            _x = (float)(x + 5) + _x;
            graphics.drawString(text, _x, (float)(y + 20));
        } else if (align.equals("left")) {
            graphics.drawString(text, x + 5, y + 20);
        } else {
            int len = text.length() * 14;
            float _x = width - 5 - len;
            _x = (float)x + _x;
            graphics.drawString(text, _x, (float)(y + 20));
        }
    }

    private void drawLine(int x1, int y1, int x2, int y2, Graphics2D graphics) {
        float thickness = 2.0f;
        graphics.setStroke(new BasicStroke(thickness));
        graphics.setColor(lineColor);
        graphics.drawLine(x1, y1, x2, y2);
    }

    private void drawArrow(int x, int y, Graphics2D graphics) {
        int[] xPoints = new int[]{x, x, x + 7};
        int[] yPoints = new int[]{y, y + 14, y + 7};
        graphics.setColor(lineColor);
        graphics.fillPolygon(xPoints, yPoints, 3);
    }

    public static void main(String[] args) {
        String json = "[{\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"D747ABAEE02344D0AE142E6C32B9219B\",\n            \"tableRowNo\": 1,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": null,\n            \"rowCondExpression\": null,\n            \"rowOpType\": \"C\",\n            \"rowOpTargetId\": \"0D66F404E3FA4E6180AA6E78C5E38F36\",\n            \"rowOpTargetName\": \"[\u5ba2\u6237\u4e2d\u5fc3]-[\u9ed1\u7070\u540d\u5355\u4fe1\u606f\u8868]-[\u9ed1\u540d\u5355\u68c0\u67e5\u67e5\u8be2]\",\n            \"rowSuccess\": \"Y\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"appId\\\":\\\"06F95C938FF04ACF83EABEFA8685C825\\\",\\\"srvModelId\\\":\\\"0D66F404E3FA4E6180AA6E78C5E38F36\\\",\\\"srvModelCode\\\":\\\"querySingleBlackRecord\\\",\\\"srvModelName\\\":\\\"\u9ed1\u540d\u5355\u68c0\u67e5\u67e5\u8be2\\\",\\\"srvModelCatalog\\\":\\\"I01\\\",\\\"srvModelType\\\":5,\\\"packageId\\\":null,\\\"tableModelId\\\":\\\"18EF4B7000634CDBA949201A0B320B7A\\\",\\\"tableModelCode\\\":\\\"black_list_info\\\",\\\"tableModelName\\\":\\\"\u9ed1\u7070\u540d\u5355\u4fe1\u606f\u8868\\\",\\\"srvModelDesc\\\":null,\\\"createUser\\\":\\\"zhjj\\\",\\\"createTime\\\":\\\"2021-06-03 14:57:03\\\",\\\"lastUpdateUser\\\":null,\\\"lastUpdateTime\\\":null,\\\"orderValue\\\":null,\\\"srvModelMethod\\\":null,\\\"appName\\\":\\\"\u5ba2\u6237\u4e2d\u5fc3\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"96E03102E7BF4ED1B9297E2B9241D520\",\n            \"tableRowNo\": 2,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": \"\u5982\u679c\u5728\u9ed1\u540d\u5355\u4e2d\",\n            \"rowCondExpression\": \"[{\\\"tdType\\\":\\\"FUNC\\\",\\\"enname\\\":\\\"isNotEmpty\\\",\\\"cnname\\\":\\\"\u5b57\u7b26\u4e32\u4e0d\u4e3a\u7a7a\\\"},{\\\"domainVarId\\\":\\\"EDE30E9BAF4847C48EFE1D9667BFAF0A\\\",\\\"domainVarType\\\":\\\"D\\\",\\\"tableModelCode\\\":\\\"black_list_info1\\\",\\\"tableModelName\\\":\\\"[\u9ed1\u7070\u540d\u5355\u4fe1\u606f\u8868] [\u5e8f\u53f71\u51fa\u53c2]\\\",\\\"text\\\":\\\"[\u9ed1\u540d\u5355\u7f16\u53f7][black_id]\\\",\\\"paramFieldCode\\\":\\\"black_id\\\",\\\"paramFieldName\\\":\\\"\u9ed1\u540d\u5355\u7f16\u53f7\\\",\\\"objectId\\\":\\\"18EF4B7000634CDBA949201A0B320B7A\\\",\\\"fieldId\\\":\\\"CAEE1BBB470B4DB697EC6F5A0EE16310\\\",\\\"fieldCode\\\":\\\"black_id\\\",\\\"fieldName\\\":\\\"\u9ed1\u540d\u5355\u7f16\u53f7\\\",\\\"fieldType\\\":\\\"varchar\\\",\\\"fieldLength\\\":32,\\\"tdType\\\":\\\"F\\\"}]\",\n            \"rowOpType\": \"C\",\n            \"rowOpTargetId\": \"3682EE97D3CA41DAAB7FFD7E20BA2DCD\",\n            \"rowOpTargetName\": \"[\u5ba2\u6237\u4e2d\u5fc3]-[\u610f\u5411\u5ba2\u6237\u4fe1\u606f]-[\u5355\u6761\u65b0\u589e\u670d\u52a1]\",\n            \"rowSuccess\": \"Y\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"appId\\\":\\\"06F95C938FF04ACF83EABEFA8685C825\\\",\\\"srvModelId\\\":\\\"3682EE97D3CA41DAAB7FFD7E20BA2DCD\\\",\\\"srvModelCode\\\":\\\"insertSingle\\\",\\\"srvModelName\\\":\\\"\u5355\u6761\u65b0\u589e\u670d\u52a1\\\",\\\"srvModelCatalog\\\":\\\"I01\\\",\\\"srvModelType\\\":2,\\\"packageId\\\":null,\\\"tableModelId\\\":\\\"4D0E303EE7DB4E5FAFFB0B646505DF6E\\\",\\\"tableModelCode\\\":\\\"cust_bf_rgst_inf\\\",\\\"tableModelName\\\":\\\"\u610f\u5411\u5ba2\u6237\u4fe1\u606f\\\",\\\"srvModelDesc\\\":null,\\\"createUser\\\":\\\"qiubc\\\",\\\"createTime\\\":\\\"2021-06-01 17:50:37\\\",\\\"lastUpdateUser\\\":null,\\\"lastUpdateTime\\\":null,\\\"orderValue\\\":null,\\\"srvModelMethod\\\":null,\\\"appName\\\":\\\"\u5ba2\u6237\u4e2d\u5fc3\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 3\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"27DB777989394CA9A42A72742A42BAA9\",\n            \"tableRowNo\": 3,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": \"\u5982\u679c\u5728\u9ed1\u540d\u5355\u4e2d\",\n            \"rowCondExpression\": \"[{\\\"tdType\\\":\\\"FUNC\\\",\\\"enname\\\":\\\"isNotEmpty\\\",\\\"cnname\\\":\\\"\u5b57\u7b26\u4e32\u4e0d\u4e3a\u7a7a\\\"},{\\\"tdType\\\":\\\"F\\\",\\\"choice\\\":true,\\\"domainVarId\\\":\\\"EDE30E9BAF4847C48EFE1D9667BFAF0A\\\",\\\"domainVarType\\\":\\\"D\\\",\\\"tableModelCode\\\":\\\"black_list_info1\\\",\\\"tableModelName\\\":\\\"[\u9ed1\u7070\u540d\u5355\u4fe1\u606f\u8868] [\u5e8f\u53f71\u51fa\u53c2]\\\",\\\"text\\\":\\\"[\u9ed1\u540d\u5355\u7f16\u53f7][black_id]\\\",\\\"paramFieldCode\\\":\\\"black_id\\\",\\\"paramFieldName\\\":\\\"\u9ed1\u540d\u5355\u7f16\u53f7\\\",\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"fieldId\\\":\\\"CAEE1BBB470B4DB697EC6F5A0EE16310\\\",\\\"objectId\\\":\\\"18EF4B7000634CDBA949201A0B320B7A\\\",\\\"fieldCode\\\":\\\"black_id\\\",\\\"fieldName\\\":\\\"\u9ed1\u540d\u5355\u7f16\u53f7\\\",\\\"fieldDesc\\\":\\\"\u9ed1\u540d\u5355\u7f16\u53f7\\\",\\\"itemId\\\":\\\"0894E6FD281F40D798D3F26813B3E0E6\\\",\\\"itemCode\\\":null,\\\"itemName\\\":null,\\\"fieldOrder\\\":1,\\\"fieldType\\\":\\\"varchar\\\",\\\"fieldLength\\\":32,\\\"fieldPrecision\\\":0,\\\"dictId\\\":null,\\\"fieldOption\\\":null,\\\"isPk\\\":\\\"Y\\\",\\\"isAllowNull\\\":\\\"N\\\",\\\"defValue\\\":null,\\\"createUser\\\":\\\"liaowc\\\",\\\"createTime\\\":\\\"2021-05-31 14:47:20\\\",\\\"lastModifyUser\\\":null,\\\"lastModifyTime\\\":null,\\\"dataStdFlag\\\":null,\\\"srvParamFlag\\\":\\\"03330003330000000000000000000000\\\",\\\"state\\\":\\\"open\\\",\\\"domId\\\":\\\"_easyui_tree_12\\\",\\\"target\\\":{},\\\"checked\\\":false}]\",\n            \"rowOpType\": \"R\",\n            \"rowOpTargetId\": \"EA48E32E8C28405E9034F2589F17AC85\",\n            \"rowOpTargetName\": \"[\u670d\u52a1\u51fa\u53c2]-[\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2]\",\n            \"rowSuccess\": \"Y\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"text\\\":\\\"[\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2][CreidtChecko]\\\",\\\"state\\\":\\\"open\\\",\\\"choice\\\":true,\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"children\\\":[],\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"domainVarId\\\":\\\"EA48E32E8C28405E9034F2589F17AC85\\\",\\\"srvModelId\\\":\\\"E0DB9D32173D423E87C8D5B4AE41AD06\\\",\\\"domainVarCode\\\":\\\"CreidtChecko\\\",\\\"domainVarName\\\":\\\"\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2\\\",\\\"domainVarType\\\":\\\"O\\\",\\\"tableModelId\\\":\\\"97F1A25A0698466580D480545507F32E\\\",\\\"tableRowNo\\\":null,\\\"listFlag\\\":null,\\\"domId\\\":\\\"_easyui_tree_6\\\",\\\"target\\\":{},\\\"checked\\\":false,\\\"id\\\":\\\"EA48E32E8C28405E9034F2589F17AC85\\\",\\\"code\\\":\\\"CreidtChecko\\\",\\\"name\\\":\\\"\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2\\\",\\\"type\\\":\\\"O\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"B025422A315D490D866A41DF0A49DF64\",\n            \"tableRowNo\": 4,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": \"\u5982\u679c\u5728\u9ed1\u540d\u5355\u4e2d\",\n            \"rowCondExpression\": \"[{\\\"tdType\\\":\\\"FUNC\\\",\\\"enname\\\":\\\"isNotEmpty\\\",\\\"cnname\\\":\\\"\u5b57\u7b26\u4e32\u4e0d\u4e3a\u7a7a\\\"},{\\\"tdType\\\":\\\"F\\\",\\\"choice\\\":true,\\\"domainVarId\\\":\\\"EDE30E9BAF4847C48EFE1D9667BFAF0A\\\",\\\"domainVarType\\\":\\\"D\\\",\\\"tableModelCode\\\":\\\"black_list_info1\\\",\\\"tableModelName\\\":\\\"[\u9ed1\u7070\u540d\u5355\u4fe1\u606f\u8868] [\u5e8f\u53f71\u51fa\u53c2]\\\",\\\"text\\\":\\\"[\u9ed1\u540d\u5355\u7f16\u53f7][black_id]\\\",\\\"paramFieldCode\\\":\\\"black_id\\\",\\\"paramFieldName\\\":\\\"\u9ed1\u540d\u5355\u7f16\u53f7\\\",\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"fieldId\\\":\\\"CAEE1BBB470B4DB697EC6F5A0EE16310\\\",\\\"objectId\\\":\\\"18EF4B7000634CDBA949201A0B320B7A\\\",\\\"fieldCode\\\":\\\"black_id\\\",\\\"fieldName\\\":\\\"\u9ed1\u540d\u5355\u7f16\u53f7\\\",\\\"fieldDesc\\\":\\\"\u9ed1\u540d\u5355\u7f16\u53f7\\\",\\\"itemId\\\":\\\"0894E6FD281F40D798D3F26813B3E0E6\\\",\\\"itemCode\\\":null,\\\"itemName\\\":null,\\\"fieldOrder\\\":1,\\\"fieldType\\\":\\\"varchar\\\",\\\"fieldLength\\\":32,\\\"fieldPrecision\\\":0,\\\"dictId\\\":null,\\\"fieldOption\\\":null,\\\"isPk\\\":\\\"Y\\\",\\\"isAllowNull\\\":\\\"N\\\",\\\"defValue\\\":null,\\\"createUser\\\":\\\"liaowc\\\",\\\"createTime\\\":\\\"2021-05-31 14:47:20\\\",\\\"lastModifyUser\\\":null,\\\"lastModifyTime\\\":null,\\\"dataStdFlag\\\":null,\\\"srvParamFlag\\\":\\\"03330003330000000000000000000000\\\",\\\"state\\\":\\\"open\\\",\\\"domId\\\":\\\"_easyui_tree_12\\\",\\\"target\\\":{},\\\"checked\\\":false}]\",\n            \"rowOpType\": \"R\",\n            \"rowOpTargetId\": \"FB1C29D6B8D14B5A899914DFC33ED5E8\",\n            \"rowOpTargetName\": \"[\u670d\u52a1\u51fa\u53c2]-[\u6807\u51c6\u670d\u52a1\u51fa\u53c2]\",\n            \"rowSuccess\": \"N\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"text\\\":\\\"[\u6807\u51c6\u670d\u52a1\u51fa\u53c2][isrv_rsp_info]\\\",\\\"state\\\":\\\"open\\\",\\\"choice\\\":true,\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"children\\\":[],\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"domainVarId\\\":\\\"FB1C29D6B8D14B5A899914DFC33ED5E8\\\",\\\"srvModelId\\\":\\\"E0DB9D32173D423E87C8D5B4AE41AD06\\\",\\\"domainVarCode\\\":\\\"isrv_rsp_info\\\",\\\"domainVarName\\\":\\\"\u6807\u51c6\u670d\u52a1\u51fa\u53c2\\\",\\\"domainVarType\\\":\\\"O\\\",\\\"tableModelId\\\":\\\"8B532A09534D49029364B4922FAACF6D\\\",\\\"tableRowNo\\\":null,\\\"listFlag\\\":\\\"N\\\",\\\"tableRowId\\\":null,\\\"domId\\\":\\\"_easyui_tree_3\\\",\\\"target\\\":{},\\\"checked\\\":false,\\\"id\\\":\\\"FB1C29D6B8D14B5A899914DFC33ED5E8\\\",\\\"code\\\":\\\"isrv_rsp_info\\\",\\\"name\\\":\\\"\u6807\u51c6\u670d\u52a1\u51fa\u53c2\\\",\\\"type\\\":\\\"O\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"CEF9F345D1F04CDCB45A7FBBA4D95EF5\",\n            \"tableRowNo\": 5,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": null,\n            \"rowCondExpression\": null,\n            \"rowOpType\": \"C\",\n            \"rowOpTargetId\": \"B55DF94BDF6E42EB850BF0809D896FF1\",\n            \"rowOpTargetName\": \"[\u5ba2\u6237\u4e2d\u5fc3]-[\u9ed1\u7070\u540d\u5355\u4fe1\u606f\u8868]-[\u7070\u540d\u5355\u67e5\u8be2\u670d\u52a1]\",\n            \"rowSuccess\": \"Y\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"appId\\\":\\\"06F95C938FF04ACF83EABEFA8685C825\\\",\\\"srvModelId\\\":\\\"B55DF94BDF6E42EB850BF0809D896FF1\\\",\\\"srvModelCode\\\":\\\"queryByGray\\\",\\\"srvModelName\\\":\\\"\u7070\u540d\u5355\u67e5\u8be2\u670d\u52a1\\\",\\\"srvModelCatalog\\\":\\\"I01\\\",\\\"srvModelType\\\":5,\\\"packageId\\\":null,\\\"tableModelId\\\":\\\"18EF4B7000634CDBA949201A0B320B7A\\\",\\\"tableModelCode\\\":\\\"black_list_info\\\",\\\"tableModelName\\\":\\\"\u9ed1\u7070\u540d\u5355\u4fe1\u606f\u8868\\\",\\\"srvModelDesc\\\":null,\\\"createUser\\\":\\\"ligm\\\",\\\"createTime\\\":\\\"2021-07-01 11:04:20\\\",\\\"lastUpdateUser\\\":null,\\\"lastUpdateTime\\\":null,\\\"orderValue\\\":null,\\\"srvModelMethod\\\":null,\\\"appName\\\":\\\"\u5ba2\u6237\u4e2d\u5fc3\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"139A9E77F4194B38814C1D3CCC7D34D4\",\n            \"tableRowNo\": 6,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": \"\u5982\u679c\u5728\u7070\u540d\u5355\u4e2d\",\n            \"rowCondExpression\": \"[{\\\"tdType\\\":\\\"FUNC\\\",\\\"enname\\\":\\\"isNotEmpty\\\",\\\"cnname\\\":\\\"\u5b57\u7b26\u4e32\u4e0d\u4e3a\u7a7a\\\"},{\\\"domainVarId\\\":\\\"EDE30E9BAF4847C48EFE1D9667BFAF0A\\\",\\\"domainVarType\\\":\\\"D\\\",\\\"tableModelCode\\\":\\\"black_list_info1\\\",\\\"tableModelName\\\":\\\"[\u9ed1\u7070\u540d\u5355\u4fe1\u606f\u8868] [\u5e8f\u53f71\u51fa\u53c2]\\\",\\\"text\\\":\\\"[\u9ed1\u540d\u5355\u7f16\u53f7][black_id]\\\",\\\"paramFieldCode\\\":\\\"black_id\\\",\\\"paramFieldName\\\":\\\"\u9ed1\u540d\u5355\u7f16\u53f7\\\",\\\"objectId\\\":\\\"18EF4B7000634CDBA949201A0B320B7A\\\",\\\"fieldId\\\":\\\"CAEE1BBB470B4DB697EC6F5A0EE16310\\\",\\\"fieldCode\\\":\\\"black_id\\\",\\\"fieldName\\\":\\\"\u9ed1\u540d\u5355\u7f16\u53f7\\\",\\\"fieldType\\\":\\\"varchar\\\",\\\"fieldLength\\\":32,\\\"tdType\\\":\\\"F\\\"}]\",\n            \"rowOpType\": \"C\",\n            \"rowOpTargetId\": \"3682EE97D3CA41DAAB7FFD7E20BA2DCD\",\n            \"rowOpTargetName\": \"[\u5ba2\u6237\u4e2d\u5fc3]-[\u610f\u5411\u5ba2\u6237\u4fe1\u606f]-[\u5355\u6761\u65b0\u589e\u670d\u52a1]\",\n            \"rowSuccess\": \"Y\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"appId\\\":\\\"06F95C938FF04ACF83EABEFA8685C825\\\",\\\"srvModelId\\\":\\\"3682EE97D3CA41DAAB7FFD7E20BA2DCD\\\",\\\"srvModelCode\\\":\\\"insertSingle\\\",\\\"srvModelName\\\":\\\"\u5355\u6761\u65b0\u589e\u670d\u52a1\\\",\\\"srvModelCatalog\\\":\\\"I01\\\",\\\"srvModelType\\\":2,\\\"packageId\\\":null,\\\"tableModelId\\\":\\\"4D0E303EE7DB4E5FAFFB0B646505DF6E\\\",\\\"tableModelCode\\\":\\\"cust_bf_rgst_inf\\\",\\\"tableModelName\\\":\\\"\u610f\u5411\u5ba2\u6237\u4fe1\u606f\\\",\\\"srvModelDesc\\\":null,\\\"createUser\\\":\\\"qiubc\\\",\\\"createTime\\\":\\\"2021-06-01 17:50:37\\\",\\\"lastUpdateUser\\\":null,\\\"lastUpdateTime\\\":null,\\\"orderValue\\\":null,\\\"srvModelMethod\\\":null,\\\"appName\\\":\\\"\u5ba2\u6237\u4e2d\u5fc3\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 3\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"E5BE36678F80464CB7B8D2522F5B533B\",\n            \"tableRowNo\": 7,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": \"\u5982\u679c\u5728\u7070\u540d\u5355\u4e2d\",\n            \"rowCondExpression\": \"[{\\\"tdType\\\":\\\"FUNC\\\",\\\"enname\\\":\\\"isNotEmpty\\\",\\\"cnname\\\":\\\"\u5b57\u7b26\u4e32\u4e0d\u4e3a\u7a7a\\\"},{\\\"tdType\\\":\\\"F\\\",\\\"choice\\\":true,\\\"domainVarId\\\":\\\"EDE30E9BAF4847C48EFE1D9667BFAF0A\\\",\\\"domainVarType\\\":\\\"D\\\",\\\"tableModelCode\\\":\\\"black_list_info1\\\",\\\"tableModelName\\\":\\\"[\u9ed1\u7070\u540d\u5355\u4fe1\u606f\u8868] [\u5e8f\u53f71\u51fa\u53c2]\\\",\\\"text\\\":\\\"[\u9ed1\u540d\u5355\u7f16\u53f7][black_id]\\\",\\\"paramFieldCode\\\":\\\"black_id\\\",\\\"paramFieldName\\\":\\\"\u9ed1\u540d\u5355\u7f16\u53f7\\\",\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"fieldId\\\":\\\"CAEE1BBB470B4DB697EC6F5A0EE16310\\\",\\\"objectId\\\":\\\"18EF4B7000634CDBA949201A0B320B7A\\\",\\\"fieldCode\\\":\\\"black_id\\\",\\\"fieldName\\\":\\\"\u9ed1\u540d\u5355\u7f16\u53f7\\\",\\\"fieldDesc\\\":\\\"\u9ed1\u540d\u5355\u7f16\u53f7\\\",\\\"itemId\\\":\\\"0894E6FD281F40D798D3F26813B3E0E6\\\",\\\"itemCode\\\":null,\\\"itemName\\\":null,\\\"fieldOrder\\\":1,\\\"fieldType\\\":\\\"varchar\\\",\\\"fieldLength\\\":32,\\\"fieldPrecision\\\":0,\\\"dictId\\\":null,\\\"fieldOption\\\":null,\\\"isPk\\\":\\\"Y\\\",\\\"isAllowNull\\\":\\\"N\\\",\\\"defValue\\\":null,\\\"createUser\\\":\\\"liaowc\\\",\\\"createTime\\\":\\\"2021-05-31 14:47:20\\\",\\\"lastModifyUser\\\":null,\\\"lastModifyTime\\\":null,\\\"dataStdFlag\\\":null,\\\"srvParamFlag\\\":\\\"03330003330000000000000000000000\\\",\\\"state\\\":\\\"open\\\",\\\"domId\\\":\\\"_easyui_tree_12\\\",\\\"target\\\":{},\\\"checked\\\":false}]\",\n            \"rowOpType\": \"R\",\n            \"rowOpTargetId\": \"FB1C29D6B8D14B5A899914DFC33ED5E8\",\n            \"rowOpTargetName\": \"[\u670d\u52a1\u51fa\u53c2]-[\u6807\u51c6\u670d\u52a1\u51fa\u53c2]\",\n            \"rowSuccess\": \"N\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"text\\\":\\\"[\u6807\u51c6\u670d\u52a1\u51fa\u53c2][isrv_rsp_info]\\\",\\\"state\\\":\\\"open\\\",\\\"choice\\\":true,\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"children\\\":[],\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"domainVarId\\\":\\\"FB1C29D6B8D14B5A899914DFC33ED5E8\\\",\\\"srvModelId\\\":\\\"E0DB9D32173D423E87C8D5B4AE41AD06\\\",\\\"domainVarCode\\\":\\\"isrv_rsp_info\\\",\\\"domainVarName\\\":\\\"\u6807\u51c6\u670d\u52a1\u51fa\u53c2\\\",\\\"domainVarType\\\":\\\"O\\\",\\\"tableModelId\\\":\\\"8B532A09534D49029364B4922FAACF6D\\\",\\\"tableRowNo\\\":null,\\\"listFlag\\\":\\\"N\\\",\\\"tableRowId\\\":null,\\\"domId\\\":\\\"_easyui_tree_3\\\",\\\"target\\\":{},\\\"checked\\\":false,\\\"id\\\":\\\"FB1C29D6B8D14B5A899914DFC33ED5E8\\\",\\\"code\\\":\\\"isrv_rsp_info\\\",\\\"name\\\":\\\"\u6807\u51c6\u670d\u52a1\u51fa\u53c2\\\",\\\"type\\\":\\\"O\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"EF6DECDF18B24AF3976D8D8C278A7AA7\",\n            \"tableRowNo\": 8,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": \"\u5982\u679c\u5728\u7070\u540d\u5355\u4e2d\",\n            \"rowCondExpression\": \"[{\\\"tdType\\\":\\\"FUNC\\\",\\\"enname\\\":\\\"isNotEmpty\\\",\\\"cnname\\\":\\\"\u5b57\u7b26\u4e32\u4e0d\u4e3a\u7a7a\\\"},{\\\"tdType\\\":\\\"F\\\",\\\"choice\\\":true,\\\"domainVarId\\\":\\\"EDE30E9BAF4847C48EFE1D9667BFAF0A\\\",\\\"domainVarType\\\":\\\"D\\\",\\\"tableModelCode\\\":\\\"black_list_info1\\\",\\\"tableModelName\\\":\\\"[\u9ed1\u7070\u540d\u5355\u4fe1\u606f\u8868] [\u5e8f\u53f71\u51fa\u53c2]\\\",\\\"text\\\":\\\"[\u9ed1\u540d\u5355\u7f16\u53f7][black_id]\\\",\\\"paramFieldCode\\\":\\\"black_id\\\",\\\"paramFieldName\\\":\\\"\u9ed1\u540d\u5355\u7f16\u53f7\\\",\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"fieldId\\\":\\\"CAEE1BBB470B4DB697EC6F5A0EE16310\\\",\\\"objectId\\\":\\\"18EF4B7000634CDBA949201A0B320B7A\\\",\\\"fieldCode\\\":\\\"black_id\\\",\\\"fieldName\\\":\\\"\u9ed1\u540d\u5355\u7f16\u53f7\\\",\\\"fieldDesc\\\":\\\"\u9ed1\u540d\u5355\u7f16\u53f7\\\",\\\"itemId\\\":\\\"0894E6FD281F40D798D3F26813B3E0E6\\\",\\\"itemCode\\\":null,\\\"itemName\\\":null,\\\"fieldOrder\\\":1,\\\"fieldType\\\":\\\"varchar\\\",\\\"fieldLength\\\":32,\\\"fieldPrecision\\\":0,\\\"dictId\\\":null,\\\"fieldOption\\\":null,\\\"isPk\\\":\\\"Y\\\",\\\"isAllowNull\\\":\\\"N\\\",\\\"defValue\\\":null,\\\"createUser\\\":\\\"liaowc\\\",\\\"createTime\\\":\\\"2021-05-31 14:47:20\\\",\\\"lastModifyUser\\\":null,\\\"lastModifyTime\\\":null,\\\"dataStdFlag\\\":null,\\\"srvParamFlag\\\":\\\"03330003330000000000000000000000\\\",\\\"state\\\":\\\"open\\\",\\\"domId\\\":\\\"_easyui_tree_12\\\",\\\"target\\\":{},\\\"checked\\\":false}]\",\n            \"rowOpType\": \"R\",\n            \"rowOpTargetId\": \"EA48E32E8C28405E9034F2589F17AC85\",\n            \"rowOpTargetName\": \"[\u670d\u52a1\u51fa\u53c2]-[\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2]\",\n            \"rowSuccess\": \"Y\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"text\\\":\\\"[\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2][CreidtChecko]\\\",\\\"state\\\":\\\"open\\\",\\\"choice\\\":true,\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"children\\\":[],\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"domainVarId\\\":\\\"EA48E32E8C28405E9034F2589F17AC85\\\",\\\"srvModelId\\\":\\\"E0DB9D32173D423E87C8D5B4AE41AD06\\\",\\\"domainVarCode\\\":\\\"CreidtChecko\\\",\\\"domainVarName\\\":\\\"\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2\\\",\\\"domainVarType\\\":\\\"O\\\",\\\"tableModelId\\\":\\\"97F1A25A0698466580D480545507F32E\\\",\\\"tableRowNo\\\":null,\\\"listFlag\\\":null,\\\"tableRowId\\\":null,\\\"domId\\\":\\\"_easyui_tree_2\\\",\\\"target\\\":{},\\\"checked\\\":false,\\\"id\\\":\\\"EA48E32E8C28405E9034F2589F17AC85\\\",\\\"code\\\":\\\"CreidtChecko\\\",\\\"name\\\":\\\"\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2\\\",\\\"type\\\":\\\"O\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"BFE6E2AE77B24C259DA7003BD8ABCDC7\",\n            \"tableRowNo\": 9,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": null,\n            \"rowCondExpression\": null,\n            \"rowOpType\": \"T\",\n            \"rowOpTargetId\": \"18D9C3D06FC54459A55AD9E31C38613E\",\n            \"rowOpTargetName\": \"[\u8eab\u4efd\u8bc1\u5904\u7406]-[\u8eab\u4efd\u8bc1\u5e74\u9f84\u8ba1\u7b97]\",\n            \"rowSuccess\": \"Y\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"appId\\\":\\\"A6DD33BF653749BAB3343E01FF56150C\\\",\\\"srvModelId\\\":\\\"18D9C3D06FC54459A55AD9E31C38613E\\\",\\\"srvModelCode\\\":\\\"IdCardAge\\\",\\\"srvModelName\\\":\\\"\u8eab\u4efd\u8bc1\u5e74\u9f84\u8ba1\u7b97\\\",\\\"srvModelCatalog\\\":\\\"A01\\\",\\\"srvModelType\\\":30,\\\"packageId\\\":\\\"870CE88A818D458CBF06D66FA8ED9998\\\",\\\"tableModelId\\\":null,\\\"tableModelCode\\\":null,\\\"tableModelName\\\":null,\\\"srvModelDesc\\\":null,\\\"createUser\\\":\\\"ligm\\\",\\\"createTime\\\":\\\"2021-07-01 16:56:03\\\",\\\"lastUpdateUser\\\":null,\\\"lastUpdateTime\\\":null,\\\"orderValue\\\":1,\\\"srvModelMethod\\\":\\\"\\\",\\\"appName\\\":\\\"\u8eab\u4efd\u8bc1\u5904\u7406\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"72C43B91B56041F5ABD1B54A0BFF0D18\",\n            \"tableRowNo\": 10,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": null,\n            \"rowCondExpression\": null,\n            \"rowOpType\": \"C\",\n            \"rowOpTargetId\": \"59227F3F1C6F4E8AA3AD1CB725BA8B1A\",\n            \"rowOpTargetName\": \"[\u4ea4\u6613\u63a5\u53e3\u5355\u5143]-[\u4fe1\u7528\u4e92\u65a5]\",\n            \"rowSuccess\": \"Y\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"appId\\\":\\\"B501A4DE33664448B2655C90D25FFFBF\\\",\\\"srvModelId\\\":\\\"59227F3F1C6F4E8AA3AD1CB725BA8B1A\\\",\\\"srvModelCode\\\":\\\"CrdtNutuApp\\\",\\\"srvModelName\\\":\\\"\u4fe1\u7528\u4e92\u65a5\\\",\\\"srvModelCatalog\\\":\\\"A01\\\",\\\"srvModelType\\\":30,\\\"packageId\\\":\\\"CBA9EA98133D4A4B92D70E118E26E609\\\",\\\"tableModelId\\\":null,\\\"tableModelCode\\\":null,\\\"tableModelName\\\":null,\\\"srvModelDesc\\\":null,\\\"createUser\\\":\\\"ligm\\\",\\\"createTime\\\":\\\"2021-06-14 09:35:47\\\",\\\"lastUpdateUser\\\":null,\\\"lastUpdateTime\\\":null,\\\"orderValue\\\":2,\\\"srvModelMethod\\\":\\\"handle\\\",\\\"appName\\\":\\\"\u4ea4\u6613\u63a5\u53e3\u5355\u5143\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"D0AB3402A7084C04903E4E5FADE41665\",\n            \"tableRowNo\": 11,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": \"\u5982\u679c\u4e92\u65a5\",\n            \"rowCondExpression\": \"[{\\\"tdType\\\":\\\"F\\\",\\\"choice\\\":true,\\\"domainVarId\\\":\\\"20D3573D6B064119AF461E04B15A1A16\\\",\\\"domainVarType\\\":\\\"D\\\",\\\"tableModelCode\\\":\\\"CrdtNutuAppServiceHandle9\\\",\\\"tableModelName\\\":\\\"[\u4fe1\u7528\u4e92\u65a5\u51fa\u53c2] [\u5e8f\u53f79\u51fa\u53c2]\\\",\\\"text\\\":\\\"[\u662f\u5426\u4e92\u65a5\u6807\u5fd7][is_mutu_excl_flg]\\\",\\\"paramFieldCode\\\":\\\"is_mutu_excl_flg\\\",\\\"paramFieldName\\\":\\\"\u662f\u5426\u4e92\u65a5\u6807\u5fd7\\\",\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"fieldId\\\":\\\"4B059BBA60EA468893AC797A35729F83\\\",\\\"objectId\\\":\\\"FB71F634CC9D428CB32F5B5A0D76258C\\\",\\\"fieldCode\\\":\\\"is_mutu_excl_flg\\\",\\\"fieldName\\\":\\\"\u662f\u5426\u4e92\u65a5\u6807\u5fd7\\\",\\\"fieldDesc\\\":\\\"\\\",\\\"itemId\\\":\\\"3105257336074127AC9723A1F6D0E46B\\\",\\\"itemCode\\\":null,\\\"itemName\\\":\\\"\u662f\u5426\u4e92\u65a5\u6807\u5fd7\\\",\\\"fieldOrder\\\":1,\\\"fieldType\\\":\\\"varchar\\\",\\\"fieldLength\\\":1,\\\"fieldPrecision\\\":0,\\\"dictId\\\":null,\\\"fieldOption\\\":\\\"\\\",\\\"isPk\\\":\\\"N\\\",\\\"isAllowNull\\\":\\\"N\\\",\\\"defValue\\\":null,\\\"createUser\\\":\\\"ligm\\\",\\\"createTime\\\":\\\"2021-06-14 09:47:59\\\",\\\"lastModifyUser\\\":\\\"liaowc\\\",\\\"lastModifyTime\\\":\\\"2021-06-25 17:52:15\\\",\\\"dataStdFlag\\\":\\\"Y\\\",\\\"srvParamFlag\\\":\\\"00000000000000000000000000000000\\\",\\\"state\\\":\\\"open\\\",\\\"domId\\\":\\\"_easyui_tree_54\\\",\\\"target\\\":{},\\\"checked\\\":false},{\\\"tdType\\\":\\\"C\\\",\\\"enname\\\":\\\"=\\\",\\\"cnname\\\":\\\"\u7b49\u4e8e\\\"},{\\\"tdType\\\":\\\"FUNC\\\",\\\"enname\\\":\\\"const\\\",\\\"cnname\\\":\\\"\u5e38\u91cf\\\",\\\"value\\\":\\\"1\\\"}]\",\n            \"rowOpType\": \"C\",\n            \"rowOpTargetId\": \"3682EE97D3CA41DAAB7FFD7E20BA2DCD\",\n            \"rowOpTargetName\": \"[\u5ba2\u6237\u4e2d\u5fc3]-[\u610f\u5411\u5ba2\u6237\u4fe1\u606f]-[\u5355\u6761\u65b0\u589e\u670d\u52a1]\",\n            \"rowSuccess\": \"Y\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"appId\\\":\\\"06F95C938FF04ACF83EABEFA8685C825\\\",\\\"srvModelId\\\":\\\"3682EE97D3CA41DAAB7FFD7E20BA2DCD\\\",\\\"srvModelCode\\\":\\\"insertSingle\\\",\\\"srvModelName\\\":\\\"\u5355\u6761\u65b0\u589e\u670d\u52a1\\\",\\\"srvModelCatalog\\\":\\\"I01\\\",\\\"srvModelType\\\":2,\\\"packageId\\\":null,\\\"tableModelId\\\":\\\"4D0E303EE7DB4E5FAFFB0B646505DF6E\\\",\\\"tableModelCode\\\":\\\"cust_bf_rgst_inf\\\",\\\"tableModelName\\\":\\\"\u610f\u5411\u5ba2\u6237\u4fe1\u606f\\\",\\\"srvModelDesc\\\":null,\\\"createUser\\\":\\\"qiubc\\\",\\\"createTime\\\":\\\"2021-06-01 17:50:37\\\",\\\"lastUpdateUser\\\":null,\\\"lastUpdateTime\\\":null,\\\"orderValue\\\":null,\\\"srvModelMethod\\\":null,\\\"appName\\\":\\\"\u5ba2\u6237\u4e2d\u5fc3\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"F99EA7AE438B45DD877A4EC5BE81686A\",\n            \"tableRowNo\": 12,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": \"\u5982\u679c\u4e92\u65a5\",\n            \"rowCondExpression\": \"[{\\\"tdType\\\":\\\"F\\\",\\\"choice\\\":true,\\\"domainVarId\\\":\\\"20D3573D6B064119AF461E04B15A1A16\\\",\\\"domainVarType\\\":\\\"D\\\",\\\"tableModelCode\\\":\\\"CrdtNutuAppServiceHandle9\\\",\\\"tableModelName\\\":\\\"[\u4fe1\u7528\u4e92\u65a5\u51fa\u53c2] [\u5e8f\u53f79\u51fa\u53c2]\\\",\\\"text\\\":\\\"[\u662f\u5426\u4e92\u65a5\u6807\u5fd7][is_mutu_excl_flg]\\\",\\\"paramFieldCode\\\":\\\"is_mutu_excl_flg\\\",\\\"paramFieldName\\\":\\\"\u662f\u5426\u4e92\u65a5\u6807\u5fd7\\\",\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"fieldId\\\":\\\"4B059BBA60EA468893AC797A35729F83\\\",\\\"objectId\\\":\\\"FB71F634CC9D428CB32F5B5A0D76258C\\\",\\\"fieldCode\\\":\\\"is_mutu_excl_flg\\\",\\\"fieldName\\\":\\\"\u662f\u5426\u4e92\u65a5\u6807\u5fd7\\\",\\\"fieldDesc\\\":\\\"\\\",\\\"itemId\\\":\\\"3105257336074127AC9723A1F6D0E46B\\\",\\\"itemCode\\\":null,\\\"itemName\\\":\\\"\u662f\u5426\u4e92\u65a5\u6807\u5fd7\\\",\\\"fieldOrder\\\":1,\\\"fieldType\\\":\\\"varchar\\\",\\\"fieldLength\\\":1,\\\"fieldPrecision\\\":0,\\\"dictId\\\":null,\\\"fieldOption\\\":\\\"\\\",\\\"isPk\\\":\\\"N\\\",\\\"isAllowNull\\\":\\\"N\\\",\\\"defValue\\\":null,\\\"createUser\\\":\\\"ligm\\\",\\\"createTime\\\":\\\"2021-06-14 09:47:59\\\",\\\"lastModifyUser\\\":\\\"liaowc\\\",\\\"lastModifyTime\\\":\\\"2021-06-25 17:52:15\\\",\\\"dataStdFlag\\\":\\\"Y\\\",\\\"srvParamFlag\\\":\\\"00000000000000000000000000000000\\\",\\\"state\\\":\\\"open\\\",\\\"domId\\\":\\\"_easyui_tree_54\\\",\\\"target\\\":{},\\\"checked\\\":false},{\\\"tdType\\\":\\\"C\\\",\\\"enname\\\":\\\"=\\\",\\\"cnname\\\":\\\"\u7b49\u4e8e\\\"},{\\\"tdType\\\":\\\"FUNC\\\",\\\"enname\\\":\\\"const\\\",\\\"cnname\\\":\\\"\u5e38\u91cf\\\",\\\"value\\\":\\\"1\\\"}]\",\n            \"rowOpType\": \"R\",\n            \"rowOpTargetId\": \"EA48E32E8C28405E9034F2589F17AC85\",\n            \"rowOpTargetName\": \"[\u670d\u52a1\u51fa\u53c2]-[\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2]\",\n            \"rowSuccess\": \"Y\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"text\\\":\\\"[\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2][CreidtChecko]\\\",\\\"state\\\":\\\"open\\\",\\\"choice\\\":true,\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"children\\\":[],\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"domainVarId\\\":\\\"EA48E32E8C28405E9034F2589F17AC85\\\",\\\"srvModelId\\\":\\\"E0DB9D32173D423E87C8D5B4AE41AD06\\\",\\\"domainVarCode\\\":\\\"CreidtChecko\\\",\\\"domainVarName\\\":\\\"\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2\\\",\\\"domainVarType\\\":\\\"O\\\",\\\"tableModelId\\\":\\\"97F1A25A0698466580D480545507F32E\\\",\\\"tableRowNo\\\":null,\\\"listFlag\\\":null,\\\"tableRowId\\\":null,\\\"domId\\\":\\\"_easyui_tree_2\\\",\\\"target\\\":{},\\\"checked\\\":false,\\\"id\\\":\\\"EA48E32E8C28405E9034F2589F17AC85\\\",\\\"code\\\":\\\"CreidtChecko\\\",\\\"name\\\":\\\"\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2\\\",\\\"type\\\":\\\"O\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"0B2991A41F5E4445858E2FA6888A2361\",\n            \"tableRowNo\": 13,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": \"\u5982\u679c\u4e92\u65a5\",\n            \"rowCondExpression\": \"[{\\\"tdType\\\":\\\"F\\\",\\\"choice\\\":true,\\\"domainVarId\\\":\\\"20D3573D6B064119AF461E04B15A1A16\\\",\\\"domainVarType\\\":\\\"D\\\",\\\"tableModelCode\\\":\\\"CrdtNutuAppServiceHandle9\\\",\\\"tableModelName\\\":\\\"[\u4fe1\u7528\u4e92\u65a5\u51fa\u53c2] [\u5e8f\u53f79\u51fa\u53c2]\\\",\\\"text\\\":\\\"[\u662f\u5426\u4e92\u65a5\u6807\u5fd7][is_mutu_excl_flg]\\\",\\\"paramFieldCode\\\":\\\"is_mutu_excl_flg\\\",\\\"paramFieldName\\\":\\\"\u662f\u5426\u4e92\u65a5\u6807\u5fd7\\\",\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"fieldId\\\":\\\"4B059BBA60EA468893AC797A35729F83\\\",\\\"objectId\\\":\\\"FB71F634CC9D428CB32F5B5A0D76258C\\\",\\\"fieldCode\\\":\\\"is_mutu_excl_flg\\\",\\\"fieldName\\\":\\\"\u662f\u5426\u4e92\u65a5\u6807\u5fd7\\\",\\\"fieldDesc\\\":\\\"\\\",\\\"itemId\\\":\\\"3105257336074127AC9723A1F6D0E46B\\\",\\\"itemCode\\\":null,\\\"itemName\\\":\\\"\u662f\u5426\u4e92\u65a5\u6807\u5fd7\\\",\\\"fieldOrder\\\":1,\\\"fieldType\\\":\\\"varchar\\\",\\\"fieldLength\\\":1,\\\"fieldPrecision\\\":0,\\\"dictId\\\":null,\\\"fieldOption\\\":\\\"\\\",\\\"isPk\\\":\\\"N\\\",\\\"isAllowNull\\\":\\\"N\\\",\\\"defValue\\\":null,\\\"createUser\\\":\\\"ligm\\\",\\\"createTime\\\":\\\"2021-06-14 09:47:59\\\",\\\"lastModifyUser\\\":\\\"liaowc\\\",\\\"lastModifyTime\\\":\\\"2021-06-25 17:52:15\\\",\\\"dataStdFlag\\\":\\\"Y\\\",\\\"srvParamFlag\\\":\\\"00000000000000000000000000000000\\\",\\\"state\\\":\\\"open\\\",\\\"domId\\\":\\\"_easyui_tree_54\\\",\\\"target\\\":{},\\\"checked\\\":false},{\\\"tdType\\\":\\\"C\\\",\\\"enname\\\":\\\"=\\\",\\\"cnname\\\":\\\"\u7b49\u4e8e\\\"},{\\\"tdType\\\":\\\"FUNC\\\",\\\"enname\\\":\\\"const\\\",\\\"cnname\\\":\\\"\u5e38\u91cf\\\",\\\"value\\\":\\\"1\\\"}]\",\n            \"rowOpType\": \"R\",\n            \"rowOpTargetId\": \"FB1C29D6B8D14B5A899914DFC33ED5E8\",\n            \"rowOpTargetName\": \"[\u670d\u52a1\u51fa\u53c2]-[\u6807\u51c6\u670d\u52a1\u51fa\u53c2]\",\n            \"rowSuccess\": \"N\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"text\\\":\\\"[\u6807\u51c6\u670d\u52a1\u51fa\u53c2][isrv_rsp_info]\\\",\\\"state\\\":\\\"open\\\",\\\"choice\\\":true,\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"children\\\":[],\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"domainVarId\\\":\\\"FB1C29D6B8D14B5A899914DFC33ED5E8\\\",\\\"srvModelId\\\":\\\"E0DB9D32173D423E87C8D5B4AE41AD06\\\",\\\"domainVarCode\\\":\\\"isrv_rsp_info\\\",\\\"domainVarName\\\":\\\"\u6807\u51c6\u670d\u52a1\u51fa\u53c2\\\",\\\"domainVarType\\\":\\\"O\\\",\\\"tableModelId\\\":\\\"8B532A09534D49029364B4922FAACF6D\\\",\\\"tableRowNo\\\":null,\\\"listFlag\\\":\\\"N\\\",\\\"tableRowId\\\":null,\\\"domId\\\":\\\"_easyui_tree_3\\\",\\\"target\\\":{},\\\"checked\\\":false,\\\"id\\\":\\\"FB1C29D6B8D14B5A899914DFC33ED5E8\\\",\\\"code\\\":\\\"isrv_rsp_info\\\",\\\"name\\\":\\\"\u6807\u51c6\u670d\u52a1\u51fa\u53c2\\\",\\\"type\\\":\\\"O\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"597CDD8ACBA94320913BC17B14346CCF\",\n            \"tableRowNo\": 14,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": null,\n            \"rowCondExpression\": null,\n            \"rowOpType\": \"C\",\n            \"rowOpTargetId\": \"2B4DC34CF28D462AA34A311710252E80\",\n            \"rowOpTargetName\": \"[\u516c\u5171\u4e2d\u5fc3]-[\u4ea7\u54c1\u914d\u7f6e\u4fe1\u606f]-[\u5355\u6761\u67e5\u8be2\u670d\u52a1]\",\n            \"rowSuccess\": \"Y\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"appId\\\":\\\"066EBEA768194E14A3B85C8CA8907CE3\\\",\\\"srvModelId\\\":\\\"2B4DC34CF28D462AA34A311710252E80\\\",\\\"srvModelCode\\\":\\\"queryByPk\\\",\\\"srvModelName\\\":\\\"\u5355\u6761\u67e5\u8be2\u670d\u52a1\\\",\\\"srvModelCatalog\\\":\\\"I01\\\",\\\"srvModelType\\\":5,\\\"packageId\\\":null,\\\"tableModelId\\\":\\\"F8BCC84B5A734F408E4A15774CE17114\\\",\\\"tableModelCode\\\":\\\"prd_info\\\",\\\"tableModelName\\\":\\\"\u4ea7\u54c1\u914d\u7f6e\u4fe1\u606f\\\",\\\"srvModelDesc\\\":null,\\\"createUser\\\":\\\"system\\\",\\\"createTime\\\":\\\"2021-05-26 17:53:15\\\",\\\"lastUpdateUser\\\":null,\\\"lastUpdateTime\\\":null,\\\"orderValue\\\":null,\\\"srvModelMethod\\\":null,\\\"appName\\\":\\\"\u516c\u5171\u4e2d\u5fc3\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"9D1C88A5860B452AA7089E5B1C2900D5\",\n            \"tableRowNo\": 15,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": \"\u5982\u679c\u4f7f\u7528\u767d\u540d\u5355\",\n            \"rowCondExpression\": \"[{\\\"tdType\\\":\\\"F\\\",\\\"choice\\\":true,\\\"domainVarId\\\":\\\"53FE1D191B874B618410335A6BD2AEB1\\\",\\\"domainVarType\\\":\\\"D\\\",\\\"tableModelCode\\\":\\\"prd_info13\\\",\\\"tableModelName\\\":\\\"[\u4ea7\u54c1\u914d\u7f6e\u4fe1\u606f] [\u5e8f\u53f713\u51fa\u53c2]\\\",\\\"text\\\":\\\"[\u662f\u5426\u4f7f\u7528\u767d\u540d\u5355][white_list_flag]\\\",\\\"paramFieldCode\\\":\\\"white_list_flag\\\",\\\"paramFieldName\\\":\\\"\u662f\u5426\u4f7f\u7528\u767d\u540d\u5355\\\",\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"fieldId\\\":\\\"95F26758CB99486C95118AC9B61250AC\\\",\\\"objectId\\\":\\\"F8BCC84B5A734F408E4A15774CE17114\\\",\\\"fieldCode\\\":\\\"white_list_flag\\\",\\\"fieldName\\\":\\\"\u662f\u5426\u4f7f\u7528\u767d\u540d\u5355\\\",\\\"fieldDesc\\\":\\\"\u662f\u5426\u4f7f\u7528\u767d\u540d\u5355\\\",\\\"itemId\\\":\\\"D9C65291755F47F09708F905EC6358A2\\\",\\\"itemCode\\\":null,\\\"itemName\\\":null,\\\"fieldOrder\\\":90,\\\"fieldType\\\":\\\"char\\\",\\\"fieldLength\\\":1,\\\"fieldPrecision\\\":0,\\\"dictId\\\":null,\\\"fieldOption\\\":\\\"\\\",\\\"isPk\\\":\\\"N\\\",\\\"isAllowNull\\\":\\\"N\\\",\\\"defValue\\\":null,\\\"createUser\\\":\\\"ligm\\\",\\\"createTime\\\":\\\"2021-07-01 16:14:40\\\",\\\"lastModifyUser\\\":null,\\\"lastModifyTime\\\":null,\\\"dataStdFlag\\\":null,\\\"srvParamFlag\\\":\\\"11110111111111111111111111111111\\\",\\\"state\\\":\\\"open\\\",\\\"domId\\\":\\\"_easyui_tree_150\\\",\\\"target\\\":{},\\\"checked\\\":false},{\\\"tdType\\\":\\\"C\\\",\\\"enname\\\":\\\"=\\\",\\\"cnname\\\":\\\"\u7b49\u4e8e\\\"},{\\\"tdType\\\":\\\"FUNC\\\",\\\"enname\\\":\\\"const\\\",\\\"cnname\\\":\\\"\u5e38\u91cf\\\",\\\"value\\\":\\\"Y\\\"}]\",\n            \"rowOpType\": \"C\",\n            \"rowOpTargetId\": \"B037852BED9447F1A0346A239759348D\",\n            \"rowOpTargetName\": \"[\u5ba2\u6237\u4e2d\u5fc3]-[\u6280\u672f\u767d\u540d\u5355]-[\u67e5\u8be2\u662f\u5426\u5728\u767d\u540d\u5355\u4e2d]\",\n            \"rowSuccess\": \"Y\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"appId\\\":\\\"06F95C938FF04ACF83EABEFA8685C825\\\",\\\"srvModelId\\\":\\\"B037852BED9447F1A0346A239759348D\\\",\\\"srvModelCode\\\":\\\"queryByPk\\\",\\\"srvModelName\\\":\\\"\u5355\u6761\u67e5\u8be2\u670d\u52a1\\\",\\\"srvModelCatalog\\\":\\\"I01\\\",\\\"srvModelType\\\":5,\\\"packageId\\\":null,\\\"tableModelId\\\":\\\"8B4629A8ED244BAAAED00E543DBA95F4\\\",\\\"tableModelCode\\\":\\\"cus_white_list_tec\\\",\\\"tableModelName\\\":\\\"\u6280\u672f\u767d\u540d\u5355\\\",\\\"srvModelDesc\\\":null,\\\"createUser\\\":\\\"system\\\",\\\"createTime\\\":\\\"2021-05-31 14:48:27\\\",\\\"lastUpdateUser\\\":null,\\\"lastUpdateTime\\\":null,\\\"orderValue\\\":null,\\\"srvModelMethod\\\":null,\\\"appName\\\":\\\"\u5ba2\u6237\u4e2d\u5fc3\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"700DEFF3EF4947B98CFABD8FFE7B5F0D\",\n            \"tableRowNo\": 16,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": \"\u5982\u679c\u4e0d\u5728\u767d\u540d\u5355\u4e2d\",\n            \"rowCondExpression\": \"[{\\\"tdType\\\":\\\"FUNC\\\",\\\"enname\\\":\\\"isEmpty\\\",\\\"cnname\\\":\\\"\u5b57\u7b26\u4e32\u4e3a\u7a7a\\\"},{\\\"tdType\\\":\\\"F\\\",\\\"choice\\\":true,\\\"domainVarId\\\":\\\"38FD8C1983DC40608ECA72CD4EAD3544\\\",\\\"domainVarType\\\":\\\"D\\\",\\\"tableModelCode\\\":\\\"cus_white_list_tec14\\\",\\\"tableModelName\\\":\\\"[\u6280\u672f\u767d\u540d\u5355] [\u5e8f\u53f714\u51fa\u53c2]\\\",\\\"text\\\":\\\"[\u767d\u540d\u5355ID][cus_white_id]\\\",\\\"paramFieldCode\\\":\\\"cus_white_id\\\",\\\"paramFieldName\\\":\\\"\u767d\u540d\u5355ID\\\",\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"fieldId\\\":\\\"5CBDBC6DB4D44020A38D18FB5AD9440F\\\",\\\"objectId\\\":\\\"8B4629A8ED244BAAAED00E543DBA95F4\\\",\\\"fieldCode\\\":\\\"cus_white_id\\\",\\\"fieldName\\\":\\\"\u767d\u540d\u5355ID\\\",\\\"fieldDesc\\\":\\\"\u767d\u540d\u5355ID\\\",\\\"itemId\\\":\\\"CC989ACA9D644B3D99C9FF0E2988F1A3\\\",\\\"itemCode\\\":null,\\\"itemName\\\":null,\\\"fieldOrder\\\":1,\\\"fieldType\\\":\\\"varchar\\\",\\\"fieldLength\\\":32,\\\"fieldPrecision\\\":0,\\\"dictId\\\":null,\\\"fieldOption\\\":null,\\\"isPk\\\":\\\"Y\\\",\\\"isAllowNull\\\":\\\"N\\\",\\\"defValue\\\":null,\\\"createUser\\\":\\\"liaowc\\\",\\\"createTime\\\":\\\"2021-05-31 14:47:20\\\",\\\"lastModifyUser\\\":null,\\\"lastModifyTime\\\":null,\\\"dataStdFlag\\\":null,\\\"srvParamFlag\\\":\\\"03330000000000000000000000000000\\\",\\\"state\\\":\\\"open\\\",\\\"domId\\\":\\\"_easyui_tree_152\\\",\\\"target\\\":{},\\\"checked\\\":false}]\",\n            \"rowOpType\": \"C\",\n            \"rowOpTargetId\": \"3682EE97D3CA41DAAB7FFD7E20BA2DCD\",\n            \"rowOpTargetName\": \"[\u5ba2\u6237\u4e2d\u5fc3]-[\u610f\u5411\u5ba2\u6237\u4fe1\u606f]-[\u5355\u6761\u65b0\u589e\u670d\u52a1]\",\n            \"rowSuccess\": \"Y\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"appId\\\":\\\"06F95C938FF04ACF83EABEFA8685C825\\\",\\\"srvModelId\\\":\\\"3682EE97D3CA41DAAB7FFD7E20BA2DCD\\\",\\\"srvModelCode\\\":\\\"insertSingle\\\",\\\"srvModelName\\\":\\\"\u5355\u6761\u65b0\u589e\u670d\u52a1\\\",\\\"srvModelCatalog\\\":\\\"I01\\\",\\\"srvModelType\\\":2,\\\"packageId\\\":null,\\\"tableModelId\\\":\\\"4D0E303EE7DB4E5FAFFB0B646505DF6E\\\",\\\"tableModelCode\\\":\\\"cust_bf_rgst_inf\\\",\\\"tableModelName\\\":\\\"\u610f\u5411\u5ba2\u6237\u4fe1\u606f\\\",\\\"srvModelDesc\\\":null,\\\"createUser\\\":\\\"qiubc\\\",\\\"createTime\\\":\\\"2021-06-01 17:50:37\\\",\\\"lastUpdateUser\\\":null,\\\"lastUpdateTime\\\":null,\\\"orderValue\\\":null,\\\"srvModelMethod\\\":null,\\\"appName\\\":\\\"\u5ba2\u6237\u4e2d\u5fc3\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"51E17816397C4E499E493E7DAA344BAA\",\n            \"tableRowNo\": 17,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": \"\u5982\u679c\u4e0d\u5728\u767d\u540d\u5355\u4e2d\",\n            \"rowCondExpression\": \"[{\\\"tdType\\\":\\\"FUNC\\\",\\\"enname\\\":\\\"isEmpty\\\",\\\"cnname\\\":\\\"\u5b57\u7b26\u4e32\u4e3a\u7a7a\\\"},{\\\"tdType\\\":\\\"F\\\",\\\"choice\\\":true,\\\"domainVarId\\\":\\\"38FD8C1983DC40608ECA72CD4EAD3544\\\",\\\"domainVarType\\\":\\\"D\\\",\\\"tableModelCode\\\":\\\"cus_white_list_tec14\\\",\\\"tableModelName\\\":\\\"[\u6280\u672f\u767d\u540d\u5355] [\u5e8f\u53f714\u51fa\u53c2]\\\",\\\"text\\\":\\\"[\u767d\u540d\u5355ID][cus_white_id]\\\",\\\"paramFieldCode\\\":\\\"cus_white_id\\\",\\\"paramFieldName\\\":\\\"\u767d\u540d\u5355ID\\\",\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"fieldId\\\":\\\"5CBDBC6DB4D44020A38D18FB5AD9440F\\\",\\\"objectId\\\":\\\"8B4629A8ED244BAAAED00E543DBA95F4\\\",\\\"fieldCode\\\":\\\"cus_white_id\\\",\\\"fieldName\\\":\\\"\u767d\u540d\u5355ID\\\",\\\"fieldDesc\\\":\\\"\u767d\u540d\u5355ID\\\",\\\"itemId\\\":\\\"CC989ACA9D644B3D99C9FF0E2988F1A3\\\",\\\"itemCode\\\":null,\\\"itemName\\\":null,\\\"fieldOrder\\\":1,\\\"fieldType\\\":\\\"varchar\\\",\\\"fieldLength\\\":32,\\\"fieldPrecision\\\":0,\\\"dictId\\\":null,\\\"fieldOption\\\":null,\\\"isPk\\\":\\\"Y\\\",\\\"isAllowNull\\\":\\\"N\\\",\\\"defValue\\\":null,\\\"createUser\\\":\\\"liaowc\\\",\\\"createTime\\\":\\\"2021-05-31 14:47:20\\\",\\\"lastModifyUser\\\":null,\\\"lastModifyTime\\\":null,\\\"dataStdFlag\\\":null,\\\"srvParamFlag\\\":\\\"03330000000000000000000000000000\\\",\\\"state\\\":\\\"open\\\",\\\"domId\\\":\\\"_easyui_tree_152\\\",\\\"target\\\":{},\\\"checked\\\":false}]\",\n            \"rowOpType\": \"R\",\n            \"rowOpTargetId\": \"EA48E32E8C28405E9034F2589F17AC85\",\n            \"rowOpTargetName\": \"[\u670d\u52a1\u51fa\u53c2]-[\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2]\",\n            \"rowSuccess\": \"Y\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"text\\\":\\\"[\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2][CreidtChecko]\\\",\\\"state\\\":\\\"open\\\",\\\"choice\\\":true,\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"children\\\":[],\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"domainVarId\\\":\\\"EA48E32E8C28405E9034F2589F17AC85\\\",\\\"srvModelId\\\":\\\"E0DB9D32173D423E87C8D5B4AE41AD06\\\",\\\"domainVarCode\\\":\\\"CreidtChecko\\\",\\\"domainVarName\\\":\\\"\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2\\\",\\\"domainVarType\\\":\\\"O\\\",\\\"tableModelId\\\":\\\"97F1A25A0698466580D480545507F32E\\\",\\\"tableRowNo\\\":null,\\\"listFlag\\\":null,\\\"tableRowId\\\":null,\\\"domId\\\":\\\"_easyui_tree_2\\\",\\\"target\\\":{},\\\"checked\\\":false,\\\"id\\\":\\\"EA48E32E8C28405E9034F2589F17AC85\\\",\\\"code\\\":\\\"CreidtChecko\\\",\\\"name\\\":\\\"\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2\\\",\\\"type\\\":\\\"O\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"8A5CD4B6191F48838CEE4A36A045CB14\",\n            \"tableRowNo\": 18,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": \"\u5982\u679c\u4e0d\u5728\u767d\u540d\u5355\u4e2d\",\n            \"rowCondExpression\": \"[{\\\"tdType\\\":\\\"FUNC\\\",\\\"enname\\\":\\\"isEmpty\\\",\\\"cnname\\\":\\\"\u5b57\u7b26\u4e32\u4e3a\u7a7a\\\"},{\\\"tdType\\\":\\\"F\\\",\\\"choice\\\":true,\\\"domainVarId\\\":\\\"38FD8C1983DC40608ECA72CD4EAD3544\\\",\\\"domainVarType\\\":\\\"D\\\",\\\"tableModelCode\\\":\\\"cus_white_list_tec14\\\",\\\"tableModelName\\\":\\\"[\u6280\u672f\u767d\u540d\u5355] [\u5e8f\u53f714\u51fa\u53c2]\\\",\\\"text\\\":\\\"[\u767d\u540d\u5355ID][cus_white_id]\\\",\\\"paramFieldCode\\\":\\\"cus_white_id\\\",\\\"paramFieldName\\\":\\\"\u767d\u540d\u5355ID\\\",\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"fieldId\\\":\\\"5CBDBC6DB4D44020A38D18FB5AD9440F\\\",\\\"objectId\\\":\\\"8B4629A8ED244BAAAED00E543DBA95F4\\\",\\\"fieldCode\\\":\\\"cus_white_id\\\",\\\"fieldName\\\":\\\"\u767d\u540d\u5355ID\\\",\\\"fieldDesc\\\":\\\"\u767d\u540d\u5355ID\\\",\\\"itemId\\\":\\\"CC989ACA9D644B3D99C9FF0E2988F1A3\\\",\\\"itemCode\\\":null,\\\"itemName\\\":null,\\\"fieldOrder\\\":1,\\\"fieldType\\\":\\\"varchar\\\",\\\"fieldLength\\\":32,\\\"fieldPrecision\\\":0,\\\"dictId\\\":null,\\\"fieldOption\\\":null,\\\"isPk\\\":\\\"Y\\\",\\\"isAllowNull\\\":\\\"N\\\",\\\"defValue\\\":null,\\\"createUser\\\":\\\"liaowc\\\",\\\"createTime\\\":\\\"2021-05-31 14:47:20\\\",\\\"lastModifyUser\\\":null,\\\"lastModifyTime\\\":null,\\\"dataStdFlag\\\":null,\\\"srvParamFlag\\\":\\\"03330000000000000000000000000000\\\",\\\"state\\\":\\\"open\\\",\\\"domId\\\":\\\"_easyui_tree_152\\\",\\\"target\\\":{},\\\"checked\\\":false}]\",\n            \"rowOpType\": \"R\",\n            \"rowOpTargetId\": \"FB1C29D6B8D14B5A899914DFC33ED5E8\",\n            \"rowOpTargetName\": \"[\u670d\u52a1\u51fa\u53c2]-[\u6807\u51c6\u670d\u52a1\u51fa\u53c2]\",\n            \"rowSuccess\": \"N\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"text\\\":\\\"[\u6807\u51c6\u670d\u52a1\u51fa\u53c2][isrv_rsp_info]\\\",\\\"state\\\":\\\"open\\\",\\\"choice\\\":true,\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"children\\\":[],\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"domainVarId\\\":\\\"FB1C29D6B8D14B5A899914DFC33ED5E8\\\",\\\"srvModelId\\\":\\\"E0DB9D32173D423E87C8D5B4AE41AD06\\\",\\\"domainVarCode\\\":\\\"isrv_rsp_info\\\",\\\"domainVarName\\\":\\\"\u6807\u51c6\u670d\u52a1\u51fa\u53c2\\\",\\\"domainVarType\\\":\\\"O\\\",\\\"tableModelId\\\":\\\"8B532A09534D49029364B4922FAACF6D\\\",\\\"tableRowNo\\\":null,\\\"listFlag\\\":\\\"N\\\",\\\"tableRowId\\\":null,\\\"domId\\\":\\\"_easyui_tree_3\\\",\\\"target\\\":{},\\\"checked\\\":false,\\\"id\\\":\\\"FB1C29D6B8D14B5A899914DFC33ED5E8\\\",\\\"code\\\":\\\"isrv_rsp_info\\\",\\\"name\\\":\\\"\u6807\u51c6\u670d\u52a1\u51fa\u53c2\\\",\\\"type\\\":\\\"O\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"2EF6EE192A144A7687129CC26D5021B9\",\n            \"tableRowNo\": 19,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": null,\n            \"rowCondExpression\": null,\n            \"rowOpType\": \"C\",\n            \"rowOpTargetId\": \"3682EE97D3CA41DAAB7FFD7E20BA2DCD\",\n            \"rowOpTargetName\": \"[\u5ba2\u6237\u4e2d\u5fc3]-[\u610f\u5411\u5ba2\u6237\u4fe1\u606f]-[\u5355\u6761\u65b0\u589e\u670d\u52a1]\",\n            \"rowSuccess\": \"Y\",\n            \"rowFailed\": \"Y\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"appId\\\":\\\"06F95C938FF04ACF83EABEFA8685C825\\\",\\\"srvModelId\\\":\\\"3682EE97D3CA41DAAB7FFD7E20BA2DCD\\\",\\\"srvModelCode\\\":\\\"insertSingle\\\",\\\"srvModelName\\\":\\\"\u5355\u6761\u65b0\u589e\u670d\u52a1\\\",\\\"srvModelCatalog\\\":\\\"I01\\\",\\\"srvModelType\\\":2,\\\"packageId\\\":null,\\\"tableModelId\\\":\\\"4D0E303EE7DB4E5FAFFB0B646505DF6E\\\",\\\"tableModelCode\\\":\\\"cust_bf_rgst_inf\\\",\\\"tableModelName\\\":\\\"\u610f\u5411\u5ba2\u6237\u4fe1\u606f\\\",\\\"srvModelDesc\\\":null,\\\"createUser\\\":\\\"qiubc\\\",\\\"createTime\\\":\\\"2021-06-01 17:50:37\\\",\\\"lastUpdateUser\\\":null,\\\"lastUpdateTime\\\":null,\\\"orderValue\\\":null,\\\"srvModelMethod\\\":null,\\\"appName\\\":\\\"\u5ba2\u6237\u4e2d\u5fc3\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"B2327ACE32054B07B2ADBAD1CB02D380\",\n            \"tableRowNo\": 20,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": null,\n            \"rowCondExpression\": null,\n            \"rowOpType\": \"R\",\n            \"rowOpTargetId\": \"EA48E32E8C28405E9034F2589F17AC85\",\n            \"rowOpTargetName\": \"[\u670d\u52a1\u51fa\u53c2]-[\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2]\",\n            \"rowSuccess\": \"Y\",\n            \"rowFailed\": \"Y\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"text\\\":\\\"[\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2][CreidtChecko]\\\",\\\"state\\\":\\\"open\\\",\\\"choice\\\":true,\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"children\\\":[],\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"domainVarId\\\":\\\"EA48E32E8C28405E9034F2589F17AC85\\\",\\\"srvModelId\\\":\\\"E0DB9D32173D423E87C8D5B4AE41AD06\\\",\\\"domainVarCode\\\":\\\"CreidtChecko\\\",\\\"domainVarName\\\":\\\"\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2\\\",\\\"domainVarType\\\":\\\"O\\\",\\\"tableModelId\\\":\\\"97F1A25A0698466580D480545507F32E\\\",\\\"tableRowNo\\\":null,\\\"listFlag\\\":null,\\\"tableRowId\\\":null,\\\"domId\\\":\\\"_easyui_tree_2\\\",\\\"target\\\":{},\\\"checked\\\":false,\\\"id\\\":\\\"EA48E32E8C28405E9034F2589F17AC85\\\",\\\"code\\\":\\\"CreidtChecko\\\",\\\"name\\\":\\\"\u6388\u4fe1\u524d\u7f6e\u68c0\u67e5\u51fa\u53c2\\\",\\\"type\\\":\\\"O\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }, {\n            \"page\": 0,\n            \"size\": 0,\n            \"total\": 0,\n            \"rows\": 0,\n            \"order\": \"\",\n            \"loginUserId\": null,\n            \"loginUserOrgCode\": null,\n            \"loginUserLeageOrgCode\": null,\n            \"loginUserOrgLocation\": null,\n            \"tableRowId\": \"64EFC468644A4BEFB29304EE6312FB7A\",\n            \"tableRowNo\": 21,\n            \"srvModelId\": \"E0DB9D32173D423E87C8D5B4AE41AD06\",\n            \"rowCondName\": null,\n            \"rowCondExpression\": null,\n            \"rowOpType\": \"R\",\n            \"rowOpTargetId\": \"FB1C29D6B8D14B5A899914DFC33ED5E8\",\n            \"rowOpTargetName\": \"[\u670d\u52a1\u51fa\u53c2]-[\u6807\u51c6\u670d\u52a1\u51fa\u53c2]\",\n            \"rowSuccess\": \"N\",\n            \"rowFailed\": \"N\",\n            \"rowContent\": \"{\\\"targetInfo\\\":{\\\"text\\\":\\\"[\u6807\u51c6\u670d\u52a1\u51fa\u53c2][isrv_rsp_info]\\\",\\\"state\\\":\\\"open\\\",\\\"choice\\\":true,\\\"iconCls\\\":\\\"icon iconfont icon-shuxing\\\",\\\"children\\\":[],\\\"page\\\":0,\\\"size\\\":0,\\\"total\\\":0,\\\"rows\\\":0,\\\"order\\\":\\\"\\\",\\\"loginUserId\\\":null,\\\"loginUserOrgCode\\\":null,\\\"loginUserLeageOrgCode\\\":null,\\\"loginUserOrgLocation\\\":null,\\\"domainVarId\\\":\\\"FB1C29D6B8D14B5A899914DFC33ED5E8\\\",\\\"srvModelId\\\":\\\"E0DB9D32173D423E87C8D5B4AE41AD06\\\",\\\"domainVarCode\\\":\\\"isrv_rsp_info\\\",\\\"domainVarName\\\":\\\"\u6807\u51c6\u670d\u52a1\u51fa\u53c2\\\",\\\"domainVarType\\\":\\\"O\\\",\\\"tableModelId\\\":\\\"8B532A09534D49029364B4922FAACF6D\\\",\\\"tableRowNo\\\":null,\\\"listFlag\\\":\\\"N\\\",\\\"tableRowId\\\":null,\\\"domId\\\":\\\"_easyui_tree_3\\\",\\\"target\\\":{},\\\"checked\\\":false,\\\"id\\\":\\\"FB1C29D6B8D14B5A899914DFC33ED5E8\\\",\\\"code\\\":\\\"isrv_rsp_info\\\",\\\"name\\\":\\\"\u6807\u51c6\u670d\u52a1\u51fa\u53c2\\\",\\\"type\\\":\\\"O\\\"}}\",\n            \"rowOpCopyId\": null,\n            \"rowCondEffect\": 1\n        }]";
        List tables = JSON.parseArray((String)json, OsrvArrangeTableDTO.class);
        String srvModelId = "C4275CC403104600B21E4A6E673200FE";
        DrawOsrvArrangeTable draw = new DrawOsrvArrangeTable();
        File file = draw.generateImage(srvModelId, tables, new File("F:/yusys/temp/"));
        System.out.println(file);
    }
}

