/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.application.service.utils;

import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsParamPortalService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.portal.console.application.service.task.AppRepoPullTask;
import com.irdstudio.allinapaas.portal.console.application.service.task.AppTemplateRepoPullTask;
import com.irdstudio.allinapaas.portal.console.application.service.utils.SdEnvUtil;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.util.FreemarkerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiddleAppConfigFileGenerate {
    private static final Logger logger = LoggerFactory.getLogger(MiddleAppConfigFileGenerate.class);

    public void pullTemplateRepo(String appTemplateId) {
        AppTemplateRepoPullTask templateRepoPullTask = new AppTemplateRepoPullTask(appTemplateId);
        templateRepoPullTask.syncRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File obtainConfigFile(String appId, String envId) {
        File configFile;
        block5: {
            configFile = null;
            try {
                DataSource dataSource = (DataSource)SpringContextUtils.getBean(DataSource.class);
                PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
                PaasAppsInfoDTO appParam = new PaasAppsInfoDTO();
                appParam.setAppId(appId);
                PaasAppsInfoDTO appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appParam);
                Map<String, Object> root = this.loadAppData(appInfo, envId, true);
                String configFileName = MapUtils.getString(root, (Object)"config.file.name");
                String configFilePath = MapUtils.getString(root, (Object)"config.file.path");
                String configFileDir = this.getAppConfigFilePath(appInfo);
                File file = new File(configFileDir + File.separator + this.wrapperConfigFileNameWithEnvId(configFileName, envId));
                if (file.exists()) {
                    configFile = file;
                    break block5;
                }
                this.produceCodeFile(configFileName, envId, appInfo, root);
                configFile = file;
            }
            catch (Exception e) {
                logger.error("\u4e2d\u95f4\u4ef6\u5e94\u7528{}\u914d\u7f6e\u6587\u4ef6\u83b7\u53d6\u5f02\u5e38: {}", new Object[]{appId, e.getMessage(), e});
            }
        }
        return configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File updateConfigFile(String appId, String envId, String configFileName, String content) {
        Object conn = null;
        FileOutputStream out = null;
        File configFile = null;
        try {
            PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            PaasAppsInfoDTO appParam = new PaasAppsInfoDTO();
            appParam.setAppId(appId);
            PaasAppsInfoDTO appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appParam);
            Map<String, Object> root = this.loadAppData(appInfo, envId, false);
            String configFileDir = this.getAppConfigFilePath(appInfo);
            File file = new File(configFileDir + File.separator + configFileName);
            out = new FileOutputStream(file);
            IOUtils.write((String)content, (OutputStream)out, (String)"UTF-8");
            out.flush();
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (Exception e) {
            logger.error("\u4e2d\u95f4\u4ef6\u5e94\u7528{}\u914d\u7f6e\u6587\u4ef6\u66f4\u65b0\u5f02\u5e38: {}", new Object[]{appId, e.getMessage(), e});
        }
        finally {
            IOUtils.closeQuietly(out);
        }
        return configFile;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] obtainDeployConfigFile(String appId, String envId) {
        String[] stringArray;
        FileInputStream input;
        block12: {
            Object[] objectArray;
            String configFileName;
            String configTemplateFileName;
            String configFileDir;
            Map<String, Object> root;
            PaasAppsInfoDTO appInfo;
            String fileName;
            String content;
            block13: {
                File localConfigFile;
                File[] configList;
                Object conn = null;
                input = null;
                content = null;
                fileName = null;
                PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
                PaasAppsInfoDTO appParam = new PaasAppsInfoDTO();
                appParam.setAppId(appId);
                appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appParam);
                root = this.loadAppData(appInfo, envId, true);
                AppTemplateRepoPullTask templateRepoPullTask = new AppTemplateRepoPullTask(appInfo.getAppTemplateId());
                templateRepoPullTask.syncRun();
                String templateRoot = templateRepoPullTask.getAppTemplatePath();
                AppRepoPullTask appRepoPullTask = new AppRepoPullTask(appInfo.getAppId(), appInfo.getAppGitUrl());
                appRepoPullTask.syncRun();
                String appRoot = appRepoPullTask.getAppPath();
                configFileDir = this.getAppConfigFilePath(appInfo);
                configTemplateFileName = "";
                File[] configTempList = new File(templateRoot, String.format("%s-code", appInfo.getAppTemplateId())).listFiles();
                if (configTempList != null) {
                    File configTemp = configTempList[0];
                    String configFileName2 = configTemp.getName();
                    configTemplateFileName = StringUtils.replace((String)configFileName2, (String)".vm", (String)"");
                }
                if (StringUtils.isBlank((String)configTemplateFileName)) {
                    throw new RuntimeException("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u6a21\u677f\u5f02\u5e38");
                }
                configFileName = this.wrapperConfigFileNameWithEnvId(configTemplateFileName, envId);
                File configDir = new File(appRoot, "config");
                if (StringUtils.isNotBlank((String)appRoot) && configDir.exists() && (configList = configDir.listFiles()) != null) {
                    for (File config : configList) {
                        if (!config.isFile() || !StringUtils.equals((String)config.getName(), (String)configFileName)) continue;
                        File appConfigDir = new File(configFileDir);
                        if (!appConfigDir.exists()) {
                            appConfigDir.mkdirs();
                        }
                        File newConfig = new File(appConfigDir, config.getName());
                        FileUtils.copyFile((File)config, (File)newConfig);
                        input = new FileInputStream(newConfig);
                        content = IOUtils.toString((InputStream)input, (String)"UTF-8");
                        fileName = configFileName;
                        stringArray = new String[]{fileName, content};
                        break block12;
                    }
                }
                if (!(localConfigFile = new File(configFileDir, configFileName)).exists()) break block13;
                input = new FileInputStream(localConfigFile);
                content = IOUtils.toString((InputStream)input, (String)"UTF-8");
                fileName = configFileName;
                objectArray = new String[]{fileName, content};
                IOUtils.closeQuietly((InputStream)input);
                return objectArray;
            }
            try {
                this.produceCodeFile(configTemplateFileName, envId, appInfo, root);
                input = new FileInputStream(new File(configFileDir, configFileName));
                content = IOUtils.toString((InputStream)input, (String)"UTF-8");
                fileName = configFileName;
                objectArray = new String[]{fileName, content};
            }
            catch (RuntimeException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        logger.error("\u4e2d\u95f4\u4ef6\u5e94\u7528{}\u914d\u7f6e\u6587\u4ef6\u66f4\u65b0\u5f02\u5e38: {}", new Object[]{appId, e2.getMessage(), e2});
                        throw new RuntimeException("\u83b7\u53d6\u5e94\u7528\u914d\u7f6e\u5f02\u5e38:" + e2.getMessage(), e2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)input);
            return objectArray;
        }
        IOUtils.closeQuietly((InputStream)input);
        return stringArray;
    }

    public String getFileType(File file) {
        String fileName = file.getName();
        if (StringUtils.lastIndexOf((String)fileName, (String)".") > 0) {
            return fileName.substring(StringUtils.lastIndexOf((String)fileName, (String)".") + 1);
        }
        return "";
    }

    public String getFileType(String fileName) {
        if (StringUtils.lastIndexOf((String)fileName, (String)".") > 0) {
            return fileName.substring(StringUtils.lastIndexOf((String)fileName, (String)".") + 1);
        }
        return "";
    }

    private Map<String, Object> loadAppData(PaasAppsInfoDTO appInfo, String envId, boolean loadEcs) throws Exception {
        PaasAppsParamPortalService paasAppsParamPortalService = (PaasAppsParamPortalService)SpringContextUtils.getBean(PaasAppsParamPortalService.class);
        PaasEcsInfoService paasEcsInfoService = (PaasEcsInfoService)SpringContextUtils.getBean(PaasEcsInfoService.class);
        PaasEnvInfoService paasEnvInfoService = (PaasEnvInfoService)SpringContextUtils.getBean(PaasEnvInfoService.class);
        HashMap<String, Object> root = new HashMap<String, Object>();
        PaasEnvInfoDTO envInfo = new PaasEnvInfoDTO();
        envInfo.setEnvId(envId);
        envInfo = (PaasEnvInfoDTO)paasEnvInfoService.queryByPk((Object)envInfo);
        root.put("env", BeanUtility.bean2Map((Object)envInfo));
        root.put("appInfo", BeanUtility.bean2Map((Object)appInfo));
        Map appsParam = paasAppsParamPortalService.queryAppParamMap(appInfo.getAppId(), envId);
        root.putAll(appsParam);
        if (loadEcs) {
            PaasEcsInfoDTO envEcsParam = new PaasEcsInfoDTO();
            envEcsParam.setEnvId(envId);
            envEcsParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
            List notAppEcsList = paasEcsInfoService.queryListByPage((Object)envEcsParam);
            envEcsParam.setSubsId(appInfo.getSubsId());
            List subsEcsList = paasEcsInfoService.queryListByPage((Object)envEcsParam);
            notAppEcsList.addAll(subsEcsList);
            envEcsParam.setAppId(appInfo.getAppId());
            List ecsList = paasEcsInfoService.queryListByPage((Object)envEcsParam);
            notAppEcsList.addAll(ecsList);
            ecsList = notAppEcsList;
            if (CollectionUtils.isNotEmpty((Collection)ecsList)) {
                for (PaasEcsInfoDTO ecs : ecsList) {
                    Map ecsMap = BeanUtility.bean2Map((Object)ecs);
                    HashMap ecsParamMap = new HashMap();
                    for (Map.Entry entry : ecsMap.entrySet()) {
                        String key = TmModelUtil.propertyToField((String)((String)entry.getKey())).toUpperCase();
                        ecsParamMap.put(key, entry.getValue());
                    }
                    root.put(ecs.getPaasDuId(), ecsParamMap);
                }
            }
        }
        return root;
    }

    private String getAppConfigFilePath(PaasAppsInfoDTO appInfo) {
        String targetPath = SdEnvUtil.PROJECT_PATH + appInfo.getAppId() + File.separator + "config";
        targetPath = this.pathMatchSystem(targetPath);
        return targetPath;
    }

    private String wrapperConfigFileNameWithEnvId(String configFileName, String envId) {
        if (StringUtils.lastIndexOf((String)configFileName, (String)".") > 0) {
            int dotIdx = StringUtils.lastIndexOf((String)configFileName, (String)".");
            StringBuffer sb = new StringBuffer(configFileName);
            sb.insert(dotIdx, "-" + envId);
            return sb.toString();
        }
        return configFileName + "-" + envId;
    }

    private void produceCodeFile(String templateFile, String envId, PaasAppsInfoDTO appInfo, Map<String, Object> mapData) throws Exception {
        CodeTemplateDataBo ctdb = new CodeTemplateDataBo();
        ctdb.getMapData().putAll(mapData);
        String appCode = SdEnvUtil.wrapperAppCode(appInfo.getAppCode());
        String templatePath = SdEnvUtil.getTemplatePath(appInfo.getAppTemplateId());
        ctdb.getMapData().put("TEMPLATE_PATH", templatePath);
        String targetPath = this.getAppConfigFilePath(appInfo);
        if (!MiddleAppConfigFileGenerate.checkFileExist(targetPath).booleanValue()) {
            File targetDic = new File(targetPath);
            targetDic.mkdirs();
        }
        String fileNameResult = templateFile;
        String outputFileName = targetPath + File.separator + this.wrapperConfigFileNameWithEnvId(fileNameResult, envId);
        ctdb.getMapData().put("TmModelUtil", new TmModelUtil());
        FreemarkerUtil.produceSingleFile((CodeTemplateDataBo)ctdb, (String)templatePath, (String)(templateFile + ".vm"), (String)outputFileName);
    }

    public static final Boolean checkFileExist(String filepath) {
        File file = new File(filepath);
        return file.exists();
    }

    private String pathMatchSystem(String path) {
        String targetSeparetor = File.separator;
        if (targetSeparetor.equals("\\")) {
            if (path.contains("/")) {
                // empty if block
            }
        } else if (targetSeparetor.equals("/") && path.contains("\\")) {
            path = path.replaceAll("\\\\", "/");
        }
        return path;
    }
}

