/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.quality.console.application.service.check.scheme.impl.srv;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.quality.console.application.service.check.conn.IConnPool;
import com.irdstudio.allinapaas.quality.console.application.service.check.scheme.inf.CheckJavaRule;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultDTO;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultDtlDTO;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultDtlService;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckResultService;
import com.irdstudio.allinapaas.quality.console.facade.dto.SCheckRuleDTO;
import com.irdstudio.allinapaas.quality.console.types.CheckResult;
import com.irdstudio.allinapaas.quality.console.types.CheckScope;
import com.irdstudio.allinapaas.quality.console.types.RuleResult;
import com.irdstudio.allinapaas.quality.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.facade.DictOptionEnumService;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.dto.DictOptionEnumDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.allinrdm.dev.console.facade.IsrvEvalInsertService;
import com.irdstudio.allinrdm.dev.console.facade.IsrvEvalOutService;
import com.irdstudio.allinrdm.dev.console.facade.IsrvEvalUpdateService;
import com.irdstudio.allinrdm.dev.console.facade.IsrvSqlCondService;
import com.irdstudio.allinrdm.dev.console.facade.OsrvArrangeSectionService;
import com.irdstudio.allinrdm.dev.console.facade.OsrvArrangeTableService;
import com.irdstudio.allinrdm.dev.console.facade.OsrvArrangeVarService;
import com.irdstudio.allinrdm.dev.console.facade.OsrvEvalIsrvService;
import com.irdstudio.allinrdm.dev.console.facade.OsrvEvalVarService;
import com.irdstudio.allinrdm.dev.console.facade.SrvErrorMappingService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelConditionService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelExpressionService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelExpvarService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelInoutService;
import com.irdstudio.allinrdm.dev.console.facade.SrvModelValidateService;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvArrangeSectionDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvArrangeTableDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvArrangeVarDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvEvalIsrvDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.OsrvEvalVarDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvErrorMappingDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelConditionDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelExpvarDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.SrvModelValidateDTO;
import com.irdstudio.allinrdm.dev.console.types.CondEvalWay;
import com.irdstudio.allinrdm.dev.console.types.DomainEvalWay;
import com.irdstudio.allinrdm.dev.console.types.DomainVarType;
import com.irdstudio.allinrdm.dev.console.types.RowOpType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAS103Rule
implements CheckJavaRule {
    private static final Logger logger = LoggerFactory.getLogger(RAS103Rule.class);
    private boolean genDtl;
    private SCheckRuleDTO rule;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(String serialNo, SCheckRuleDTO rule, Map<String, Object> param, IConnPool connTool) {
        this.rule = rule;
        this.genDtl = StringUtils.equals((CharSequence)rule.getRuleGenDtl(), (CharSequence)YesOrNO.YES.getCode());
        SCheckResultDTO ruleResult = new SCheckResultDTO();
        ruleResult.setSerialNo(serialNo);
        ruleResult.setSchemeNo(rule.getSchemeNo());
        ruleResult.setRuleId(rule.getRuleId());
        ruleResult.setRuleName(rule.getRuleName());
        RuleResult flag = RuleResult.Pass;
        ArrayList<SCheckResultDtlDTO> ruleResultDtlList = new ArrayList<SCheckResultDtlDTO>();
        CheckScope ruleScope = (CheckScope)param.get("ruleScope");
        boolean resultFlag = true;
        Connection conn = null;
        try {
            conn = connTool.getConnection();
            SrvModelInfoService srvModelInfoService = (SrvModelInfoService)SpringContextUtils.getBean(SrvModelInfoService.class);
            SrvModelInfoDTO srvParam = new SrvModelInfoDTO();
            if (ruleScope == CheckScope.Subs) {
                String srvModelId = MapUtils.getString(param, (Object)"srvModelId");
                srvParam.setSrvModelId(srvModelId);
            } else if (ruleScope == CheckScope.Subs) {
                String subsId = MapUtils.getString(param, (Object)"subsId");
                srvParam.setSubsId(subsId);
            } else {
                String appId = MapUtils.getString(param, (Object)"appId");
                srvParam.setAppId(appId);
            }
            srvParam.setSrvModelCatalogs(Arrays.asList(SrvModelCatalogEnum.ComponentServer.getCode(), SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode(), SrvModelCatalogEnum.SdkServer.getCode()));
            List checkList = srvModelInfoService.queryList((Object)srvParam);
            for (SrvModelInfoDTO srvModelInfo : checkList) {
                RuleResult tmpFlag = this.checkSrvModelInfo(srvModelInfo, ruleResultDtlList, rule, param, conn = connTool.getConnection(conn));
                if (tmpFlag == RuleResult.Pass) continue;
                flag = tmpFlag;
            }
        }
        catch (Exception e) {
            logger.error("\u9886\u57df\u670d\u52a1\u6838\u9a8c " + e.getMessage(), (Throwable)e);
            resultFlag = false;
            ruleResult.setRuleResult(flag.getCode());
            ruleResult.setCreateUser(rule.getLoginUserId());
            ruleResult.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            ruleResult.setRuleResult(RuleResult.Error.getCode());
            try {
                SCheckResultService sCheckResultService = (SCheckResultService)SpringContextUtils.getBean(SCheckResultService.class);
                sCheckResultService.insert((Object)ruleResult);
                if (conn != null) {
                    connTool.releaseConnection(conn);
                }
            }
            catch (Exception e1) {
                logger.error("\u6821\u9a8c\u63d2\u4ef6\u4fdd\u5b58\u6821\u9a8c\u7ed3\u679c\u5f02\u5e38 {}", (Object)e1.getMessage(), (Object)e1);
                if (conn != null) {
                    connTool.releaseConnection(conn);
                }
            }
        }
        finally {
            if (conn != null) {
                connTool.releaseConnection(conn);
            }
        }
        ruleResult.setRuleResult(flag.getCode());
        ruleResult.setCreateUser(rule.getLoginUserId());
        ruleResult.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        try {
            SCheckResultService sCheckResultService = (SCheckResultService)SpringContextUtils.getBean(SCheckResultService.class);
            SCheckResultDtlService sCheckResultDtlService = (SCheckResultDtlService)SpringContextUtils.getBean(SCheckResultDtlService.class);
            sCheckResultService.insert((Object)ruleResult);
            if (CollectionUtils.isNotEmpty(ruleResultDtlList)) {
                for (SCheckResultDtlDTO dtl : ruleResultDtlList) {
                    String subsId = MapUtils.getString(param, (Object)"subsId");
                    String subsCode = MapUtils.getString(param, (Object)"subsCode");
                    String subsName = MapUtils.getString(param, (Object)"subsName");
                    String appId = MapUtils.getString(param, (Object)"appId");
                    String appCode = MapUtils.getString(param, (Object)"appCode");
                    String appName = MapUtils.getString(param, (Object)"appName");
                    String appType = MapUtils.getString(param, (Object)"appType");
                    String objectId = MapUtils.getString(param, (Object)"objectId");
                    String objectCode = MapUtils.getString(param, (Object)"objectCode");
                    String objectName = MapUtils.getString(param, (Object)"objectName");
                    String dtlId = UUIDUtil.getUUID();
                    dtl.setSerialNo(serialNo);
                    dtl.setRuleId(rule.getRuleId());
                    dtl.setRuleName(rule.getRuleName());
                    dtl.setDtlId(dtlId);
                    dtl.setAppId(appId);
                    dtl.setAppCode(appCode);
                    dtl.setAppName(appName);
                    dtl.setSubsId(subsId);
                    dtl.setSubsCode(subsCode);
                    dtl.setSubsName(subsName);
                    dtl.setAppType(appType);
                    dtl.setObjectId(objectId);
                    dtl.setObjectCode(objectCode);
                    dtl.setObjectName(objectName);
                    dtl.setCreateUser(rule.getLoginUserId());
                }
                sCheckResultDtlService.batchInsert(ruleResultDtlList);
            }
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u63d2\u4ef6\u4fdd\u5b58\u6821\u9a8c\u7ed3\u679c\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (conn != null) {
                connTool.releaseConnection(conn);
            }
        }
        return resultFlag;
    }

    private RuleResult checkSrvModelInfo(SrvModelInfoDTO srvModelInfo, List<SCheckResultDtlDTO> ruleResultDtlList, SCheckRuleDTO rule, Map<String, Object> param, Connection conn) throws Exception {
        RuleResult flag = RuleResult.Pass;
        boolean genDtl = StringUtils.equals((CharSequence)rule.getRuleGenDtl(), (CharSequence)YesOrNO.YES.getCode());
        String testExp = rule.getRuleSucCondition();
        String errorMsgExp = rule.getRuleErrDesc();
        SrvModelInfoService srvModelInfoService = (SrvModelInfoService)SpringContextUtils.getBean(SrvModelInfoService.class);
        SrvModelInoutService srvModelInoutService = (SrvModelInoutService)SpringContextUtils.getBean(SrvModelInoutService.class);
        ModelTableFieldService modelTableFieldService = (ModelTableFieldService)SpringContextUtils.getBean(ModelTableFieldService.class);
        IsrvEvalUpdateService isrvEvalUpdateService = (IsrvEvalUpdateService)SpringContextUtils.getBean(IsrvEvalUpdateService.class);
        IsrvEvalInsertService isrvEvalInsertService = (IsrvEvalInsertService)SpringContextUtils.getBean(IsrvEvalInsertService.class);
        IsrvEvalOutService isrvEvalOutService = (IsrvEvalOutService)SpringContextUtils.getBean(IsrvEvalOutService.class);
        IsrvSqlCondService isrvSqlCondService = (IsrvSqlCondService)SpringContextUtils.getBean(IsrvSqlCondService.class);
        SrvModelValidateService srvModelValidateService = (SrvModelValidateService)SpringContextUtils.getBean(SrvModelValidateService.class);
        OsrvArrangeSectionService osrvArrangeSectionService = (OsrvArrangeSectionService)SpringContextUtils.getBean(OsrvArrangeSectionService.class);
        OsrvArrangeVarService osrvArrangeVarService = (OsrvArrangeVarService)SpringContextUtils.getBean(OsrvArrangeVarService.class);
        OsrvArrangeTableService osrvArrangeTableService = (OsrvArrangeTableService)SpringContextUtils.getBean(OsrvArrangeTableService.class);
        OsrvEvalIsrvService osrvEvalIsrvService = (OsrvEvalIsrvService)SpringContextUtils.getBean(OsrvEvalIsrvService.class);
        OsrvEvalVarService osrvEvalVarService = (OsrvEvalVarService)SpringContextUtils.getBean(OsrvEvalVarService.class);
        String srvModelId = srvModelInfo.getSrvModelId();
        OsrvArrangeSectionDTO sectionParam = new OsrvArrangeSectionDTO();
        sectionParam.setSrvModelId(srvModelInfo.getSrvModelId());
        sectionParam.setAppId(srvModelInfo.getAppId());
        List sectionList = osrvArrangeSectionService.queryList((Object)sectionParam);
        HashMap<String, OsrvArrangeSectionDTO> sectionMap = new HashMap<String, OsrvArrangeSectionDTO>();
        if (CollectionUtils.isNotEmpty((Collection)sectionList)) {
            for (OsrvArrangeSectionDTO section : sectionList) {
                sectionMap.put(section.getSectionId(), section);
            }
        }
        OsrvArrangeTableDTO tableParam = new OsrvArrangeTableDTO();
        tableParam.setSrvModelId(srvModelId);
        List tableRows = osrvArrangeTableService.queryList((Object)tableParam);
        if (CollectionUtils.isNotEmpty((Collection)tableRows)) {
            for (OsrvArrangeTableDTO row : tableRows) {
                CheckResult cr;
                String checkDesc;
                SCheckResultDtlDTO dtl;
                List evalList;
                OsrvEvalIsrvDTO evalParam;
                OsrvArrangeSectionDTO tbSection = (OsrvArrangeSectionDTO)sectionMap.get(row.getSectionId());
                if (RowOpType.Serve.getCode().equals(row.getRowOpType()) || RowOpType.TServe.getCode().equals(row.getRowOpType()) || RowOpType.BServe.getCode().equals(row.getRowOpType()) || RowOpType.RServe.getCode().equals(row.getRowOpType()) || RowOpType.SServe.getCode().equals(row.getRowOpType())) {
                    CheckResult cr2;
                    SrvModelInfoDTO srvModelParam = new SrvModelInfoDTO();
                    srvModelParam.setSrvModelId(row.getRowOpTargetId());
                    SrvModelInfoDTO opTarget = (SrvModelInfoDTO)srvModelInfoService.queryByPk((Object)srvModelParam);
                    if (opTarget == null && (cr2 = CheckResult.Fail) != CheckResult.Pass) {
                        flag = RuleResult.Fail;
                        if (genDtl) {
                            SCheckResultDtlDTO dtl2 = new SCheckResultDtlDTO();
                            dtl2.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                            dtl2.setCheckResult(cr2.getCode());
                            String checkDesc2 = String.format("%s %s \u7247\u6bb5[%s]\u7b2c[%s]\u884c\u8c03\u7528\u670d\u52a1[%s]\u672a\u5b9a\u4e49", srvModelInfo.getSrvModelName(), srvModelInfo.getSrvModelCode(), tbSection.getSectionDesc(), row.getTableRowNo(), row.getRowOpTargetName());
                            dtl2.setCheckDesc(checkDesc2);
                            ruleResultDtlList.add(dtl2);
                        }
                    }
                    evalParam = new OsrvEvalIsrvDTO();
                    evalParam.setTableRowId(row.getTableRowId());
                    evalList = osrvEvalIsrvService.queryList((Object)evalParam);
                    boolean breakOutFlag = false;
                    if (CollectionUtils.isNotEmpty((Collection)evalList)) {
                        for (OsrvEvalIsrvDTO eval : evalList) {
                            this.validateAssign(srvModelInfo, String.format("%s\u7b2c%s\u884c", tbSection.getSectionDesc(), row.getTableRowNo()), eval.getIsrvEvalWay(), eval.getEvalContent(), ruleResultDtlList, conn);
                        }
                    }
                    if (!breakOutFlag) continue;
                    break;
                }
                if (StringUtils.equals((CharSequence)row.getRowOpType(), (CharSequence)RowOpType.EXIT.getCode())) continue;
                if (StringUtils.equals((CharSequence)row.getRowOpType(), (CharSequence)RowOpType.SubSection.getCode())) {
                    CheckResult cr3;
                    OsrvArrangeSectionDTO subSection = (OsrvArrangeSectionDTO)sectionMap.get(row.getRowOpTargetId());
                    if (subSection != null || (cr3 = CheckResult.Fail) == CheckResult.Pass) continue;
                    flag = RuleResult.Fail;
                    if (!genDtl) continue;
                    dtl = new SCheckResultDtlDTO();
                    dtl.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                    dtl.setCheckResult(cr3.getCode());
                    checkDesc = String.format("%s %s \u7247\u6bb5[%s]\u7b2c[%s]\u884c%s[%s]\u672a\u5b9a\u4e49", srvModelInfo.getSrvModelName(), srvModelInfo.getSrvModelCode(), tbSection.getSectionDesc(), row.getTableRowNo(), RowOpType.SubSection.getName(), row.getRowOpTargetName());
                    dtl.setCheckDesc(checkDesc);
                    ruleResultDtlList.add(dtl);
                    continue;
                }
                OsrvArrangeVarDTO varTarget = osrvArrangeVarService.queryByDomainVarId(srvModelId, row.getRowOpTargetId());
                if (varTarget == null && (cr = CheckResult.Fail) != CheckResult.Pass) {
                    flag = RuleResult.Fail;
                    if (genDtl) {
                        dtl = new SCheckResultDtlDTO();
                        dtl.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                        dtl.setCheckResult(cr.getCode());
                        checkDesc = String.format("%s %s \u7247\u6bb5[%s]\u7b2c[%s]\u884c\u8d4b\u503c\u53d8\u91cf[%s]\u672a\u5b9a\u4e49", srvModelInfo.getSrvModelName(), srvModelInfo.getSrvModelCode(), tbSection.getSectionDesc(), row.getTableRowNo(), row.getRowOpTargetName());
                        dtl.setCheckDesc(checkDesc);
                        ruleResultDtlList.add(dtl);
                    }
                }
                boolean breakOutFlag = false;
                if (varTarget.getDomainVarType().equals(DomainVarType.Var.getCode())) {
                    evalParam = new OsrvEvalVarDTO();
                    evalParam.setTableRowId(row.getTableRowId());
                    evalList = osrvEvalVarService.queryList((Object)evalParam);
                    if (CollectionUtils.isNotEmpty((Collection)evalList)) {
                        for (OsrvEvalVarDTO eval : evalList) {
                            this.validateAssign(srvModelInfo, String.format("%s\u7b2c%s\u884c", tbSection.getSectionDesc(), row.getTableRowNo()), eval.getDomainEvalWay(), eval.getEvalContent(), ruleResultDtlList, conn);
                        }
                    }
                } else {
                    evalParam = new OsrvEvalIsrvDTO();
                    evalParam.setTableRowId(row.getTableRowId());
                    evalList = osrvEvalIsrvService.queryList((Object)evalParam);
                    if (CollectionUtils.isNotEmpty((Collection)evalList)) {
                        for (OsrvEvalVarDTO eval : evalList) {
                            this.validateAssign(srvModelInfo, String.format("%s\u7b2c%s\u884c", tbSection.getSectionDesc(), row.getTableRowNo()), eval.getIsrvEvalWay(), eval.getEvalContent(), ruleResultDtlList, conn);
                        }
                    }
                }
                if (!breakOutFlag) continue;
                break;
            }
        }
        this.validateCondition(srvModelInfo, ruleResultDtlList, conn);
        return flag;
    }

    private boolean validateAssign(SrvModelInfoDTO srvModelInfo, String rowTargetName, String evalWay, String evalContent, List<SCheckResultDtlDTO> ruleResultDtlList, Connection conn) throws Exception {
        return this.validateAssign(srvModelInfo, null, rowTargetName, evalWay, evalContent, ruleResultDtlList, conn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateAssign(SrvModelInfoDTO srvModelInfo, SrvModelConditionDTO cond, String rowTargetName, String evalWay, String evalContent, List<SCheckResultDtlDTO> ruleResultDtlList, Connection conn) throws Exception {
        OsrvArrangeVarService osrvArrangeVarService = (OsrvArrangeVarService)SpringContextUtils.getBean(OsrvArrangeVarService.class);
        ModelTableFieldService modelTableFieldService = (ModelTableFieldService)SpringContextUtils.getBean(ModelTableFieldService.class);
        SrvModelExpressionService srvModelExpressionService = (SrvModelExpressionService)SpringContextUtils.getBean(SrvModelExpressionService.class);
        SrvModelExpvarService srvModelExpvarService = (SrvModelExpvarService)SpringContextUtils.getBean(SrvModelExpvarService.class);
        String srvModelId = srvModelInfo.getSrvModelId();
        boolean valid = true;
        if (DomainEvalWay.FORMULA.getCode().equals(evalWay)) {
            try {
                Map formulaExpression = (Map)JSON.parseObject((String)evalContent, Map.class);
                String expId = MapUtils.getString((Map)formulaExpression, (Object)"expId");
                SrvModelExpvarDTO expVarParam = new SrvModelExpvarDTO();
                expVarParam.setSrvModelId(srvModelInfo.getSrvModelId());
                expVarParam.setExpId(expId);
                List expVarList = srvModelExpvarService.queryList((Object)expVarParam);
                HashMap expVarMap = new HashMap(expVarList.size());
                for (SrvModelExpvarDTO expVar : expVarList) {
                    String varEvalWay = expVar.getEvalWay();
                    String varEvalContent = expVar.getEvalContent();
                    this.validateCondContent(srvModelInfo, cond, varEvalWay, varEvalContent, ruleResultDtlList, conn);
                }
                return valid;
            }
            catch (Exception e) {
                valid = false;
                CheckResult cr = CheckResult.Fail;
                if (cr == CheckResult.Pass || !this.genDtl) return valid;
                SCheckResultDtlDTO dtl = new SCheckResultDtlDTO();
                dtl.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                dtl.setCheckResult(cr.getCode());
                String checkDesc = "";
                if (cond != null) {
                    String condName = this.searchCondName(cond, conn);
                    checkDesc = String.format("%s %s %s-%s\u8fd0\u7b97\u8868\u8fbe\u5f0f\u89e3\u6790\u9519\u8bef", srvModelInfo.getSrvModelName(), srvModelInfo.getSrvModelCode(), condName, cond.getCondName());
                } else {
                    checkDesc = String.format("%s %s %s\u8fd0\u7b97\u8868\u8fbe\u5f0f\u89e3\u6790\u9519\u8bef", srvModelInfo.getSrvModelName(), srvModelInfo.getSrvModelCode(), rowTargetName);
                }
                dtl.setCheckDesc(checkDesc);
                ruleResultDtlList.add(dtl);
                return valid;
            }
        } else {
            if (!DomainEvalWay.ASSIGN.getCode().equals(evalWay)) return valid;
            Map map = (Map)JSON.parseObject((String)evalContent, Map.class);
            String domainVarId = MapUtils.getString((Map)map, (Object)"domainVarId", (String)"");
            String domainVarType = MapUtils.getString((Map)map, (Object)"domainVarType", (String)"");
            String tableModelCode = MapUtils.getString((Map)map, (Object)"tableModelCode", (String)"");
            String tableModelName = MapUtils.getString((Map)map, (Object)"tableModelName", (String)"");
            String tdType = MapUtils.getString((Map)map, (Object)"tdType");
            String objectId = MapUtils.getString((Map)map, (Object)"objectId");
            String paramFieldCode = MapUtils.getString((Map)map, (Object)"paramFieldCode", (String)"");
            OsrvArrangeVarDTO varTarget = osrvArrangeVarService.queryByDomainVarId(srvModelId, domainVarId);
            if (varTarget == null) {
                OsrvArrangeVarDTO varParam = new OsrvArrangeVarDTO();
                varParam.setSrvModelId(srvModelId);
                varParam.setTableModelId(objectId);
                varParam.setDomainVarType(domainVarType);
                List varList = osrvArrangeVarService.queryList((Object)varParam);
                if (CollectionUtils.isNotEmpty((Collection)varList)) {
                    varTarget = (OsrvArrangeVarDTO)varList.get(0);
                }
            }
            if (varTarget == null) {
                valid = false;
                CheckResult cr = CheckResult.Fail;
                if (cr == CheckResult.Pass || !this.genDtl) return valid;
                SCheckResultDtlDTO dtl = new SCheckResultDtlDTO();
                dtl.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                dtl.setCheckResult(cr.getCode());
                String checkDesc = "";
                if (cond != null) {
                    String condName = this.searchCondName(cond, conn);
                    checkDesc = String.format("%s %s %s-%s\u53d8\u91cf[%s]\u672a\u5b9a\u4e49", srvModelInfo.getSrvModelName(), srvModelInfo.getSrvModelCode(), condName, cond.getCondName(), tableModelName);
                } else {
                    checkDesc = String.format("%s %s %s\u53d8\u91cf[%s]\u672a\u5b9a\u4e49", srvModelInfo.getSrvModelName(), srvModelInfo.getSrvModelCode(), rowTargetName, tableModelName);
                }
                dtl.setCheckDesc(checkDesc);
                ruleResultDtlList.add(dtl);
                return valid;
            } else {
                if (StringUtils.equals((CharSequence)"O", (CharSequence)tdType)) return valid;
                ModelTableFieldDTO fieldCheck = new ModelTableFieldDTO();
                fieldCheck.setObjectId(objectId);
                fieldCheck.setFieldCode(paramFieldCode);
                List fieldExists = modelTableFieldService.queryListByPage((Object)fieldCheck);
                if (!CollectionUtils.isEmpty((Collection)fieldExists)) return valid;
                valid = false;
                CheckResult cr = CheckResult.Fail;
                if (cr == CheckResult.Pass || !this.genDtl) return valid;
                SCheckResultDtlDTO dtl = new SCheckResultDtlDTO();
                dtl.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                dtl.setCheckResult(cr.getCode());
                String checkDesc = "";
                if (cond != null) {
                    String condName = this.searchCondName(cond, conn);
                    checkDesc = String.format("%s %s %s%s\u53d8\u91cf[%s]-[%s]\u672a\u5b9a\u4e49", srvModelInfo.getSrvModelName(), srvModelInfo.getSrvModelCode(), condName, cond.getCondName(), tableModelName, paramFieldCode);
                } else {
                    checkDesc = String.format("%s %s %s\u53d8\u91cf[%s]-[%s]\u672a\u5b9a\u4e49", srvModelInfo.getSrvModelName(), srvModelInfo.getSrvModelCode(), rowTargetName, tableModelName, paramFieldCode);
                }
                dtl.setCheckDesc(checkDesc);
                ruleResultDtlList.add(dtl);
            }
        }
        return valid;
    }

    private boolean validateCondition(SrvModelInfoDTO srvModelInfo, List<SCheckResultDtlDTO> ruleResultDtlList, Connection conn) throws Exception {
        SrvModelConditionService srvModelConditionService = (SrvModelConditionService)SpringContextUtils.getBean(SrvModelConditionService.class);
        SrvModelConditionDTO condParam = new SrvModelConditionDTO();
        condParam.setAppId(srvModelInfo.getAppId());
        condParam.setSrvModelId(srvModelInfo.getSrvModelId());
        condParam.setSize(Integer.valueOf(Integer.MAX_VALUE));
        List condList = srvModelConditionService.queryList((Object)condParam);
        if (CollectionUtils.isNotEmpty((Collection)condList)) {
            for (SrvModelConditionDTO cond : condList) {
                if (!this.condIsRef(cond, conn)) continue;
                this.validateCondContent(srvModelInfo, cond, cond.getLeftEvalWay(), cond.getLeftEvalContent(), ruleResultDtlList, conn);
                this.validateCondContent(srvModelInfo, cond, cond.getRightEvalWay(), cond.getRightEvalContent(), ruleResultDtlList, conn);
            }
        }
        return true;
    }

    private void validateCondContent(SrvModelInfoDTO srvModelInfo, SrvModelConditionDTO cond, String evalWay, String evalContent, List<SCheckResultDtlDTO> ruleResultDtlList, Connection conn) throws Exception {
        block12: {
            block14: {
                CheckResult cr;
                CheckResult cr2;
                block13: {
                    CheckResult cr3;
                    block11: {
                        if (!CondEvalWay.ASSIGN.getCode().equals(evalWay)) break block11;
                        this.validateAssign(srvModelInfo, cond, null, evalWay, evalContent, ruleResultDtlList, conn);
                        break block12;
                    }
                    if (!CondEvalWay.ENUM.getCode().equals(evalWay)) break block13;
                    Map map = (Map)JSON.parseObject((String)evalContent, Map.class);
                    String dictId = MapUtils.getString((Map)map, (Object)"dictId");
                    String dictCode = MapUtils.getString((Map)map, (Object)"dictCode");
                    String optionCode = MapUtils.getString((Map)map, (Object)"optionCode");
                    String optionEnum = MapUtils.getString((Map)map, (Object)"optionEnum");
                    String optionName = MapUtils.getString((Map)map, (Object)"optionName");
                    DictOptionEnumService dictOptionEnumService = (DictOptionEnumService)SpringContextUtils.getBean(DictOptionEnumService.class);
                    DictOptionEnumDTO optionParam = new DictOptionEnumDTO();
                    optionParam.setDictId(dictId);
                    optionParam.setOptionCode(optionCode);
                    List checkList = dictOptionEnumService.queryList((Object)optionParam);
                    if (CollectionUtils.isEmpty((Collection)checkList) && (cr3 = CheckResult.Fail) != CheckResult.Pass && this.genDtl) {
                        SCheckResultDtlDTO dtl = new SCheckResultDtlDTO();
                        dtl.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                        dtl.setCheckResult(cr3.getCode());
                        String checkDesc = "";
                        if (cond != null) {
                            String condName = this.searchCondName(cond, conn);
                            checkDesc = String.format("%s %s %s\u6761\u4ef6\u5217\u8868%s\u8d4b\u503c\u7684\u679a\u4e3e\u503c%s %s\u672a\u5b9a\u4e49", srvModelInfo.getSrvModelName(), srvModelInfo.getSrvModelCode(), condName, cond.getCondName(), dictCode, optionName);
                        } else {
                            checkDesc = String.format("%s %s \u8d4b\u503c\u7684\u679a\u4e3e\u503c%s %s\u672a\u5b9a\u4e49", srvModelInfo.getSrvModelName(), srvModelInfo.getSrvModelCode(), dictCode, optionName);
                        }
                        dtl.setCheckDesc(checkDesc);
                        ruleResultDtlList.add(dtl);
                    }
                    break block12;
                }
                if (!CondEvalWay.ERROR.getCode().equals(evalWay)) break block14;
                Map map = (Map)JSON.parseObject((String)evalContent, Map.class);
                String errorAppId = MapUtils.getString((Map)map, (Object)"appId");
                String errorCode = MapUtils.getString((Map)map, (Object)"errorCode");
                String errorMessage = MapUtils.getString((Map)map, (Object)"errorMessage");
                SrvErrorMappingService srvErrorMappingService = (SrvErrorMappingService)SpringContextUtils.getBean(SrvErrorMappingService.class);
                SrvErrorMappingDTO errorParam = new SrvErrorMappingDTO();
                errorParam.setAppId(errorAppId);
                errorParam.setErrorCode(errorCode);
                List checkList = srvErrorMappingService.queryList((Object)errorParam);
                if (CollectionUtils.isNotEmpty((Collection)checkList) && (cr2 = CheckResult.Fail) != CheckResult.Pass && this.genDtl) {
                    SCheckResultDtlDTO dtl = new SCheckResultDtlDTO();
                    dtl.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                    dtl.setCheckResult(cr2.getCode());
                    String checkDesc = "";
                    if (cond != null) {
                        String condName = this.searchCondName(cond, conn);
                        checkDesc = String.format("%s %s %s\u6761\u4ef6\u5217\u8868%s\u8d4b\u503c\u7684\u9519\u8bef\u7801%s %s\u672a\u5b9a\u4e49", srvModelInfo.getSrvModelName(), srvModelInfo.getSrvModelCode(), condName, cond.getCondName(), errorCode, errorMessage);
                    } else {
                        checkDesc = String.format("%s %s \u8d4b\u503c\u7684\u9519\u8bef\u7801%s %s\u672a\u5b9a\u4e49", srvModelInfo.getSrvModelName(), srvModelInfo.getSrvModelCode(), errorCode, errorMessage);
                    }
                    dtl.setCheckDesc(checkDesc);
                    ruleResultDtlList.add(dtl);
                }
                if (srvModelInfo.getAppId().equals(errorAppId)) break block12;
                PaasAppsInfoService paasAppsInfoDao = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
                PaasAppsInfoDTO errorAppInfo = new PaasAppsInfoDTO();
                errorAppInfo.setAppId(errorAppId);
                errorAppInfo = (PaasAppsInfoDTO)paasAppsInfoDao.queryByPk((Object)errorAppInfo);
                if (errorAppInfo != null || (cr = CheckResult.Fail) == CheckResult.Pass || !this.genDtl) break block12;
                SCheckResultDtlDTO dtl = new SCheckResultDtlDTO();
                dtl.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                dtl.setCheckResult(cr.getCode());
                String checkDesc = "";
                if (cond != null) {
                    String condName = this.searchCondName(cond, conn);
                    checkDesc = String.format("%s %s %s\u6761\u4ef6\u5217\u8868%s\u8d4b\u503c\u7684\u9519\u8bef\u7801%s %s\u672a\u5b9a\u4e49", srvModelInfo.getSrvModelName(), srvModelInfo.getSrvModelCode(), condName, cond.getCondName(), errorCode, errorMessage);
                } else {
                    checkDesc = String.format("%s %s \u8d4b\u503c\u7684\u9519\u8bef\u7801%s %s\u672a\u5b9a\u4e49", srvModelInfo.getSrvModelName(), srvModelInfo.getSrvModelCode(), errorCode, errorMessage);
                }
                dtl.setCheckDesc(checkDesc);
                ruleResultDtlList.add(dtl);
                break block12;
            }
            if (CondEvalWay.FUNC.getCode().equals(evalWay)) {
                Map evalContentMap = (Map)JSON.parseObject((String)evalContent, Map.class);
                Map func = MapUtils.getMap((Map)evalContentMap, (Object)"func");
                Map parameters = MapUtils.getMap((Map)func, (Object)"parameters");
                List parameterList = (List)evalContentMap.get("parameterList");
                if (CollectionUtils.isNotEmpty((Collection)parameterList)) {
                    for (Map param : parameterList) {
                        String funcEvalWay = MapUtils.getString((Map)param, (Object)"evalWay");
                        String funcEvalContent = MapUtils.getString((Map)param, (Object)"evalContent");
                        this.validateAssign(srvModelInfo, cond, null, funcEvalWay, funcEvalContent, ruleResultDtlList, conn);
                    }
                }
            }
        }
    }

    private boolean condIsRef(SrvModelConditionDTO cond, Connection conn) throws Exception {
        OsrvArrangeTableService osrvArrangeTableService = (OsrvArrangeTableService)SpringContextUtils.getBean(OsrvArrangeTableService.class);
        OsrvArrangeSectionService osrvArrangeSectionService = (OsrvArrangeSectionService)SpringContextUtils.getBean(OsrvArrangeSectionService.class);
        SrvModelValidateService srvModelValidateService = (SrvModelValidateService)SpringContextUtils.getBean(SrvModelValidateService.class);
        String condRefId = cond.getCondRefId();
        OsrvArrangeTableDTO tableParam = new OsrvArrangeTableDTO();
        tableParam.setTableRowId(condRefId);
        OsrvArrangeTableDTO table = (OsrvArrangeTableDTO)osrvArrangeTableService.queryByPk((Object)tableParam);
        if (table != null) {
            return true;
        }
        SrvModelValidateDTO validateParam = new SrvModelValidateDTO();
        validateParam.setRuleId(condRefId);
        SrvModelValidateDTO validate = (SrvModelValidateDTO)srvModelValidateService.queryByPk((Object)validateParam);
        if (validate != null) {
            return true;
        }
        OsrvArrangeSectionDTO sectionParam = new OsrvArrangeSectionDTO();
        sectionParam.setSectionId(condRefId);
        OsrvArrangeSectionDTO section = (OsrvArrangeSectionDTO)osrvArrangeSectionService.queryByPk((Object)sectionParam);
        if (section != null) {
            Map sectionCondMap = (Map)JSON.parseObject((String)section.getSectionContent(), Map.class);
            String condName = MapUtils.getString((Map)sectionCondMap, (Object)"condName");
            return true;
        }
        return false;
    }

    private String searchCondName(SrvModelConditionDTO cond, Connection conn) throws Exception {
        OsrvArrangeTableService osrvArrangeTableService = (OsrvArrangeTableService)SpringContextUtils.getBean(OsrvArrangeTableService.class);
        OsrvArrangeSectionService osrvArrangeSectionService = (OsrvArrangeSectionService)SpringContextUtils.getBean(OsrvArrangeSectionService.class);
        SrvModelValidateService srvModelValidateService = (SrvModelValidateService)SpringContextUtils.getBean(SrvModelValidateService.class);
        String condRefId = cond.getCondRefId();
        OsrvArrangeTableDTO tableParam = new OsrvArrangeTableDTO();
        tableParam.setTableRowId(condRefId);
        OsrvArrangeTableDTO table = (OsrvArrangeTableDTO)osrvArrangeTableService.queryByPk((Object)tableParam);
        if (table != null) {
            return table.getRowCondName();
        }
        SrvModelValidateDTO validateParam = new SrvModelValidateDTO();
        validateParam.setRuleId(condRefId);
        SrvModelValidateDTO validate = (SrvModelValidateDTO)srvModelValidateService.queryByPk((Object)validateParam);
        if (validate != null) {
            return validate.getRuleName();
        }
        OsrvArrangeSectionDTO sectionParam = new OsrvArrangeSectionDTO();
        sectionParam.setSectionId(condRefId);
        OsrvArrangeSectionDTO section = (OsrvArrangeSectionDTO)osrvArrangeSectionService.queryByPk((Object)sectionParam);
        if (section != null) {
            Map sectionCondMap = (Map)JSON.parseObject((String)section.getSectionContent(), Map.class);
            String condName = MapUtils.getString((Map)sectionCondMap, (Object)"condName");
            return condName;
        }
        return "";
    }
}

