/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.admin.console.web.controller.api;

import com.irdstudio.allinapaas.admin.console.facade.PaasSubsUserService;
import com.irdstudio.allinapaas.admin.console.facade.dto.PaasSubsUserDTO;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvParamDTO;
import com.irdstudio.allinapaas.design.console.facade.SSubsInfoPortalService;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasSubsUserController
extends BaseController<PaasSubsUserDTO, PaasSubsUserService> {
    @Autowired
    private SSubsInfoPortalService sSubsInfoPortalService;

    @RequestMapping(value={"/api/paas/subs/users"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasSubsUserDTO>> queryRdmProjectMemberAll(PaasSubsUserDTO dto) {
        List outputVo = ((PaasSubsUserService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/subs/users/list"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasSubsUserDTO>> queryList(PaasSubsUserDTO dto) {
        List outputVo = ((PaasSubsUserService)this.getService()).queryList((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/subs/user"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasSubsUserDTO> queryByPk(@RequestParam(value="subsId") String subsId, @RequestParam(value="userId") String userId) {
        PaasSubsUserDTO inVo = new PaasSubsUserDTO();
        inVo.setSubsId(subsId);
        inVo.setUserId(userId);
        PaasSubsUserDTO outputVo = (PaasSubsUserDTO)((PaasSubsUserService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/subs/user"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasSubsUserDTO inPaasSubsUserDTO) {
        int outputVo = ((PaasSubsUserService)this.getService()).deleteByPk((Object)inPaasSubsUserDTO);
        if (outputVo == 1) {
            this.handleGitMember(inPaasSubsUserDTO.getSubsId(), this.getUserInfo().getUserId(), inPaasSubsUserDTO.getUserId(), true);
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/subs/user"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasSubsUserDTO inPaasSubsUserDTO) {
        this.setUserInfoToVO(inPaasSubsUserDTO);
        String now = CurrentDateUtil.getTodayDateEx2();
        inPaasSubsUserDTO.setLastModifyTime(now);
        inPaasSubsUserDTO.setLastModifyUser(inPaasSubsUserDTO.getLoginUserId());
        int outputVo = ((PaasSubsUserService)this.getService()).updateByPk((Object)inPaasSubsUserDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/subs/user"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertRdmProjectMember(@RequestBody PaasSubsUserDTO inPaasSubsUserDTO) {
        this.setUserInfoToVO(inPaasSubsUserDTO);
        String now = CurrentDateUtil.getTodayDateEx2();
        inPaasSubsUserDTO.setCreateTime(now);
        inPaasSubsUserDTO.setCreateUser(inPaasSubsUserDTO.getLoginUserId());
        inPaasSubsUserDTO.setLastModifyTime(now);
        inPaasSubsUserDTO.setLastModifyUser(inPaasSubsUserDTO.getLoginUserId());
        int outputVo = ((PaasSubsUserService)this.getService()).insert((Object)inPaasSubsUserDTO);
        if (outputVo == 1) {
            this.handleGitMember(inPaasSubsUserDTO.getSubsId(), inPaasSubsUserDTO.getLoginUserId(), inPaasSubsUserDTO.getUserId(), false);
        }
        return this.getResponseData(outputVo);
    }

    private void handleGitMember(String subsId, String currentUserId, String userId, boolean deleteUserFlag) {
        PaasEnvParamDTO envParam = new PaasEnvParamDTO();
        envParam.setEnvId("paas");
        envParam.setParamGroup("git.user");
        PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
        List gitParamList = paasEnvParamService.queryList((Object)envParam);
        SSubsInfoDTO subsInfo = new SSubsInfoDTO();
        subsInfo.setSubsId(subsId);
        subsInfo = (SSubsInfoDTO)this.sSubsInfoPortalService.queryByPk((Object)subsInfo);
        if (CollectionUtils.isNotEmpty((Collection)gitParamList) && subsInfo != null) {
            String subsGitGroup;
            String gitType = this.getEnvParamByCode("git.type", gitParamList);
            String gitHostUrl = this.getEnvParamByCode("git.host.url", gitParamList);
            String accessToken = this.getEnvParamByCode("git.open.api.access_token", gitParamList);
            if (gitHostUrl.endsWith("/")) {
                gitHostUrl = gitHostUrl.substring(0, gitHostUrl.length() - 1);
            }
            if (StringUtils.isBlank((CharSequence)(subsGitGroup = subsInfo.getSubsGitGroup()))) {
                subsGitGroup = String.format("%s/%s", gitHostUrl, subsInfo.getSubsCode());
            }
            subsGitGroup = subsGitGroup.substring(subsGitGroup.lastIndexOf("/") + 1);
            try {
                this.sSubsInfoPortalService.gitlabHandler(subsGitGroup, currentUserId, gitHostUrl, accessToken, Arrays.asList(userId), subsInfo.getSubsName(), deleteUserFlag);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String getEnvParamByCode(String paramCode, List<PaasEnvParamDTO> paramList) {
        if (CollectionUtils.isNotEmpty(paramList)) {
            for (PaasEnvParamDTO param : paramList) {
                if (!param.getParamCode().equals(paramCode)) continue;
                return param.getParamValue();
            }
        }
        return null;
    }
}

