/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.deliver.console.web.controller.api;

import com.irdstudio.allinapaas.deliver.console.facade.PluginFolderInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PluginFolderInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PluginFolderInfoController
extends BaseController<PluginFolderInfoDTO, PluginFolderInfoService> {
    @RequestMapping(value={"/api/plugin/folder/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PluginFolderInfoDTO>> queryPluginFolderInfoAll(PluginFolderInfoDTO dto) {
        List outputVo = ((PluginFolderInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/plugin/folder/info/{folderId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PluginFolderInfoDTO> queryByPk(@PathVariable(value="folderId") String folderId) {
        PluginFolderInfoDTO inVo = new PluginFolderInfoDTO();
        inVo.setFolderId(folderId);
        PluginFolderInfoDTO outputVo = (PluginFolderInfoDTO)((PluginFolderInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/plugin/folder/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PluginFolderInfoDTO inPluginFolderInfoDTO) {
        int outputVo = ((PluginFolderInfoService)this.getService()).deleteByPk((Object)inPluginFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/plugin/folder/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PluginFolderInfoDTO inPluginFolderInfoDTO) {
        this.setUserInfoToVO(inPluginFolderInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inPluginFolderInfoDTO.setLastModifyUser(userId);
        inPluginFolderInfoDTO.setLastModifyTime(now);
        int outputVo = ((PluginFolderInfoService)this.getService()).updateByPk((Object)inPluginFolderInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/plugin/folder/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPluginFolderInfo(@RequestBody PluginFolderInfoDTO inPluginFolderInfoDTO) {
        this.setUserInfoToVO(inPluginFolderInfoDTO);
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inPluginFolderInfoDTO.setCreateUser(userId);
        inPluginFolderInfoDTO.setCreateTime(now);
        inPluginFolderInfoDTO.setLastModifyUser(userId);
        inPluginFolderInfoDTO.setLastModifyTime(now);
        if (StringUtils.isBlank((CharSequence)inPluginFolderInfoDTO.getFolderId())) {
            inPluginFolderInfoDTO.setFolderId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((PluginFolderInfoService)this.getService()).insert((Object)inPluginFolderInfoDTO);
        return this.getResponseData(outputVo);
    }
}

