/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.design.console.web.controller.api;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsGroupService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsGroupDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasAppsGroupController
extends BaseController<PaasAppsGroupDTO, PaasAppsGroupService> {
    @RequestMapping(value={"/api/paas/apps/groups"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsGroupDTO>> queryPaasAppsGroupAll(PaasAppsGroupDTO dto) {
        List outputVo = ((PaasAppsGroupService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/group/{groupId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasAppsGroupDTO> queryByPk(@PathVariable(value="groupId") String groupId) {
        PaasAppsGroupDTO inVo = new PaasAppsGroupDTO();
        inVo.setGroupId(groupId);
        PaasAppsGroupDTO outputVo = (PaasAppsGroupDTO)((PaasAppsGroupService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/group"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasAppsGroupDTO inPaasAppsGroupDTO) {
        int outputVo = ((PaasAppsGroupService)this.getService()).deleteByPk((Object)inPaasAppsGroupDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/group"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasAppsGroupDTO inPaasAppsGroupDTO) {
        this.setUserInfoToVO(inPaasAppsGroupDTO);
        inPaasAppsGroupDTO.setLastModifyUser(inPaasAppsGroupDTO.getLoginUserId());
        inPaasAppsGroupDTO.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((PaasAppsGroupService)this.getService()).updateByPk((Object)inPaasAppsGroupDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/group"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPaasAppsGroup(@RequestBody PaasAppsGroupDTO inPaasAppsGroupDTO) {
        this.setUserInfoToVO(inPaasAppsGroupDTO);
        inPaasAppsGroupDTO.setCreateUser(inPaasAppsGroupDTO.getLoginUserId());
        inPaasAppsGroupDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inPaasAppsGroupDTO.setLastModifyUser(inPaasAppsGroupDTO.getLoginUserId());
        inPaasAppsGroupDTO.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        if (StringUtils.isBlank((CharSequence)inPaasAppsGroupDTO.getGroupId())) {
            inPaasAppsGroupDTO.setGroupId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((PaasAppsGroupService)this.getService()).insert((Object)inPaasAppsGroupDTO);
        return this.getResponseData(outputVo);
    }
}

