/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.design.console.web.controller.api;

import com.irdstudio.allinapaas.design.console.facade.PaasTemplateGroupService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasTemplateGroupDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasTemplateGroupController
extends BaseController<PaasTemplateGroupDTO, PaasTemplateGroupService> {
    @RequestMapping(value={"/api/paas/template/groups"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasTemplateGroupDTO>> queryPaasTemplateGroupAll(PaasTemplateGroupDTO vo) {
        List outputVo = ((PaasTemplateGroupService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/template/groups/notpage"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasTemplateGroupDTO>> queryTemplateGroupNotPage(PaasTemplateGroupDTO vo) {
        List outputVo = ((PaasTemplateGroupService)this.getService()).queryList((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/template/group/{templateGroupCode}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasTemplateGroupDTO> queryByPk(@PathVariable(value="templateGroupCode") String templateGroupCode) {
        PaasTemplateGroupDTO inVo = new PaasTemplateGroupDTO();
        inVo.setTemplateGroupCode(templateGroupCode);
        PaasTemplateGroupDTO outputVo = (PaasTemplateGroupDTO)((PaasTemplateGroupService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/template/group"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasTemplateGroupDTO inPaasTemplateGroupVo) {
        int outputVo = ((PaasTemplateGroupService)this.getService()).deleteByPk((Object)inPaasTemplateGroupVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/template/group"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasTemplateGroupDTO inPaasTemplateGroupVo) {
        this.setUserInfoToVO(inPaasTemplateGroupVo);
        inPaasTemplateGroupVo.setLastUpdateUser(inPaasTemplateGroupVo.getLoginUserId());
        inPaasTemplateGroupVo.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((PaasTemplateGroupService)this.getService()).updateByPk((Object)inPaasTemplateGroupVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/template/group"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPaasTemplateGroup(@RequestBody PaasTemplateGroupDTO inPaasTemplateGroupVo) {
        this.setUserInfoToVO(inPaasTemplateGroupVo);
        inPaasTemplateGroupVo.setCreateUser(inPaasTemplateGroupVo.getLoginUserId());
        inPaasTemplateGroupVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inPaasTemplateGroupVo.setLastUpdateUser(inPaasTemplateGroupVo.getLoginUserId());
        inPaasTemplateGroupVo.setLastUpdateTime(inPaasTemplateGroupVo.getCreateTime());
        int outputVo = ((PaasTemplateGroupService)this.getService()).insert((Object)inPaasTemplateGroupVo);
        return this.getResponseData(outputVo);
    }
}

