/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.deliver.console.web.controller.api;

import com.irdstudio.allinapaas.deliver.console.facade.CloudRegionInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.CloudRegionInfoDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class CloudRegionInfoController
extends BaseController<CloudRegionInfoDTO, CloudRegionInfoService> {
    @RequestMapping(value={"/api/cloud/region/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<CloudRegionInfoDTO>> queryCloudRegionInfoAll(CloudRegionInfoDTO dto) {
        List outputVo = ((CloudRegionInfoService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/cloud/region/info/{cloudRegionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<CloudRegionInfoDTO> queryByPk(@PathVariable(value="cloudRegionId") String cloudRegionId) {
        CloudRegionInfoDTO inVo = new CloudRegionInfoDTO();
        inVo.setCloudRegionId(cloudRegionId);
        CloudRegionInfoDTO outputVo = (CloudRegionInfoDTO)((CloudRegionInfoService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/cloud/region/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody CloudRegionInfoDTO inCloudRegionInfoDTO) {
        int outputVo = ((CloudRegionInfoService)this.getService()).deleteByPk((Object)inCloudRegionInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/cloud/region/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody CloudRegionInfoDTO inCloudRegionInfoDTO) {
        this.setUserInfoToVO(inCloudRegionInfoDTO);
        inCloudRegionInfoDTO.setLastModifyUser(inCloudRegionInfoDTO.getLoginUserId());
        inCloudRegionInfoDTO.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((CloudRegionInfoService)this.getService()).updateByPk((Object)inCloudRegionInfoDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/cloud/region/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertCloudRegionInfo(@RequestBody CloudRegionInfoDTO inCloudRegionInfoDTO) {
        this.setUserInfoToVO(inCloudRegionInfoDTO);
        inCloudRegionInfoDTO.setCreateUser(inCloudRegionInfoDTO.getLoginUserId());
        inCloudRegionInfoDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inCloudRegionInfoDTO.setLastModifyUser(inCloudRegionInfoDTO.getLoginUserId());
        inCloudRegionInfoDTO.setLastModifyTime(inCloudRegionInfoDTO.getCreateTime());
        if (StringUtils.isNotBlank((CharSequence)inCloudRegionInfoDTO.getCloudRegionId())) {
            inCloudRegionInfoDTO.setCloudRegionId(UUIDUtil.getUUID());
        }
        int outputVo = ((CloudRegionInfoService)this.getService()).insert((Object)inCloudRegionInfoDTO);
        return this.getResponseData(outputVo);
    }
}

