/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.deliver.console.web.controller.api;

import com.irdstudio.allinapaas.deliver.console.facade.PaasScriptGroupService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasScriptGroupDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasScriptGroupController
extends BaseController<PaasScriptGroupDTO, PaasScriptGroupService> {
    @RequestMapping(value={"/api/paas/script/groups"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasScriptGroupDTO>> queryPaasScriptGroupAll(PaasScriptGroupDTO dto) {
        List outputVo = ((PaasScriptGroupService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/script/group/{scriptGroupCode}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasScriptGroupDTO> queryByPk(@PathVariable(value="scriptGroupCode") String scriptGroupCode) {
        PaasScriptGroupDTO inVo = new PaasScriptGroupDTO();
        inVo.setScriptGroupCode(scriptGroupCode);
        PaasScriptGroupDTO outputVo = (PaasScriptGroupDTO)((PaasScriptGroupService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/script/group"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasScriptGroupDTO inPaasScriptGroupDTO) {
        int outputVo = ((PaasScriptGroupService)this.getService()).deleteByPk((Object)inPaasScriptGroupDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/script/group"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasScriptGroupDTO inPaasScriptGroupDTO) {
        this.setUserInfoToVO(inPaasScriptGroupDTO);
        String userId = inPaasScriptGroupDTO.getLoginUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inPaasScriptGroupDTO.setUpdateUser(userId);
        inPaasScriptGroupDTO.setUpdateTime(now);
        int outputVo = ((PaasScriptGroupService)this.getService()).updateByPk((Object)inPaasScriptGroupDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/script/group"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPaasScriptGroup(@RequestBody PaasScriptGroupDTO inPaasScriptGroupDTO) {
        this.setUserInfoToVO(inPaasScriptGroupDTO);
        String userId = inPaasScriptGroupDTO.getLoginUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        inPaasScriptGroupDTO.setCreateUser(userId);
        inPaasScriptGroupDTO.setCreateTime(now);
        inPaasScriptGroupDTO.setUpdateUser(userId);
        inPaasScriptGroupDTO.setUpdateTime(now);
        int outputVo = ((PaasScriptGroupService)this.getService()).insert((Object)inPaasScriptGroupDTO);
        return this.getResponseData(outputVo);
    }
}

