/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.manager.console.web.controller.api;

import com.irdstudio.allinapaas.manager.console.facade.PaasAppsDocumentService;
import com.irdstudio.allinapaas.manager.console.facade.dto.PaasAppsDocumentDTO;
import com.irdstudio.sdk.beans.core.util.ResourceCloseUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasAppsDocumentController
extends BaseController<PaasAppsDocumentDTO, PaasAppsDocumentService> {
    @Value(value="${tdp.docs.path}")
    private String DOCS_PATH;

    @RequestMapping(value={"/api/paas/apps/documents"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasAppsDocumentDTO>> queryPaasAppsDocumentAll(PaasAppsDocumentDTO vo) {
        List outputVo = ((PaasAppsDocumentService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/document/{documentId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasAppsDocumentDTO> queryByPk(@PathVariable(value="documentId") String documentId) {
        PaasAppsDocumentDTO inVo = new PaasAppsDocumentDTO();
        inVo.setDocumentId(documentId);
        PaasAppsDocumentDTO outputVo = (PaasAppsDocumentDTO)((PaasAppsDocumentService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/document"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasAppsDocumentDTO inPaasAppsDocumentVo) {
        int outputVo = ((PaasAppsDocumentService)this.getService()).deleteByPk((Object)inPaasAppsDocumentVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/document"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody PaasAppsDocumentDTO inPaasAppsDocumentVo) {
        int outputVo = ((PaasAppsDocumentService)this.getService()).updateByPk((Object)inPaasAppsDocumentVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/apps/document"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertPaasAppsDocument(@RequestBody PaasAppsDocumentDTO inPaasAppsDocumentVo) {
        int outputVo = ((PaasAppsDocumentService)this.getService()).insert((Object)inPaasAppsDocumentVo);
        return this.getResponseData(outputVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/paas/apps/document/download/{documentId}"}, method={RequestMethod.GET})
    public void downloadDoc(@PathVariable(value="documentId") String documentId, HttpServletResponse response) throws IOException {
        block6: {
            PaasAppsDocumentDTO inVo = new PaasAppsDocumentDTO();
            inVo.setDocumentId(documentId);
            PaasAppsDocumentDTO doc = (PaasAppsDocumentDTO)((PaasAppsDocumentService)this.getService()).queryByPk((Object)inVo);
            BufferedInputStream bis = null;
            BufferedOutputStream bos = null;
            try {
                int bytesRead;
                String finalFileName = doc.getDocumentName();
                File file = new File(this.DOCS_PATH + File.separator + doc.getSubsCode() + File.separator + doc.getAppCode() + File.separator + finalFileName);
                response.setContentType("application/msword;charset=utf-8");
                response.setHeader("Content-Disposition", "attachment;filename=" + new String(finalFileName.getBytes(), "iso-8859-1"));
                ServletOutputStream out = response.getOutputStream();
                bis = new BufferedInputStream(new FileInputStream(file));
                bos = new BufferedOutputStream((OutputStream)out);
                byte[] buff = new byte[2048];
                while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                    bos.write(buff, 0, bytesRead);
                }
                ResourceCloseUtil.closeInputStream((InputStream)bis);
            }
            catch (Exception e) {
                logger.error("\u6587\u6863\u4e2d\u5fc3\u6587\u6863\u4e0b\u8f7d\u5931\u8d25\uff1a", (Throwable)e);
                break block6;
            }
            finally {
                ResourceCloseUtil.closeInputStream(bis);
                ResourceCloseUtil.closeOutputStream(bos);
            }
            ResourceCloseUtil.closeOutputStream((OutputStream)bos);
        }
    }

    @RequestMapping(value={"/client/PaasAppsDocumentService/deleteByCond"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer deleteByCond(@RequestBody PaasAppsDocumentDTO param) {
        return ((PaasAppsDocumentService)this.getService()).deleteByCond(param);
    }
}

