/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.manager.console.web.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDocTemplateDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.impl.ConnPoolForDruid;
import com.irdstudio.allinapaas.manager.console.facade.PaasDocExecutorService;
import com.irdstudio.allinapaas.manager.console.facade.PaasDocTemplateService;
import com.irdstudio.allinapaas.manager.console.facade.dto.PaasDocTemplateDTO;
import com.irdstudio.allinapaas.portal.console.application.service.task.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.portal.console.application.service.task.GitRepoPushQueueExecutor;
import com.irdstudio.allinapaas.portal.console.application.service.task.GitRepoPushTask;
import com.irdstudio.allinapaas.portal.console.application.service.task.WikiRepoPushTaskImpl;
import com.irdstudio.allinapaas.portal.console.application.service.utils.SdEnvUtil;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.ResourceCloseUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasDocExecutorController
extends AbstractController {
    @Autowired
    protected PaasDocTemplateService paasDocTemplateService;
    @Autowired
    protected PaasDocExecutorService paasDocExecutorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/paas/doc/generate"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> docTemplateGenerateAndDownload(@RequestParam(value="docTid") String docTid, @RequestParam(value="subsId", required=false) String subsId, @RequestParam(value="appId", required=false) String appId, @RequestParam(value="useSubs", required=false) boolean useSubs, @RequestParam(value="groupName", required=false) String groupName, @RequestParam(value="extParms", required=false) String extParms, HttpServletResponse response) throws IOException {
        Iterator iterator;
        String userId = this.getUserInfo().getUserId();
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        File file = null;
        try {
            int bytesRead;
            PaasDocTemplateDTO templateVO = new PaasDocTemplateDTO();
            templateVO.setDocTid(docTid);
            templateVO = (PaasDocTemplateDTO)this.paasDocTemplateService.queryByPk((Object)templateVO);
            if (templateVO == null) {
                ResponseData resp = this.getResponseData(false);
                resp.setMessage("\u6587\u6863\u6a21\u677f\u4e0d\u5b58\u5728");
                ResponseData responseData = resp;
                return responseData;
            }
            DocTemplateRepoPullQueueExecutor.syncRun();
            String docsRootPath = SdEnvUtil.DOCS_PATH;
            File sysDir = new File(docsRootPath + File.separator + subsId);
            PaasDocTemplateDTO template = new PaasDocTemplateDTO();
            BeanUtility.beanCopy((Object)templateVO, (Object)template);
            template.setLoginUserId(userId);
            if (StringUtils.equals((String)"java", (String)template.getDocGenType())) {
                Object conn = null;
                try {
                    List<String> filePathList = this.docTemplateGenerate(docTid, subsId, appId, useSubs, groupName, extParms, userId);
                    List files = filePathList.stream().map(p -> new File((String)p)).collect(Collectors.toList());
                    file = (File)files.get(0);
                    for (File f : files) {
                        WikiRepoPushTaskImpl task = new WikiRepoPushTaskImpl(subsId, userId, f, null, "\u9875\u9762\u53d1\u8d77\u6587\u6863\u751f\u6210 " + file.getName());
                        GitRepoPushQueueExecutor.addTask((GitRepoPushTask)task);
                    }
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528\u6a21\u677f\u751f\u6210\u7c7b\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                }
            }
            response.setContentType("application/" + template.getDocType() + ";charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(file.getName().getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(file));
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            iterator = null;
            ResourceCloseUtil.closeInputStream((InputStream)bis);
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff1a", (Throwable)e);
            ResponseData responseData = this.getResponseData(false);
            return responseData;
        }
        finally {
            ResourceCloseUtil.closeInputStream(bis);
            ResourceCloseUtil.closeOutputStream(bos);
        }
        ResourceCloseUtil.closeOutputStream((OutputStream)bos);
        return iterator;
    }

    private static Map<String, Object> processExtParam(String extParms) {
        JSONObject extParamsMap = Collections.emptyMap();
        if (StringUtils.isNotEmpty((String)extParms)) {
            extParamsMap = JSON.parseObject((String)extParms);
        }
        return extParamsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/paas/doc/import/template"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> excelTemplateDownload(@RequestParam(value="docTid") String docTid, HttpServletResponse response) {
        ResponseData responseData;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int bytesRead;
            PaasDocTemplateDTO templateVO = new PaasDocTemplateDTO();
            templateVO.setDocTid(docTid);
            templateVO = (PaasDocTemplateDTO)this.paasDocTemplateService.queryByPk((Object)templateVO);
            if (templateVO == null) {
                ResponseData resp = this.getResponseData(false);
                resp.setMessage("\u6587\u6863\u6a21\u677f\u4e0d\u5b58\u5728");
                ResponseData responseData2 = resp;
                return responseData2;
            }
            String docFile = templateVO.getDocFile();
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File file = new File(templateRootPath + File.separator + docFile);
            String fileName = file.getName();
            String pureFileName = fileName.substring(0, fileName.lastIndexOf("."));
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            String importTemplateFileName = String.format("%s-import.%s", pureFileName, suffix);
            File downloadFile = new File(file.getParentFile(), importTemplateFileName);
            response.setContentType("application/" + templateVO.getDocType() + ";charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(importTemplateFileName.replaceAll("-import", "").getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(downloadFile));
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            responseData = this.getResponseData(true);
            ResourceCloseUtil.closeInputStream((InputStream)bis);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f\u5f02\u5e38", (Throwable)e);
            ResponseData responseData3 = this.getResponseData(false);
            return responseData3;
        }
        finally {
            ResourceCloseUtil.closeInputStream(bis);
            ResourceCloseUtil.closeOutputStream(bos);
        }
        ResourceCloseUtil.closeOutputStream((OutputStream)bos);
        return responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/client/PaasDocTemplateService/docTemplateGenerate"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> docTemplateGenerate(@RequestParam(value="docTid") String docTid, @RequestParam(value="subsId", required=false) String subsId, @RequestParam(value="appId", required=false) String appId, @RequestParam(value="useSubs", required=false) boolean useSubs, @RequestParam(value="groupName", required=false) String groupName, @RequestParam(value="extParms", required=false) String extParms, @RequestParam(value="userId") String userId) {
        List<File> files = null;
        try {
            List<String> list;
            block16: {
                if (StringUtils.isBlank((String)docTid)) {
                    return null;
                }
                DocTemplateRepoPullQueueExecutor.syncRun();
                String docsRootPath = SdEnvUtil.DOCS_PATH;
                File sysDir = new File(docsRootPath + File.separator + subsId);
                ConnPoolForDruid connPool = new ConnPoolForDruid();
                Connection conn = null;
                try {
                    conn = connPool.getConnection();
                    PaasDocTemplateDao paasDocTemplateDao = new PaasDocTemplateDao(conn);
                    PaasDocTemplate template = paasDocTemplateDao.queryByPk(docTid);
                    template.setLoginUserId(userId);
                    if (!StringUtils.equals((String)"java", (String)template.getDocGenType())) {
                        List<String> list2 = null;
                        return list2;
                    }
                    Class<?> genClass = Class.forName(template.getDocGenContent());
                    DocGenerate genInstance = (DocGenerate)genClass.newInstance();
                    Map<String, Object> extParamsMap = null;
                    if (StringUtils.isNotBlank((String)extParms)) {
                        try {
                            extParamsMap = PaasDocExecutorController.processExtParam(new String(Base64.getDecoder().decode(extParms.getBytes())));
                        }
                        catch (Exception e) {
                            logger.info("\u6269\u5c55\u53c2\u6570\u89e3\u6790\u5f02\u5e38 \u5ffd\u7565\u3002 " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (useSubs) {
                        files = genInstance.generateDoc(template, subsId, sysDir, (IConnPool)connPool, extParamsMap);
                        break block16;
                    }
                    if (StringUtils.isNotBlank((String)groupName)) {
                        File file = genInstance.generateGroupDoc(template, subsId, groupName, sysDir, (IConnPool)connPool, extParamsMap);
                        files = Arrays.asList(file);
                    } else {
                        File file = genInstance.generateAppDoc(template, appId, sysDir, (IConnPool)connPool, extParamsMap);
                        files = Arrays.asList(file);
                    }
                }
                catch (Exception e) {
                    logger.error("\u8c03\u7528\u6a21\u677f\u751f\u6210\u7c7b\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                }
                finally {
                    connPool.releaseConnection(conn);
                }
            }
            if (files == null) {
                list = Collections.emptyList();
                return list;
            }
            list = files.stream().map(f -> f.getAbsolutePath()).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    @GetMapping(value={"/api/paas/doc/template/table/script/{objectId}"})
    @ResponseBody
    public ResponseData<String> generateDDL(@PathVariable(value="objectId") String objectId) {
        String sqlContent = this.paasDocExecutorService.generateDDL(objectId);
        return this.getResponseData(sqlContent);
    }

    @RequestMapping(value={"/client/PaasDocTemplateService/generateDDL"}, method={RequestMethod.POST})
    @ResponseBody
    public String generateDDL_client(@RequestParam(value="objectId") String objectId) {
        return this.paasDocExecutorService.generateDDL(objectId);
    }

    @RequestMapping(value={"/api/paas/doc/subs/initlocaldir"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> subsDocsInitLocalDir(@RequestParam(value="subsId") String subsId) {
        boolean flag = this.paasDocExecutorService.subsDocsInitLocalDir(subsId, this.getUserInfo().getUserId());
        return this.getResponseData(flag);
    }

    @RequestMapping(value={"/api/paas/doc/subs/gen"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> subsDocsGenerate(@RequestParam(value="subsId") String subsId) {
        boolean flag = this.paasDocExecutorService.subsDocsGenerate(subsId, this.getUserInfo().getUserId());
        return this.getResponseData(flag);
    }

    @RequestMapping(value={"/api/paas/doc/subs/push"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> subsDocsPush(@RequestParam(value="subsId") String subsId) {
        boolean flag = this.paasDocExecutorService.subsDocsPush(subsId, this.getUserInfo().getUserId());
        return this.getResponseData(flag);
    }

    @RequestMapping(value={"/client/PaasDocTemplateService/subsDocsInitLocalDir"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean subsDocsInitLocalDir_client(@RequestParam(value="subsId") String subsId, @RequestParam(value="userId") String userId) {
        return this.paasDocExecutorService.subsDocsInitLocalDir(subsId, userId);
    }

    @RequestMapping(value={"/client/PaasDocTemplateService/subsDocsGenerate"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean subsDocsGenerate_client(@RequestParam(value="subsId") String subsId, @RequestParam(value="userId") String userId) {
        return this.paasDocExecutorService.subsDocsGenerate(subsId, userId);
    }

    @RequestMapping(value={"/client/PaasDocTemplateService/subsDocsPush"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean subsDocsPush_client(@RequestParam(value="subsId") String subsId, @RequestParam(value="userId") String userId) {
        return this.paasDocExecutorService.subsDocsPush(subsId, userId);
    }
}

