/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.portal.console.web.controller.api;

import com.irdstudio.allinapaas.portal.console.facade.PaasTaskCardgenService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasTaskCardgenDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class PaasTaskCardgenController
extends BaseController<PaasTaskCardgenDTO, PaasTaskCardgenService> {
    @RequestMapping(value={"/api/paas/task/cardgens"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PaasTaskCardgenDTO>> queryPaasTaskCardgenAll(PaasTaskCardgenDTO dto) {
        if (StringUtils.contains((CharSequence)dto.getTaskType(), (CharSequence)",")) {
            String[] taskTypes = StringUtils.split((String)dto.getTaskType(), (String)",");
            dto.setTaskTypes(Arrays.asList(taskTypes));
            dto.setTaskType(null);
        }
        List outputVo = ((PaasTaskCardgenService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/cardgen/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<PaasTaskCardgenDTO> queryByPk(@PathVariable(value="taskId") String taskId) {
        PaasTaskCardgenDTO inVo = new PaasTaskCardgenDTO();
        inVo.setTaskId(taskId);
        PaasTaskCardgenDTO outputVo = (PaasTaskCardgenDTO)((PaasTaskCardgenService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/cardgen"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody PaasTaskCardgenDTO inPaasTaskCardgenDTO) {
        int outputVo = ((PaasTaskCardgenService)this.getService()).deleteByPk((Object)inPaasTaskCardgenDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/paas/task/cardgen"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<String> updateByPk(@RequestBody PaasTaskCardgenDTO inPaasTaskCardgenDTO) {
        this.setUserInfoToVO(inPaasTaskCardgenDTO);
        inPaasTaskCardgenDTO.setLastUpdateUser(inPaasTaskCardgenDTO.getLoginUserId());
        inPaasTaskCardgenDTO.setLastUpdateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = ((PaasTaskCardgenService)this.getService()).updateByPk((Object)inPaasTaskCardgenDTO);
        return this.getResponseData(inPaasTaskCardgenDTO.getTaskId());
    }

    @RequestMapping(value={"/api/paas/task/cardgen"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> insertPaasTaskCardgen(@RequestBody PaasTaskCardgenDTO inPaasTaskCardgenDTO) {
        this.setUserInfoToVO(inPaasTaskCardgenDTO);
        inPaasTaskCardgenDTO.setCreateUser(inPaasTaskCardgenDTO.getLoginUserId());
        inPaasTaskCardgenDTO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inPaasTaskCardgenDTO.setLastUpdateUser(inPaasTaskCardgenDTO.getLoginUserId());
        inPaasTaskCardgenDTO.setLastUpdateTime(inPaasTaskCardgenDTO.getCreateTime());
        if (StringUtils.isBlank((CharSequence)inPaasTaskCardgenDTO.getTaskId())) {
            inPaasTaskCardgenDTO.setTaskId(UUIDUtil.getShortUUID());
        }
        int outputVo = ((PaasTaskCardgenService)this.getService()).insert((Object)inPaasTaskCardgenDTO);
        return this.getResponseData(inPaasTaskCardgenDTO.getTaskId());
    }
}

