/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.paas.dbo.application.service.db;

import com.irdstudio.allinapaas.design.console.facade.dto.SSubsDatasourceDTO;
import com.irdstudio.paas.dbo.acl.repository.DboSqlLogRepository;
import com.irdstudio.paas.dbo.domain.entity.DboSqlLogDO;
import com.irdstudio.sdk.beans.core.util.KeyUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatabaseDao {
    public List<Map<String, Object>> doExcetueSql(SSubsDatasourceDTO sSubsDatasource, String remark, String sql, DboSqlLogRepository dboSqlLogRepository) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Statement ps = null;
        Connection conn = null;
        DboSqlLogDO dboSqlLog = new DboSqlLogDO();
        dboSqlLog.setRecordKeyid(KeyUtil.createUUIDKey());
        dboSqlLog.setDboSqlContent(sql);
        dboSqlLog.setStartTime(TimeUtil.getCurrentDateTime());
        dboSqlLog.setDsCode(sSubsDatasource.getSubsId());
        dboSqlLog.setDboRemarks(remark);
        long startMills = System.currentTimeMillis();
        try {
            String driver = "com.mysql.jdbc.Driver";
            String url = sSubsDatasource.getDsConnStr() + "/" + sSubsDatasource.getDsDbName() + "?useSSL=false&serverTimezone=UTC&allowMultiQueries=true";
            String user = sSubsDatasource.getDsUserId();
            String password = sSubsDatasource.getDsUserPwd();
            Class.forName(driver);
            conn = DriverManager.getConnection(url, user, password);
            if (!conn.isClosed()) {
                ps = conn.prepareStatement(sql);
                if (sql.toLowerCase().startsWith("select")) {
                    ResultSet rs = ps.executeQuery();
                    ResultSetMetaData rsmd = rs.getMetaData();
                    while (rs.next()) {
                        int ColumnCount = rsmd.getColumnCount();
                        HashMap<String, Object> rowData = new HashMap<String, Object>();
                        for (int i = 1; i <= ColumnCount; ++i) {
                            rowData.put(rsmd.getColumnName(i), rs.getObject(i));
                        }
                        result.add(rowData);
                    }
                } else {
                    int rs = ps.executeUpdate();
                    result.add((Map<String, Object>)((Object)("\u5f71\u54cd\u6761\u6570\uff1a" + rs)));
                    dboSqlLog.setDboAffectedNum(Integer.valueOf(rs));
                }
                long endMills = System.currentTimeMillis();
                dboSqlLog.setEndTime(TimeUtil.getCurrentDateTime());
                dboSqlLog.setCostTime(new BigDecimal(endMills - startMills).divide(BigDecimal.valueOf(1000.0)));
                dboSqlLog.setDboResult("Y");
                dboSqlLogRepository.insert((Object)dboSqlLog);
            }
            ps.close();
            conn.close();
            return result;
        }
        catch (Exception e) {
            result.add((Map<String, Object>)((Object)("\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage())));
            long endMills = System.currentTimeMillis();
            dboSqlLog.setEndTime(TimeUtil.getCurrentDateTime());
            dboSqlLog.setCostTime(new BigDecimal(endMills - startMills).divide(BigDecimal.valueOf(1000.0)));
            dboSqlLog.setDboErrMsg(e.getMessage());
            DboSqlLogRepository _dboSqlLogRepository = (DboSqlLogRepository)SpringContextUtils.getBean(DboSqlLogRepository.class);
            _dboSqlLogRepository.insert((Object)dboSqlLog);
            throw new RuntimeException("\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    public String sqlConnection(SSubsDatasourceDTO sSubsDatasource) {
        String driverName = null;
        if ("05".equals(sSubsDatasource.getSubsDsType())) {
            driverName = "com.mysql.jdbc.Driver";
        } else if ("1".equals(sSubsDatasource.getSubsDsType())) {
            driverName = "oracle.jdbc.driver.OracleDriver";
        } else if ("2".equals(sSubsDatasource.getSubsDsType())) {
            driverName = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        try {
            Class.forName(driverName);
            String url = sSubsDatasource.getDsConnStr() + "/" + sSubsDatasource.getDsDbName() + "?useSSL=false&serverTimezone=UTC&allowMultiQueries=true";
            Connection connection = DriverManager.getConnection(url, sSubsDatasource.getDsUserId(), sSubsDatasource.getDsUserPwd());
            connection.close();
        }
        catch (Exception e) {
            return "\u6d4b\u8bd5\u5931\u8d25:" + e;
        }
        return "\u6d4b\u8bd5\u6210\u529f";
    }

    public List<String> getTableName(SSubsDatasourceDTO sSubsDatasource) {
        ArrayList<String> result = new ArrayList<String>();
        PreparedStatement ps = null;
        Connection conn = null;
        String driverName = null;
        if ("05".equals(sSubsDatasource.getSubsDsType())) {
            driverName = "com.mysql.jdbc.Driver";
        } else if ("1".equals(sSubsDatasource.getSubsDsType())) {
            driverName = "oracle.jdbc.driver.OracleDriver";
        } else if ("2".equals(sSubsDatasource.getSubsDsType())) {
            driverName = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        try {
            String url = sSubsDatasource.getDsConnStr() + "/" + sSubsDatasource.getDsDbName() + "?useSSL=false&serverTimezone=UTC&allowMultiQueries=true";
            String user = sSubsDatasource.getDsUserId();
            String password = sSubsDatasource.getDsUserPwd();
            String sql = "SELECT TB.TABLE_NAME FROM INFORMATION_SCHEMA.TABLES TB WHERE TB.TABLE_SCHEMA ='" + sSubsDatasource.getDsDbName() + "'";
            Class.forName(driverName);
            conn = DriverManager.getConnection(url, user, password);
            ps = conn.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            while (rs.next()) {
                int ColumnCount = rsmd.getColumnCount();
                HashMap<String, Object> rowData = new HashMap<String, Object>();
                for (int i = 1; i <= ColumnCount; ++i) {
                    rowData.put(rsmd.getColumnName(i), rs.getObject(i));
                }
                result.add((String)((Object)rowData));
            }
            return result;
        }
        catch (ClassNotFoundException | SQLException e) {
            result.add("\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            e.printStackTrace();
            return result;
        }
    }
}

