/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.paas.dbo.web.controller.api;

import com.irdstudio.paas.dbo.facade.DataSqlOrderService;
import com.irdstudio.paas.dbo.facade.dto.DataSqlOrderDTO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class DataSqlOrderController
extends BaseController<DataSqlOrderDTO, DataSqlOrderService> {
    @RequestMapping(value={"/api/data/sql/orders"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DataSqlOrderDTO>> queryDataSqlOrderAll(DataSqlOrderDTO dto) {
        this.setUserInfoToVO(dto);
        List outputVo = ((DataSqlOrderService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/data/sql/order/{orderId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<DataSqlOrderDTO> queryByPk(@PathVariable(value="orderId") String orderId) {
        DataSqlOrderDTO inVo = new DataSqlOrderDTO();
        inVo.setOrderId(orderId);
        DataSqlOrderDTO outputVo = (DataSqlOrderDTO)((DataSqlOrderService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/data/sql/order"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DataSqlOrderDTO inDataSqlOrderDTO) {
        int outputVo = ((DataSqlOrderService)this.getService()).deleteByPk((Object)inDataSqlOrderDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/data/sql/order"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DataSqlOrderDTO inDataSqlOrderDTO) {
        int outputVo = ((DataSqlOrderService)this.getService()).updateByPk((Object)inDataSqlOrderDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/data/sql/order"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertDataSqlOrder(@RequestBody DataSqlOrderDTO inDataSqlOrderDTO) {
        int outputVo = ((DataSqlOrderService)this.getService()).insert((Object)inDataSqlOrderDTO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/data/sql/order/seq"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryMaxIdBySubsId(@RequestParam(value="subsId") String subsId) {
        return this.getResponseData(((DataSqlOrderService)this.getService()).queryMaxIdByPrefix(subsId));
    }

    @RequestMapping(value={"/api/data/sql/orders/group"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DataSqlOrderDTO>> queryDataSqlOrderGroupAll(DataSqlOrderDTO dto) {
        this.setUserInfoToVO(dto);
        List outputVo = ((DataSqlOrderService)this.getService()).queryTimeGroupListByPage(dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/admpaas/data/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryAdmpaasSummary(@RequestBody Map<String, Object> param) {
        List outputVo = ((DataSqlOrderService)this.getService()).queryAdmpaasSummary(param);
        return this.getResponseData(outputVo);
    }
}

