/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allincloud.portal.web.controller.api;

import com.irdstudio.allinapaas.deliver.console.facade.PaasEcsInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.PaasEnvInfoService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEnvInfoDTO;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.sdk.admin.dao.domain.SEnvInfo;
import com.irdstudio.sdk.admin.service.facade.SPortalModuleService;
import com.irdstudio.sdk.admin.service.facade.SRolemoduleService;
import com.irdstudio.sdk.admin.service.facade.SRoleuserService;
import com.irdstudio.sdk.admin.service.vo.SPortalModuleVO;
import com.irdstudio.sdk.admin.service.vo.SRolemoduleVO;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class MyPortalModuleController
extends AbstractController {
    @Autowired
    @Qualifier(value="sPortalModuleServiceImpl")
    private SPortalModuleService sPortalModuleService;
    @Autowired
    private PaasEcsInfoService paasEcsInfoService;
    @Autowired
    private PaasEnvInfoService paasEnvInfoService;
    @Autowired
    @Qualifier(value="sRolemoduleServiceImpl")
    private SRolemoduleService sRolemoduleService;
    @Autowired
    @Qualifier(value="sRoleuserServiceImpl")
    private SRoleuserService sRoleuserService;
    public static final String RIGHT_FLAG_ALLOW_ACCESS = "A";
    public static final String RIGHT_FLAG_FORBID = "F";

    @RequestMapping(value={"/api/s/portal/module/enable"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> enableModule(@RequestBody SPortalModuleVO sPortalModuleVO) {
        boolean output = false;
        if ((sPortalModuleVO = this.sPortalModuleService.queryByPk(sPortalModuleVO)) != null) {
            this.clearModuleRoleData(sPortalModuleVO);
            sPortalModuleVO.setModuleState(YesOrNO.YES.getCode());
            this.sPortalModuleService.updateByPk(sPortalModuleVO);
            PaasEcsInfoDTO moduleEcs = new PaasEcsInfoDTO();
            moduleEcs.setEcsId(UUIDUtil.getShortUUID());
            moduleEcs.setPaasDuId(sPortalModuleVO.getModuleCode());
            moduleEcs.setEcsName(sPortalModuleVO.getModuleShort() + "\u670d\u52a1\u5668");
            this.paasEcsInfoService.insert((Object)moduleEcs);
            output = true;
        } else {
            output = false;
        }
        return this.getResponseData(output);
    }

    @RequestMapping(value={"/api/s/portal/module/disable"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> disableModule(@RequestBody SPortalModuleVO sPortalModuleVO) {
        boolean output = false;
        if ((sPortalModuleVO = this.sPortalModuleService.queryByPk(sPortalModuleVO)) != null) {
            sPortalModuleVO.setModuleState(YesOrNO.NO.getCode());
            this.sPortalModuleService.updateByPk(sPortalModuleVO);
            output = this.clearModuleRoleData(sPortalModuleVO);
        } else {
            output = false;
        }
        return this.getResponseData(output);
    }

    private boolean clearModuleRoleData(SPortalModuleVO sPortalModuleVO) {
        String moduleCode = sPortalModuleVO.getModuleCode();
        PaasEcsInfoDTO moduleEcs = new PaasEcsInfoDTO();
        moduleEcs.setPaasDuId(moduleCode);
        this.paasEcsInfoService.deleteByPaasDuId(moduleEcs);
        return true;
    }

    @RequestMapping(value={"/api/s/env/role"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SEnvInfo> queryUserEnvRole(@RequestParam(name="module", required=false) String module) {
        if (StringUtils.isBlank((CharSequence)module) || StringUtils.equals((CharSequence)module, (CharSequence)"undefined")) {
            module = "";
        }
        UserInfo userInfo = this.getUserInfo();
        SRolemoduleVO roleParam = new SRolemoduleVO();
        roleParam.setModuleCode(module);
        roleParam.setLoginUserId(userInfo.getUserId());
        roleParam.setRightFlag(RIGHT_FLAG_ALLOW_ACCESS);
        List userRoles = this.sRolemoduleService.queryAllOwner(roleParam);
        SRolemoduleVO moduleRole = null;
        if (CollectionUtils.isNotEmpty((Collection)userRoles)) {
            moduleRole = (SRolemoduleVO)userRoles.get(0);
        }
        if (moduleRole != null) {
            String[] str = StringUtils.split((String)moduleRole.getModuleCode(), (String)"-");
            if (str != null && str.length > 1) {
                String envId = str[1];
                PaasEnvInfoDTO envParam = new PaasEnvInfoDTO();
                envParam.setEnvId(envId);
                PaasEnvInfoDTO envInfo = (PaasEnvInfoDTO)this.paasEnvInfoService.queryByPk((Object)envParam);
                SEnvInfo sEnv = new SEnvInfo();
                sEnv.setEnvId(envInfo.getEnvId());
                sEnv.setEnvName(envInfo.getEnvName());
                return this.getResponseData(sEnv, "\u6709\u6743\u9650\u8bbf\u95ee", "\u65e0\u6743\u9650\u8bbf\u95ee");
            }
            return this.getResponseData(null, "\u6709\u6743\u9650\u8bbf\u95ee", "\u65e0\u6743\u9650\u8bbf\u95ee");
        }
        return this.getResponseData(null, "\u6709\u6743\u9650\u8bbf\u95ee", "\u65e0\u6743\u9650\u8bbf\u95ee");
    }
}

