/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allincloud.portal.web.controller.api;

import com.irdstudio.allincloud.portal.facade.WxService;
import com.irdstudio.allincloud.portal.facade.dto.wx.WXBaseInfo;
import com.irdstudio.allincloud.portal.facade.dto.wx.WXGetPhoneNumber;
import com.irdstudio.allincloud.portal.facade.dto.wx.WXJscode2session;
import com.irdstudio.allincloud.portal.facade.dto.wx.WXSendSubscribe;
import com.irdstudio.allincloud.portal.facade.dto.wx.WXUserInfo;
import com.irdstudio.sdk.admin.service.facade.E4AServiceSsm;
import com.irdstudio.sdk.admin.service.facade.SUserService;
import com.irdstudio.sdk.admin.service.vo.AuthInfoVO;
import com.irdstudio.sdk.admin.service.vo.SUserVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import com.irdstudio.sdk.ssm.session.SessionManager;
import com.irdstudio.sdk.ssm.vo.UserInfo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class WXOpenController
extends AbstractController {
    @Autowired
    private WxService wxService;
    @Autowired
    @Qualifier(value="sUserServiceImpl")
    private SUserService sUserService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    @Qualifier(value="e4aServiceC")
    private E4AServiceSsm e4AService;

    @RequestMapping(value={"/client/wx/getUserInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<WXUserInfo> getUserInfo(@RequestBody WXUserInfo param, HttpServletRequest request) {
        WXJscode2session openidDto = new WXJscode2session();
        openidDto.setJs_code(param.getJs_code());
        openidDto = this.wxService.jscode2session(openidDto);
        if (openidDto != null && StringUtils.isNotBlank((CharSequence)openidDto.getOpenid())) {
            SUserVO userInfo = new SUserVO();
            userInfo.setWexinOpenid(openidDto.getOpenid());
            logger.debug("wx openid {}", (Object)openidDto.getOpenid());
            List users = this.sUserService.queryAllOwner(userInfo);
            if (CollectionUtils.isNotEmpty((Collection)users)) {
                WXUserInfo wxUserInfo = new WXUserInfo();
                SUserVO user = (SUserVO)users.stream().findFirst().get();
                wxUserInfo.setActorname(user.getActorname());
                wxUserInfo.setActorno(user.getActorno());
                wxUserInfo.setMobNum(user.getMobNum());
                AuthInfoVO authInfo = new AuthInfoVO();
                authInfo.setSessionId(request.getSession().getId());
                authInfo.setUsercode(user.getActorno());
                authInfo = this.e4AService.casGetUserInfo(authInfo);
                if (authInfo != null && Objects.nonNull(authInfo.getUserInfo())) {
                    request.getSession().setAttribute("WX_SESSION", (Object)true);
                    this.sessionManager.setLoginInfo(authInfo.getUserInfo(), request);
                    wxUserInfo.setSessionId(authInfo.getSessionId());
                }
                wxUserInfo.setMobNum(user.getMobNum());
                return this.getResponseData(wxUserInfo);
            }
            WXUserInfo wxUserInfo = new WXUserInfo();
            wxUserInfo.setOpenid(openidDto.getOpenid());
            return ResponseData.create((Object)wxUserInfo, (String)"901", (String)"\u7528\u6237\u672a\u7ed1\u5b9a\u5fae\u4fe1", (boolean)false);
        }
        return this.getResponseData(null);
    }

    @RequestMapping(value={"/client/wx/userBindWx"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<WXUserInfo> userBindWx(@RequestBody WXUserInfo param, HttpServletRequest request) {
        String phoneNumber = param.getMobNum();
        if (StringUtils.isBlank((CharSequence)phoneNumber) && StringUtils.isNotBlank((CharSequence)param.getJs_code())) {
            WXGetPhoneNumber phoneNumberDto = new WXGetPhoneNumber();
            phoneNumberDto.setCode(param.getJs_code());
            phoneNumberDto = this.wxService.getPhoneNumber(phoneNumberDto);
            phoneNumber = phoneNumberDto.getPhone_info().getPhoneNumber();
        }
        if (StringUtils.isNotBlank((CharSequence)phoneNumber)) {
            SUserVO userInfo = new SUserVO();
            userInfo.setTelnum(phoneNumber);
            List users = this.sUserService.queryAllOwner(userInfo);
            if (CollectionUtils.isNotEmpty((Collection)users)) {
                if (users.size() > 1) {
                    logger.error("\u8be5\u624b\u673a\u53f7\u6709\u591a\u4e2a\u7528\u6237 {}", (Object)userInfo.getMobNum());
                }
                WXUserInfo wxUserInfo = new WXUserInfo();
                SUserVO user = (SUserVO)users.stream().findFirst().get();
                user.setWexinOpenid(param.getOpenid());
                this.sUserService.updateByPk(user);
                wxUserInfo.setActorname(user.getActorname());
                wxUserInfo.setActorno(user.getActorno());
                wxUserInfo.setMobNum(user.getMobNum());
                AuthInfoVO authInfo = new AuthInfoVO();
                authInfo.setUsercode(user.getActorno());
                authInfo.setSessionId(request.getSession().getId());
                authInfo = this.e4AService.casGetUserInfo(authInfo);
                if (authInfo != null && Objects.nonNull(authInfo.getUserInfo())) {
                    this.sessionManager.setLoginInfo(authInfo.getUserInfo(), request);
                    wxUserInfo.setSessionId(authInfo.getSessionId());
                }
                wxUserInfo.setMobNum(user.getMobNum());
                return this.getResponseData(wxUserInfo);
            }
            return ResponseData.create(null, (String)"902", (String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728AllinPaas\u6570\u5b57\u57fa\u5ea7\u4e2d\u7ef4\u62a4\u7528\u6237\u624b\u673a\u53f7", (boolean)false);
        }
        return ResponseData.create(null, (String)"903", (String)"\u672a\u80fd\u83b7\u53d6\u5fae\u4fe1\u7528\u6237\u624b\u673a\u53f7", (boolean)false);
    }

    @RequestMapping(value={"/client/wx/sessionInfo"}, method={RequestMethod.GET})
    public UserInfo sessionInfo(@RequestParam(value="ssoClient") String ssoClient) {
        UserInfo userInfo = this.sessionManager.getLoginInfo(ssoClient);
        return userInfo;
    }

    @RequestMapping(value={"/client/WxService/jscode2session"}, method={RequestMethod.POST})
    @ResponseBody
    public WXJscode2session jscode2session(@RequestBody WXJscode2session input) {
        return this.wxService.jscode2session(input);
    }

    @RequestMapping(value={"/client/WxService/WXGetPhoneNumber"}, method={RequestMethod.POST})
    @ResponseBody
    public WXGetPhoneNumber getPhoneNumber(@RequestBody WXGetPhoneNumber input) {
        return this.wxService.getPhoneNumber(input);
    }

    @RequestMapping(value={"/client/WxService/sendSubscribe"}, method={RequestMethod.POST})
    @ResponseBody
    public String sendSubscribe(@RequestBody WXSendSubscribe input) {
        return this.wxService.sendSubscribe(input);
    }

    @RequestMapping(value={"/client/WxService/getAccessToken"}, method={RequestMethod.GET})
    @ResponseBody
    public WXBaseInfo getAccessToken() {
        return this.wxService.getAccessToken();
    }
}

