/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.admin.console.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinflow.admin.console.acl.repository.PaasSubsSyncRepository;
import com.irdstudio.allinflow.admin.console.domain.entity.PaasSubsSyncDO;
import com.irdstudio.allinflow.admin.console.facade.PaasSubsSyncService;
import com.irdstudio.allinflow.admin.console.facade.dto.PaasSubsSyncDTO;
import com.irdstudio.allinflow.admin.console.types.SyncState;
import com.irdstudio.allinflow.console.acl.repository.SSubsInfoPortalRepository;
import com.irdstudio.allinflow.console.types.YesOrNO;
import com.irdstudio.allinflow.deliver.console.acl.repository.PaasEnvInfoRepository;
import com.irdstudio.allinflow.design.console.acl.repository.PaasAppsGroupRepository;
import com.irdstudio.allinflow.design.console.acl.repository.PaasAppsInfoRepository;
import com.irdstudio.allinflow.design.console.acl.repository.PaasSubsGroupRepository;
import com.irdstudio.allinflow.design.console.domain.entity.PaasAppsGroupDO;
import com.irdstudio.allinflow.design.console.domain.entity.PaasAppsInfoDO;
import com.irdstudio.allinflow.design.console.domain.entity.PaasSubsGroupDO;
import com.irdstudio.allinflow.design.console.domain.entity.SSubsInfoDO;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.SUserService;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.dto.SUserDTO;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sSubsSyncServiceImpl")
public class PaasSubsSyncServiceImpl
extends BaseServiceImpl<PaasSubsSyncDTO, PaasSubsSyncDO, PaasSubsSyncRepository>
implements PaasSubsSyncService {
    @Autowired
    private PaasEnvInfoRepository paasEnvInfoRepository;
    @Autowired
    private SSubsInfoPortalRepository sSubsInfoPortalRepository;
    @Autowired
    private PaasAppsInfoRepository paasAppsInfoPortalRepository;
    @Autowired
    private PaasAppsGroupRepository paasAppsGroupRepository;
    @Autowired
    private PaasSubsGroupRepository paasSubsGroupRepository;
    @Autowired
    private SUserService sUserService;
    private HttpClient httpClient = HttpClients.createDefault();
    private static final ConcurrentMap<String, String> taskQueue = new ConcurrentHashMap<String, String>();

    public String execSync(String runType) {
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)taskQueue.get("runStat")))) {
            return (String)taskQueue.get("runStat");
        }
        Thread caller = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PaasSubsSyncDO syncParam = new PaasSubsSyncDO();
                List syncList = ((PaasSubsSyncRepository)PaasSubsSyncServiceImpl.this.getRepository()).queryList((Object)syncParam);
                if (CollectionUtils.isNotEmpty((Collection)syncList)) {
                    taskQueue.put("runStat", YesOrNO.YES.getCode());
                    try {
                        PaasAppsGroupDO groupParam = new PaasAppsGroupDO();
                        List groupList = PaasSubsSyncServiceImpl.this.paasAppsGroupRepository.queryList((Object)groupParam);
                        PaasSubsGroupDO subsGroupParam = new PaasSubsGroupDO();
                        List subsGroupList = PaasSubsSyncServiceImpl.this.paasSubsGroupRepository.queryList((Object)subsGroupParam);
                        SSubsInfoDO subsParam = new SSubsInfoDO();
                        List subsList = PaasSubsSyncServiceImpl.this.sSubsInfoPortalRepository.queryList((Object)subsParam);
                        ArrayList<PaasAppsInfoDO> appList = new ArrayList<PaasAppsInfoDO>();
                        if (CollectionUtils.isNotEmpty((Collection)subsList)) {
                            PaasAppsInfoDO appParam = new PaasAppsInfoDO();
                            List list = PaasSubsSyncServiceImpl.this.paasAppsInfoPortalRepository.queryList((Object)appParam);
                            if (CollectionUtils.isNotEmpty((Collection)list)) {
                                appList.addAll(list);
                            }
                        }
                        PaasSubsSyncData syncData = new PaasSubsSyncData();
                        syncData.setSubsList(subsList);
                        syncData.setAppList(appList);
                        syncData.setGroupList(groupList);
                        syncData.setSubsGroupList(subsGroupList);
                        SUserDTO userParam = new SUserDTO();
                        List userList = PaasSubsSyncServiceImpl.this.sUserService.queryList((Object)userParam);
                        syncData.setUserList(userList);
                        for (PaasSubsSyncDO syncConfig : syncList) {
                            syncConfig.setSyncState(null);
                            syncConfig.setSyncTime(null);
                            ((PaasSubsSyncRepository)PaasSubsSyncServiceImpl.this.getRepository()).updateByPk((Object)syncConfig);
                            HttpPost postMethod = new HttpPost(syncConfig.getSyncUrl());
                            HttpResponse response = null;
                            try {
                                String reqJson = JSON.toJSONString((Object)syncData);
                                StringEntity entity = new StringEntity(reqJson, ContentType.APPLICATION_JSON);
                                postMethod.setEntity((HttpEntity)entity);
                                response = PaasSubsSyncServiceImpl.this.httpClient.execute((HttpUriRequest)postMethod);
                                String json = EntityUtils.toString((HttpEntity)response.getEntity());
                                ResponseData output = (ResponseData)JSON.parseObject((String)json, ResponseData.class);
                                if (output == null) {
                                    syncConfig.setSyncState(SyncState.Fail.getCode());
                                    syncConfig.setSyncTime(CurrentDateUtil.getTodayDateEx2());
                                    ((PaasSubsSyncRepository)PaasSubsSyncServiceImpl.this.getRepository()).updateByPk((Object)syncConfig);
                                    continue;
                                }
                                if (output.isSuccess()) {
                                    syncConfig.setSyncState(SyncState.Success.getCode());
                                } else {
                                    syncConfig.setSyncState(SyncState.Fail.getCode());
                                }
                                syncConfig.setSyncTime(CurrentDateUtil.getTodayDateEx2());
                                ((PaasSubsSyncRepository)PaasSubsSyncServiceImpl.this.getRepository()).updateByPk((Object)syncConfig);
                            }
                            catch (Exception e) {
                                BaseServiceImpl.logger.error("\u5916\u90e8\u5de5\u5177\u6982\u89c8\u63a5\u53e3\u8c03\u7528\u5931\u8d25 {}", (Object)e.getMessage(), (Object)e);
                            }
                        }
                    }
                    finally {
                        taskQueue.remove("runStat");
                    }
                }
            }
        };
        if (StringUtils.equals((CharSequence)"local", (CharSequence)runType)) {
            caller.start();
        } else {
            caller.run();
        }
        return YesOrNO.YES.getCode();
    }

    public String fetchExecSyncState() {
        return (String)taskQueue.get("runStat");
    }

    public static class PaasSubsSyncData {
        private List<SSubsInfoDO> subsList;
        private List<PaasAppsInfoDO> appList;
        private List<PaasAppsGroupDO> groupList;
        private List<PaasSubsGroupDO> subsGroupList;
        private List<SUserDTO> userList;

        public List<SSubsInfoDO> getSubsList() {
            return this.subsList;
        }

        public void setSubsList(List<SSubsInfoDO> subsList) {
            this.subsList = subsList;
        }

        public List<PaasAppsInfoDO> getAppList() {
            return this.appList;
        }

        public void setAppList(List<PaasAppsInfoDO> appList) {
            this.appList = appList;
        }

        public List<PaasAppsGroupDO> getGroupList() {
            return this.groupList;
        }

        public void setGroupList(List<PaasAppsGroupDO> groupList) {
            this.groupList = groupList;
        }

        public List<PaasSubsGroupDO> getSubsGroupList() {
            return this.subsGroupList;
        }

        public void setSubsGroupList(List<PaasSubsGroupDO> subsGroupList) {
            this.subsGroupList = subsGroupList;
        }

        public List<SUserDTO> getUserList() {
            return this.userList;
        }

        public void setUserList(List<SUserDTO> userList) {
            this.userList = userList;
        }
    }
}

