/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.console.application.service.task;

import com.irdstudio.allinflow.console.facade.PaasTaskComimportService;
import com.irdstudio.allinflow.console.facade.PaasTaskHisService;
import com.irdstudio.allinflow.console.facade.PaasTaskInfoService;
import com.irdstudio.allinflow.console.facade.dto.PaasTaskComimportDTO;
import com.irdstudio.allinflow.console.facade.dto.PaasTaskHisDTO;
import com.irdstudio.allinflow.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.allinflow.design.console.facade.PaasTemplateComService;
import com.irdstudio.allinflow.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinflow.design.console.facade.dto.PaasTemplateComDTO;
import com.irdstudio.framework.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.framework.beans.core.util.BeanUtility;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.core.util.UUIDUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMetaTask.class);
    public static final ConcurrentMap<String, Boolean> taskDebounce = new ConcurrentHashMap<String, Boolean>();

    public void updateMetaTask(PaasTaskInfoDTO taskInfo, ExecuteRtnInfo rtn) {
        int state;
        PaasTaskInfoService paasTaskInfoService = (PaasTaskInfoService)SpringContextUtils.getBean(PaasTaskInfoService.class);
        PaasTaskHisService paasTaskHisService = (PaasTaskHisService)SpringContextUtils.getBean(PaasTaskHisService.class);
        taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        if (rtn != null) {
            state = rtn.isSuccessFlag() ? 6 : 7;
            taskInfo.setTaskState(String.valueOf(state));
            if (StringUtils.isNotBlank((CharSequence)rtn.getFailReason())) {
                taskInfo.setTaskErrorMsg(rtn.getFailReason());
            }
            String startTime = taskInfo.getStartTime();
            String endTime = taskInfo.getEndTime();
            try {
                Date startDate = DateUtils.parseDate((String)startTime, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
                Date endData = DateUtils.parseDate((String)endTime, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
                long costTime = endData.getTime() - startDate.getTime();
                BigDecimal re = new BigDecimal(costTime).divide(new BigDecimal(1000), 2, RoundingMode.HALF_UP);
                taskInfo.setCostTime(re);
            }
            catch (Exception e) {
                logger.error("\u8fd0\u884c\u8017\u65f6\u8ba1\u7b97\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            }
        } else {
            state = 2;
            taskInfo.setTaskState(String.valueOf(state));
        }
        if (StringUtils.isNotBlank((CharSequence)taskInfo.getTaskErrorMsg()) && taskInfo.getTaskErrorMsg().length() > 300) {
            taskInfo.setTaskErrorMsg(StringUtils.substring((String)taskInfo.getTaskErrorMsg(), (int)0, (int)299));
        }
        paasTaskInfoService.updateByPk((Object)taskInfo);
        if (rtn != null) {
            PaasTaskHisDTO history = new PaasTaskHisDTO();
            BeanUtility.beanCopy((Object)taskInfo, (Object)history);
            history.setTaskHisId(UUIDUtil.getShortUUID());
            paasTaskHisService.insert((Object)history);
        }
    }

    public void checkAndImportCom(PaasAppsInfoDTO appInfo, String comId, String subsId) {
        if (appInfo == null) {
            logger.info("\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5e94\u7528\u6a21\u677f\u4f9d\u8d56\u7ec4\u4ef6\u68c0\u67e5\u5bfc\u5165");
            return;
        }
        PaasTemplateComService paasTemplateComService = (PaasTemplateComService)SpringContextUtils.getBean(PaasTemplateComService.class);
        PaasTaskComimportService paasTaskComimportService = (PaasTaskComimportService)SpringContextUtils.getBean(PaasTaskComimportService.class);
        PaasTaskInfoService paasTaskInfoService = (PaasTaskInfoService)SpringContextUtils.getBean(PaasTaskInfoService.class);
        PaasTemplateComDTO comParam = new PaasTemplateComDTO();
        comParam.setAppTemplateId(appInfo.getAppTemplateId());
        List comList = paasTemplateComService.queryList((Object)comParam);
        ArrayList<PaasTaskComimportDTO> comImportTask = new ArrayList<PaasTaskComimportDTO>();
        if (CollectionUtils.isNotEmpty((Collection)comList)) {
            for (PaasTemplateComDTO com : comList) {
                PaasTaskComimportDTO comImport = new PaasTaskComimportDTO();
                BeanUtility.beanCopy((Object)com, (Object)comImport, (boolean)true);
                comImport.setTaskType("C01001");
                comImport.setAppId(appInfo.getAppId());
                comImport.setAppCode(appInfo.getAppCode());
                comImport.setAppName(appInfo.getAppName());
                comImport.setSubsId(appInfo.getSubsId());
                List checkList = paasTaskComimportService.queryListByPage((Object)comImport);
                if (CollectionUtils.isNotEmpty((Collection)checkList)) {
                    comImport = (PaasTaskComimportDTO)checkList.get(0);
                } else {
                    comImport.setTaskName(String.format("%s-%s-%s", com.getComDomainName(), com.getComGroupName(), com.getComName()));
                    comImport.setTaskId(UUIDUtil.getShortUUID());
                    comImport.setComSubsId(com.getSubsId());
                    comImport.setPackagePrefix("com.irdstudio");
                    comImport.setCreateUser(appInfo.getCreateUser());
                    comImport.setCreateTime(appInfo.getCreateTime());
                    comImport.setLastUpdateUser(appInfo.getCreateUser());
                    comImport.setLastUpdateTime(appInfo.getCreateTime());
                    paasTaskComimportService.insert((Object)comImport);
                }
                comImportTask.add(comImport);
            }
        }
        for (PaasTaskComimportDTO task : comImportTask) {
            paasTaskInfoService.executeTask(task.getTaskId(), appInfo.getCreateUser());
        }
    }
}

