/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.console.application.service.task;

import com.irdstudio.allinflow.console.application.service.task.GitRepoPushTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitRepoPushQueueExecutor {
    private static Logger logger = LoggerFactory.getLogger(GitRepoPushQueueExecutor.class);
    private static ConcurrentLinkedQueue<GitRepoPushTask> taskQueue = new ConcurrentLinkedQueue();
    private static AtomicBoolean isRunning = new AtomicBoolean(false);

    public static void addTask(GitRepoPushTask task) {
        taskQueue.add(task);
    }

    public static void run(GitRepoPushTask task) {
        taskQueue.add(task);
        if (isRunning.get()) {
            return;
        }
        GitRepoPushQueueExecutor.start();
    }

    public static synchronized void start() {
        if (isRunning.get()) {
            return;
        }
        GitRepoPushQueueExecutor.loop();
    }

    public static void loop() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (!taskQueue.isEmpty()) {
                    GitRepoPushTask task = (GitRepoPushTask)taskQueue.poll();
                    try {
                        task.execute();
                    }
                    catch (Exception e) {
                        logger.error("wiki \u6587\u6863\u4ed3\u5e93\u63a8\u9001\u4efb\u52a1\u5931\u8d25 " + e.getMessage(), (Throwable)e);
                    }
                }
                isRunning.set(false);
            }
        };
        thread.start();
        isRunning.set(true);
    }
}

