/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.console.application.service.task;

import com.irdstudio.allinflow.console.application.service.task.AbstractMetaTask;
import com.irdstudio.allinflow.console.application.service.task.AppRepoPushTaskImpl;
import com.irdstudio.allinflow.console.application.service.utils.SdEnvUtil;
import com.irdstudio.allinflow.console.facade.dto.PaasTaskInfoDTO;
import com.irdstudio.allinflow.deliver.console.facade.PaasEcsInfoService;
import com.irdstudio.allinflow.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinflow.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinflow.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinflow.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinflow.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinflow.executor.application.executor.core.plugin.db.TdpAgentCommonUtil;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.LoggerFactory;
import com.irdstudio.allinflow.executor.application.executor.core.tinycore.log.TLogger;
import com.irdstudio.allinflow.executor.types.ExecutorInstInfo;
import com.irdstudio.framework.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.framework.beans.core.util.BeanUtility;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.ibatis.jdbc.ScriptRunner;

public class InitDbBaseTask
extends AbstractMetaTask
implements Callable<ExecuteRtnInfo> {
    private ILogger logger = null;
    private PaasTaskInfoDTO taskInfo;
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (InitDbBaseTask.this.logger != null) {
                InitDbBaseTask.this.logger.info((Object)line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (InitDbBaseTask.this.logger != null) {
                InitDbBaseTask.this.logger.error((Object)line);
            } else {
                System.err.println(line);
            }
        }
    };

    public InitDbBaseTask(PaasTaskInfoDTO taskInfo) {
        this.taskInfo = taskInfo;
        String fullLogFileName = ExecutorInstInfo.BATCH_LOG_PATH + File.separator + taskInfo.getTaskId() + ".log";
        FileUtils.deleteQuietly((File)new File(fullLogFileName));
        ILogger fileLogger = LoggerFactory.makeTxtFileLogger((String)fullLogFileName, (boolean)true);
        fileLogger.setName(taskInfo.getTaskId());
        TLogger.registerCategoryLogger((String)taskInfo.getTaskId(), (ILogger)fileLogger);
        this.logger = TLogger.getLogger((String)taskInfo.getTaskId());
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        ExecuteRtnInfo rtn = new ExecuteRtnInfo();
        this.taskInfo.setStartTime(CurrentDateUtil.getTodayDateEx2());
        this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
        this.updateMetaTask(this.taskInfo, null);
        Connection conn = null;
        try {
            PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
            PaasEcsInfoService paasEcsInfoService = (PaasEcsInfoService)SpringContextUtils.getBean(PaasEcsInfoService.class);
            PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
            String userId = this.taskInfo.getLoginUserId();
            String subsId = this.taskInfo.getSubsId();
            String appId = this.taskInfo.getAppId();
            String taskId = this.taskInfo.getTaskId();
            String envId = this.taskInfo.getEnvId();
            PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
            appInfo.setAppId(appId);
            appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appInfo);
            Object ecsInfo = new PaasEcsInfoDTO();
            ecsInfo.setAppId(appId);
            ecsInfo.setEnvId(envId);
            List ecsInfoList = paasEcsInfoService.queryListByPage(ecsInfo);
            ecsInfo = CollectionUtils.isNotEmpty((Collection)ecsInfoList) ? (PaasEcsInfoDTO)ecsInfoList.get(0) : null;
            if (ecsInfo == null) {
                throw new RuntimeException("\u670d\u52a1\u5668\u4e0d\u5b58\u5728");
            }
            this.logger.info((Object)String.format("\u5f00\u59cb\u521d\u59cb\u5316\u57fa\u7840\u6570\u636e\u5230\u670d\u52a1\u5668%s,\u7aef\u53e3%s", ecsInfo.getEcsIp(), ecsInfo.getEcsPort()));
            File configDir = new File(this.getAppConfigFilePath(appInfo));
            File initBase = new File(configDir, "initBase.sql");
            String initBaseContent = this.readFileContent(initBase);
            HashMap<String, String> appsParam = new HashMap<String, String>();
            appsParam.put("database_ip", ecsInfo.getEcsIp());
            appsParam.put("database_port", ecsInfo.getEcsPort());
            appsParam.put("database_username", ecsInfo.getEcsLoginUser());
            appsParam.put("database_password", ecsInfo.getEcsLoginPwd());
            conn = TdpAgentCommonUtil.getNativeConnection((PaasAppsInfo)((PaasAppsInfo)BeanUtility.beanCopy((Object)appInfo, (Object)new PaasAppsInfo())), appsParam, (boolean)false);
            if (conn == null) {
                conn = TdpAgentCommonUtil.getNativeConnection((PaasAppsInfo)((PaasAppsInfo)BeanUtility.beanCopy((Object)appInfo, (Object)new PaasAppsInfo())), appsParam, (boolean)true);
            }
            this.logger.info((Object)String.format("\u6267\u884c\u521d\u59cb\u5316\u57fa\u7840\u6570\u636e\u8bed\u53e5:\n%s", initBaseContent));
            this.runScript(conn, initBaseContent);
            AppRepoPushTaskImpl pushTask = new AppRepoPushTaskImpl(userId, configDir.getParentFile(), appInfo.getAppGitUrl(), String.format("%s #%s %s", this.taskInfo.getTaskName(), this.taskInfo.getTaskId(), CurrentDateUtil.getTodayDate()), appInfo);
            pushTask.execute();
            rtn.setSuccessFlag(true);
        }
        catch (Exception e) {
            rtn.setSuccessFlag(false);
            this.taskInfo.setTaskErrorMsg("\u521d\u59cb\u5316\u57fa\u7840\u6570\u636e\u5f02\u5e38 " + e.getMessage());
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u521d\u59cb\u5316\u57fa\u7840\u6570\u636e\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            taskDebounce.put(this.taskInfo.getTaskId(), false);
            if (conn != null) {
                conn.close();
            }
            this.taskInfo.setEndTime(CurrentDateUtil.getTodayDateEx2());
            this.updateMetaTask(this.taskInfo, rtn);
        }
        return rtn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFileContent(File file) {
        try (FileInputStream input = new FileInputStream(file);){
            String string = IOUtils.toString((InputStream)input, (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6\u811a\u672c\u6587\u4ef6\u5f02\u5e38 " + e.getMessage());
        }
    }

    private boolean runScript(Connection conn, String content) throws Exception {
        boolean flag = true;
        ScriptRunner sr = new ScriptRunner(conn);
        SqlRunLogWriter errorWriter = new SqlRunLogWriter(new StringWriter(), true);
        sr.setErrorLogWriter((PrintWriter)errorWriter);
        sr.setLogWriter((PrintWriter)new SqlRunLogWriter(new StringWriter(), false));
        BufferedReader reader = new BufferedReader(new StringReader(content));
        sr.runScript((Reader)reader);
        if (errorWriter.isHasError()) {
            throw new RuntimeException(errorWriter.getErrorMsg());
        }
        return flag;
    }

    private String getDeployRootDir(String deployRootDir) {
        if (deployRootDir == null) {
            deployRootDir = "/agent";
        }
        return deployRootDir;
    }

    private String getAppConfigFilePath(PaasAppsInfoDTO appInfo) {
        String targetPath = SdEnvUtil.PROJECT_PATH + appInfo.getAppId() + File.separator + "sql";
        targetPath = this.pathMatchSystem(targetPath);
        return targetPath;
    }

    private String pathMatchSystem(String path) {
        String targetSeparetor = File.separator;
        if (targetSeparetor.equals("\\")) {
            if (path.contains("/")) {
                // empty if block
            }
        } else if (targetSeparetor.equals("/") && path.contains("\\")) {
            path = path.replaceAll("\\\\", "/");
        }
        return path;
    }

    private class SqlRunLogWriter
    extends PrintWriter {
        private boolean errorFlag;
        private boolean hasError;
        private StringBuffer errorMsg;

        public SqlRunLogWriter(Writer out, boolean errorFlag) {
            super(out);
            this.errorMsg = new StringBuffer();
            this.errorFlag = errorFlag;
        }

        @Override
        public void println(Object x) {
            String s = String.valueOf(x);
            if (this.errorFlag) {
                InitDbBaseTask.this.logger.error((Object)s);
                this.hasError = true;
                this.errorMsg.append(s + '\n');
            } else {
                InitDbBaseTask.this.logger.info((Object)s);
            }
        }

        public boolean isHasError() {
            return this.hasError;
        }

        public String getErrorMsg() {
            return this.errorMsg.toString();
        }
    }
}

