/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.console.application.service.task;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinflow.console.application.service.task.AppTemplateRepoPullTask;
import com.irdstudio.allinflow.console.facade.PaasTaskComimportService;
import com.irdstudio.allinflow.console.facade.PaasTaskInfoService;
import com.irdstudio.allinflow.console.facade.dto.PaasTaskComimportDTO;
import com.irdstudio.allinflow.deliver.console.acl.repository.PaasEcsInfoRepository;
import com.irdstudio.allinflow.deliver.console.domain.entity.PaasEcsInfoDO;
import com.irdstudio.allinflow.design.console.acl.repository.PaasTemplateInfoRepository;
import com.irdstudio.allinflow.design.console.domain.entity.PaasAppsInfoDO;
import com.irdstudio.allinflow.design.console.domain.entity.PaasAppsSqlDO;
import com.irdstudio.allinflow.design.console.domain.entity.PaasTemplateInfoDO;
import com.irdstudio.allinflow.design.console.facade.PaasTemplateComService;
import com.irdstudio.allinflow.design.console.facade.dto.PaasTemplateComDTO;
import com.irdstudio.framework.beans.core.spring.ExpressionUtil;
import com.irdstudio.framework.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.framework.beans.core.util.BeanUtility;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.core.util.UUIDUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeModuleInitTask
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(InvokeModuleInitTask.class);
    private PaasAppsInfoDO appInfo;
    private List<PaasAppsSqlDO> sqlList;
    private PaasTemplateComService paasTemplateComService;
    private PaasTaskComimportService paasTaskComimportService;
    private PaasTaskInfoService paasTaskInfoService;

    public InvokeModuleInitTask(PaasAppsInfoDO appInfo, List<PaasAppsSqlDO> sqlList) {
        this.appInfo = appInfo;
        this.sqlList = sqlList;
        this.paasTaskComimportService = (PaasTaskComimportService)SpringContextUtils.getBean(PaasTaskComimportService.class);
        this.paasTaskInfoService = (PaasTaskInfoService)SpringContextUtils.getBean(PaasTaskInfoService.class);
        this.paasTemplateComService = (PaasTemplateComService)SpringContextUtils.getBean(PaasTemplateComService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteRtnInfo call() throws Exception {
        String moduleCode;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        PaasEcsInfoRepository paasEcsInfoRepository = (PaasEcsInfoRepository)SpringContextUtils.getBean(PaasEcsInfoRepository.class);
        PaasTemplateInfoRepository paasTemplateInfoRepository = (PaasTemplateInfoRepository)SpringContextUtils.getBean(PaasTemplateInfoRepository.class);
        if (this.appInfo == null) {
            return null;
        }
        if (CollectionUtils.isEmpty(this.sqlList)) {
            this.sqlList = new ArrayList<PaasAppsSqlDO>();
        }
        PaasTemplateInfoDO templateParam = new PaasTemplateInfoDO();
        templateParam.setAppTemplateId(this.appInfo.getAppTemplateId());
        PaasTemplateInfoDO templateInfo = (PaasTemplateInfoDO)paasTemplateInfoRepository.queryByPk((Object)templateParam);
        if (templateInfo == null) {
            return null;
        }
        AppTemplateRepoPullTask templateRepoPullTask = new AppTemplateRepoPullTask(templateInfo.getAppTemplateId(), templateInfo.getAppTemplateGitUrl());
        templateRepoPullTask.syncRun();
        String appTemplatePath = templateRepoPullTask.getAppTemplatePath();
        File templateScriptDir = new File(appTemplatePath, templateInfo.getAppTemplateId() + "-script");
        File createDbSqlFile = new File(templateScriptDir, "create_db.sql");
        if (createDbSqlFile.exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(createDbSqlFile);
                String string = IOUtils.toString((InputStream)input, (String)"UTF-8");
            }
            catch (Exception e) {
                try {
                    logger.error("\u8bfb\u53d6\u5e94\u7528\u6a21\u677f\u4ed3\u5e93 \u8868\u6a21\u578b\u811a\u672c\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)input);
            }
            IOUtils.closeQuietly((InputStream)input);
        }
        File createAppSqlFile = new File(templateScriptDir, "create_app.sql");
        String createAppSqlContent = null;
        if (createAppSqlFile.exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(createAppSqlFile);
                createAppSqlContent = IOUtils.toString((InputStream)input, (String)"UTF-8");
                PaasAppsSqlDO createDbSql = new PaasAppsSqlDO();
                createDbSql.setAppId(this.appInfo.getAppId());
                createDbSql.setExecuteStage("1");
                createDbSql.setSqlContent(createAppSqlContent);
                this.sqlList.add(createDbSql);
            }
            catch (Exception e) {
                try {
                    logger.error("\u8bfb\u53d6\u5e94\u7528\u6a21\u677f\u4ed3\u5e93\u521b\u5efa\u5e94\u7528\u65f6\u6267\u884c\u811a\u672c\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)input);
            }
            IOUtils.closeQuietly((InputStream)input);
        }
        PaasTemplateComDTO comParam = new PaasTemplateComDTO();
        comParam.setAppTemplateId(this.appInfo.getAppTemplateId());
        List comList = this.paasTemplateComService.queryList((Object)comParam);
        if (CollectionUtils.isNotEmpty((Collection)comList)) {
            ArrayList<PaasTaskComimportDTO> comImportTask = new ArrayList<PaasTaskComimportDTO>();
            for (PaasTemplateComDTO com : comList) {
                PaasTaskComimportDTO comImport = new PaasTaskComimportDTO();
                BeanUtility.beanCopy((Object)com, (Object)comImport, (boolean)true);
                comImport.setTaskType("C01001");
                comImport.setAppId(this.appInfo.getAppId());
                comImport.setAppCode(this.appInfo.getAppCode());
                comImport.setAppName(this.appInfo.getAppName());
                comImport.setSubsId(this.appInfo.getSubsId());
                comImport.setTaskName(String.format("%s-%s-%s", com.getComDomainName(), com.getComGroupName(), com.getComName()));
                comImport.setTaskId(UUIDUtil.getShortUUID());
                comImport.setComSubsId(com.getSubsId());
                comImport.setPackagePrefix("com.irdstudio");
                comImport.setCreateUser(this.appInfo.getCreateUser());
                comImport.setCreateTime(this.appInfo.getCreateTime());
                comImport.setLastUpdateUser(this.appInfo.getCreateUser());
                comImport.setLastUpdateTime(this.appInfo.getCreateTime());
                comImportTask.add(comImport);
                this.paasTaskComimportService.insert((Object)comImport);
            }
            for (PaasTaskComimportDTO task : comImportTask) {
                this.paasTaskInfoService.executeTask(task.getTaskId(), this.appInfo.getCreateUser());
            }
        }
        if (StringUtils.equalsAny((CharSequence)(moduleCode = templateInfo.getModuleCode()), (CharSequence[])new CharSequence[]{"apdpaas", "radpaas"})) {
            DataSource dataSource = (DataSource)SpringContextUtils.getBean(DataSource.class);
            int count = 0;
            Connection conn = null;
            try {
                conn = dataSource.getConnection();
                if (CollectionUtils.isNotEmpty(this.sqlList)) {
                    for (PaasAppsSqlDO appSql : this.sqlList) {
                        String sql = appSql.getSqlContent();
                        sql = ExpressionUtil.parse((String)sql, (Object)this.appInfo);
                        ScriptRunner sr = new ScriptRunner(conn);
                        BufferedReader reader = new BufferedReader(new StringReader(sql));
                        sr.runScript((Reader)reader);
                        ++count;
                    }
                }
            }
            catch (Exception e) {
                logger.error(moduleCode + e.getMessage(), (Throwable)e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        logger.error("\u6267\u884c\u5e94\u7528\u521d\u59cb\u5316\u811a\u672c\u65f6\uff0c\u5173\u95ed\u8fde\u63a5\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                    }
                }
            }
            return null;
        }
        PaasEcsInfoDO portalEcs = new PaasEcsInfoDO();
        portalEcs.setEnvId("pedestal");
        portalEcs.setPaasDuId("D000001");
        portalEcs.setAppCodeLike(moduleCode);
        portalEcs.setSubsId("AllinPaas");
        List ecsList = paasEcsInfoRepository.queryListByPage((Object)portalEcs);
        if (CollectionUtils.isNotEmpty((Collection)ecsList)) {
            HashMap<String, Object> reqData = new HashMap<String, Object>();
            reqData.put("root", this.appInfo);
            reqData.put("sql", this.sqlList);
            for (PaasEcsInfoDO ecs : ecsList) {
                String ecsPortString;
                String ecsIpString = ecs.getEcsIp();
                if (ecsIpString.isEmpty() || (ecsPortString = ecs.getEcsPort()).isEmpty()) continue;
                String urlString = "http://" + ecsIpString + ":" + ecsPortString + "/" + ecs.getAppCode() + "/openapi/app/init/sql/exec";
                HttpPost syncPost = new HttpPost(urlString);
                StringEntity createEntity = new StringEntity(JSON.toJSONString(reqData), "UTF-8");
                syncPost.setHeader("Content-Type", "application/json;charset=UTF-8");
                syncPost.setEntity((HttpEntity)createEntity);
                try {
                    HttpResponse response = httpClient.execute((HttpUriRequest)syncPost);
                    String json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    logger.info(moduleCode + "\u5e94\u7528\u521b\u5efa\u65f6\u8c03\u7528\u63a7\u5236\u53f0\u5e94\u7528\u521d\u59cb\u5316\u811a\u672c\u6267\u884c\u63a5\u53e3\u8fd4\u56de {}", (Object)json);
                }
                catch (Exception e) {
                    logger.error(moduleCode + e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    private String trimBackquote(String str) {
        if (StringUtils.startsWith((CharSequence)str, (CharSequence)"`")) {
            str = StringUtils.removeStart((String)str, (String)"`");
        }
        if (StringUtils.endsWith((CharSequence)str, (CharSequence)"`")) {
            str = StringUtils.removeEnd((String)str, (String)"`");
        }
        return str.toLowerCase();
    }
}

