/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinflow.console.application.service.task;

import com.irdstudio.allinflow.console.types.AppCreateWay;
import com.irdstudio.allinflow.deliver.console.facade.PaasEnvParamService;
import com.irdstudio.allinflow.deliver.console.facade.dto.PaasEnvParamDTO;
import com.irdstudio.allinflow.design.console.domain.entity.PaasAppsInfoDO;
import com.irdstudio.allinflow.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinflow.design.console.facade.SSubsInfoPortalService;
import com.irdstudio.allinflow.design.console.types.AppCategory;
import com.irdstudio.framework.beans.core.threadpool.ExecuteRtnInfo;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaasAppInitTask
implements Callable<ExecuteRtnInfo> {
    private static final Logger logger = LoggerFactory.getLogger(PaasAppInitTask.class);
    private PaasAppsInfoDO appInfo;

    public PaasAppInitTask(PaasAppsInfoDO appInfo) {
        this.appInfo = appInfo;
    }

    @Override
    public ExecuteRtnInfo call() throws Exception {
        PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
        SSubsInfoPortalService sSubsInfoService = (SSubsInfoPortalService)SpringContextUtils.getBean(SSubsInfoPortalService.class);
        PaasEnvParamService paasEnvParamService = (PaasEnvParamService)SpringContextUtils.getBean(PaasEnvParamService.class);
        String userId = this.appInfo.getLoginUserId();
        try {
            PaasEnvParamDTO envParam = new PaasEnvParamDTO();
            envParam.setEnvId("paas");
            envParam.setParamGroup("git.user");
            List gitParamList = paasEnvParamService.queryList((Object)envParam);
            if (CollectionUtils.isNotEmpty((Collection)gitParamList)) {
                String gitUrl;
                String gitType = this.getEnvParamByCode("git.type", gitParamList);
                String gitHostUrl = this.getEnvParamByCode("git.host.url", gitParamList);
                String accessToken = this.getEnvParamByCode("git.open.api.access_token", gitParamList);
                if (gitHostUrl.endsWith("/")) {
                    gitHostUrl = gitHostUrl.substring(0, gitHostUrl.length() - 1);
                }
                if (StringUtils.isNotBlank((CharSequence)(gitUrl = this.appInfo.getAppGitUrl())) && !StringUtils.equalsAny((CharSequence)this.appInfo.getAppCategory(), (CharSequence[])new CharSequence[]{AppCategory.Middleware.getCode(), AppCategory.DBApp.getCode()}) && !StringUtils.equals((CharSequence)this.appInfo.getAppCreateWay(), (CharSequence)AppCreateWay.GitRepoCreate.getCode())) {
                    logger.info(String.format("\u5f53\u524d\u4ed3\u5e93\u5bf9\u63a5\u662f %s", gitType));
                    boolean result = true;
                    result = sSubsInfoService.gitlabRepoHandler(gitUrl, userId, gitHostUrl, accessToken, Collections.emptyList(), this.appInfo.getAppName());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efaSDK\u4ed3\u5e93\u5f02\u5e38 " + this.appInfo.getAppGitUrl() + " " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String getEnvParamByCode(String paramCode, List<PaasEnvParamDTO> paramList) {
        if (CollectionUtils.isNotEmpty(paramList)) {
            for (PaasEnvParamDTO param : paramList) {
                if (!param.getParamCode().equals(paramCode)) continue;
                return param.getParamValue();
            }
        }
        return null;
    }
}

